/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security.datavalidator;

import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.datavalidator.SendFileValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.io.FilenameUtils;
import psdi.util.MXApplicationException;

public abstract class FileExtensionValidator
implements SendFileValidator {
    protected abstract HashSet<String> getAllowableExtensions(SessionInfo var1);

    @Override
    public boolean performsReceivedFileValidation() {
        return false;
    }

    @Override
    public void validateFileToReceive(SessionInfo session, String docType, String fileName) throws MXApplicationException {
        String fileExtension;
        HashSet<String> allowableExtensions = this.getAllowableExtensions(session);
        if (allowableExtensions != null && !allowableExtensions.contains(fileExtension = FilenameUtils.getExtension((String)fileName))) {
            ArrayList<String> sortedExtensions = new ArrayList<String>();
            sortedExtensions.addAll(allowableExtensions);
            Collections.sort(sortedExtensions);
            StringBuilder sb = new StringBuilder();
            for (String extension : sortedExtensions) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(extension);
            }
            Object[] params = new String[]{fileExtension, sb.toString()};
            throw new MXApplicationException("doclink", "errordoclinkinvalidextension", params);
        }
    }

    @Override
    public String getTemporaryFilePathForReceivedFileValidation(SessionInfo session, String docType, String fileName) {
        return null;
    }

    @Override
    public void validateReceivedFile(SessionInfo session, String docType, String fileName, String receivedFilePath) throws MXApplicationException {
    }
}

