/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.logging.MXLogger;

public class SessionPurgeCronTask
extends SimpleCronTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cronAction() {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.info((Object)"Purging expired Informer sessions.");
        try {
            MXServer mxServer = MXServer.getMXServer();
            DBManager dbManager = mxServer.getDBManager();
            UserInfo userInfo = this.getRunasUserInfo();
            Connection conn = dbManager.getConnection(userInfo.getConnectionKey());
            try {
                int numDeleted;
                SqlFormat sqlf;
                try (Statement stmt = conn.createStatement();){
                    sqlf = new SqlFormat("DELETE FROM issession WHERE expires < :1");
                    sqlf.setTimestamp(1, mxServer.getDate());
                    numDeleted = stmt.executeUpdate(sqlf.format());
                    if (logger2.isDebugEnabled()) {
                        logger2.debug((Object)String.format("%d expired ISSESSION records deleted", numDeleted));
                    }
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                stmt = conn.createStatement();
                try {
                    sqlf = new SqlFormat("DELETE FROM issessioncatalog WHERE sessionid NOT IN (SELECT sessionid FROM issession)");
                    numDeleted = stmt.executeUpdate(sqlf.format());
                    if (logger2.isDebugEnabled()) {
                        logger2.debug((Object)String.format("%d orphaned ISSESSIONCATALOG records deleted", numDeleted));
                    }
                }
                finally {
                    stmt.close();
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                stmt = conn.createStatement();
                try {
                    sqlf = new SqlFormat("DELETE FROM issessioncatpage WHERE sessioncatalogid NOT IN (SELECT sessioncatalogid FROM issessioncatalog)");
                    numDeleted = stmt.executeUpdate(sqlf.format());
                    if (logger2.isDebugEnabled()) {
                        logger2.debug((Object)String.format("%d orphaned ISSESSIONCATPAGE records deleted", numDeleted));
                    }
                }
                finally {
                    stmt.close();
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                stmt = conn.createStatement();
                try {
                    sqlf = new SqlFormat("DELETE FROM issessionresource WHERE sessionid NOT IN (SELECT sessionid FROM issession)");
                    numDeleted = stmt.executeUpdate(sqlf.format());
                    if (logger2.isDebugEnabled()) {
                        logger2.debug((Object)String.format("%d orphaned ISSESSIONRESOURCE records deleted", numDeleted));
                    }
                }
                finally {
                    stmt.close();
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
            }
            finally {
                dbManager.freeConnection(userInfo.getConnectionKey());
            }
        }
        catch (SQLException e) {
            logger2.error((Object)"An error occurred while purging expired sessions", (Throwable)e);
        }
        catch (RemoteException e) {
            logger2.error((Object)"An error occurred while purging expired sessions", (Throwable)e);
        }
    }

    public CrontaskParamInfo[] getParameters() {
        return new CrontaskParamInfo[0];
    }
}

