/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.NotifySessionRemote;
import com.interlocsolutions.maximo.notify.security.NotifySession;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.rmi.RemoteException;
import java.util.List;
import java.util.UUID;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXException;

public class SessionInfo
implements NotifySession {
    private volatile long sessionRowId = -1L;
    private final String sessionKey;
    private final long timeoutDuration;
    private volatile long timeout = 0L;
    private final String deviceName;
    private final String deviceSerialNumber;
    private volatile long lastActive = 0L;
    private boolean compressionSupported = false;
    private final String deviceOS;
    private final String profiles;
    private final String langCode;
    private final boolean supportsSqlite;
    private final String userId;
    private final boolean isAnonymous;
    private final String platform;
    private volatile String loginId;
    private volatile Object lock = null;

    public SessionInfo(String userId, String deviceName, String deviceSerialNumber, String deviceOS, boolean compressionSupported, String profiles2, String langCode, String loginId, boolean supportsSqlite) throws RemoteException, MXException {
        long timeoutDuration = PropUtils.getLongMaxProp("informer.session.timeout", 60L) * 60000L;
        if (timeoutDuration <= 0L) {
            timeoutDuration = 600000L;
        }
        this.timeoutDuration = timeoutDuration;
        this.isAnonymous = false;
        this.compressionSupported = compressionSupported;
        this.supportsSqlite = supportsSqlite;
        this.loginId = loginId;
        this.userId = userId;
        try {
            this.timeout = MXServer.getMXServer().getDate().getTime() + this.timeoutDuration;
        }
        catch (RemoteException e) {
            this.timeout = System.currentTimeMillis() + this.timeoutDuration;
        }
        this.sessionKey = UUID.randomUUID().toString();
        try {
            this.lastActive = MXServer.getMXServer().getDate().getTime();
        }
        catch (RemoteException e) {
            this.lastActive = System.currentTimeMillis();
        }
        this.deviceName = deviceName;
        this.deviceSerialNumber = deviceSerialNumber;
        this.deviceOS = deviceOS;
        this.profiles = profiles2;
        this.langCode = langCode;
        this.platform = null;
    }

    public SessionInfo(NotifySessionRemote session) throws RemoteException, MXException {
        long timeoutDuration = PropUtils.getLongMaxProp("informer.session.timeout", 60L) * 60000L;
        if (timeoutDuration <= 0L) {
            timeoutDuration = 600000L;
        }
        this.timeoutDuration = timeoutDuration;
        this.sessionRowId = session.getUniqueIDValue();
        this.sessionKey = session.getString("SESSIONKEY");
        this.loginId = session.getString("LOGINID");
        if (!session.isNull("EXPIRES")) {
            this.timeout = session.getDate("EXPIRES").getTime();
        }
        if (!session.isNull("LASTACTIVE")) {
            this.lastActive = session.getDate("LASTACTIVE").getTime();
        }
        this.deviceName = session.getString("DEVICE.NAME");
        this.deviceOS = session.getString("DEVICE.OS");
        this.deviceSerialNumber = session.getString("DEVICE.SERIALNUM");
        this.compressionSupported = session.getBoolean("SUPPORTSCOMPRESSION");
        this.profiles = session.getString("PROFILES");
        this.langCode = session.getString("LANGCODE");
        this.supportsSqlite = session.getBoolean("SUPPORTSSQLITE");
        this.userId = session.getString("USERID");
        this.isAnonymous = session.getBoolean("ISANONYMOUS");
        this.platform = session.getString("PLATFORM");
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.sessionKey.equals(obj);
        }
        return obj instanceof SessionInfo && this.sessionKey.equals(((SessionInfo)obj).getSessionKey());
    }

    @Override
    @Deprecated
    public String getLoginid() {
        return this.loginId;
    }

    @Override
    public String getLoginId() {
        return this.loginId;
    }

    @Override
    public String getUserName() {
        return this.getUserId();
    }

    @Override
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isValid() {
        try {
            return this.timeout > MXServer.getMXServer().getDate().getTime();
        }
        catch (RemoteException e) {
            return this.timeout > System.currentTimeMillis();
        }
    }

    @Override
    public long getLastActive() {
        return this.lastActive;
    }

    @Override
    public void setLastActive(long lastActive) {
        this.lastActive = lastActive;
    }

    @Override
    public void updateLastActive() throws RemoteException {
        this.setLastActive(MXServer.getMXServer().getDate().getTime());
    }

    @Override
    public boolean supportsCompressions() {
        return this.compressionSupported;
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public void setLock(Object lock) {
        this.lock = lock;
    }

    @Override
    public void close() {
        this.timeout = 0L;
        if (this.lock != null) {
            try {
                this.lock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    @Override
    public String getDeviceOS() {
        return this.deviceOS;
    }

    @Override
    public String getProfiles() {
        return this.profiles;
    }

    @Override
    public String[] getProfilesAsArray() {
        return StringUtils.splitListByDelimiter(this.profiles, "\\|").toArray(new String[0]);
    }

    @Override
    public List<String> getProfilesAsList() {
        return StringUtils.splitListByDelimiter(this.profiles, "\\|");
    }

    @Override
    public boolean isValidForProfile(String profile) {
        if (profile == null || profile.trim().length() == 0) {
            return false;
        }
        if (profile.equals(this.profiles)) {
            return true;
        }
        for (String sessionProfile : this.getProfilesAsArray()) {
            if (!profile.equals(sessionProfile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MboRemote getDevice(MboSetRemote deviceSet) throws MXException, RemoteException {
        SqlFormat sqlf = new SqlFormat("serialnum = :1");
        sqlf.setObject(1, "ISDEVICE", "SERIALNUM", this.getDeviceSerialNumber());
        deviceSet.setWhere(sqlf.format());
        deviceSet.reset();
        if (!deviceSet.isEmpty()) {
            return deviceSet.getMbo(0);
        }
        return null;
    }

    @Override
    public String getLangCode() {
        return this.langCode;
    }

    public void updateLoginId(String newLoginId) {
        this.loginId = newLoginId;
    }

    @Override
    public boolean supportsSqlite() {
        return this.supportsSqlite;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public long getSessionRowId() {
        return this.sessionRowId;
    }

    public void setSessionRowId(long sessionRowId) {
        this.sessionRowId = sessionRowId;
    }
}

