/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.security.UserIdentifier;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.xml.LoginExtras;
import java.io.Closeable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.SecurityService;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.ServiceRemote;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/interlocsolutions/maximo/notify/security/DefaultUserIdentifier;", "Lcom/interlocsolutions/maximo/notify/security/UserIdentifier;", "()V", "findUserId", "", "loginId", "identify", "Lpsdi/security/UserInfo;", "receivedUserInfo", "extras", "Lcom/interlocsolutions/maximo/notify/xml/LoginExtras;", "logger", "Lpsdi/util/logging/MXLogger;", "isDefaultUser", "", "userId", "isinformer"})
public final class DefaultUserIdentifier
implements UserIdentifier {
    @Override
    @Nullable
    public UserInfo identify(@NotNull String loginId, @NotNull UserInfo receivedUserInfo, @NotNull LoginExtras extras, @NotNull MXLogger logger2) {
        UserInfo userInfo;
        Intrinsics.checkNotNullParameter((Object)loginId, (String)"loginId");
        Intrinsics.checkNotNullParameter((Object)receivedUserInfo, (String)"receivedUserInfo");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        String userId = StringsKt.isBlank((CharSequence)loginId) ? null : this.findUserId(loginId);
        if (StringsKt.isBlank((CharSequence)loginId)) {
            String string = receivedUserInfo.getUserName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"receivedUserInfo.userName");
            if (this.isDefaultUser(string)) {
                MXLogger $this$infoLazy_u24default$iv = logger2;
                Object e$iv = null;
                boolean $i$f$infoLazy = false;
                if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                    Object $i$a$-infoLazy$default-DefaultUserIdentifier$identify$22;
                    try {
                        boolean $i$a$-infoLazy$default-DefaultUserIdentifier$identify$22 = false;
                        $i$a$-infoLazy$default-DefaultUserIdentifier$identify$22 = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                            The captured UserInfo belongs to the default user which does not expect to be an actual user.\n                            Maximo captured user: " + receivedUserInfo.getUserName() + "\n                        ")));
                    }
                    catch (Throwable throwable) {
                        $i$a$-infoLazy$default-DefaultUserIdentifier$identify$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string2 = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-DefaultUserIdentifier$identify$22) ? string2 : $i$a$-infoLazy$default-DefaultUserIdentifier$identify$22);
                    $this$infoLazy_u24default$iv.info((Object)msg$iv);
                }
                userInfo = null;
            } else {
                MXLogger $this$debugLazy_u24default$iv = logger2;
                Object e$iv = null;
                boolean $i$f$debugLazy = false;
                if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                    Object $i$a$-debugLazy$default-DefaultUserIdentifier$identify$32;
                    try {
                        boolean $i$a$-debugLazy$default-DefaultUserIdentifier$identify$32 = false;
                        $i$a$-debugLazy$default-DefaultUserIdentifier$identify$32 = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                            Informer app didn't provided any user Id, Rely on Maximo captured: " + receivedUserInfo.getUserName() + "\n                        ")));
                    }
                    catch (Throwable throwable) {
                        $i$a$-debugLazy$default-DefaultUserIdentifier$identify$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string3 = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-DefaultUserIdentifier$identify$32) ? string3 : $i$a$-debugLazy$default-DefaultUserIdentifier$identify$32);
                    $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                }
                userInfo = receivedUserInfo;
            }
        } else {
            String string = receivedUserInfo.getUserName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"receivedUserInfo.userName");
            if (this.isDefaultUser(string)) {
                String string4 = userId;
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    MXLogger $this$debugLazy_u24default$iv = logger2;
                    Object e$iv = null;
                    boolean $i$f$debugLazy = false;
                    if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                        Object object;
                        try {
                            boolean bl2 = false;
                            object = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                        Maximo captured UserInfo was either Maximo or Informer default user: " + receivedUserInfo.getUserName() + "\n                        Informer will rely on its own provided user: " + userId + "\n                    ")));
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        String string5 = "(Unable to form error msg)";
                        String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string5 : object);
                        $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                    }
                    ServiceRemote serviceRemote = MXServer.getMXServer().lookupLocal("SECURITY");
                    Intrinsics.checkNotNull((Object)serviceRemote, (String)"null cannot be cast to non-null type psdi.security.SecurityService");
                    SecurityService secServ = (SecurityService)serviceRemote;
                    userInfo = secServ.authenticateUser(userId, true);
                } else {
                    userInfo = null;
                }
            } else if (receivedUserInfo.getUserName().equals(userId)) {
                MXLogger $this$infoLazy_u24default$iv = logger2;
                Object e$iv = null;
                boolean $i$f$infoLazy = false;
                if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                    Object $i$a$-infoLazy$default-DefaultUserIdentifier$identify$52;
                    try {
                        boolean $i$a$-infoLazy$default-DefaultUserIdentifier$identify$52 = false;
                        $i$a$-infoLazy$default-DefaultUserIdentifier$identify$52 = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                        Informer rely on Maximo captured user info: " + receivedUserInfo.getUserName() + "\n                    ")));
                    }
                    catch (Throwable throwable) {
                        $i$a$-infoLazy$default-DefaultUserIdentifier$identify$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string6 = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-DefaultUserIdentifier$identify$52) ? string6 : $i$a$-infoLazy$default-DefaultUserIdentifier$identify$52);
                    $this$infoLazy_u24default$iv.info((Object)msg$iv);
                }
                userInfo = receivedUserInfo;
            } else {
                MXLogger $this$debugLazy_u24default$iv = logger2;
                Object e$iv = null;
                boolean $i$f$debugLazy = false;
                if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                    Object object;
                    try {
                        boolean bl = false;
                        object = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                        Informer provided user id is not match with Maximo captured one.\n                        Maximo captured user info: " + receivedUserInfo.getUserName() + "\n                        Informer provided: " + userId + "      \n                    ")));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string7 = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string7 : object);
                    $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                }
                userInfo = null;
            }
        }
        return userInfo;
    }

    @Override
    public boolean isDefaultUser(@NotNull String userId) {
        Object object;
        Object maxDefaultUser;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Object object2 = PropUtil.INSTANCE.getProp("mxe.int.dfltuser");
        if (object2 == null || (object2 = ((InformerProp)object2).asString()) == null) {
            object2 = maxDefaultUser = "";
        }
        if ((object = PropUtil.INSTANCE.getProp("informer.dfltuser")) == null || (object = ((InformerProp)object).asString()) == null) {
            object = "";
        }
        Object infDefaultUser = object;
        return StringsKt.equals((String)userId, (String)maxDefaultUser, (boolean)true) || StringsKt.equals((String)userId, (String)infDefaultUser, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findUserId(String loginId) {
        String string;
        String string2;
        Object object = PropUtil.INSTANCE.getProp("mxe.convertLoginid");
        if (object != null && (object = ((InformerProp)object).asBoolean()) != null ? (Boolean)object : false) {
            string2 = MboExtensionsKt.sqlFormat$default("loginid = :1", null, null, (Function1)new Function1<SqlFormat, Unit>(loginId){
                final /* synthetic */ String $loginId;
                {
                    this.$loginId = $loginId;
                    super(1);
                }

                public final void invoke(@NotNull SqlFormat $this$sqlFormat) {
                    Intrinsics.checkNotNullParameter((Object)$this$sqlFormat, (String)"$this$sqlFormat");
                    String string = this.$loginId.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                    $this$sqlFormat.setObject(1, "MAXUSER", "LOGINID", string);
                }
            }, 3, null);
        } else {
            Object object2 = PropUtil.INSTANCE.getProp("informer.ignoreLoginCase");
            if (object2 != null && (object2 = ((InformerProp)object2).asBoolean()) != null ? (Boolean)object2 : false) {
                Object object3 = PropUtil.INSTANCE.getProp("mxe.db.format.upper");
                if (object3 == null || (object3 = ((InformerProp)object3).asString()) == null) {
                    object3 = "UPPER";
                }
                Object upperFunction = object3;
                string2 = MboExtensionsKt.sqlFormat$default((String)upperFunction + "(loginid) = " + (String)upperFunction + "(:1)", null, null, (Function1)new Function1<SqlFormat, Unit>(loginId){
                    final /* synthetic */ String $loginId;
                    {
                        this.$loginId = $loginId;
                        super(1);
                    }

                    public final void invoke(@NotNull SqlFormat $this$sqlFormat) {
                        Intrinsics.checkNotNullParameter((Object)$this$sqlFormat, (String)"$this$sqlFormat");
                        $this$sqlFormat.setObject(1, "MAXUSER", "LOGINID", this.$loginId);
                    }
                }, 3, null);
            } else {
                string2 = MboExtensionsKt.sqlFormat$default("loginid = :1", null, null, (Function1)new Function1<SqlFormat, Unit>(loginId){
                    final /* synthetic */ String $loginId;
                    {
                        this.$loginId = $loginId;
                        super(1);
                    }

                    public final void invoke(@NotNull SqlFormat $this$sqlFormat) {
                        Intrinsics.checkNotNullParameter((Object)$this$sqlFormat, (String)"$this$sqlFormat");
                        $this$sqlFormat.setObject(1, "MAXUSER", "LOGINID", this.$loginId);
                    }
                }, 3, null);
            }
        }
        String userLookup2 = string2;
        MboSetRemote $this$use$iv = MboExtensionsKt.getNewMboSet$default("MAXUSER", null, null, true, 6, null);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl = false;
            MboSetRemote maxuserSet = $this$use$iv;
            boolean bl2 = false;
            maxuserSet.setWhere(userLookup2);
            MboRemote mboRemote = maxuserSet.getMbo(0);
            string = mboRemote != null ? mboRemote.getString("USERID") : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }
}

