/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.requests;

import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.push.PushService;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.GenericLogger;
import com.interlocsolutions.maximo.notify.util.MXLoggerAdapterKt;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/interlocsolutions/maximo/notify/requests/PushRegisterRequest;", "", "session", "Lcom/interlocsolutions/maximo/notify/security/SessionInfo;", "serialnum", "", "appName", "token", "(Lcom/interlocsolutions/maximo/notify/security/SessionInfo;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "logger", "Lcom/interlocsolutions/maximo/notify/util/GenericLogger;", "invoke", "", "isinformer"})
public final class PushRegisterRequest {
    @NotNull
    private final SessionInfo session;
    @Nullable
    private final String serialnum;
    @NotNull
    private final String appName;
    @NotNull
    private final String token;
    @NotNull
    private final GenericLogger logger;

    public PushRegisterRequest(@NotNull SessionInfo session, @Nullable String serialnum, @NotNull String appName, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.session = session;
        this.serialnum = serialnum;
        this.appName = appName;
        this.token = token;
        MXLogger mXLogger = NotifyConstants.INFORMER_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_LOGGER");
        this.logger = MXLoggerAdapterKt.toGenericLogger(mXLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void invoke() {
        void $this$use$iv$iv;
        void mboName$iv;
        Object[] it$iv$iv$iv2;
        void $this$use$iv$iv$iv;
        void discardable$iv22;
        void mboName$iv2;
        void this_$iv;
        Object[] serialnum;
        Object it;
        Object[] objectArray;
        Object object;
        block25: {
            block24: {
                object = this.serialnum;
                if (this.serialnum == null) break block24;
                it = objectArray = object;
                boolean bl = false;
                object = StringsKt.isBlank((CharSequence)((CharSequence)it)) ? objectArray : null;
                if (object != null) break block25;
            }
            object = this.session.getDeviceSerialNumber();
        }
        if (!Intrinsics.areEqual((Object)(serialnum = object), (Object)this.session.getDeviceSerialNumber())) {
            boolean $i$a$-require-PushRegisterRequest$invoke$32 = false;
            String $i$a$-require-PushRegisterRequest$invoke$32 = "This session may not modify device " + (String)serialnum;
            throw new IllegalArgumentException($i$a$-require-PushRegisterRequest$invoke$32.toString());
        }
        if (!PushService.Companion.isPushRelayAvailable()) {
            boolean bl = false;
            objectArray = new String[]{PushService.Companion.getRelayUrl()};
            throw new InformerException("pushRelayNotAvailable", objectArray);
        }
        MboInterface mbos = MboInterface.Companion.obtain$default(MboInterface.Companion, null, 1, null);
        Object object2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)serialnum, (String)"serialnum");
        object2[0] = serialnum;
        Object[] bl = MboExtensionsKt.sqlFormatArgs("serialnum = :1", object2);
        object2 = mbos;
        String string = "ISDEVICE";
        boolean bl2 = true;
        boolean $i$f$mapSingleMbo = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useNewMboSet = false;
        MboSetRemote mboSetRemote = this_$iv$iv.getNewMboSet((String)mboName$iv2, (String)bl, (boolean)discardable$iv22);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv$iv);
        Throwable throwable = null;
        try {
            it$iv$iv$iv2 = (MboSetRemoteClosableWrapper)closeable;
            boolean bl3 = false;
            void mboSet$iv = $this$use$iv$iv$iv;
            boolean bl4 = false;
            MboRemote it2 = mboSet$iv.getMbo(0);
            boolean bl5 = false;
            MboRemote mboRemote = it2;
            Long result$iv = mboRemote != null ? Long.valueOf(mboRemote.getUniqueIDValue()) : null;
            it$iv$iv$iv2 = result$iv;
        }
        catch (Throwable it$iv$iv$iv2) {
            throwable = it$iv$iv$iv2;
            throw it$iv$iv$iv2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (it$iv$iv$iv2 == null) {
            bl = new String[]{serialnum};
            throw new InformerException("missingDevice", bl);
        }
        long deviceUniqueId = it$iv$iv$iv2.longValue();
        it = "ISPUSHREG";
        bl = new Object[]{this.appName};
        String whereClause$iv = MboExtensionsKt.sqlFormatArgs("appname = :1", bl);
        boolean discardable$iv = false;
        boolean $i$f$useNewMboSet2 = false;
        MboSetRemote discardable$iv22 = mbos.getNewMboSet((String)mboName$iv, whereClause$iv, discardable$iv);
        boolean $i$f$use2 = false;
        Closeable closeable2 = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv);
        Throwable throwable2 = null;
        try {
            MboSetRemoteClosableWrapper it$iv$iv = (MboSetRemoteClosableWrapper)closeable2;
            boolean bl6 = false;
            void regSet = $this$use$iv$iv;
            boolean bl7 = false;
            if (regSet.isEmpty()) {
                it$iv$iv$iv2 = new String[]{this.appName};
                throw new InformerException("appNotRegistered", it$iv$iv$iv2);
            }
            void $this$forEach$iv = regSet;
            boolean $i$f$forEach = false;
            Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence((MboSetRemote)$this$forEach$iv);
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Object object3;
                void $this$logLazy$iv$iv;
                Object[] objectArray2;
                MboRemote reg = (MboRemote)element$iv$iv;
                boolean bl8 = false;
                String profileName = reg.getString("NOTIFY.NOTIFYNUM");
                if (this.session.isValidForProfile(profileName)) {
                    MboSetRemote deviceSet = reg.getMboSet("DEVICE");
                    Object[] objectArray3 = new Object[]{deviceUniqueId};
                    deviceSet.setWhere(MboExtensionsKt.sqlFormatArgs("deviceuid = :1", objectArray3));
                    deviceSet.reset();
                    MboRemote mboRemote = deviceSet.moveFirst();
                    if (mboRemote == null) {
                        Object[] $this$invoke_u24lambda_u247_u24lambda_u246_u24lambda_u244 = objectArray2 = deviceSet.add();
                        boolean bl9 = false;
                        $this$invoke_u24lambda_u247_u24lambda_u246_u24lambda_u244.setValue("DEVICEUID", deviceUniqueId);
                        mboRemote = objectArray2;
                    }
                    MboRemote device = mboRemote;
                    device.setValue("USERID", this.session.getUserId());
                    device.setValue("TOKEN", this.token);
                    device.setValue("REGDATE", MXServer.getMXServer().getDate());
                    objectArray2 = new Object[2];
                    Intrinsics.checkNotNullExpressionValue((Object)this.session.getUserId(), (String)"session.userId");
                    objectArray2[1] = device.getLong("pushreg.notifyid");
                    MboSetRemote maxSequenceSet = device.getMboSet("$USERNOTIFICATION", "ISUSERNOTIFICATION", MboExtensionsKt.sqlFormatArgs("userid = :1 and notifyid = :2", objectArray2));
                    device.setValue("LASTSEQUENCE", (int)maxSequenceSet.max("SEQUENCE"));
                    continue;
                }
                Object[] $this$warnLazy_u24default$iv = this.logger;
                Object e$iv = null;
                boolean $i$f$warnLazy = false;
                objectArray2 = $this$warnLazy_u24default$iv;
                GenericLogger.LogLevel level$iv$iv = GenericLogger.LogLevel.WARN;
                boolean $i$f$logLazy = false;
                if (!$this$logLazy$iv$iv.isEnabled(level$iv$iv)) continue;
                try {
                    boolean bl10 = false;
                    object3 = Result.constructor-impl((Object)("Skipping push registration for appName " + this.appName + ", profile " + profileName + " for deviceId " + (String)serialnum + ". Session " + this.session.getSessionKey() + " is not authorized for this profile"));
                }
                catch (Throwable throwable3) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                }
                String string2 = "(Unable to form error msg)";
                String msg$iv$iv = (String)(Result.isFailure-impl((Object)object3) ? string2 : object3);
                GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
            }
            regSet.save();
            mboSetRemote = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable2 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
        }
    }
}

