/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.requests;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.CatalogEntry;
import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.NotifySessionCatalogRemote;
import com.interlocsolutions.maximo.notify.NotifySessionRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.LogLevel;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PerformanceTimer;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import com.interlocsolutions.maximo.notify.util.db.DefaultDbAccessor;
import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class GetCatalogRequest {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private final String notificationName;
    private final String catalogName;
    private final long declaredDeviceId;
    private final int requestedCount;
    private final long declaredSequence;
    private final String langCode;
    private final SessionInfo session;
    private NotifySessionRemote notifySession;
    private MboRemote profileMbo;
    private MboRemote catalogMbo;
    private MboRemote deviceMbo;
    private MboRemote catalogDevice;

    public GetCatalogRequest(String notificationName, String catalogName, long deviceId, int count, long sequence, String langCode, SessionInfo session) throws RemoteException, MXException {
        this.notificationName = notificationName;
        this.catalogName = catalogName.toUpperCase();
        this.declaredDeviceId = deviceId;
        this.requestedCount = count;
        this.declaredSequence = sequence;
        this.langCode = langCode;
        this.assertLangCodeSupported(langCode);
        this.session = session;
    }

    private MboRemote getCatalogDevice(boolean createIfNecessary) throws RemoteException, MXException {
        if (this.catalogDevice == null) {
            MboRemote catDev = null;
            SqlFormat sqlf = new SqlFormat(this.getCatalog(), "catalogid = :catalogid AND revision = :revision AND devicekey = :1");
            sqlf.setLong(1, this.getDevice().getLong("DEVICEID"));
            MboSetRemote catDeviceSet = this.getCatalog().getMboSet("$catalogdevice", "ISCATALOGDEVICE", sqlf.format());
            MboSetIterator catDevItr = new MboSetIterator(catDeviceSet);
            MboRemote mbo = catDevItr.moveFirst();
            while (mbo != null) {
                if (mbo.getUniqueIDValue() == this.declaredDeviceId && mbo.getLong("REVISION") == this.getCatalog().getLong("REVISION") && mbo.getString("LANGCODE").equals(this.langCode)) {
                    catDev = mbo;
                } else {
                    mbo.delete();
                }
                mbo = catDevItr.moveNext();
            }
            if (catDev == null && createIfNecessary) {
                catDev = catDeviceSet.add();
                catDev.setValue("CATALOGID", this.getCatalog().getLong("CATALOGID"));
                catDev.setValue("REVISION", this.getCatalog().getLong("REVISION"));
                catDev.setValue("LANGCODE", this.langCode);
                catDev.setValue("DEVICEKEY", this.getDevice().getLong("DEVICEID"));
            }
            this.catalogDevice = catDev;
        }
        return this.catalogDevice;
    }

    private MboRemote getProfileRO() throws MXException, RemoteException {
        if (this.profileMbo == null) {
            SqlFormat sqlf = new SqlFormat("notifynum = :1 and active = :yes");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", this.notificationName);
            MboSetRemote notifySet = this.notifySession.getMboSet("$profile", "ISNOTIFY", sqlf.format());
            notifySet.setFlag(7L, true);
            this.profileMbo = notifySet.getMbo(0);
            if (this.profileMbo == null) {
                Object[] args = new String[]{this.notificationName};
                throw new MXApplicationException("informer", "requestedProfileInactive", args);
            }
        }
        return this.profileMbo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MboRemote getCatalog() throws RemoteException, MXException {
        if (this.catalogMbo == null) {
            SqlFormat sqlf = new SqlFormat(this.getProfileRO(), "catalog = :1 and notifyid = :notifyid");
            sqlf.setObject(1, "ISCATALOG", "CATALOG", this.catalogName);
            MboSetRemote catalogSet = this.notifySession.getMboSet("$catalog", "ISCATALOG", sqlf.format());
            try {
                this.catalogMbo = catalogSet.getMbo(0);
                if (this.catalogMbo == null) {
                    Object[] args = new String[]{this.getProfileRO().getString("NOTIFYNUM"), this.catalogName};
                    throw new MXApplicationException("informer", "noSuchCatalog", args);
                }
            }
            finally {
                NotifyUtil.close(catalogSet);
            }
        }
        return this.catalogMbo;
    }

    private MboRemote getDevice() throws RemoteException, MXException {
        if (this.deviceMbo == null) {
            MboSetRemote deviceSet = this.notifySession.getMboSet("DEVICE");
            this.deviceMbo = deviceSet.getMbo(0);
            if (this.deviceMbo == null) {
                throw new MXApplicationException("informer", "missingDevice");
            }
        }
        return this.deviceMbo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke() throws NotifyFault, RemoteException, MXException, SQLException {
        String string;
        MboSetRemote sessionSet = null;
        try {
            sessionSet = MXServer.getMXServer().getMboSet("ISSESSION", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("sessionkey = :1");
            sqlf.setObject(1, "ISSESSION", "SESSIONKEY", this.session.getSessionKey());
            sessionSet.setWhere(sqlf.format());
            this.notifySession = (NotifySessionRemote)sessionSet.getMbo(0);
            if (this.notifySession == null) {
                throw new NotifyFault(String.format("Session %1$s was not found.", this.session.getSessionKey()));
            }
            if (this.getCatalog().getString("PARTITIONTYPE").equals(Catalog.PartitionType.PARTITIONED.toString()) && this.getCatalog().getString("PARTITIONERCLASS") != null && !this.getCatalog().getString("PARTITIONERCLASS").isEmpty()) {
                throw new NotifyFault(String.format("There is no full catalog partition for catalog %s:%s.", this.notificationName, this.catalogName));
            }
            CatalogPageFetch catalogPageFetch = new CatalogPageFetch();
            CatalogObjects objects = catalogPageFetch.newFetchSession() ? catalogPageFetch.generateCatalogPages(this.requestedCount, this.langCode) : catalogPageFetch.getNextCatalogPage();
            if (!objects.isHasMoreRecords()) {
                MboRemote catDev = this.getCatalogDevice(true);
                catDev.setValue("SEQUENCE", objects.getSequence());
                catDev.setValue("UPDATED", MXServerFactory.getMXServer().getDate());
                objects.setDeviceId(catDev.getUniqueIDValue());
                catalogPageFetch.cleanUpFetchSession();
            }
            PerformanceTimer timerSessionSave = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Saving session mbo (and children) took %dms on a " + (catalogPageFetch.newFetchSession() ? "first" : "subsequent") + " page of " + objects.getCount() + " records of " + this.notificationName + ":" + this.catalogName);
            timerSessionSave.start();
            sessionSet.save();
            timerSessionSave.stop();
            MboRemote catDev = this.getCatalogDevice(false);
            if (catDev != null) {
                objects.setDeviceId(catDev.getUniqueIDValue());
                this.doTracking(catDev);
            }
            string = NotifyXMLUtils.getCatalog(objects);
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(sessionSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(sessionSet);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTracking(MboRemote catalogDevice) throws MXException, RemoteException {
        if (!NotifyUtil.isTrackingRetrieval()) {
            return;
        }
        MboSetRemote retrievalSet = null;
        MboSetRemote deviceSet = null;
        try {
            retrievalSet = MXServer.getMXServer().getMboSet("ISRETRIEVALTRACKING", MXServer.getMXServer().getSystemUserInfo());
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", MXServer.getMXServer().getSystemUserInfo());
            MboRemote retrieval = retrievalSet.add();
            retrieval.setValue("CATALOGID", catalogDevice.getLong("CATALOGID"));
            retrieval.setValue("SEQUENCE", catalogDevice.getString("SEQUENCE"));
            retrieval.setValue("NOTIFYID", catalogDevice.getLong("CATALOG.NOTIFYID"));
            retrieval.setValue("RETRIEVALDATE", MXServer.getMXServer().getDate());
            MboRemote device = this.session.getDevice(deviceSet);
            if (device != null) {
                retrieval.setValue("DEVICEID", device.getUniqueIDValue());
            }
            retrievalSet.save();
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(retrievalSet);
            NotifyUtil.closeAndCleanup(deviceSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(retrievalSet);
        NotifyUtil.closeAndCleanup(deviceSet);
    }

    private void assertLangCodeSupported(String langCode) throws RemoteException, MXException {
        if (langCode == null || !NotifyUtil.getLangCodes().contains(langCode)) {
            Object[] args = new String[]{langCode};
            throw new MXApplicationException("informer", "invalidLanguage", args);
        }
    }

    private class CatalogPageFetch {
        final NotifySessionCatalogRemote sessionCatalog;
        private final PerformanceTimer timerPageFormationFirst = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching/Forming Catalog page (first) into objects took %dms");
        private final PerformanceTimer timerPageFormationSubsequent = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching/Forming Catalog page (subsequent) into objects took %dms");
        private final boolean useCachedXml;
        private PerformanceTimer timerPagePlanning = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Partitioning/Planning Catalog pages took %dms (but this does not include the associated DB write)");

        CatalogPageFetch() throws RemoteException, MXException {
            MboSetRemote sessionCatalogSet = GetCatalogRequest.this.notifySession.getMboSet("SESSIONCATALOG");
            SqlFormat sqlfSessCat = new SqlFormat("notifynum = :1 and catalog = :2");
            sqlfSessCat.setObject(1, "ISSESSIONCATALOG", "NOTIFYNUM", GetCatalogRequest.this.notificationName);
            sqlfSessCat.setObject(2, "ISSESSIONCATALOG", "CATALOG", GetCatalogRequest.this.catalogName);
            sessionCatalogSet.setWhere(sqlfSessCat.format());
            sessionCatalogSet.reset();
            if (sessionCatalogSet.isEmpty()) {
                this.sessionCatalog = (NotifySessionCatalogRemote)sessionCatalogSet.add();
                this.sessionCatalog.setValue("NOTIFYNUM", GetCatalogRequest.this.notificationName);
                this.sessionCatalog.setValue("CATALOG", GetCatalogRequest.this.catalogName);
            } else {
                this.sessionCatalog = (NotifySessionCatalogRemote)sessionCatalogSet.getMbo(0);
            }
            this.useCachedXml = PropUtils.getBooleanMaxProp("informer.catalog.xml.store", true);
        }

        boolean newFetchSession() throws RemoteException {
            return this.sessionCatalog.toBeAdded();
        }

        CatalogObjects getNextCatalogPage() throws RemoteException, MXException {
            MboSetRemote sessionCatPageSet = this.sessionCatalog.getMboSet("CATALOGPAGE");
            SqlFormat sqlf = new SqlFormat("seqend > :1");
            sqlf.setLong(1, GetCatalogRequest.this.declaredSequence);
            sessionCatPageSet.setWhere(sqlf.format());
            sessionCatPageSet.setOrderBy("seqend ASC");
            MboRemote catPage = sessionCatPageSet.getMbo(0);
            this.timerPageFormationSubsequent.start();
            CatalogObjects objects = this.deserializeCatPage(catPage);
            this.timerPageFormationSubsequent.stop();
            objects.setHasMoreRecords(sessionCatPageSet.getMbo(1) != null);
            return objects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CatalogObjects deserializeCatPage(MboRemote catPage) throws MXException, RemoteException {
            CatalogObjects objects;
            Object contentDataObj;
            try {
                byte[] data;
                String contentStr = catPage.getString("CONTENT");
                if (contentStr == null || contentStr.isEmpty()) {
                    contentStr = catPage.getString("CATPREPAGE.CONTENT");
                }
                if ((data = Base64.decodeBase64(contentStr)).length == 0) {
                    throw new NotifyFault(String.format("Catalog page for %s:%s has no content", GetCatalogRequest.this.getProfileRO().getString("NOTIFYNUM"), GetCatalogRequest.this.getCatalog().getString("CATALOG")));
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream in = new ObjectInputStream(bais);
                contentDataObj = in.readObject();
            }
            catch (IOException e) {
                throw new MXApplicationException("system", "error", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MXApplicationException("system", "error", (Throwable)e);
            }
            if (contentDataObj instanceof List) {
                List entries = (List)contentDataObj;
                String objectName = catPage.getString("OBJECTNAME");
                UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
                userInfo.setLangCode(GetCatalogRequest.this.langCode);
                MboSetRemote objectSet = MXServer.getMXServer().getMboSet(objectName, userInfo);
                try {
                    objects = new CatalogObjects();
                    if (this.useCachedXml) {
                        try {
                            XMLPopulationStrategy fetchStrategy = DefaultDbAccessor.identifyMaximoDbType() == DbServerType.ORACLE ? new ClobFetchStrategy() : new MboRowwiseFetchStrategy();
                            fetchStrategy.fetchCatalogEntryXML(entries);
                        }
                        catch (MXException e) {
                            LOGGER.error((Object)"Failure fetching cached XML", (Throwable)e);
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"Failure fetching cached XML", (Throwable)e);
                        }
                        catch (SQLException e) {
                            LOGGER.error((Object)"Failure fetching cached XML", (Throwable)e);
                        }
                    }
                    String[] attributes = ((CatalogRemote)GetCatalogRequest.this.getCatalog()).getAttributes();
                    for (CatalogEntry entry : entries) {
                        if (entry.isDelete()) {
                            objects.addObject(new CatalogObject(entry.getId(), true, entry.getSequence()));
                            continue;
                        }
                        if (entry.hasXmlRepresentation()) {
                            try {
                                InformerObjectSerializer serializer2 = InformerObjectSerializer.getInstance();
                                CatalogObject catObj = (CatalogObject)serializer2.deserialize(entry.getXml(), CatalogEntry.POLICY_UNMARSHALL_CATALOG_OBJECT);
                                catObj.setSeqeunce(entry.getSequence());
                                objects.addObject(catObj);
                                continue;
                            }
                            catch (JAXBException e) {
                                throw new MXApplicationException("informer", "jaxberror", new Object[]{objectName, e.getMessage()}, (Throwable)e);
                            }
                            catch (XMLStreamException e) {
                                throw new MXApplicationException("informer", "jaxberror", new Object[]{objectName, e.getMessage()}, (Throwable)e);
                            }
                        }
                        MboRemote catalogRecord = objectSet.getMboForUniqueId(entry.getId());
                        if (catalogRecord == null) continue;
                        objects.addObject(new CatalogObject(catalogRecord, attributes, entry.getSequence(), GetCatalogRequest.this.langCode));
                    }
                }
                finally {
                    NotifyUtil.closeAndCleanup(objectSet);
                }
            }
            objects = (CatalogObjects)contentDataObj;
            objects.setName(GetCatalogRequest.this.catalogName);
            objects.setPosition(catPage.getInt("PAGEEND"));
            objects.setSequence(catPage.getLong("SEQEND"));
            objects.setPageNumber(catPage.getInt("PAGESEQ"));
            objects.setCount(this.sessionCatalog.getInt("COUNT"));
            return objects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CatalogObjects generateCatalogPages(int pagesize, String langCode) throws RemoteException, MXException, SQLException {
            PageTool pageTool;
            MboSetRemote catalogPageSet;
            MboRemote firstPage;
            block20: {
                long seqIndex;
                block21: {
                    block19: {
                        this.timerPagePlanning.start();
                        String objectName = GetCatalogRequest.this.getCatalog().getString("OBJECTNAME");
                        if (objectName == null || objectName.isEmpty()) {
                            throw new MXApplicationException("informer", "missingCatalogObject");
                        }
                        firstPage = null;
                        catalogPageSet = this.sessionCatalog.getMboSet("CATALOGPAGE");
                        seqIndex = GetCatalogRequest.this.getCatalogDevice(false) == null ? -1L : GetCatalogRequest.this.declaredSequence;
                        pageTool = new PageTool(objectName, this.sessionCatalog, seqIndex);
                        if (seqIndex >= 0L) break block19;
                        SqlFormat sqlf = new SqlFormat(GetCatalogRequest.this.getCatalog(), "catalogid = :catalogid AND revision = :revision AND partitionname IS NULL AND langcode = :1");
                        sqlf.setObject(1, "ISCATPRELOAD", "LANGCODE", langCode);
                        MboSetRemote catPreloadSet = GetCatalogRequest.this.getCatalog().getMboSet("$catPreload", "ISCATPRELOAD", sqlf.format());
                        catPreloadSet.reset();
                        catPreloadSet.setFlag(39L, true);
                        MboRemote preloadMbo = catPreloadSet.moveFirst();
                        if (preloadMbo != null) {
                            MboSetRemote catPrePageSet = preloadMbo.getMboSet("$catprepagefetch", "ISCATPREPAGE");
                            SqlFormat sqlf2 = new SqlFormat(preloadMbo, "preloaduid = :preloaduid AND seqend > :1");
                            sqlf2.setLong(1, GetCatalogRequest.this.declaredSequence);
                            catPrePageSet.setWhere(sqlf2.format());
                            catPrePageSet.reset();
                            catPrePageSet.setOrderBy("seqend ASC");
                            catPrePageSet.setFlag(39L, true);
                            MboSetIterator catPageItr = new MboSetIterator(catPrePageSet);
                            MboRemote catPage = catPageItr.moveFirst();
                            while (catPage != null) {
                                int totalCount = preloadMbo.getInt("RECORDCOUNT");
                                MboRemote sessionCatPage = pageTool.addPrePage(catPage, totalCount, objectName);
                                if (firstPage == null) {
                                    firstPage = sessionCatPage;
                                }
                                catPage = catPageItr.moveNext();
                            }
                        }
                        break block20;
                    }
                    if (!this.useCachedXml) break block21;
                    ConnectionKey key = MXServer.getMXServer().getDBManager().getSystemConnectionKey();
                    Connection c = MXServer.getMXServer().getDBManager().getConnection(key);
                    PreparedStatement queueStatement = null;
                    ResultSet rs = null;
                    try {
                        MboRemote page;
                        PerformanceTimer timer = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching info from ISCATALOGDATA via JDBC, record via XML, delayed, took %dms");
                        timer.start();
                        SqlFormat sqlf = new SqlFormat(GetCatalogRequest.this.getCatalog(), "SELECT recordid, sequence, inscope, catalogdataid FROM iscatalogdata WHERE catalogid = :catalogid  AND revision = :revision AND langcode = :1 AND mainrecord = :yes AND sequence > :2 ORDER BY sequence ASC");
                        sqlf.setObject(1, "ISCATALOGDATA", "LANGCODE", langCode);
                        sqlf.setLong(2, seqIndex);
                        queueStatement = c.prepareStatement(sqlf.format());
                        rs = queueStatement.executeQuery();
                        int colIdxRecordId = rs.findColumn("recordid");
                        int colIdxSeq = rs.findColumn("sequence");
                        int colIdxInScope = rs.findColumn("inscope");
                        int colIdxDataId = rs.findColumn("catalogdataid");
                        int idxWithinPage = 0;
                        while (rs.next()) {
                            pageTool.addTuple(rs.getLong(colIdxRecordId), rs.getLong(colIdxSeq), !rs.getBoolean(colIdxInScope), rs.getLong(colIdxDataId));
                            if (++idxWithinPage % pagesize != 0 || idxWithinPage == 0) continue;
                            page = pageTool.flushPage();
                            idxWithinPage = 0;
                            if (firstPage != null) continue;
                            firstPage = page;
                        }
                        if (idxWithinPage > 0) {
                            page = pageTool.flushPage();
                            if (firstPage == null) {
                                firstPage = page;
                            }
                        }
                        timer.stop();
                    }
                    catch (Throwable throwable) {
                        try {
                            NotifyUtil.close(rs);
                            NotifyUtil.close(queueStatement);
                            MXServer.getMXServer().getDBManager().freeConnection(key);
                        }
                        catch (Throwable t) {
                            LOGGER.warn((Object)String.format("Failed to free DB connection key '%s'", key));
                        }
                        throw throwable;
                    }
                    try {
                        NotifyUtil.close(rs);
                        NotifyUtil.close(queueStatement);
                        MXServer.getMXServer().getDBManager().freeConnection(key);
                    }
                    catch (Throwable t) {
                        LOGGER.warn((Object)String.format("Failed to free DB connection key '%s'", key));
                    }
                    break block20;
                }
                MboSetRemote set = GetCatalogRequest.this.getCatalog().getMboSet("CATALOGDATA");
                SqlFormat sqlf = new SqlFormat("langcode = :1 AND sequence > :2");
                sqlf.setObject(1, "ISCATALOGDATA", "LANGCODE", langCode);
                sqlf.setLong(2, seqIndex);
                set.setWhere(sqlf.format());
                set.setOrderBy("sequence ASC");
                set.setFlag(39L, true);
                int idxWithinPage = 0;
                MboSetIterator setItr = new MboSetIterator(set);
                PerformanceTimer timer = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching info from ISCATALOGDATA via MBO, record via MBO, delayed, took %dms");
                timer.start();
                MboRemote mbo = setItr.moveFirst();
                while (mbo != null) {
                    pageTool.addTuple(mbo.getLong("RECORDID"), mbo.getLong("SEQUENCE"), "delete".equalsIgnoreCase(mbo.getString("ACTION")));
                    if (++idxWithinPage % pagesize == 0 && idxWithinPage != 0) {
                        MboRemote page = pageTool.flushPage();
                        idxWithinPage = 0;
                        if (firstPage == null) {
                            firstPage = page;
                        }
                    }
                    mbo = setItr.moveNext();
                }
                if (idxWithinPage > 0) {
                    MboRemote page = pageTool.flushPage();
                    if (firstPage == null) {
                        firstPage = page;
                    }
                }
                timer.stop();
            }
            if (firstPage == null) {
                firstPage = pageTool.flushPage();
            }
            pageTool.finish();
            this.timerPagePlanning.stop();
            this.timerPageFormationFirst.start();
            CatalogObjects objects = this.deserializeCatPage(firstPage);
            objects.setHasMoreRecords(catalogPageSet.getMbo(0) != null && catalogPageSet.getMbo(1) != null);
            this.timerPageFormationFirst.stop();
            return objects;
        }

        void cleanUpFetchSession() throws RemoteException, MXException {
            this.sessionCatalog.delete();
        }
    }

    private static class MboRowwiseFetchStrategy
    implements XMLPopulationStrategy {
        final PerformanceTimer mTimer = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching cached XML via MBO rowwise lookups took %dms");

        private MboRowwiseFetchStrategy() {
        }

        @Override
        public void fetchCatalogEntryXML(List<CatalogEntry> entries) throws IOException, SQLException, MXException {
            this.mTimer.start();
            this.fetchCatalogEntryXMLViaMbos(entries);
            this.mTimer.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fetchCatalogEntryXMLViaMbos(List<CatalogEntry> entries) throws IOException, SQLException, MXException {
            if (entries.size() < 1) {
                return;
            }
            MboSetRemote dataSet = MXServer.getMXServer().getMboSet("ISCATALOGDATA", MXServer.getMXServer().getSystemUserInfo());
            try {
                dataSet.setFlag(39L, true);
                for (CatalogEntry entry : entries) {
                    MboRemote dataMbo = dataSet.getMboForUniqueId(entry.getCatalogDataId());
                    String xml = dataMbo.getString("XML");
                    if (xml == null || xml.trim().length() < 1) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)String.format("ISCATALOGDATA record %d has no cached XML", entry.getCatalogDataId()));
                        continue;
                    }
                    entry.setXml(xml);
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(dataSet);
            }
        }
    }

    private static class ClobFetchStrategy
    implements XMLPopulationStrategy {
        final PerformanceTimer mTimer;
        private final int batchSize = PropUtils.getIntMaxProp("informer.pb.catalog.xml.cached.fetchcount", 50);

        public ClobFetchStrategy() {
            this.mTimer = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching cached XML via direct CLOB accessors in batches of " + this.batchSize + " took %dms");
        }

        @Override
        public void fetchCatalogEntryXML(List<CatalogEntry> entries) throws IOException, SQLException, MXException {
            this.mTimer.start();
            ArrayList<CatalogEntry> entrySubset = new ArrayList<CatalogEntry>(this.batchSize);
            for (CatalogEntry entry : entries) {
                entrySubset.add(entry);
                if (entrySubset.size() % this.batchSize != 0) continue;
                this.fetchCatalogEntryXMLDirectly(entrySubset);
                entrySubset.clear();
            }
            if (entrySubset.size() > 0) {
                this.fetchCatalogEntryXMLDirectly(entrySubset);
            }
            this.mTimer.stop();
        }

        /*
         * Exception decompiling
         */
        void fetchCatalogEntryXMLDirectly(List<CatalogEntry> entries) throws IOException, SQLException, MXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class PageTool {
        final String objectName;
        final MboSetRemote catalogPageSet;
        final MboRemote sessionCatalog;
        long pageIdx = 0L;
        long objIdx = 0L;
        long highSeq = -1L;
        long seqStartForPage = -1L;
        long seqEndForPage = -1L;
        List<CatalogEntry> entriesForPage = new LinkedList<CatalogEntry>();

        public PageTool(String objectName, MboRemote sessionCatalog, long startingSeq) throws RemoteException, MXException {
            this.objectName = objectName;
            this.sessionCatalog = sessionCatalog;
            this.catalogPageSet = sessionCatalog.getMboSet("CATALOGPAGE");
            this.highSeq = startingSeq;
            this.seqStartForPage = startingSeq;
            this.seqEndForPage = startingSeq;
        }

        MboRemote addPrePage(MboRemote prePage, int totalCount, String objectName) throws RemoteException, MXException {
            MboRemote page = this.catalogPageSet.add();
            page.setValue("CATPREPAGEID", prePage.getUniqueIDValue());
            page.setValue("PAGESTART", prePage.getInt("PAGESTART"));
            page.setValue("PAGEEND", prePage.getInt("PAGEEND"));
            page.setValue("PAGESEQ", this.pageIdx);
            page.setValue("PAGECOUNT", totalCount);
            page.setValue("OBJECTNAME", objectName);
            page.setValue("SEQSTART", prePage.getLong("SEQSTART"));
            page.setValue("SEQEND", prePage.getLong("SEQEND"));
            this.highSeq = prePage.getLong("SEQEND");
            this.objIdx = prePage.getInt("PAGEEND");
            ++this.pageIdx;
            return page;
        }

        void addTuple(long id, long sequence, boolean delete) {
            this.addTuple(id, sequence, delete, null);
        }

        void addTuple(long id, long sequence, boolean delete, String xml) {
            this.entriesForPage.add(new CatalogEntry(id, sequence, delete, xml));
            if (this.seqStartForPage < 0L) {
                this.seqStartForPage = sequence;
            }
            this.seqEndForPage = sequence;
        }

        void addTuple(long id, long sequence, boolean delete, long catalogdataid) {
            this.entriesForPage.add(new CatalogEntry(id, sequence, delete, catalogdataid));
            if (this.seqStartForPage < 0L) {
                this.seqStartForPage = sequence;
            }
            this.seqEndForPage = sequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MboRemote flushPage() throws RemoteException, MXException {
            int pageLen = this.entriesForPage.size();
            long pageStart = this.objIdx;
            long newObjIdx = this.objIdx + (long)pageLen;
            if (this.seqStartForPage < 0L) {
                this.seqStartForPage = 0L;
            }
            if (this.seqEndForPage < 0L) {
                this.seqEndForPage = this.seqStartForPage;
            }
            MboRemote page = this.catalogPageSet.add();
            page.setValue("PAGESTART", pageStart);
            page.setValue("PAGEEND", newObjIdx);
            page.setValue("PAGECOUNT", pageLen);
            page.setValue("PAGESEQ", this.pageIdx);
            page.setValue("OBJECTNAME", this.objectName);
            page.setValue("SEQSTART", this.seqStartForPage);
            page.setValue("SEQEND", this.seqEndForPage);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (ObjectOutputStream out = new ObjectOutputStream(baos);){
                    out.writeObject(this.entriesForPage);
                }
                String dataStr = Base64.encodeBase64String(baos.toByteArray());
                page.setValue("CONTENT", dataStr);
            }
            catch (IOException e) {
                Object[] args = new String[]{"CATALOG"};
                throw new MXApplicationException("informer", "error", args, (Throwable)e);
            }
            this.objIdx = newObjIdx;
            ++this.pageIdx;
            this.highSeq = this.seqEndForPage;
            this.entriesForPage.clear();
            this.seqStartForPage = this.seqEndForPage;
            return page;
        }

        public void finish() throws RemoteException, MXException {
            this.sessionCatalog.setValue("SEQUENCE", this.highSeq);
            this.sessionCatalog.setValue("COUNT", this.objIdx);
        }
    }

    static interface XMLPopulationStrategy {
        public void fetchCatalogEntryXML(List<CatalogEntry> var1) throws IOException, SQLException, MXException;
    }
}

