/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.requests;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifySessionRemote;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class CatalogPreloadRequest {
    private final CachedCatalog cachedCatalog;
    private final long declaredSequence;
    @Nullable
    private final String partitionName;
    private final String langCode;
    @NotNull
    private final SessionInfo session;
    private NotifySessionRemote notifySession;

    public CatalogPreloadRequest(String notificationName, String catalogName, long sequence, @Nullable String partitionName, @NotNull String langCode, @NotNull SessionInfo session) throws RemoteException, MXException {
        this.declaredSequence = sequence;
        this.partitionName = partitionName == null ? null : partitionName.trim();
        this.langCode = langCode;
        this.session = session;
        try {
            this.cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(notificationName, catalogName);
        }
        catch (NoSuchCatalogException e) {
            Object[] args = new String[]{notificationName, catalogName};
            throw new MXApplicationException("informer", "noSuchCatalog", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke() throws NotifyFault, RemoteException, MXException, SQLException {
        String string;
        MboSetRemote sessionSet = null;
        try {
            UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
            sessionSet = MXServer.getMXServer().getMboSet("ISSESSION", userInfo);
            SqlFormat sqlf = new SqlFormat("sessionkey = :1");
            sqlf.setObject(1, "ISSESSION", "SESSIONKEY", this.session.getSessionKey());
            sessionSet.setWhere(sqlf.format());
            this.notifySession = (NotifySessionRemote)sessionSet.getMbo(0);
            if (this.notifySession == null) {
                throw new NotifyFault(String.format("Session %1$s was not found.", this.session.getSessionKey()));
            }
            if (!NotifyUtil.getLangCodes().contains(this.langCode)) {
                Object[] args = new String[]{this.langCode};
                throw new MXApplicationException("informer", "invalidLanguage", args);
            }
            if (this.cachedCatalog.partitionType == Catalog.PartitionType.PARTITIONED && (this.partitionName == null || this.partitionName.isEmpty())) {
                throw new NotifyFault(String.format("There is no full catalog partition for catalog %s:%s.", this.cachedCatalog.notifyNum, this.cachedCatalog.catalogName));
            }
            CatalogObjects objects = this.fetchNextPrepage();
            if (!objects.isHasMoreRecords()) {
                SqlFormat sqlf2;
                if (this.partitionName != null) {
                    sqlf2 = new SqlFormat((MboRemote)this.notifySession, "devicekey = :deviceid AND catalogid = :1 AND partitionname = :2");
                    sqlf2.setLong(1, this.cachedCatalog.catalogId);
                    sqlf2.setObject(2, "ISCATALOGDEVICE", "PARTITIONNAME", this.partitionName);
                } else {
                    sqlf2 = new SqlFormat((MboRemote)this.notifySession, "devicekey = :deviceid AND catalogid = :1 AND partitionname IS NULL");
                    sqlf2.setLong(1, this.cachedCatalog.catalogId);
                }
                MboSetRemote catDeviceSet = this.notifySession.getMboSet("$catalogdevice", "ISCATALOGDEVICE", sqlf2.format());
                catDeviceSet.deleteAll();
                MboRemote catalogDevice = catDeviceSet.add();
                catalogDevice.setValue("CATALOGID", this.cachedCatalog.catalogId);
                catalogDevice.setValue("REVISION", this.cachedCatalog.catalogRevision);
                if (this.partitionName == null) {
                    catalogDevice.setValueNull("PARTITIONNAME");
                } else {
                    catalogDevice.setValue("PARTITIONNAME", this.partitionName);
                }
                catalogDevice.setValue("LANGCODE", this.langCode);
                catalogDevice.setValue("DEVICEKEY", this.notifySession.getLong("DEVICEID"));
                catalogDevice.setValue("SEQUENCE", objects.getSequence());
                catalogDevice.setValue("UPDATED", MXServerFactory.getMXServer().getDate());
                objects.setDeviceId(catalogDevice.getUniqueIDValue());
                this.doTracking(catalogDevice, userInfo);
            }
            String response = NotifyXMLUtils.getCatalog(objects);
            sessionSet.save();
            string = response;
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(sessionSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(sessionSet);
        return string;
    }

    @NotNull
    private CatalogObjects fetchNextPrepage() throws RemoteException, MXException {
        CatalogObjects objects;
        SqlFormat sqlf;
        MboSetRemote catPreloadSet = this.notifySession.getMboSet("$catpreloadfetch", "ISCATPRELOAD");
        if (this.partitionName == null) {
            sqlf = new SqlFormat("catalogid = :1 AND revision = :2 AND partitionname IS NULL AND langcode = :3");
            sqlf.setLong(1, this.cachedCatalog.catalogId);
            sqlf.setLong(2, this.cachedCatalog.catalogRevision);
            sqlf.setObject(3, "ISCATPRELOAD", "LANGCODE", this.langCode);
        } else {
            sqlf = new SqlFormat("catalogid = :1 AND revision = :2 AND partitionname = :3 AND langcode = :4");
            sqlf.setLong(1, this.cachedCatalog.catalogId);
            sqlf.setLong(2, this.cachedCatalog.catalogRevision);
            sqlf.setObject(3, "ISCATPRELOAD", "PARTITIONNAME", this.partitionName);
            sqlf.setObject(4, "ISCATPRELOAD", "LANGCODE", this.langCode);
        }
        catPreloadSet.setWhere(sqlf.format());
        catPreloadSet.reset();
        catPreloadSet.setFlag(39L, true);
        MboRemote preloadMbo = catPreloadSet.moveFirst();
        if (preloadMbo != null) {
            MboSetRemote catPrePageSet = this.notifySession.getMboSet("$catprepagefetch", "ISCATPREPAGE");
            SqlFormat sqlf2 = new SqlFormat(preloadMbo, "preloaduid = :preloaduid AND seqend > :1");
            sqlf2.setLong(1, this.declaredSequence);
            catPrePageSet.setWhere(sqlf2.format());
            catPrePageSet.reset();
            catPrePageSet.setOrderBy("seqend ASC");
            catPrePageSet.setFlag(39L, true);
            if (catPrePageSet.isEmpty()) {
                objects = this.emptyResponse();
            } else {
                objects = this.deserializeCatPage(catPrePageSet.getMbo(0), preloadMbo.getInt("RECORDCOUNT"));
                objects.setHasMoreRecords(catPrePageSet.getMbo(0) != null && catPrePageSet.getMbo(1) != null);
            }
        } else {
            objects = this.emptyResponse();
        }
        return objects;
    }

    @NotNull
    private CatalogObjects emptyResponse() {
        CatalogObjects objects = new CatalogObjects();
        objects.setPartition(this.partitionName);
        objects.setName(this.cachedCatalog.catalogName);
        objects.setSequence(Math.max(this.declaredSequence, 0L));
        objects.setPageNumber(0);
        objects.setCount(0);
        objects.setPosition(0);
        objects.setHasMoreRecords(false);
        return objects;
    }

    private CatalogObjects deserializeCatPage(MboRemote catPage, int totalCount) throws MXException, RemoteException {
        Object contentDataObj;
        try {
            String contentStr = catPage.getString("CONTENT");
            if (contentStr == null || contentStr.trim().isEmpty()) {
                throw new NotifyFault(String.format("Catalog page for %s:%s has no content", this.cachedCatalog.notifyNum, this.cachedCatalog.catalogName));
            }
            byte[] data = Base64.decodeBase64(contentStr);
            if (data.length == 0) {
                throw new NotifyFault(String.format("Catalog page for %s:%s has no content", this.cachedCatalog.notifyNum, this.cachedCatalog.catalogName));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream in = new ObjectInputStream(bais);
            contentDataObj = in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MXApplicationException("system", "error", (Throwable)e);
        }
        CatalogObjects objects = (CatalogObjects)contentDataObj;
        objects.setName(this.cachedCatalog.catalogName);
        objects.setPosition(catPage.getInt("PAGEEND"));
        objects.setSequence(catPage.getLong("SEQEND"));
        objects.setPageNumber(catPage.getInt("PAGESEQ"));
        objects.setCount(totalCount);
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTracking(MboRemote catalogDevice, UserInfo userInfo) throws MXException, RemoteException {
        if (!NotifyUtil.isTrackingRetrieval()) {
            return;
        }
        MboSetRemote retrievalSet = MXServer.getMXServer().getMboSet("ISRETRIEVALTRACKING", userInfo);
        try {
            MboRemote retrieval = retrievalSet.add();
            retrieval.setValue("CATALOGID", catalogDevice.getLong("CATALOGID"));
            retrieval.setValue("SEQUENCE", catalogDevice.getString("SEQUENCE"));
            retrieval.setValue("NOTIFYID", catalogDevice.getLong("CATALOG.NOTIFYID"));
            retrieval.setValue("RETRIEVALDATE", MXServer.getMXServer().getDate());
            retrieval.setValue("DEVICEID", catalogDevice.getLong("DEVICE.DEVICEID"));
            retrievalSet.save();
        }
        finally {
            NotifyUtil.closeAndCleanup(retrievalSet);
        }
    }
}

