/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.requests;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.CatalogEntry;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifySessionRemote;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.IOUtils;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.LogLevel;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PerformanceTimer;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import com.interlocsolutions.maximo.notify.xml.CatalogStream;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class CatalogDeltaRequest {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private final long declaredDeviceId;
    private final int requestedCount;
    private final long declaredSequence;
    @NotNull
    private final String langCode;
    @NotNull
    private final SessionInfo session;
    private final boolean useCachedXml = PropUtils.getBooleanMaxProp("informer.catalog.xml.store", true);
    @NotNull
    private final CachedCatalog cachedCatalog;
    @Nullable
    private final String partitionName;
    private PerformanceTimer timer = new PerformanceTimer(LOGGER, LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Fetching info from ISCATALOGDATA via JDBC, record via XML, delayed, took %dms");

    public CatalogDeltaRequest(@NotNull String notificationName, @NotNull String catalogName, @Nullable String partitionName, long deviceId, int count, long sequence, @Nullable String langCode, @NotNull SessionInfo session) throws RemoteException, MXException {
        this.declaredDeviceId = deviceId;
        this.requestedCount = count;
        this.declaredSequence = sequence;
        if (langCode == null || !NotifyUtil.getLangCodes().contains(langCode)) {
            Object[] args = new String[]{langCode};
            throw new MXApplicationException("informer", "invalidLanguage", args);
        }
        this.langCode = langCode;
        this.session = session;
        try {
            this.cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(notificationName, catalogName);
        }
        catch (NoSuchCatalogException e) {
            Object[] args = new String[]{notificationName, catalogName};
            throw new MXApplicationException("informer", "noSuchCatalog", args);
        }
        this.partitionName = partitionName == null ? null : partitionName.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchXml(ResultSet rs, int colIdxXml, long catDataId) throws SQLException {
        String xml;
        block19: {
            block18: {
                Clob xmlClob = rs.getClob(colIdxXml);
                if (xmlClob == null) break block18;
                try {
                    StringWriter sw = new StringWriter();
                    try {
                        IOUtils.streamCopy(xmlClob.getCharacterStream(), sw, 4096);
                        xml = sw.toString();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Failure reading from ISCATALOGDATA XML stream.");
                        xml = null;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        xmlClob.free();
                    }
                    catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                    catch (Throwable t) {
                        LOGGER.warn((Object)String.format("Failed to free CLOB for column '%s' on ISCATALOGDATA row '%d'", "xml", catDataId), t);
                    }
                    throw throwable;
                }
                try {
                    xmlClob.free();
                }
                catch (SQLFeatureNotSupportedException sw) {
                }
                catch (UnsupportedOperationException sw) {
                }
                catch (AbstractMethodError sw) {
                }
                catch (Throwable t) {
                    LOGGER.warn((Object)String.format("Failed to free CLOB for column '%s' on ISCATALOGDATA row '%d'", "xml", catDataId), t);
                }
                if (xml == null || xml.trim().length() == 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)String.format("ISCATALOGDATA record %d has no cached XML", catDataId));
                    }
                    xml = null;
                }
                break block19;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("ISCATALOGDATA record %d has no cached XML", catDataId));
            }
            xml = null;
        }
        return xml;
    }

    /*
     * Loose catch block
     */
    public String invoke() throws NotifyFault, RemoteException, MXException, SQLException {
        MboSetRemote sessionSet = null;
        UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
        sessionSet = MXServer.getMXServer().getMboSet("ISSESSION", userInfo);
        SqlFormat sqlf = new SqlFormat("sessionkey = :1");
        sqlf.setObject(1, "ISSESSION", "SESSIONKEY", this.session.getSessionKey());
        sessionSet.setWhere(sqlf.format());
        NotifySessionRemote notifySession = (NotifySessionRemote)sessionSet.getMbo(0);
        if (notifySession == null) {
            throw new NotifyFault(String.format("Session %1$s was not found.", this.session.getSessionKey()));
        }
        if (this.cachedCatalog.partitionType == Catalog.PartitionType.PARTITIONED && (this.partitionName == null || this.partitionName.isEmpty())) {
            throw new NotifyFault(String.format("There is no full catalog partition for catalog %s:%s.", this.cachedCatalog.notifyNum, this.cachedCatalog.catalogName));
        }
        MboSetRemote catDeviceSet = notifySession.getMboSet("$catalogdevice", "ISCATALOGDEVICE");
        MboRemote catalogDevice = catDeviceSet.getMboForUniqueId(this.declaredDeviceId);
        if (catalogDevice == null) {
            throw new NotifyFault("[informer:newCatalogBaselineRequired]");
        }
        if (catalogDevice.getLong("REVISION") != this.cachedCatalog.catalogRevision) {
            throw new NotifyFault("[informer:newCatalogBaselineRequired]");
        }
        if (!catalogDevice.getString("LANGCODE").equals(this.langCode)) {
            throw new NotifyFault("[informer:newCatalogBaselineRequired]");
        }
        if (catalogDevice.isNull("PARTITIONNAME") ? this.partitionName != null : !catalogDevice.getString("PARTITIONNAME").equals(this.partitionName)) {
            throw new NotifyFault("[informer:newCatalogBaselineRequired]");
        }
        CatalogStream objects = this.formPage(userInfo);
        catalogDevice.setValue("SEQUENCE", objects.getHighSeqNum());
        catalogDevice.setValue("UPDATED", MXServerFactory.getMXServer().getDate());
        sessionSet.save();
        this.doTracking(catalogDevice, userInfo);
        String string = InformerObjectSerializer.getInstance().serialize(objects, InformerObjectSerializer.MARSHAL_PPRINT_STRIPCONTROL);
        NotifyUtil.closeAndCleanup(sessionSet);
        return string;
        {
            catch (JAXBException e) {
                try {
                    Object[] args = new String[]{"Catalog", e.getMessage()};
                    throw new MXApplicationException("informer", "jaxberror", args, (Throwable)e);
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(sessionSet);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    CatalogStream formPage(UserInfo userInfo) throws RemoteException, MXException, SQLException {
        CatalogStream payload = new CatalogStream(this.declaredSequence);
        PreparedStatement catDataFetchStmt = null;
        ResultSet rs = null;
        MboSetRemote objectSet = null;
        ConnectionKey key = userInfo.getConnectionKey();
        try {
            SqlFormat sqlf;
            Connection c = MXServer.getMXServer().getDBManager().getConnection(key);
            this.timer.start();
            payload.setName(this.cachedCatalog.catalogName);
            payload.setPartition(this.partitionName);
            if (this.partitionName == null) {
                sqlf = new SqlFormat("SELECT recordid, sequence, inscope, catalogdataid, xml FROM iscatalogdata WHERE catalogid = :1 AND revision = :2 AND mainrecord = :yes AND langcode = :3 AND sequence > :4 ORDER BY sequence ASC");
                sqlf.setLong(1, this.cachedCatalog.catalogId);
                sqlf.setLong(2, this.cachedCatalog.catalogRevision);
                sqlf.setObject(3, "ISCATALOGDATA", "LANGCODE", this.langCode);
                sqlf.setLong(4, this.declaredSequence);
            } else {
                sqlf = new SqlFormat("SELECT recordid, sequence, inscope, catalogdataid, xml FROM iscatalogdata WHERE catalogid = :1 AND revision = :2 AND partitionname = :3 AND langcode = :4 AND sequence > :5 ORDER BY sequence ASC");
                sqlf.setLong(1, this.cachedCatalog.catalogId);
                sqlf.setLong(2, this.cachedCatalog.catalogRevision);
                sqlf.setObject(3, "ISCATALOGDATA", "PARTITIONNAME", this.partitionName);
                sqlf.setObject(4, "ISCATALOGDATA", "LANGCODE", this.langCode);
                sqlf.setLong(5, this.declaredSequence);
            }
            catDataFetchStmt = c.prepareStatement(sqlf.format());
            rs = catDataFetchStmt.executeQuery();
            int colIdxRecordId = rs.findColumn("recordid");
            int colIdxSeq = rs.findColumn("sequence");
            int colIdxInScope = rs.findColumn("inscope");
            int colIdxDataId = rs.findColumn("catalogdataid");
            int colIdxXml = rs.findColumn("xml");
            int idxWithinPage = 0;
            while (rs.next()) {
                String xml;
                if (idxWithinPage == this.requestedCount) {
                    payload.setMoreToFetch(true);
                    break;
                }
                ++idxWithinPage;
                boolean inScope = rs.getBoolean(colIdxInScope);
                long catDataId = rs.getLong(colIdxDataId);
                long seqNum = rs.getLong(colIdxSeq);
                long recordId = rs.getLong(colIdxRecordId);
                if (!inScope) {
                    payload.addObject(new CatalogObject(recordId, true, seqNum));
                    continue;
                }
                String string = xml = this.useCachedXml ? CatalogDeltaRequest.fetchXml(rs, colIdxXml, catDataId) : null;
                if (xml != null) {
                    try {
                        InformerObjectSerializer serializer2 = InformerObjectSerializer.getInstance();
                        CatalogObject catObj = (CatalogObject)serializer2.deserialize(xml, CatalogEntry.POLICY_UNMARSHALL_CATALOG_OBJECT);
                        catObj.setSeqeunce(seqNum);
                        payload.addObject(catObj);
                        continue;
                    }
                    catch (JAXBException e) {
                        throw new MXApplicationException("informer", "jaxberror", new Object[]{this.cachedCatalog.objectName, e.getMessage()}, (Throwable)e);
                    }
                    catch (XMLStreamException e) {
                        throw new MXApplicationException("informer", "jaxberror", new Object[]{this.cachedCatalog.objectName, e.getMessage()}, (Throwable)e);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("ISCATALOGDATA evaluating ISCATALOGDATA record %d inline (no cached XML)", catDataId));
                }
                if (objectSet == null) {
                    UserInfo langSetUserInfo = userInfo;
                    langSetUserInfo.setLangCode(this.langCode);
                    objectSet = MXServer.getMXServer().getMboSet(this.cachedCatalog.objectName, langSetUserInfo);
                    objectSet.setFlag(39L, true);
                }
                payload.addObject(new CatalogObject(objectSet.getMboForUniqueId(recordId), this.cachedCatalog.attributes, seqNum, this.langCode));
            }
            this.timer.stop();
        }
        catch (Throwable throwable) {
            try {
                NotifyUtil.close(objectSet);
                NotifyUtil.close(rs);
                NotifyUtil.close(catDataFetchStmt);
                MXServer.getMXServer().getDBManager().freeConnection(key);
            }
            catch (Throwable t) {
                LOGGER.warn((Object)String.format("Failed to free DB connection key '%s'", key));
            }
            throw throwable;
        }
        try {
            NotifyUtil.close(objectSet);
            NotifyUtil.close(rs);
            NotifyUtil.close(catDataFetchStmt);
            MXServer.getMXServer().getDBManager().freeConnection(key);
        }
        catch (Throwable t) {
            LOGGER.warn((Object)String.format("Failed to free DB connection key '%s'", key));
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTracking(MboRemote catalogDevice, UserInfo userInfo) throws MXException, RemoteException {
        if (!NotifyUtil.isTrackingRetrieval()) {
            return;
        }
        MboSetRemote retrievalSet = null;
        try {
            retrievalSet = MXServer.getMXServer().getMboSet("ISRETRIEVALTRACKING", userInfo);
            MboRemote retrieval = retrievalSet.add();
            retrieval.setValue("CATALOGID", catalogDevice.getLong("CATALOGID"));
            retrieval.setValue("SEQUENCE", catalogDevice.getString("SEQUENCE"));
            retrieval.setValue("NOTIFYID", catalogDevice.getLong("CATALOG.NOTIFYID"));
            retrieval.setValue("RETRIEVALDATE", MXServer.getMXServer().getDate());
            retrieval.setValue("DEVICEID", catalogDevice.getLong("DEVICE.DEVICEID"));
            retrievalSet.save();
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(retrievalSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(retrievalSet);
    }
}

