/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.notification;

import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.UserNotificationRemote;
import com.interlocsolutions.maximo.notify.err.NoSuchRecordException;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecUserRefresh;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJob;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.MboMutator;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import java.rmi.RemoteException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotificationJobQueueEvaluator {
    private final MboInterface mbos;
    private final NotificationJobManager jobManager = NotificationJobManager.INSTANCE;
    private final MXLogger logger;
    private final String name;

    public NotificationJobQueueEvaluator(MboInterface mbos, MXLogger logger2, String name) {
        this.mbos = mbos;
        this.logger = logger2;
        this.name = name;
    }

    public void evaluate(NotificationJob job) throws RemoteException, MXException {
        if (job.getJobType() == NotificationJob.NotificationJobType.USEREXPAND) {
            this.processUserExpandQueueRecord(job.getNotifyId());
        } else if (job.getJobType() == NotificationJob.NotificationJobType.USERREFRESH) {
            if (job.getRecordId() == null) {
                throw new NullPointerException("RecordId is null");
            }
            this.processUserRefreshQueueRecord(job.getJobId(), job.getRecordId());
        } else {
            if (job.getRecordId() == null) {
                throw new NullPointerException("RecordId is null");
            }
            this.processNotificationRefreshQueueRecord(job.getJobId(), job.getNotifyId(), job.getRecordId());
        }
    }

    private void processUserExpandQueueRecord(long notifyId) throws RemoteException, MXException {
        SqlFormat sqlf = new SqlFormat("notifyid = :1 and disabled=0");
        sqlf.setLong(1, notifyId);
        ImmutableLongSet notifyUserIds2 = MboUtil.collectUniqueIds(this.mbos.getUserInfo(), "ISNOTIFYUSER", sqlf.format());
        for (Long notifyUserId : notifyUserIds2) {
            this.jobManager.enqueue(new JobSpecUserRefresh(notifyId, notifyUserId));
        }
    }

    private void processUserRefreshQueueRecord(final long refreshQueueId, long notifyUserId) throws RemoteException, MXException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.name + ": Starting user refresh for user with id " + notifyUserId));
        }
        UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
        MboUtil.visitSingleMbo(userInfo, "ISNOTIFYUSER", notifyUserId, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote mbo) throws RemoteException, MXException {
                NotifyUserRemote user = (NotifyUserRemote)mbo;
                if (user.refreshNotifications(refreshQueueId)) {
                    user.sendPushMessage(refreshQueueId);
                }
            }
        });
        InformerTracking.notificationStop(refreshQueueId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("%s: Completed user refresh for user with id %d", this.name, notifyUserId));
        }
    }

    private void processNotificationRefreshQueueRecord(final long refreshQueueId, final long notifyId, final long recordId) throws RemoteException, MXException {
        UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("%s: Evaluating (notifyid=%d, recordid=%d) for data updates", this.name, notifyId, recordId));
        }
        try {
            final String hash = NotifyXMLUtils.getNotificationContentHash(userInfo, notifyId, recordId);
            SqlFormat sqlf = new SqlFormat("notifyid = :1 AND recordid = :2 AND active = 1 AND hash <> :3");
            sqlf.setLong(1, notifyId);
            sqlf.setLong(2, recordId);
            sqlf.setObject(3, "ISUSERNOTIFICATION", "HASH", hash);
            final Date updateDate = MXServer.getMXServer().getDate();
            int updates = MboUtil.visitMbos(userInfo, "ISUSERNOTIFICATION", sqlf.format(), new NotifyUtil.MboVisitor(){

                @Override
                public void visit(@NotNull MboRemote mbo) throws RemoteException, MXException {
                    if (NotificationJobQueueEvaluator.this.logger.isInfoEnabled()) {
                        NotificationJobQueueEvaluator.this.logger.info((Object)String.format("%s: Recording update for user notification %d (notifyid %d, recordId %d) for user %s", NotificationJobQueueEvaluator.this.name, mbo.getUniqueIDValue(), notifyId, recordId, mbo.getString("USERID")));
                    }
                    new MboMutator(mbo, 2L).setValue("LASTUPDATE", updateDate).setValue("HASH", hash).setValue("REFRESHED", true);
                    ((UserNotificationRemote)mbo).sendPushMessage(refreshQueueId);
                }
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("%s: Processed update for notifyid %d, recordid %d for %d users", this.name, notifyId, recordId, updates));
            }
        }
        catch (NoSuchRecordException e) {
            this.logger.info((Object)"Record was not found. Presuming that this job is just stale, and concluding it as no-op", (Throwable)((Object)e));
        }
        InformerTracking.notificationStop(refreshQueueId, notifyId, recordId);
    }
}

