/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.notification;

import com.interlocsolutions.maximo.notify.err.ErrorHandlerAccessor;
import com.interlocsolutions.maximo.notify.queue.ProcessorKey;
import com.interlocsolutions.maximo.notify.queue.ProcessorKeyKt;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJob;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobQueueEvaluator;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.ProcessorMonitorable;
import com.interlocsolutions.maximo.notify.util.ProcessorState;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.RuntimeInfo;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import java.rmi.RemoteException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import psdi.server.MXServer;
import psdi.util.MXException;

public class BulkByThreadProcessor
extends InformerThreadIndefinite
implements ProcessorMonitorable {
    public final ProcessorType processorType;
    private final String name;
    @NotNull
    private ProcessorState processorState = ProcessorState.STARTING;
    private final MboInterface mbos;
    private final NotificationJobManager jobManager = NotificationJobManager.INSTANCE;
    private ProcessorKey processorKey;
    private final ErrorHandlerAccessor mErrorHandlerAccessor = new ErrorHandlerAccessor(this.logger, "informer.nrqp.errorhandler");

    public BulkByThreadProcessor(InformerThreadGroup threadGroup, String threadName, String name, ProcessorType processorType) throws MXException {
        super(threadGroup, threadName, 25000L, false, true, NotifyConstants.INFORMER_NRQP_LOGGER);
        this.setPriority(1);
        this.processorType = processorType;
        switch (processorType) {
            case USEREXPAND: {
                this.name = name + "-X";
                break;
            }
            case USERREFRESH: {
                this.name = name + "-U";
                break;
            }
            default: {
                this.name = name;
            }
        }
        try {
            this.mbos = MboInterface.Companion.obtain(MXServer.getMXServer().getSystemUserInfo());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public ProcessorState getProcessorState() {
        return this.processorState;
    }

    private void setProcessorState(@NotNull ProcessorState processorState) {
        this.processorState = processorState;
    }

    @Override
    protected void initTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        this.processorKey = ProcessorKeyKt.asProcessorKey(RuntimeInfo.getRuntimeInfo());
        this.setProcessorState(ProcessorState.STARTING);
        NotifyXMLUtils.getMD5Digest();
        try {
            this.jobManager.freeJobsForProcessor(this.processorKey);
        }
        catch (Throwable t) {
            this.logger.warn((Object)(this.getName() + ": Failed to clean up own jobs locks from the last run. Initialization will proceed anyway."), t);
        }
    }

    @Override
    protected void cleanUpTask() {
    }

    @Override
    protected void onIntervalPause() {
        super.onIntervalPause();
        this.setProcessorState(ProcessorState.WAITING);
    }

    @Override
    protected void onAdminModePause() {
        super.onAdminModePause();
        this.setProcessorState(ProcessorState.ADMINMODE);
    }

    @Override
    protected void runRecurringInformerTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        this.setProcessorState(ProcessorState.RUNNING);
        InformerProp prop = PropUtil.INSTANCE.getProp("informer.queue.serializeClaiming.notification");
        boolean serializeClaiming = prop != null && prop.asBoolean(false);
        int threadNumber = serializeClaiming ? this.jobManager.findThreadNumber(this.processorType, this.processorKey) : 0;
        try {
            List<NotificationJob> lockedJobs = this.jobManager.claimJobs(this.processorKey, this.processorType, threadNumber, serializeClaiming);
            NotificationJobQueueEvaluator evaluator = new NotificationJobQueueEvaluator(this.mbos, this.logger, this.name);
            while (!lockedJobs.isEmpty()) {
                for (NotificationJob job : lockedJobs) {
                    if (!this.jobManager.activateJob(this.processorKey, job)) continue;
                    try {
                        evaluator.evaluate(job);
                        this.jobManager.reportJobCompletion(this.processorKey, job);
                    }
                    catch (Exception e) {
                        try {
                            this.mErrorHandlerAccessor.getErrorHandler().handleError(e);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.jobManager.reportError(this.processorKey, job, e);
                    }
                }
                lockedJobs = this.jobManager.claimJobs(this.processorKey, this.processorType, threadNumber, serializeClaiming);
            }
        }
        catch (Exception e) {
            throw new InformerThreadIndefinite.InformerTaskException(e);
        }
    }

    @Override
    @NotNull
    public String getProcessorCategory() {
        return "NOTIFICATION.Q";
    }

    @Override
    @NotNull
    public String getProcessorType() {
        return this.processorType.getName();
    }

    @Override
    public void logAdditionalInformation() {
    }

    public static enum ProcessorType {
        USEREXPAND,
        USERREFRESH,
        NOTIFICATION;


        public String getName() {
            switch (this) {
                case USEREXPAND: {
                    return "Expansion";
                }
                case USERREFRESH: {
                    return "User";
                }
                case NOTIFICATION: {
                    return "Notification";
                }
            }
            return this.toString();
        }
    }
}

