/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.notification;

import com.interlocsolutions.maximo.notify.queue.AbstractQueueProcessor;
import com.interlocsolutions.maximo.notify.queue.QueueProcessorsMonitorRepo;
import com.interlocsolutions.maximo.notify.queue.notification.BulkByThreadProcessor;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobQueueProcessor;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0012\u001a\u00020\u00052\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0014J\b\u0010\u001d\u001a\u00020\u001aH\u0014J\b\u0010\u001e\u001a\u00020\u0017H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadNotificationJobQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJobQueueProcessor;", "()V", "legacyNotifyQueueDoNotRun", "", "legacyNotifyQueuePool", "nextThreadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "notificationPool", "Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadNotificationJobQueueProcessor$NotificationPoolConfig;", "getNotificationPool", "()Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadNotificationJobQueueProcessor$NotificationPoolConfig;", "notificationThreadGroup", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;", "queueProcessors", "", "Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadProcessor;", "determineNewNotificationQProp", "propAccessor", "Lkotlin/Function1;", "Lcom/interlocsolutions/maximo/notify/util/InformerProp;", "determineShutdown", "", "findLegacyNotificationConfig", "logDeprecationWarning", "", "it", "performProcess", "performShutdown", "performStartup", "NJQPThreadGroup", "NotificationPoolConfig", "isinformer"})
public final class BulkByThreadNotificationJobQueueProcessor
extends AbstractQueueProcessor
implements NotificationJobQueueProcessor {
    @NotNull
    private final String legacyNotifyQueueDoNotRun;
    @NotNull
    private final String legacyNotifyQueuePool;
    @NotNull
    private final InformerThreadGroup notificationThreadGroup;
    @NotNull
    private final List<BulkByThreadProcessor> queueProcessors;
    @NotNull
    private final AtomicInteger nextThreadNumber;

    public BulkByThreadNotificationJobQueueProcessor() {
        MXLogger mXLogger = NotifyConstants.INFORMER_NRQP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_NRQP_LOGGER");
        super(mXLogger);
        this.legacyNotifyQueueDoNotRun = "informer.notify.queue.donotrun";
        this.legacyNotifyQueuePool = "informer.notify.queue.pool";
        this.notificationThreadGroup = new NJQPThreadGroup();
        this.queueProcessors = new ArrayList();
        this.nextThreadNumber = new AtomicInteger(1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotificationPoolConfig getNotificationPool() {
        NotificationPoolConfig notificationPoolConfig;
        InformerProp informerProp;
        NotificationPoolConfig defaultNotificationConfig = new NotificationPoolConfig(1, 1, 1);
        InformerProp informerProp2 = this.findLegacyNotificationConfig();
        if (informerProp2 != null) {
            InformerProp it = informerProp2;
            boolean bl = false;
            this.logDeprecationWarning(it);
            informerProp = new InformerProp("informer.queue.pool.notification", this.determineNewNotificationQProp((Function1<? super String, InformerProp>)((Function1)new Function1<String, InformerProp>((Object)PropUtil.INSTANCE){

                @Nullable
                public final InformerProp invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((PropUtil)this.receiver).getProp(p0);
                }
            })));
        } else {
            informerProp = PropUtil.INSTANCE.getProp("informer.queue.pool.notification");
        }
        InformerProp poolProp2 = informerProp;
        try {
            NotificationPoolConfig notificationPoolConfig2;
            Object object = poolProp2;
            if (object != null && (object = ((InformerProp)object).asList()) != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable bl = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Integer it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    InformerProp it = (InformerProp)element$iv$iv;
                    boolean bl3 = false;
                    if (it.asInt() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List args = (List)destination$iv$iv;
                boolean bl5 = false;
                block1 : switch (args.size()) {
                    case 0: {
                        NotifyConstants.INFORMER_LOGGER.warn((Object)("informer.queue.pool.notification=" + poolProp2 + " is blank. Defaults will be used."));
                        notificationPoolConfig2 = defaultNotificationConfig;
                        break;
                    }
                    case 1: {
                        int singleValue = ((Number)args.get(0)).intValue();
                        switch (singleValue) {
                            case 0: {
                                notificationPoolConfig2 = new NotificationPoolConfig(0, 0, 0);
                                break block1;
                            }
                            case 1: 
                            case 2: {
                                NotifyConstants.INFORMER_LOGGER.warn((Object)("informer.queue.pool.notification=" + poolProp2 + " is specified as a single number, but less than the required minimum of 3. Defaults will be used."));
                                notificationPoolConfig2 = defaultNotificationConfig;
                                break block1;
                            }
                        }
                        notificationPoolConfig2 = new NotificationPoolConfig(1, 1, singleValue - 2);
                        break;
                    }
                    case 2: {
                        NotifyConstants.INFORMER_LOGGER.warn((Object)("informer.queue.pool.notification=" + poolProp2 + " has too few arguments. Defaults will be used. To allow only specific queue types to run, specify 0 for other types (i.e. " + ((Number)args.get(0)).intValue() + ',' + ((Number)args.get(1)).intValue() + ",0 or 0," + ((Number)args.get(0)).intValue() + ',' + ((Number)args.get(1)).intValue() + " or " + ((Number)args.get(0)).intValue() + ",0," + ((Number)args.get(1)).intValue() + ")."));
                        notificationPoolConfig2 = defaultNotificationConfig;
                        break;
                    }
                    case 3: {
                        notificationPoolConfig2 = new NotificationPoolConfig(((Number)args.get(0)).intValue(), ((Number)args.get(1)).intValue(), ((Number)args.get(2)).intValue());
                        break;
                    }
                    default: {
                        NotifyConstants.INFORMER_LOGGER.warn((Object)("informer.queue.pool.notification=" + poolProp2 + " has too many arguments. Defaults will be used."));
                        notificationPoolConfig2 = defaultNotificationConfig;
                    }
                }
            } else {
                notificationPoolConfig2 = defaultNotificationConfig;
            }
            notificationPoolConfig = notificationPoolConfig2;
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)("Unable to parse queue pool size from informer.queue.pool.notification=" + poolProp2 + ".Pool sizes will be set to default values.\nCause: " + e));
            notificationPoolConfig = defaultNotificationConfig;
        }
        return notificationPoolConfig;
    }

    @Override
    protected boolean performStartup() {
        int existingNotificationThreadNum;
        int existingUsrThreadNum;
        int existingExpThreadNum;
        NotificationPoolConfig notificationPoolConfig = this.getNotificationPool();
        int numUserExpand = notificationPoolConfig.component1();
        int numUserRefresh = notificationPoolConfig.component2();
        int numNotification = notificationPoolConfig.component3();
        int n = numUserExpand + existingExpThreadNum;
        for (int i = existingExpThreadNum = QueueProcessorsMonitorRepo.INSTANCE.getProcessorsCount("NOTIFICATION.Q", BulkByThreadProcessor.ProcessorType.USEREXPAND.name()); i < n; ++i) {
            BulkByThreadProcessor nrqp = new BulkByThreadProcessor(this.notificationThreadGroup, "Informer-NotificationQueueProcessor-UserExpansion-" + this.nextThreadNumber.getAndAdd(1), "NRQP" + i, BulkByThreadProcessor.ProcessorType.USEREXPAND);
            this.queueProcessors.add(nrqp);
            nrqp.start();
        }
        int nrqp = numUserRefresh + existingUsrThreadNum;
        for (int i = existingUsrThreadNum = QueueProcessorsMonitorRepo.INSTANCE.getProcessorsCount("NOTIFICATION.Q", BulkByThreadProcessor.ProcessorType.USERREFRESH.name()); i < nrqp; ++i) {
            BulkByThreadProcessor nrqp2 = new BulkByThreadProcessor(this.notificationThreadGroup, "Informer-NotificationQueueProcessor-UserEvaluator-" + this.nextThreadNumber.getAndAdd(1), "NRQP" + i, BulkByThreadProcessor.ProcessorType.USERREFRESH);
            this.queueProcessors.add(nrqp2);
            nrqp2.start();
        }
        int n2 = numNotification + existingNotificationThreadNum;
        for (int i = existingNotificationThreadNum = QueueProcessorsMonitorRepo.INSTANCE.getProcessorsCount("NOTIFICATION.Q", BulkByThreadProcessor.ProcessorType.NOTIFICATION.name()); i < n2; ++i) {
            BulkByThreadProcessor nrqp3 = new BulkByThreadProcessor(this.notificationThreadGroup, "Informer-NotificationQueueProcessor-Record-" + this.nextThreadNumber.getAndAdd(1), "NRQP" + i, BulkByThreadProcessor.ProcessorType.NOTIFICATION);
            this.queueProcessors.add(nrqp3);
            nrqp3.start();
        }
        return true;
    }

    @Override
    protected void performShutdown() {
        this.queueProcessors.clear();
        this.notificationThreadGroup.awaitShutdown(10L, TimeUnit.SECONDS);
    }

    @Override
    protected void performProcess() {
        for (BulkByThreadProcessor nrqp : this.queueProcessors) {
            nrqp.wake();
        }
    }

    @Override
    protected boolean determineShutdown() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.queueProcessors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BulkByThreadProcessor it = (BulkByThreadProcessor)element$iv;
                    boolean bl2 = false;
                    if (!it.isAlive()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void logDeprecationWarning(InformerProp it) {
        NotifyConstants.INFORMER_LOGGER.warn((Object)StringsKt.trimIndent((String)("\n                **** **** **** ****\n                **** **** **** ****\n                Use of JVM or System Property '" + it.getPropName() + "' is deprecated, and will be removed in a later version.\n                Please use the 'informer.queue.pool.notification'\n                Maximo System Properties to control your queues, globally and/or using Instance properties.\n                **** **** **** ****\n                **** **** **** ****\n                ")));
    }

    private final InformerProp findLegacyNotificationConfig() {
        InformerProp informerProp = PropUtil.INSTANCE.getProp("informer.queue.donotrun");
        if (informerProp == null && (informerProp = PropUtil.INSTANCE.getProp("informer.queue.pool")) == null && (informerProp = PropUtil.INSTANCE.getProp(this.legacyNotifyQueueDoNotRun)) == null) {
            informerProp = PropUtil.INSTANCE.getProp(this.legacyNotifyQueuePool);
        }
        return informerProp;
    }

    private final String determineNewNotificationQProp(Function1<? super String, InformerProp> propAccessor) {
        int n;
        InformerProp informerProp = (InformerProp)propAccessor.invoke((Object)"informer.queue.donotrun");
        if (informerProp != null ? Intrinsics.areEqual((Object)informerProp.asBoolean(), (Object)true) : false) {
            n = 0;
        } else {
            InformerProp informerProp2 = (InformerProp)propAccessor.invoke((Object)this.legacyNotifyQueueDoNotRun);
            if (informerProp2 != null ? Intrinsics.areEqual((Object)informerProp2.asBoolean(), (Object)true) : false) {
                n = 0;
            } else {
                Object object = (InformerProp)propAccessor.invoke((Object)this.legacyNotifyQueuePool);
                if (object != null && (object = ((InformerProp)object).asInt()) != null) {
                    n = (Integer)object;
                } else {
                    InformerProp informerProp3 = (InformerProp)propAccessor.invoke((Object)"informer.queue.pool");
                    Integer n2 = informerProp3 != null ? informerProp3.asInt() : null;
                    n = n2 != null ? n2 : 3;
                }
            }
        }
        int poolSize = n;
        return poolSize <= 0 ? "0,0,0" : (poolSize >= 3 ? "1,1," + (poolSize - 2) : "1,1,1");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadNotificationJobQueueProcessor$NotificationPoolConfig;", "", "numUserExpand", "", "numUserRefresh", "numNotification", "(III)V", "getNumNotification", "()I", "getNumUserExpand", "getNumUserRefresh", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "isinformer"})
    public static final class NotificationPoolConfig {
        private final int numUserExpand;
        private final int numUserRefresh;
        private final int numNotification;

        public NotificationPoolConfig(int numUserExpand, int numUserRefresh, int numNotification) {
            this.numUserExpand = numUserExpand;
            this.numUserRefresh = numUserRefresh;
            this.numNotification = numNotification;
        }

        public final int getNumUserExpand() {
            return this.numUserExpand;
        }

        public final int getNumUserRefresh() {
            return this.numUserRefresh;
        }

        public final int getNumNotification() {
            return this.numNotification;
        }

        public final int component1() {
            return this.numUserExpand;
        }

        public final int component2() {
            return this.numUserRefresh;
        }

        public final int component3() {
            return this.numNotification;
        }

        @NotNull
        public final NotificationPoolConfig copy(int numUserExpand, int numUserRefresh, int numNotification) {
            return new NotificationPoolConfig(numUserExpand, numUserRefresh, numNotification);
        }

        public static /* synthetic */ NotificationPoolConfig copy$default(NotificationPoolConfig notificationPoolConfig, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = notificationPoolConfig.numUserExpand;
            }
            if ((n4 & 2) != 0) {
                n2 = notificationPoolConfig.numUserRefresh;
            }
            if ((n4 & 4) != 0) {
                n3 = notificationPoolConfig.numNotification;
            }
            return notificationPoolConfig.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "NotificationPoolConfig(numUserExpand=" + this.numUserExpand + ", numUserRefresh=" + this.numUserRefresh + ", numNotification=" + this.numNotification + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.numUserExpand);
            result = result * 31 + Integer.hashCode(this.numUserRefresh);
            result = result * 31 + Integer.hashCode(this.numNotification);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotificationPoolConfig)) {
                return false;
            }
            NotificationPoolConfig notificationPoolConfig = (NotificationPoolConfig)other;
            if (this.numUserExpand != notificationPoolConfig.numUserExpand) {
                return false;
            }
            if (this.numUserRefresh != notificationPoolConfig.numUserRefresh) {
                return false;
            }
            return this.numNotification == notificationPoolConfig.numNotification;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadNotificationJobQueueProcessor$NJQPThreadGroup;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;", "()V", "isinformer"})
    private static final class NJQPThreadGroup
    extends InformerThreadGroup {
        public NJQPThreadGroup() {
            super(InformerThreadGroup.getInformerThreadGroup());
        }
    }
}

