/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.notification;

import com.interlocsolutions.maximo.notify.err.ErrorHandlerAccessor;
import com.interlocsolutions.maximo.notify.queue.AbstractBulkByJvmWriterThread;
import com.interlocsolutions.maximo.notify.queue.BulkByJvmWriterSql;
import com.interlocsolutions.maximo.notify.queue.notification.BulkByJvmNotificationWriterSqlKt;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJob;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.sql.PreparedStatement;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0014J.\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0014J\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014\u00a8\u0006\u001c"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByJvmWriterThread;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread;", "Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJob;", "threadName", "", "writerQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "mErrorHandlerAccessor", "Lcom/interlocsolutions/maximo/notify/err/ErrorHandlerAccessor;", "(Ljava/lang/String;Ljava/util/concurrent/BlockingQueue;Lcom/interlocsolutions/maximo/notify/err/ErrorHandlerAccessor;)V", "getBatchSize", "", "getCurrentErrorCount", "payload", "getProcessorCategory", "getWriterSql", "Lcom/interlocsolutions/maximo/notify/queue/BulkByJvmWriterSql;", "serverType", "Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "handleError", "", "statement", "Ljava/sql/PreparedStatement;", "newErrorCount", "errorMessage", "handleErrorExceeded", "handleSuccess", "isinformer"})
public final class BulkByJvmWriterThread
extends AbstractBulkByJvmWriterThread<NotificationJob> {
    public BulkByJvmWriterThread(@Nullable String threadName, @NotNull BlockingQueue<AbstractBulkByJvmWriterThread.Payload<NotificationJob>> writerQueue, @NotNull ErrorHandlerAccessor mErrorHandlerAccessor) {
        Intrinsics.checkNotNullParameter(writerQueue, (String)"writerQueue");
        Intrinsics.checkNotNullParameter((Object)mErrorHandlerAccessor, (String)"mErrorHandlerAccessor");
        MXLogger mXLogger = NotifyConstants.INFORMER_NRQP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_NRQP_LOGGER");
        super(threadName, writerQueue, mErrorHandlerAccessor, "Notification Queue Writer", "NOTIFICATION.Q", mXLogger);
    }

    @Override
    protected int getBatchSize() {
        Object object = PropUtil.INSTANCE.getProp("informer.notification.queue.BatchSize");
        return RangesKt.coerceAtLeast((int)(object != null && (object = ((InformerProp)object).asInt()) != null ? ((Integer)object).intValue() : this.getDefaultBatchSize()), (int)1);
    }

    @Override
    @NotNull
    public String getProcessorCategory() {
        return "NOTIFICATION.Q";
    }

    @Override
    protected void handleSuccess(@NotNull PreparedStatement statement, @NotNull AbstractBulkByJvmWriterThread.Payload<NotificationJob> payload) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        statement.setLong(1, payload.getJob().getJobId());
    }

    @Override
    protected void handleError(@NotNull PreparedStatement statement, @NotNull AbstractBulkByJvmWriterThread.Payload<NotificationJob> payload, int newErrorCount, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        statement.setInt(1, newErrorCount);
        statement.setString(2, errorMessage);
        statement.setLong(3, payload.getJob().getJobId());
    }

    @Override
    protected void handleErrorExceeded(@NotNull PreparedStatement statement, @NotNull AbstractBulkByJvmWriterThread.Payload<NotificationJob> payload, int newErrorCount, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        statement.setInt(1, newErrorCount);
        statement.setString(2, errorMessage);
        statement.setLong(3, payload.getJob().getJobId());
    }

    @Override
    protected int getCurrentErrorCount(@NotNull AbstractBulkByJvmWriterThread.Payload<NotificationJob> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Integer n = payload.getJob().getErrorCount();
        return n != null ? n : 0;
    }

    @Override
    @NotNull
    protected BulkByJvmWriterSql getWriterSql(@NotNull DbServerType serverType) {
        Intrinsics.checkNotNullParameter((Object)serverType, (String)"serverType");
        return BulkByJvmNotificationWriterSqlKt.newBulkByJvmWriterSql(serverType);
    }
}

