/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.err.InformerConfException;
import com.interlocsolutions.maximo.notify.err.NoSuchRecordException;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobInit;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherDB;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherDBImpl;
import com.interlocsolutions.maximo.notify.queue.db.JobInitFinalize;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import java.io.Closeable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.MXRowUpdateException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\r\u001a\u00020\fH\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/JobInitDB;", "Lcom/interlocsolutions/maximo/notify/queue/catalog/JobInit;", "()V", "commitBatchSize", "", "evalContext", "Lcom/interlocsolutions/maximo/notify/queue/catalog/EvalContext;", "jobDispatcher", "Lcom/interlocsolutions/maximo/notify/queue/db/JobDispatcherDB;", "params", "Lcom/interlocsolutions/maximo/notify/queue/catalog/JobInit$JobSpecInit;", "initialize", "", "invoke", "Companion", "isinformer"})
public final class JobInitDB
implements JobInit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JobDispatcherDB jobDispatcher;
    @Nullable
    private EvalContext evalContext;
    @Nullable
    private JobInit.JobSpecInit params;
    private final int commitBatchSize = PropUtils.Companion.getIntMaxProp("informer.catalog.queue.commitbatchsize", 500);
    @NotNull
    private static final MXLogger LOGGER;

    public JobInitDB() throws RemoteException, MXException {
        JobDispatcher jobDispatcher = JobConfig.getJobDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)jobDispatcher, (String)"getJobDispatcher()");
        JobDispatcher jobDispatcher2 = jobDispatcher;
        JobDispatcherDB jobDispatcherDB = jobDispatcher2 instanceof JobDispatcherDB ? (JobDispatcherDB)jobDispatcher2 : null;
        if (jobDispatcherDB == null) {
            throw new InformerConfException("When using a database-backed Catalog Refresh Queue Processor, the configured implementation of " + JobDispatcher.class + " must implement " + JobDispatcherDBImpl.class + ". Obtained " + jobDispatcher2 + " instead.");
        }
        this.jobDispatcher = jobDispatcherDB;
    }

    @Override
    public void initialize(@NotNull EvalContext evalContext, @NotNull JobInit.JobSpecInit params) {
        Intrinsics.checkNotNullParameter((Object)evalContext, (String)"evalContext");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.params = params;
        this.evalContext = evalContext;
        evalContext.setFlag(EvalFlags.INITIALIZATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void invoke() throws RemoteException, MXException {
        ImmutableLongSet concurrentModificationRetries$iv2;
        long l;
        void userInfo$iv;
        JobInit.JobSpecInit jobSpecInit = this.params;
        Intrinsics.checkNotNull((Object)jobSpecInit);
        JobInit.JobSpecInit params = jobSpecInit;
        EvalContext evalContext = this.evalContext;
        Intrinsics.checkNotNull((Object)evalContext);
        EvalContext evalContext2 = evalContext;
        long catalogId = params.catalogId;
        UserInfo userInfo = evalContext2.getUserInfo();
        String string = "ISCATALOG";
        int concurrentModificationRetries$iv2 = 5;
        boolean $i$f$visitSingleMboWithRetryOrThrow = false;
        MboInterface this_$iv$iv = MboInterface.Companion.obtain((UserInfo)userInfo$iv);
        boolean $i$f$visitSingleMboWithRetryOrThrow2 = false;
        int attempts$iv$iv = 0;
        while (true) {
            try {
                void $this$use$iv$iv$iv$iv$iv;
                void mboName$iv;
                MboInterface this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$visitSingleMboOrThrow = false;
                String whereClause$iv$iv$iv$iv = null;
                boolean discardable$iv$iv$iv$iv = false;
                boolean $i$f$useNewMboSet = false;
                MboSetRemote mboSetRemote = this_$iv$iv$iv.getNewMboSet((String)mboName$iv, whereClause$iv$iv$iv$iv, discardable$iv$iv$iv$iv);
                boolean $i$f$use = false;
                Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv$iv$iv$iv);
                Throwable throwable = null;
                try {
                    MboSetRemoteClosableWrapper it$iv$iv$iv$iv$iv = (MboSetRemoteClosableWrapper)closeable;
                    boolean bl = false;
                    void mboSet$iv$iv$iv = $this$use$iv$iv$iv$iv$iv;
                    boolean bl2 = false;
                    MboRemote mbo$iv$iv$iv = mboSet$iv$iv$iv.getMboForUniqueId(catalogId);
                    if (mbo$iv$iv$iv != null) {
                        MboRemote $this$invoke_u24lambda_u240 = mbo$iv$iv$iv;
                        boolean bl3 = false;
                        long result$iv$iv$iv = ((Catalog)$this$invoke_u24lambda_u240).incrementRevisionNumber();
                        mboSet$iv$iv$iv.save();
                        long l2 = result$iv$iv$iv;
                        l = l2;
                        break;
                    }
                    try {
                        throw new NoSuchRecordException((String)mboName$iv, catalogId);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (MXRowUpdateException e$iv$iv) {
                if (++attempts$iv$iv < concurrentModificationRetries$iv2) continue;
                throw e$iv$iv;
            }
            break;
        }
        long revision = l;
        CachedCatalog cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrNull(catalogId, revision);
        if (cachedCatalog == null) {
            JobInitDB it = this;
            boolean bl = false;
            LOGGER.warn((Object)("Initialization job " + params + " is no-op because no Catalog with ID " + catalogId + " and Revision " + revision + " was found."));
            return;
        }
        CachedCatalog cachedCatalog2 = cachedCatalog;
        try {
            ImmutableLongSet immutableLongSet = DataUtils.collectUniqueIdsByMbo(evalContext2.getUserInfo(), cachedCatalog2.objectName, cachedCatalog2.whereClause);
            Intrinsics.checkNotNullExpressionValue((Object)immutableLongSet, (String)"{\n            DataUtils.\u2026og.whereClause)\n        }");
            concurrentModificationRetries$iv2 = immutableLongSet;
        }
        catch (SQLException e) {
            String[] stringArray = new String[]{"ID collection failed"};
            throw new MXApplicationException("informer", "sqlError", (Object[])stringArray, (Throwable)e);
        }
        ImmutableLongSet recordIdSet = concurrentModificationRetries$iv2;
        ArrayList<JobEval.JobSpecEval> jobDefinitions = new ArrayList<JobEval.JobSpecEval>(this.commitBatchSize);
        int created = 0;
        for (Long uniqueRecordId : recordIdSet) {
            for (String langCode : NotifyUtil.getLangCodes()) {
                Intrinsics.checkNotNullExpressionValue((Object)uniqueRecordId, (String)"uniqueRecordId");
                jobDefinitions.add(new JobEval.JobSpecEval(catalogId, revision, (long)uniqueRecordId, langCode));
                if (++created % this.commitBatchSize != 0) continue;
                this.jobDispatcher.doDbInitEvals(evalContext2.duplicate(), (Collection<? extends JobEval.JobSpecEval>)jobDefinitions, params.jobId);
                jobDefinitions.clear();
            }
        }
        this.jobDispatcher.doDbInitEvals(evalContext2.duplicate(), (Collection<? extends JobEval.JobSpecEval>)jobDefinitions, params.jobId);
        jobDefinitions.clear();
        this.jobDispatcher.doDbInitPreloads(evalContext2.duplicate(), SetsKt.setOf((Object)new JobPreload.JobSpecPreload(catalogId, revision)), params.jobId);
        this.jobDispatcher.doDbInitFinalization(evalContext2.duplicate(), new JobInitFinalize.JobSpecInitFinalize(catalogId, revision, params.jobId, 0L, 8, null));
    }

    static {
        MXLogger mXLogger = NotifyConstants.INFORMER_CRQP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_CRQP_LOGGER");
        LOGGER = mXLogger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/JobInitDB$Companion;", "", "()V", "LOGGER", "Lpsdi/util/logging/MXLogger;", "getLOGGER", "()Lpsdi/util/logging/MXLogger;", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MXLogger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

