/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.err.InformerEvalException;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobRepo;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobInit;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPartialReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.catalog.JobReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobRelationshipEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobSqliteGeneration;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherBase;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherDB;
import com.interlocsolutions.maximo.notify.queue.db.JobInitFinalize;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;

public class JobDispatcherDBImpl
extends JobDispatcherBase
implements JobDispatcherDB {
    private final CatalogJobRepo catalogJobRepo = CatalogJobRepo.INSTANCE;

    @Override
    public void doEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobEval.JobSpecEval> jobs, @NotNull MboRemote mbo) throws RemoteException, MXException {
        this.doEvals(evalContext, jobs);
    }

    @Override
    public void doEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobEval.JobSpecEval> jobs) throws RemoteException, MXException {
        int evalPriority = evalContext.hasFlag(EvalFlags.INITIALIZATION) ? 110 : (evalContext.hasFlag(EvalFlags.RECONCILIATION_FULL) ? 400 : (evalContext.hasFlag(EvalFlags.RECONCILIATION_PARTIAL) ? 350 : 200));
        try {
            this.catalogJobRepo.getAdapter().addEvals(jobs, 0, evalPriority);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogEval", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doInits(@NotNull EvalContext evalContext, @NotNull Collection<JobInit.JobSpecInit> jobs) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.getAdapter().addInits(jobs, 0, 100);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogInit", "Failed to create jobs(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doPreloads(@NotNull EvalContext evalContext, @NotNull Collection<JobPreload.JobSpecPreload> jobs) throws RemoteException, MXException {
        int priority = evalContext.hasFlag(EvalFlags.INITIALIZATION) ? 120 : 300;
        try {
            this.catalogJobRepo.getAdapter().addPreloads(jobs, 1, priority);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogPreload", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doSqliteGenerations(@NotNull EvalContext evalContext, @NotNull Collection<JobSqliteGeneration.JobSpecSqliteGeneration> jobs) throws RemoteException, MXException {
        int priority = evalContext.hasFlag(EvalFlags.INITIALIZATION) ? 140 : 300;
        try {
            this.catalogJobRepo.getAdapter().addSqliteGeneration(jobs, 1, priority);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogPreload", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doRelationEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobRelationshipEval.JobSpecRelationshipEval> jobs, @NotNull MboRemote mbo) throws RemoteException, MXException {
        ArrayList<JobPartialReconcile.JobSpecPartialReconcile> convertedJobSpecs = new ArrayList<JobPartialReconcile.JobSpecPartialReconcile>();
        for (JobRelationshipEval.JobSpecRelationshipEval job : jobs) {
            convertedJobSpecs.add(new JobPartialReconcile.JobSpecPartialReconcile(job, mbo));
        }
        this.doPartialReconciles(evalContext, convertedJobSpecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRelationEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobRelationshipEval.JobSpecRelationshipEval> jobs) throws RemoteException, MXException {
        ArrayList<JobPartialReconcile.JobSpecPartialReconcile> convertedJobs = new ArrayList<JobPartialReconcile.JobSpecPartialReconcile>();
        UserInfo userInfo = evalContext.getUserInfo();
        for (JobRelationshipEval.JobSpecRelationshipEval job : jobs) {
            MboSetRemote dataSet = MXServer.getMXServer().getMboSet(job.parentMboName, userInfo);
            try {
                MboRemote mbo = dataSet.getMboForUniqueId(job.parentRecordId);
                if (mbo == null) {
                    NotifyConstants.INFORMER_CRQP_LOGGER.info((Object)String.format("%s with unique ID %d could not be found. Relationship %s could not be evaluated to trigger updates to %s by proxy.", job.parentMboName, job.parentRecordId, job.relationshipName, NotificationEventListenerManager.CatalogCache.getCatalogOrNull(job.catalogId)));
                    continue;
                }
                convertedJobs.add(new JobPartialReconcile.JobSpecPartialReconcile(job, mbo));
            }
            finally {
                NotifyUtil.closeAndCleanup(dataSet);
            }
        }
        this.doPartialReconciles(evalContext, convertedJobs);
    }

    @Override
    public void doPartialReconciles(@NotNull EvalContext evalContext, @NotNull Collection<JobPartialReconcile.JobSpecPartialReconcile> jobs) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.getAdapter().addPartialReconciliations(jobs, 1, 500);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogEval", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doReconciliations(@NotNull EvalContext evalContext, @NotNull Collection<JobReconcile.JobSpecReconcile> jobs) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.getAdapter().addReconciliations(jobs, 1, 400);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogEval", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doDbInitEvals(@NotNull EvalContext evalContext, @NotNull Collection<? extends JobEval.JobSpecEval> jobs, long parentJobId) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.getAdapter().addEvals(jobs, 0, 110, parentJobId);
        }
        catch (Exception e) {
            throw new InformerEvalException("CatalogInitExpansion", "Failed to create leaf jobs", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doDbInitPreloads(@NotNull EvalContext evalContext, @NotNull Collection<? extends JobPreload.JobSpecPreload> jobs, long parentJobId) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.getAdapter().addPreloads(jobs, 0, 120, parentJobId);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogEval", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void doDbInitFinalization(@NotNull EvalContext evalContext, @NotNull JobInitFinalize.JobSpecInitFinalize job) throws RemoteException, MXException {
        this.doInitFinalizations(evalContext, Collections.singleton(job));
    }

    @Override
    public void doInitFinalizations(@NotNull EvalContext evalContext, @NotNull Collection<JobInitFinalize.JobSpecInitFinalize> jobs) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.getAdapter().addInitFinalizations(jobs, 0, 130);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogEval", "Failed to create job(s)", (Throwable)e);
        }
        if (jobs.size() > 0) {
            this.onContentChanged();
        }
    }

    @Override
    public void cancelBefore(@NotNull EvalContext evalContext, long catalogId, long revision) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.discardJobsForOlderRevisions(catalogId, revision);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogCleanup", "Failed to delete job(s)", (Throwable)e);
        }
    }

    @Override
    public void cancelBefore(@NotNull EvalContext evalContext, long catalogId) throws RemoteException, MXException {
        try {
            this.catalogJobRepo.discardJobsForCatalog(catalogId);
        }
        catch (Exception e) {
            throw new InformerEvalException("QueueCatalogCleanup", "Failed to delete job(s)", (Throwable)e);
        }
    }

    @Override
    public void startUp() {
        try {
            JobConfig.getJobQueueProcessor().startup();
        }
        catch (RemoteException | MXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onContentChanged() {
        try {
            JobConfig.getJobQueueProcessor().process();
        }
        catch (RemoteException | MXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutDown(int maxTime, TimeUnit timeUnit) {
        try {
            JobConfig.getJobQueueProcessor().shutdown();
        }
        catch (RemoteException | MXException e) {
            throw new RuntimeException(e);
        }
    }
}

