/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.err.ErrorHandler;
import com.interlocsolutions.maximo.notify.err.ErrorHandlerAccessor;
import com.interlocsolutions.maximo.notify.queue.ProcessorKey;
import com.interlocsolutions.maximo.notify.queue.ProcessorKeyKt;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobRepo;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogQueueJob;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogQueueJobEvaluatorKt;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.ProcessorMonitorable;
import com.interlocsolutions.maximo.notify.util.ProcessorState;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.RuntimeInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020!H\u0014J\b\u0010%\u001a\u00020!H\u0016J\b\u0010&\u001a\u00020!H\u0014J\b\u0010'\u001a\u00020!H\u0014J\b\u0010(\u001a\u00020!H\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadProcessor;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadIndefinite;", "Lcom/interlocsolutions/maximo/notify/util/ProcessorMonitorable;", "threadGroup", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;", "threadName", "", "processorType", "", "(Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;Ljava/lang/String;I)V", "currentState", "Lcom/interlocsolutions/maximo/notify/util/ProcessorState;", "getCurrentState", "()Lcom/interlocsolutions/maximo/notify/util/ProcessorState;", "setCurrentState", "(Lcom/interlocsolutions/maximo/notify/util/ProcessorState;)V", "errorHandler", "Lcom/interlocsolutions/maximo/notify/err/ErrorHandler;", "getErrorHandler", "()Lcom/interlocsolutions/maximo/notify/err/ErrorHandler;", "mErrorHandlerAccessor", "Lcom/interlocsolutions/maximo/notify/err/ErrorHandlerAccessor;", "processorKey", "Lcom/interlocsolutions/maximo/notify/queue/ProcessorKey;", "getProcessorType", "()I", "claimJobs", "", "Lcom/interlocsolutions/maximo/notify/queue/catalog/CatalogQueueJob;", "serializeClaiming", "", "threadNumber", "cleanUpTask", "", "getProcessorCategory", "getProcessorState", "initTask", "logAdditionalInformation", "onAdminModePause", "onIntervalPause", "runRecurringInformerTask", "isinformer"})
public final class BulkByThreadProcessor
extends InformerThreadIndefinite
implements ProcessorMonitorable {
    private final int processorType;
    @NotNull
    private final ErrorHandlerAccessor mErrorHandlerAccessor;
    private ProcessorKey processorKey;
    @NotNull
    private ProcessorState currentState;

    public BulkByThreadProcessor(@NotNull InformerThreadGroup threadGroup, @Nullable String threadName, int processorType) {
        Intrinsics.checkNotNullParameter((Object)threadGroup, (String)"threadGroup");
        super(threadGroup, threadName, 25000L, false, true, NotifyConstants.INFORMER_CRQP_LOGGER);
        this.processorType = processorType;
        this.setPriority(1);
        this.mErrorHandlerAccessor = new ErrorHandlerAccessor(this.logger, "informer.crqp.errorhandler");
        this.currentState = ProcessorState.STARTING;
    }

    public final int getProcessorType() {
        return this.processorType;
    }

    @NotNull
    public final ProcessorState getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull ProcessorState processorState) {
        Intrinsics.checkNotNullParameter((Object)((Object)processorState), (String)"<set-?>");
        this.currentState = processorState;
    }

    @Override
    protected void initTask() throws InformerThreadIndefinite.InformerTaskException {
        RuntimeInfo runtimeInfo = RuntimeInfo.getRuntimeInfo();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeInfo, (String)"getRuntimeInfo()");
        this.processorKey = ProcessorKeyKt.asProcessorKey(runtimeInfo);
        this.currentState = ProcessorState.INITIALIZING;
        try {
            ProcessorKey processorKey = this.processorKey;
            if (processorKey == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                processorKey = null;
            }
            CatalogJobRepo.INSTANCE.freeJobsFor(processorKey);
        }
        catch (Exception t) {
            throw new InformerThreadIndefinite.InformerTaskException("Failed to clean up own jobs locks from the last run. Cannot initialize with a dirty state.", t);
        }
    }

    @Override
    protected void cleanUpTask() {
    }

    @Override
    protected void onIntervalPause() {
        super.onIntervalPause();
        this.currentState = ProcessorState.WAITING;
    }

    @Override
    protected void onAdminModePause() {
        super.onAdminModePause();
        this.currentState = ProcessorState.ADMINMODE;
    }

    @Override
    protected void runRecurringInformerTask() {
        int n;
        boolean serializeClaiming;
        MXLogger mXLogger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
        MXLogger $this$debugLazy_u24default$iv = mXLogger;
        Object e$iv = null;
        boolean $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Iterator<CatalogQueueJob> $i$a$-debugLazy$default-BulkByThreadProcessor$runRecurringInformerTask$22;
            try {
                boolean $i$a$-debugLazy$default-BulkByThreadProcessor$runRecurringInformerTask$22 = false;
                $i$a$-debugLazy$default-BulkByThreadProcessor$runRecurringInformerTask$22 = Result.constructor-impl((Object)("Starting the catalog queue loop for processing thread: " + this.getName()));
            }
            catch (Throwable throwable) {
                $i$a$-debugLazy$default-BulkByThreadProcessor$runRecurringInformerTask$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string = "(Unable to form error msg)";
            String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-BulkByThreadProcessor$runRecurringInformerTask$22) ? string : $i$a$-debugLazy$default-BulkByThreadProcessor$runRecurringInformerTask$22);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        this.getErrorHandler().reset();
        this.currentState = ProcessorState.RUNNING;
        InformerProp informerProp = PropUtil.INSTANCE.getProp("informer.queue.serializeClaiming.catalog");
        boolean bl = serializeClaiming = informerProp != null ? informerProp.asBoolean(false) : false;
        if (serializeClaiming) {
            ProcessorKey processorKey = this.processorKey;
            if (processorKey == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                processorKey = null;
            }
            n = CatalogJobRepo.INSTANCE.findThreadNumber(this.processorType, processorKey);
        } else {
            n = 0;
        }
        int threadNumber = n;
        try {
            List<CatalogQueueJob> claimedJobs = this.claimJobs(serializeClaiming, threadNumber);
            while (!((Collection)claimedJobs).isEmpty()) {
                for (CatalogQueueJob job : claimedJobs) {
                    Throwable throwable;
                    Object jobEvaluation;
                    Object $this$runRecurringInformerTask_u24lambda_u242;
                    MXLogger $this$infoLazy_u24default$iv;
                    if (this.shutdownRequested() || this.isInterrupted()) {
                        ProcessorKey processorKey = this.processorKey;
                        if (processorKey == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                            processorKey = null;
                        }
                        CatalogJobRepo.INSTANCE.freeJobsFor(processorKey);
                        break;
                    }
                    ProcessorKey processorKey = this.processorKey;
                    if (processorKey == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                        processorKey = null;
                    }
                    int numActivated = CatalogJobRepo.INSTANCE.activateJobsForSignature(processorKey, job, serializeClaiming);
                    Intrinsics.checkNotNullExpressionValue((Object)this.logger, (String)"logger");
                    Object e$iv2 = null;
                    boolean $i$f$infoLazy = false;
                    if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                        Object object;
                        try {
                            boolean bl2 = false;
                            object = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                        " + this.getName() + " activated " + numActivated + " job(s) with signature of \n                        (jobType=" + job.getJobType() + ", catalogId=" + job.getCatalogid() + ", revision=" + job.getRevision() + ", \n                        recordId=" + job.getRecordid() + ", langCode=" + job.getLangCode() + ", whereClause=" + job.getWhereClause() + ").\n                        ")));
                        }
                        catch (Throwable throwable2) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        String string = "(Unable to form error msg)";
                        String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                        $this$infoLazy_u24default$iv.info((Object)msg$iv);
                    }
                    if (numActivated <= 0) continue;
                    Object object = this;
                    try {
                        $this$runRecurringInformerTask_u24lambda_u242 = object;
                        boolean bl3 = false;
                        CatalogQueueJobEvaluatorKt.evaluate(job);
                        $this$runRecurringInformerTask_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl3) {
                        $this$runRecurringInformerTask_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object = jobEvaluation = $this$runRecurringInformerTask_u24lambda_u242;
                    if (Result.isSuccess-impl((Object)object)) {
                        Unit it = (Unit)object;
                        boolean bl4 = false;
                        ProcessorKey processorKey2 = this.processorKey;
                        if (processorKey2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                            processorKey2 = null;
                        }
                        CatalogJobRepo.INSTANCE.deleteActiveJobsForProcessor(processorKey2);
                    }
                    if (Result.exceptionOrNull-impl((Object)(object = jobEvaluation)) == null) continue;
                    Throwable e = throwable;
                    boolean bl5 = false;
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    String errMsg2 = string;
                    this.getErrorHandler().handleError(e);
                    CatalogJobRepo.INSTANCE.reportError(job, errMsg2);
                }
                if (!this.shutdownRequested() && !this.isInterrupted()) {
                    claimedJobs = this.claimJobs(serializeClaiming, threadNumber);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            try {
                ProcessorKey processorKey = this.processorKey;
                if (processorKey == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                    processorKey = null;
                }
                CatalogJobRepo.INSTANCE.freeJobsFor(processorKey);
            }
            catch (Throwable e2) {
                this.logger.warn((Object)e2);
            }
            this.getErrorHandler().handleError(e);
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<CatalogQueueJob> claimJobs(boolean serializeClaiming, int threadNumber) {
        block23: {
            block22: {
                switch (this.processorType) {
                    case 0: {
                        v0 = PropUtil.INSTANCE.getProp("informer.max.QueueBatchSize");
                        v1 = RangesKt.coerceAtLeast((int)(v0 != null && (v0 = v0.asInt()) != null ? v0.intValue() : 100), (int)1);
                        break;
                    }
                    case 1: {
                        v1 = 1;
                        break;
                    }
                    default: {
                        v1 = 1;
                    }
                }
                batchSize = v1;
                orderPropName = "informer.catalog.queue.ordering";
                v2 = PropUtil.INSTANCE.getProp(orderPropName);
                if (v2 == null || (v2 = v2.asString()) == null) {
                    v2 = "priority";
                }
                ordering = v2;
                switch (ordering.hashCode()) {
                    case 0: {
                        if (!ordering.equals("")) {
                            ** break;
                        }
                        break block22;
                    }
                    case 3142860: {
                        if (ordering.equals("fifo")) break;
                        ** break;
                    }
                    case 3387192: {
                        if (!ordering.equals("none")) {
                            ** break;
                        }
                        break block22;
                    }
                    case -1165461084: {
                        if (!ordering.equals("priority")) ** break;
                        var7_8 = new String[]{"priority", "iscatalogjobqueueid"};
                        v3 = CollectionsKt.listOf((Object[])var7_8);
                        break block23;
                    }
                }
                v3 = CollectionsKt.listOf((Object)"iscatalogjobqueueid");
                break block23;
            }
            v3 = CollectionsKt.emptyList();
            break block23;
lbl39:
            // 5 sources

            it = var7_8 = CollectionsKt.emptyList();
            $i$a$-also-BulkByThreadProcessor$claimJobs$orderColumns$1 = false;
            this.logger.error((Object)("Value of '" + orderPropName + "', '" + (String)ordering + "', is not recognized. Ordering will not be enforced."));
            v3 = var7_8;
        }
        orderColumns = v3;
        var6_6 = serializeClaiming;
        if (!var6_6) {
            v4 = this.processorKey;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                v4 = null;
            }
            v5 = CatalogJobRepo.INSTANCE.claimJobs(v4, this.processorType, batchSize, (List<String>)orderColumns);
        } else if (var6_6) {
            v6 = this.processorKey;
            if (v6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processorKey");
                v6 = null;
            }
            v7 = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"logger");
            v5 = CatalogJobRepo.INSTANCE.claimJobs(v6, this.processorType, batchSize, (List<String>)orderColumns, threadNumber, v7);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        claimedJobs = var6_7 = v5;
        $i$a$-also-BulkByThreadProcessor$claimJobs$1 = false;
        v8 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"logger");
        $this$debugLazy_u24default$iv = v8;
        e$iv = null;
        $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            try {
                $i$a$-debugLazy$default-BulkByThreadProcessor$claimJobs$1$1 = false;
                var13_19 = Result.constructor-impl((Object)(this.getName() + " claimed " + claimedJobs.size() + " job(s)."));
            }
            catch (Throwable var12_17) {
                var13_19 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var12_17));
            }
            var12_18 = "(Unable to form error msg)";
            msg$iv = (String)(Result.isFailure-impl((Object)var13_19) != false ? var12_18 : var13_19);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        return var6_7;
    }

    private final ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.mErrorHandlerAccessor.getErrorHandler();
        Intrinsics.checkNotNullExpressionValue((Object)errorHandler, (String)"mErrorHandlerAccessor.errorHandler");
        return errorHandler;
    }

    @Override
    @NotNull
    public ProcessorState getProcessorState() {
        return this.currentState;
    }

    @Override
    @NotNull
    public String getProcessorCategory() {
        return "CATALOG.Q";
    }

    @Override
    @NotNull
    public String getProcessorType() {
        String string;
        switch (this.processorType) {
            case 1: {
                string = "Aggregate";
                break;
            }
            case 0: {
                string = "Record";
                break;
            }
            default: {
                string = String.valueOf(this.processorType);
            }
        }
        return string;
    }

    @Override
    public void logAdditionalInformation() {
    }
}

