/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPartialReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobRelationshipEval;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class JobRelationshipEvalImpl
implements JobRelationshipEval {
    protected EvalContext evalContext;
    private JobRelationshipEval.JobSpecRelationshipEval params;
    private int commitBatchSize;
    private JobDispatcher jobDispatcher = JobConfig.getJobDispatcher();

    public JobRelationshipEvalImpl() throws RemoteException, MXException {
        this.commitBatchSize = PropUtils.getIntMaxProp("informer.catalog.queue.commitbatchsize", 500);
    }

    @Override
    public void initialize(EvalContext evalContext, JobRelationshipEval.JobSpecRelationshipEval params) {
        this.params = params;
        this.evalContext = evalContext;
        evalContext.setFlag(EvalFlags.RELATIONSHIP_EVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws RemoteException, MXException {
        UserInfo userInfo = this.evalContext.getUserInfo();
        MboSetRemote dataSet = MXServer.getMXServer().getMboSet(this.params.parentMboName, userInfo);
        try {
            MboRemote mbo = dataSet.getMboForUniqueId(this.params.parentRecordId);
            if (mbo == null) {
                NotifyConstants.INFORMER_CRQP_LOGGER.info((Object)String.format("%s with unique ID %d could not be found. Relationship %s could not be evaluated to trigger updates to %s by proxy.", this.params.parentMboName, this.params.parentRecordId, this.params.relationshipName, NotificationEventListenerManager.CatalogCache.getCatalogOrNull(this.params.catalogId, this.params.revision)));
                return;
            }
            if (!StringUtils.isEmpty(this.params.relationshipName)) {
                mbo.getMboSet(this.params.relationshipName).setFlag(39L, true);
            }
            this.invoke(mbo);
        }
        finally {
            NotifyUtil.closeAndCleanup(dataSet);
        }
    }

    @Override
    public void invoke(@NotNull MboRemote parentMbo) throws RemoteException, MXException {
        MboSetRemote catalogRelatedSet;
        ArrayList<JobEval.JobSpecEval> jobDefinitions = new ArrayList<JobEval.JobSpecEval>(this.commitBatchSize);
        if (!StringUtils.isEmpty(this.params.relationshipName)) {
            catalogRelatedSet = parentMbo.getMboSet(this.params.relationshipName);
        } else if (!StringUtils.isEmpty(this.params.anonWhereClause)) {
            String relName = "$isinfrelatedlstnr_" + (this.params.catalogMboName + this.params.anonWhereClause).hashCode();
            catalogRelatedSet = parentMbo.getMboSet(relName, this.params.catalogMboName, this.params.anonWhereClause);
            catalogRelatedSet.setFlag(39L, true);
        } else {
            throw new MXApplicationException("informer", "invalidParameter", new Object[]{JobPartialReconcile.JobSpecPartialReconcile.class, String.format("%s instance contains neither a named relationship nor an anonymous where-clause", this.params.getClass())});
        }
        int currentBatchCount = 0;
        MboSetIterator relItr = new MboSetIterator(catalogRelatedSet);
        MboRemote catalogRelatedMbo = relItr.moveFirst();
        while (catalogRelatedMbo != null) {
            for (String langCode : NotifyUtil.getLangCodes()) {
                jobDefinitions.add(new JobEval.JobSpecEval(this.params.catalogId, this.params.revision, catalogRelatedMbo.getUniqueIDValue(), langCode));
                if (NotifyConstants.INFORMER_CRQP_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_CRQP_LOGGER.debug((Object)String.format("Queued evaluation of object %s with record id %d for catalog %d, langCode %s", catalogRelatedMbo.getName(), catalogRelatedMbo.getUniqueIDValue(), this.params.catalogId, langCode));
                }
                if (++currentBatchCount < this.commitBatchSize) continue;
                this.jobDispatcher.doEvals(this.evalContext.duplicate(), jobDefinitions);
                jobDefinitions.clear();
                currentBatchCount = 0;
            }
            catalogRelatedMbo = relItr.moveNext();
        }
        this.jobDispatcher.doEvals(this.evalContext.duplicate(), jobDefinitions);
        jobDefinitions.clear();
    }
}

