/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobReconcile;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class JobReconcileImpl
implements JobReconcile {
    protected static final MXLogger LOGGER = NotifyConstants.INFORMER_CRQP_LOGGER;
    protected EvalContext evalContext;
    protected JobReconcile.JobSpecReconcile params;
    private JobDispatcher jobDispatcher;
    private int commitBatchSize = PropUtils.getIntMaxProp("informer.catalog.queue.commitbatchsize", 500);

    public JobReconcileImpl() throws RemoteException, MXException {
        this.jobDispatcher = JobConfig.getJobDispatcher();
    }

    @Override
    public void initialize(EvalContext evalContext, JobReconcile.JobSpecReconcile params) {
        this.params = params;
        this.evalContext = evalContext;
        evalContext.setFlag(EvalFlags.RECONCILIATION_FULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws MXException, RemoteException {
        block24: {
            MboSetRemote catalogSet = MXServer.getMXServer().getMboSet("ISCATALOG", this.evalContext.getUserInfo());
            try {
                long[] fullIdArr;
                catalogSet.setFlag(7L, true);
                MboRemote catalog = catalogSet.getMboForUniqueId(this.params.catalogId);
                if (catalog == null) {
                    LOGGER.warn((Object)("Could not find catalog for id " + this.params.catalogId + ", the reload process is being aborted."));
                    break block24;
                }
                if (this.params.revision != catalog.getLong("REVISION")) {
                    LOGGER.warn((Object)String.format("The current catalog revision for catalog %s of %d does not match the queued revision of %d, the reload process is being aborted.", catalog.getString("CATALOG"), catalog.getLong("REVISION"), this.params.revision));
                    break block24;
                }
                String objectName = catalog.getString("OBJECTNAME");
                String whereClause = catalog.getString("WHERECLAUSE");
                DBManager dbManager = MXServer.getMXServer().getDBManager();
                ConnectionKey connKey = this.evalContext.getUserInfo().getConnectionKey();
                try {
                    Connection conn = dbManager.getConnection(connKey);
                    Statement stmt = conn.createStatement();
                    try {
                        ImmutableLongSet.Builder existingIdSetBuilder = new ImmutableLongSet.Builder();
                        SqlFormat sqlf = new SqlFormat("SELECT recordid FROM iscatalogdata WHERE catalogid = :1 AND revision = :2 AND langcode = :3 AND inscope= :yes");
                        sqlf.setLong(1, this.params.catalogId);
                        sqlf.setLong(2, this.params.revision);
                        sqlf.setObject(3, "ISCATALOGDATA", "LANGCODE", MXServer.getMXServer().getBaseLang());
                        ResultSet rs = stmt.executeQuery(sqlf.format());
                        try {
                            int colIdxRecordId = rs.findColumn("recordid");
                            while (rs.next()) {
                                existingIdSetBuilder.add(rs.getLong(colIdxRecordId));
                            }
                        }
                        finally {
                            NotifyUtil.close(rs);
                        }
                        ImmutableLongSet existingIdSet = existingIdSetBuilder.build();
                        ImmutableLongSet.Builder freshIdSetBuilder = new ImmutableLongSet.Builder();
                        MboSetInfo setInfo = MXServer.getMXServer().getMboSet(objectName, this.evalContext.getUserInfo()).getMboSetInfo();
                        StringBuilder sb = new StringBuilder().append("SELECT ").append(setInfo.getUniqueIDName()).append(" FROM ").append(setInfo.getEntityName());
                        if (whereClause != null && !whereClause.trim().isEmpty()) {
                            sb.append(" WHERE ").append(whereClause);
                        }
                        SqlFormat sqlf2 = new SqlFormat(sb.toString());
                        ResultSet rs2 = stmt.executeQuery(sqlf2.format());
                        try {
                            int colIdxRecordId = rs2.findColumn(setInfo.getUniqueIDName());
                            while (rs2.next()) {
                                long recordId = rs2.getLong(colIdxRecordId);
                                if (existingIdSet.contains(recordId)) continue;
                                freshIdSetBuilder.add(recordId);
                            }
                        }
                        finally {
                            NotifyUtil.close(rs2);
                        }
                        ImmutableLongSet freshIdSet = freshIdSetBuilder.build();
                        long[] existingIdArr = existingIdSet.asArray();
                        existingIdSet = null;
                        long[] freshIdArr = freshIdSet.asArray();
                        freshIdSet = null;
                        fullIdArr = this.arrayCat(existingIdArr, freshIdArr);
                    }
                    finally {
                        NotifyUtil.close(stmt);
                    }
                }
                catch (SQLException e) {
                    throw new MXApplicationException("informer", "sqlError", (Object[])new String[]{"Reconciliation failed due to an error"}, (Throwable)e);
                }
                finally {
                    dbManager.freeConnection(connKey);
                }
                ArrayList<JobEval.JobSpecEval> jobDefinitions = new ArrayList<JobEval.JobSpecEval>(this.commitBatchSize);
                int count = 0;
                for (long recordId : fullIdArr) {
                    for (String langCode : NotifyUtil.getLangCodes()) {
                        jobDefinitions.add(new JobEval.JobSpecEval(this.params.catalogId, this.params.revision, recordId, langCode));
                        if (++count % this.commitBatchSize != 0) continue;
                        this.jobDispatcher.doEvals(this.evalContext.duplicate(), jobDefinitions);
                        jobDefinitions.clear();
                    }
                }
                this.jobDispatcher.doEvals(this.evalContext.duplicate(), jobDefinitions);
                jobDefinitions.clear();
            }
            finally {
                NotifyUtil.closeAndCleanup(catalogSet);
            }
        }
    }

    long[] arrayCat(long[] array1, long[] array2) {
        int fullIdIdx = 0;
        long[] fullIdArr = new long[array1.length + array2.length];
        for (long anArray1 : array1) {
            fullIdArr[fullIdIdx++] = anArray1;
        }
        for (long anArray2 : array2) {
            fullIdArr[fullIdIdx++] = anArray2;
        }
        return fullIdArr;
    }
}

