/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.google.gson.Gson;
import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.CatalogPreloadCronTaskKt;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.GsonFactory;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreloadImpl;
import com.interlocsolutions.maximo.notify.queue.catalog.PreloadParams;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.util.CollectionExtensionsKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MaxSequence;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J*\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreloadImpl;", "Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreload;", "()V", "evalContext", "Lcom/interlocsolutions/maximo/notify/queue/catalog/EvalContext;", "params", "Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreload$JobSpecPreload;", "flushToNewPage", "", "catalogInfo", "Lcom/interlocsolutions/maximo/notify/util/CachedCatalog;", "partitionName", "", "pageNum", "", "pageStart", "newVersion", "langCode", "catalogEntries", "Ljava/util/Deque;", "Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreloadImpl$CatalogEntry;", "generatePreload", "pageSize", "initialize", "invoke", "", "CatalogEntry", "Companion", "isinformer"})
public final class JobPreloadImpl
implements JobPreload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private EvalContext evalContext;
    private JobPreload.JobSpecPreload params;
    @NotNull
    private static final MXLogger logger;

    @Override
    public void initialize(@NotNull EvalContext evalContext, @NotNull JobPreload.JobSpecPreload params) {
        Intrinsics.checkNotNullParameter((Object)evalContext, (String)"evalContext");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.evalContext = evalContext;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean invoke() throws RemoteException, MXException {
        PreloadParams preloadParams;
        Gson $this$fromJson$iv;
        boolean bl;
        if (this.evalContext == null || this.params == null) {
            logger.warn((Object)(this.getClass().getSimpleName() + " is not initialized."));
            return true;
        }
        JobPreload.JobSpecPreload jobSpecPreload = this.params;
        if (jobSpecPreload == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            jobSpecPreload = null;
        }
        String string = jobSpecPreload.extraParams;
        if (string != null) {
            String it = string;
            bl = false;
            $this$fromJson$iv = GsonFactory.INSTANCE.getGsonInstance();
            boolean $i$f$fromJson = false;
            preloadParams = (PreloadParams)$this$fromJson$iv.fromJson(it, PreloadParams.class);
        } else {
            preloadParams = null;
        }
        PreloadParams extraParams = preloadParams;
        ExecutorService threadPool = Executors.newFixedThreadPool(PropUtils.Companion.getIntMaxProp("informer.pregen.maxthreads", 2));
        try {
            int pagesize;
            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"com/interlocsolutions/maximo/notify/queue/catalog/JobPreloadImpl$invoke$PreloadConfig", "", "preloadEnabled", "", "pagesize", "", "(ZI)V", "getPagesize", "()I", "getPreloadEnabled", "()Z", "component1", "component2", "copy", "(ZI)Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreloadImpl$invoke$PreloadConfig;", "equals", "other", "hashCode", "toString", "", "isinformer"})
            public final class PreloadConfig {
                private final boolean preloadEnabled;
                private final int pagesize;

                public PreloadConfig(boolean preloadEnabled, int pagesize) {
                    this.preloadEnabled = preloadEnabled;
                    this.pagesize = pagesize;
                }

                public final boolean getPreloadEnabled() {
                    return this.preloadEnabled;
                }

                public final int getPagesize() {
                    return this.pagesize;
                }

                public final boolean component1() {
                    return this.preloadEnabled;
                }

                public final int component2() {
                    return this.pagesize;
                }

                @NotNull
                public final PreloadConfig copy(boolean preloadEnabled, int pagesize) {
                    return new PreloadConfig(preloadEnabled, pagesize);
                }

                public static /* synthetic */ PreloadConfig copy$default(PreloadConfig preloadConfig, boolean bl, int n, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        bl = preloadConfig.preloadEnabled;
                    }
                    if ((n2 & 2) != 0) {
                        n = preloadConfig.pagesize;
                    }
                    return preloadConfig.copy(bl, n);
                }

                @NotNull
                public String toString() {
                    return "PreloadConfig(preloadEnabled=" + this.preloadEnabled + ", pagesize=" + this.pagesize + ')';
                }

                public int hashCode() {
                    int n = (int)(this.preloadEnabled ? 1 : 0);
                    if (n != 0) {
                        n = 1;
                    }
                    int result = n;
                    result = result * 31 + Integer.hashCode(this.pagesize);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof PreloadConfig)) {
                        return false;
                    }
                    PreloadConfig preloadConfig = (PreloadConfig)other;
                    if (this.preloadEnabled != preloadConfig.preloadEnabled) {
                        return false;
                    }
                    return this.pagesize == preloadConfig.pagesize;
                }
            }
            PreloadConfig preloadConfig;
            PreloadConfig preloadConfig2;
            void $this$use$iv$iv$iv$iv;
            void mboName$iv;
            void userInfo$iv;
            CachedCatalog cachedCatalog;
            NotificationEventListenerManager.CatalogCache.reloadCache();
            JobPreload.JobSpecPreload jobSpecPreload2 = this.params;
            if (jobSpecPreload2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload2 = null;
            }
            long l = jobSpecPreload2.catalogId;
            JobPreload.JobSpecPreload jobSpecPreload3 = this.params;
            if (jobSpecPreload3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload3 = null;
            }
            if (NotificationEventListenerManager.CatalogCache.getCatalogOrNull(l, jobSpecPreload3.revision) == null) {
                JobPreloadImpl it = this;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder().append("This ").append(this.getClass().getSimpleName()).append(" cannot complete because a Catalog with ID ");
                JobPreload.JobSpecPreload jobSpecPreload4 = this.params;
                if (jobSpecPreload4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload4 = null;
                }
                logger.warn((Object)stringBuilder.append(jobSpecPreload4.catalogId).append(" could not be found.").toString());
                boolean bl3 = true;
                return bl3;
            }
            CachedCatalog catalogInfo = cachedCatalog;
            JobPreload.JobSpecPreload jobSpecPreload5 = this.params;
            if (jobSpecPreload5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload5 = null;
            }
            if (jobSpecPreload5.revision != catalogInfo.catalogRevision) {
                StringBuilder stringBuilder = new StringBuilder().append("The catalog revision ");
                JobPreload.JobSpecPreload jobSpecPreload6 = this.params;
                if (jobSpecPreload6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload6 = null;
                }
                StringBuilder stringBuilder2 = stringBuilder.append(jobSpecPreload6.revision).append(" does not match the current revision of ").append(catalogInfo.catalogRevision).append(" for catalog id ");
                JobPreload.JobSpecPreload jobSpecPreload7 = this.params;
                if (jobSpecPreload7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload7 = null;
                }
                logger.warn((Object)stringBuilder2.append(jobSpecPreload7.catalogId).append("; Skipping.").toString());
                boolean it = true;
                return it;
            }
            EvalContext evalContext = this.evalContext;
            if (evalContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"evalContext");
                evalContext = null;
            }
            $this$fromJson$iv = evalContext.getUserInfo();
            Object it = "ISCATALOG";
            JobPreload.JobSpecPreload jobSpecPreload8 = this.params;
            if (jobSpecPreload8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload8 = null;
            }
            long bl2 = jobSpecPreload8.catalogId;
            boolean readOnly$iv = true;
            boolean $i$f$mapSingleMbo = false;
            MboInterface this_$iv$iv = MboInterface.Companion.obtain((UserInfo)userInfo$iv);
            boolean $i$f$mapSingleMbo2 = false;
            String whereClause$iv$iv$iv = null;
            boolean $i$f$useNewMboSet = false;
            MboSetRemote mboSetRemote = this_$iv$iv.getNewMboSet((String)mboName$iv, whereClause$iv$iv$iv, readOnly$iv);
            boolean $i$f$use = false;
            Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv$iv$iv);
            Throwable throwable = null;
            try {
                PreloadConfig preloadConfig3;
                boolean bl4;
                MboRemote catalog;
                void uniqueId$iv;
                MboSetRemoteClosableWrapper it$iv$iv$iv$iv = (MboSetRemoteClosableWrapper)closeable;
                boolean bl5 = false;
                void mboSet$iv$iv = $this$use$iv$iv$iv$iv;
                boolean bl6 = false;
                MboRemote mbo$iv$iv = mboSet$iv$iv.getMboForUniqueId((long)uniqueId$iv);
                if (mbo$iv$iv == null) {
                    catalog = null;
                    bl4 = false;
                    preloadConfig3 = null;
                } else {
                    catalog = mbo$iv$iv;
                    bl4 = false;
                    MboRemote it2 = catalog;
                    boolean bl7 = false;
                    preloadConfig3 = new PreloadConfig(catalog.getBoolean("PRELOAD"), catalog.getInt("PAGESIZE"));
                }
                PreloadConfig preloadConfig4 = preloadConfig3;
                preloadConfig2 = preloadConfig4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (preloadConfig2 == null) {
                it = this;
                boolean bl8 = false;
                StringBuilder stringBuilder = new StringBuilder().append("The catalog refresh for catalog Id ");
                JobPreload.JobSpecPreload jobSpecPreload9 = this.params;
                if (jobSpecPreload9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload9 = null;
                }
                logger.warn((Object)stringBuilder.append(jobSpecPreload9.catalogId).append(" could not be completed because a catalog with that Id was not found.").toString());
                boolean $this$use$iv$iv$iv$iv2 = true;
                return $this$use$iv$iv$iv$iv2;
            }
            PreloadConfig preloadConfig5 = preloadConfig;
            if (!preloadConfig5.getPreloadEnabled()) {
                StringBuilder stringBuilder = new StringBuilder().append("Preload is disabled for Catalog ").append(catalogInfo.notifyNum).append(':').append(catalogInfo.catalogName).append("; Skipping job: ");
                JobPreload.JobSpecPreload jobSpecPreload10 = this.params;
                if (jobSpecPreload10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload10 = null;
                }
                logger.warn((Object)stringBuilder.append(jobSpecPreload10).toString());
                bl = true;
                return bl;
            }
            int n = pagesize = preloadConfig5.getPagesize() > 0 ? preloadConfig5.getPagesize() : 250;
            if (extraParams != null) {
                this.generatePreload(catalogInfo, extraParams.getPartitionName(), extraParams.getLangCode(), pagesize);
            } else {
                long l2 = catalogInfo.notifyId;
                JobPreload.JobSpecPreload jobSpecPreload11 = this.params;
                if (jobSpecPreload11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload11 = null;
                }
                long l3 = jobSpecPreload11.catalogId;
                JobPreload.JobSpecPreload jobSpecPreload12 = this.params;
                if (jobSpecPreload12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload12 = null;
                }
                long $this$invoke_u24lambda_u249 = InformerTracking.catalogPregenStart(l2, l3, jobSpecPreload12.jobId);
                boolean bl9 = false;
                JobPreload.JobSpecPreload jobSpecPreload13 = this.params;
                if (jobSpecPreload13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload13 = null;
                }
                long l4 = jobSpecPreload13.catalogId;
                JobPreload.JobSpecPreload jobSpecPreload14 = this.params;
                if (jobSpecPreload14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload14 = null;
                }
                Set<String> activePartitions = CatalogPreloadCronTaskKt.identifyActivePartitions(l4, jobSpecPreload14.revision);
                boolean bl10 = false;
                JobPreload.JobSpecPreload jobSpecPreload15 = this.params;
                if (jobSpecPreload15 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload15 = null;
                }
                long l5 = jobSpecPreload15.catalogId;
                JobPreload.JobSpecPreload jobSpecPreload16 = this.params;
                if (jobSpecPreload16 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                    jobSpecPreload16 = null;
                }
                CatalogPreloadCronTaskKt.deleteDefunctPartitions(l5, jobSpecPreload16.revision, activePartitions);
                Collection<String> collection = NotifyUtil.getLangCodes();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getLangCodes()");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                block19: for (Object element$iv : $this$forEach$iv) {
                    String langCode = (String)element$iv;
                    boolean bl11 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[catalogInfo.partitionType.ordinal()]) {
                        case 1: {
                            String partitionName;
                            Iterable $this$forEach$iv2 = activePartitions;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv2 : $this$forEach$iv2) {
                                partitionName = (String)element$iv2;
                                boolean bl12 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
                                this.generatePreload(catalogInfo, partitionName, langCode, pagesize);
                            }
                            continue block19;
                        }
                        case 2: {
                            Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
                            this.generatePreload(catalogInfo, null, langCode, pagesize);
                            break;
                        }
                        case 3: {
                            String partitionName;
                            Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
                            this.generatePreload(catalogInfo, null, langCode, pagesize);
                            Iterable $this$forEach$iv2 = activePartitions;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv2 : $this$forEach$iv2) {
                                partitionName = (String)element$iv2;
                                boolean bl13 = false;
                                this.generatePreload(catalogInfo, partitionName, langCode, pagesize);
                            }
                            continue block19;
                        }
                    }
                }
                InformerTracking.catalogPregenStop($this$invoke_u24lambda_u249);
            }
            NotificationEventListenerManager.CatalogCache.reloadCache();
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof MXException) {
                throw e;
            }
            if (exception instanceof RemoteException) {
                throw e;
            }
            Object[] objectArray = new String[1];
            StringBuilder stringBuilder = new StringBuilder().append("(Preload of Catalog ");
            JobPreload.JobSpecPreload jobSpecPreload17 = this.params;
            if (jobSpecPreload17 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload17 = null;
            }
            StringBuilder stringBuilder3 = stringBuilder.append(jobSpecPreload17.catalogId).append(", revision ");
            JobPreload.JobSpecPreload jobSpecPreload18 = this.params;
            if (jobSpecPreload18 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload18 = null;
            }
            objectArray[0] = stringBuilder3.append(jobSpecPreload18.revision).append(')').toString();
            throw new MXApplicationException("informer", "evalError", objectArray, (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return false;
    }

    private final void generatePreload(CachedCatalog catalogInfo, String partitionName, String langCode, int pageSize) {
        Object[] objectArray;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String newUID = string;
        String catalogDataSqlStr = null;
        Object[] catalogDataArgs = null;
        if (partitionName == null) {
            catalogDataSqlStr = "SELECT recordid, sequence, partitionname, xml\nFROM ISCATALOGDATA\nWHERE  catalogid = ? AND revision = ? AND mainrecord = ? AND langcode = ? AND inscope = ?\nORDER BY sequence ASC";
            objectArray = new Object[5];
            JobPreload.JobSpecPreload jobSpecPreload = this.params;
            if (jobSpecPreload == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload = null;
            }
            objectArray[0] = jobSpecPreload.catalogId;
            JobPreload.JobSpecPreload jobSpecPreload2 = this.params;
            if (jobSpecPreload2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload2 = null;
            }
            objectArray[1] = jobSpecPreload2.revision;
            objectArray[2] = true;
            objectArray[3] = langCode;
            objectArray[4] = true;
            catalogDataArgs = objectArray;
        } else {
            catalogDataSqlStr = "SELECT recordid, sequence, partitionname, xml\nFROM ISCATALOGDATA\nWHERE catalogid = ? AND revision = ? AND partitionname = ? AND langcode = ? AND inscope = ?\nORDER BY sequence ASC";
            objectArray = new Object[5];
            JobPreload.JobSpecPreload jobSpecPreload = this.params;
            if (jobSpecPreload == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload = null;
            }
            objectArray[0] = jobSpecPreload.catalogId;
            JobPreload.JobSpecPreload jobSpecPreload3 = this.params;
            if (jobSpecPreload3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                jobSpecPreload3 = null;
            }
            objectArray[1] = jobSpecPreload3.revision;
            objectArray[2] = partitionName;
            objectArray[3] = langCode;
            objectArray[4] = true;
            catalogDataArgs = objectArray;
        }
        Deque catalogEntries = new ArrayDeque();
        Ref.IntRef count = new Ref.IntRef();
        Ref.IntRef nextPageStart = new Ref.IntRef();
        Ref.IntRef pageCount = new Ref.IntRef();
        Ref.LongRef highestSequenceNum = new Ref.LongRef();
        DbConnectionManager.getInstance().getMaximoConnection().useConn((Function1)new Function1<Connection, Unit>(catalogDataSqlStr, catalogDataArgs, count, pageSize, (Deque<CatalogEntry>)catalogEntries, this, catalogInfo, partitionName, pageCount, nextPageStart, newUID, langCode, highestSequenceNum){
            final /* synthetic */ String $catalogDataSqlStr;
            final /* synthetic */ Object[] $catalogDataArgs;
            final /* synthetic */ Ref.IntRef $count;
            final /* synthetic */ int $pageSize;
            final /* synthetic */ Deque<CatalogEntry> $catalogEntries;
            final /* synthetic */ JobPreloadImpl this$0;
            final /* synthetic */ CachedCatalog $catalogInfo;
            final /* synthetic */ String $partitionName;
            final /* synthetic */ Ref.IntRef $pageCount;
            final /* synthetic */ Ref.IntRef $nextPageStart;
            final /* synthetic */ String $newUID;
            final /* synthetic */ String $langCode;
            final /* synthetic */ Ref.LongRef $highestSequenceNum;
            {
                this.$catalogDataSqlStr = $catalogDataSqlStr;
                this.$catalogDataArgs = $catalogDataArgs;
                this.$count = $count;
                this.$pageSize = $pageSize;
                this.$catalogEntries = $catalogEntries;
                this.this$0 = $receiver;
                this.$catalogInfo = $catalogInfo;
                this.$partitionName = $partitionName;
                this.$pageCount = $pageCount;
                this.$nextPageStart = $nextPageStart;
                this.$newUID = $newUID;
                this.$langCode = $langCode;
                this.$highestSequenceNum = $highestSequenceNum;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Connection conn) {
                void resultSetConcurrency$iv$iv$iv;
                void resultSetType$iv$iv$iv;
                void $this$usePrepStatement_u24default$iv$iv$iv;
                void sqlStr$iv;
                Statement $this$use$iv$iv$iv;
                void $this$executeReadOnceQuery$iv$iv;
                void bindArgs$iv;
                void $this$executeReadOnceQuery$iv;
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Connection connection = conn;
                String string = this.$catalogDataSqlStr;
                Object[] objectArray = Arrays.copyOf(this.$catalogDataArgs, this.$catalogDataArgs.length);
                Ref.IntRef intRef = this.$count;
                int n = this.$pageSize;
                Deque<CatalogEntry> deque = this.$catalogEntries;
                JobPreloadImpl jobPreloadImpl = this.this$0;
                CachedCatalog cachedCatalog = this.$catalogInfo;
                String string2 = this.$partitionName;
                Ref.IntRef intRef2 = this.$pageCount;
                Ref.IntRef intRef3 = this.$nextPageStart;
                String string3 = this.$newUID;
                String string4 = this.$langCode;
                Ref.LongRef longRef = this.$highestSequenceNum;
                boolean $i$f$executeReadOnceQuery = false;
                void var17_17 = $this$executeReadOnceQuery$iv;
                List bindArgs$iv$iv = ArraysKt.toList((Object[])bindArgs$iv);
                boolean $i$f$executeReadOnceQuery2 = false;
                Collection collection = bindArgs$iv$iv;
                if (collection == null || collection.isEmpty()) {
                    $this$use$iv$iv$iv = $this$executeReadOnceQuery$iv$iv.createStatement(1003, 1007);
                    boolean $i$f$use = false;
                    Closeable closeable = (Closeable)new StatementCloseableWrapper($this$use$iv$iv$iv);
                    Throwable throwable = null;
                    try {
                        StatementCloseableWrapper it$iv$iv$iv = (StatementCloseableWrapper)closeable;
                        boolean bl = false;
                        Statement it$iv$iv = $this$use$iv$iv$iv;
                        boolean bl2 = false;
                        ResultSet resultSet = it$iv$iv.executeQuery((String)sqlStr$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(sqlStr)");
                        ResultSet rs = resultSet;
                        boolean bl3 = false;
                        int colRecordId = rs.findColumn("RECORDID");
                        int colSequence = rs.findColumn("SEQUENCE");
                        int colPartitionName = rs.findColumn("PARTITIONNAME");
                        int colXml = rs.findColumn("XML");
                        while (rs.next()) {
                            if (intRef.element > 0 && intRef.element % n == 0) {
                                int countInPage = deque.size();
                                int n2 = intRef2.element;
                                intRef2.element = n2 + 1;
                                JobPreloadImpl.access$flushToNewPage(jobPreloadImpl, cachedCatalog, string2, n2, intRef3.element, string3, string4, deque);
                                intRef3.element += countInPage;
                            }
                            long sequence = rs.getLong(colSequence);
                            deque.addLast(new CatalogEntry(rs.getLong(colRecordId), sequence, rs.getString(colPartitionName), rs.getString(colXml)));
                            longRef.element = Math.max(longRef.element, sequence);
                            int n3 = intRef.element;
                            intRef.element = n3 + 1;
                        }
                        it$iv$iv$iv = Unit.INSTANCE;
                    }
                    catch (Throwable it$iv$iv$iv) {
                        throwable = it$iv$iv$iv;
                        throw it$iv$iv$iv;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                $this$use$iv$iv$iv = $this$executeReadOnceQuery$iv$iv;
                int $i$f$use = 1003;
                int n4 = 1007;
                Object resultSetHoldability$iv$iv$iv = null;
                Object generatedKeys$iv$iv$iv = null;
                boolean $i$f$usePrepStatement = false;
                PreparedStatement stmt$iv$iv$iv = $this$usePrepStatement_u24default$iv$iv$iv.prepareStatement((String)sqlStr$iv, (int)resultSetType$iv$iv$iv, (int)resultSetConcurrency$iv$iv$iv);
                Statement $this$use$iv$iv$iv$iv = stmt$iv$iv$iv;
                boolean $i$f$use2 = false;
                Closeable closeable = (Closeable)new StatementCloseableWrapper($this$use$iv$iv$iv$iv);
                Throwable throwable = null;
                try {
                    Unit unit;
                    StatementCloseableWrapper it$iv$iv$iv$iv = (StatementCloseableWrapper)closeable;
                    boolean bl = false;
                    PreparedStatement prepStmt$iv$iv$iv = (PreparedStatement)$this$use$iv$iv$iv$iv;
                    boolean bl4 = false;
                    List list = bindArgs$iv$iv;
                    if (list != null) {
                        Iterable $this$forEachIndexed$iv$iv$iv$iv = list;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv$iv$iv$iv = 0;
                        for (T item$iv$iv$iv$iv : $this$forEachIndexed$iv$iv$iv$iv) {
                            void arg$iv$iv$iv;
                            int n5;
                            if ((n5 = index$iv$iv$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            T t = item$iv$iv$iv$iv;
                            int index$iv$iv$iv = n5;
                            boolean bl5 = false;
                            void var55_78 = arg$iv$iv$iv;
                            if (var55_78 instanceof Boolean) {
                                if (DbServerType.identify((Connection)$this$usePrepStatement_u24default$iv$iv$iv) == DbServerType.POSTGRESQL) {
                                    prepStmt$iv$iv$iv.setInt(index$iv$iv$iv + 1, (Boolean)arg$iv$iv$iv != false ? 1 : 0);
                                    continue;
                                }
                                prepStmt$iv$iv$iv.setBoolean(index$iv$iv$iv + 1, (Boolean)arg$iv$iv$iv);
                                continue;
                            }
                            if (var55_78 instanceof Integer) {
                                prepStmt$iv$iv$iv.setInt(index$iv$iv$iv + 1, ((Number)arg$iv$iv$iv).intValue());
                                continue;
                            }
                            if (var55_78 instanceof Long) {
                                prepStmt$iv$iv$iv.setLong(index$iv$iv$iv + 1, ((Number)arg$iv$iv$iv).longValue());
                                continue;
                            }
                            if (var55_78 instanceof Date) {
                                prepStmt$iv$iv$iv.setDate(index$iv$iv$iv + 1, (Date)arg$iv$iv$iv);
                                continue;
                            }
                            if (var55_78 instanceof java.util.Date) {
                                prepStmt$iv$iv$iv.setTimestamp(index$iv$iv$iv + 1, new Timestamp(((java.util.Date)arg$iv$iv$iv).getTime()));
                                continue;
                            }
                            if (var55_78 instanceof Timestamp) {
                                prepStmt$iv$iv$iv.setTimestamp(index$iv$iv$iv + 1, (Timestamp)arg$iv$iv$iv);
                                continue;
                            }
                            if (var55_78 instanceof String) {
                                prepStmt$iv$iv$iv.setString(index$iv$iv$iv + 1, (String)arg$iv$iv$iv);
                                continue;
                            }
                            if (var55_78 instanceof Clob) {
                                prepStmt$iv$iv$iv.setClob(index$iv$iv$iv + 1, (Clob)arg$iv$iv$iv);
                                continue;
                            }
                            if (var55_78 instanceof Reader) {
                                prepStmt$iv$iv$iv.setClob(index$iv$iv$iv + 1, (Reader)arg$iv$iv$iv);
                                continue;
                            }
                            prepStmt$iv$iv$iv.setObject(index$iv$iv$iv + 1, arg$iv$iv$iv);
                        }
                    }
                    Statement $this$use$iv$iv$iv$iv2 = prepStmt$iv$iv$iv;
                    boolean $i$f$use3 = false;
                    Closeable closeable2 = (Closeable)new StatementCloseableWrapper($this$use$iv$iv$iv$iv2);
                    Object object = null;
                    try {
                        StatementCloseableWrapper it$iv$iv$iv$iv2 = (StatementCloseableWrapper)closeable2;
                        $i$a$-use-JDBCExtensionsKt$use$2$iv$iv$iv$iv = false;
                        PreparedStatement it$iv$iv$iv = (PreparedStatement)$this$use$iv$iv$iv$iv2;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it$iv$iv$iv, (String)"it");
                        PreparedStatement prepStmt$iv$iv = it$iv$iv$iv;
                        boolean bl7 = false;
                        ResultSet resultSet = prepStmt$iv$iv.executeQuery();
                        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"prepStmt.executeQuery()");
                        ResultSet rs = resultSet;
                        boolean bl8 = false;
                        int colRecordId = rs.findColumn("RECORDID");
                        int colSequence = rs.findColumn("SEQUENCE");
                        int colPartitionName = rs.findColumn("PARTITIONNAME");
                        int colXml = rs.findColumn("XML");
                        while (rs.next()) {
                            if (intRef.element > 0 && intRef.element % n == 0) {
                                int countInPage = deque.size();
                                int n6 = intRef2.element;
                                intRef2.element = n6 + 1;
                                JobPreloadImpl.access$flushToNewPage(jobPreloadImpl, cachedCatalog, string2, n6, intRef3.element, string3, string4, deque);
                                intRef3.element += countInPage;
                            }
                            long sequence = rs.getLong(colSequence);
                            deque.addLast(new CatalogEntry(rs.getLong(colRecordId), sequence, rs.getString(colPartitionName), rs.getString(colXml)));
                            longRef.element = Math.max(longRef.element, sequence);
                            int n7 = intRef.element;
                            intRef.element = n7 + 1;
                        }
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        try {
                            object = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable2, object);
                            throw throwable3;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                    Unit unit2 = unit;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
        if (!((Collection)catalogEntries).isEmpty()) {
            int n = pageCount.element;
            pageCount.element = n + 1;
            this.flushToNewPage(catalogInfo, partitionName, n, nextPageStart.element, newUID, langCode, catalogEntries);
        }
        int finalCount = count.element;
        DbConnectionManager.getInstance().getMaximoConnection().useConn((Function1)new Function1<Connection, Integer>(partitionName, catalogInfo, langCode, this, newUID, finalCount, highestSequenceNum){
            final /* synthetic */ String $partitionName;
            final /* synthetic */ CachedCatalog $catalogInfo;
            final /* synthetic */ String $langCode;
            final /* synthetic */ JobPreloadImpl this$0;
            final /* synthetic */ String $newUID;
            final /* synthetic */ int $finalCount;
            final /* synthetic */ Ref.LongRef $highestSequenceNum;
            {
                this.$partitionName = $partitionName;
                this.$catalogInfo = $catalogInfo;
                this.$langCode = $langCode;
                this.this$0 = $receiver;
                this.$newUID = $newUID;
                this.$finalCount = $finalCount;
                this.$highestSequenceNum = $highestSequenceNum;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final Integer invoke(@NotNull Connection conn) {
                Integer n;
                void $this$transaction$iv;
                String string;
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                if (this.$partitionName != null) {
                    objectArray = new Object[]{this.$catalogInfo.catalogId, this.$catalogInfo.catalogRevision, this.$langCode, this.$partitionName};
                    string = JDBCExtensionsKt.queryForString((Connection)conn, (String)"SELECT preloaduid FROM iscatpreload\nWHERE catalogid = ? AND revision = ? AND langcode = ? AND partitionname = ?", (Object[])objectArray);
                } else {
                    objectArray = new Object[]{this.$catalogInfo.catalogId, this.$catalogInfo.catalogRevision, this.$langCode};
                    string = JDBCExtensionsKt.queryForString((Connection)conn, (String)"SELECT preloaduid FROM iscatpreload\nWHERE catalogid = ? AND revision = ? AND langcode = ? AND partitionname IS NULL", (Object[])objectArray);
                }
                String previousUID = string;
                java.util.Date timeNow = MXServer.getMXServer().getDate();
                Connection connection = conn;
                String string2 = this.$partitionName;
                JobPreloadImpl jobPreloadImpl = this.this$0;
                String string3 = this.$langCode;
                String string4 = this.$newUID;
                int n2 = this.$finalCount;
                Ref.LongRef longRef = this.$highestSequenceNum;
                boolean $i$f$transaction = false;
                boolean autoCommitWasEnabled$iv = $this$transaction$iv.getAutoCommit();
                try {
                    Integer n3;
                    int numUpdated;
                    int n4;
                    Object[] objectArray2;
                    if (autoCommitWasEnabled$iv) {
                        $this$transaction$iv.setAutoCommit(false);
                    } else {
                        $this$transaction$iv.rollback();
                    }
                    void it = $this$transaction$iv;
                    boolean bl = false;
                    if (previousUID == null && string2 != null) {
                        objectArray2 = new Object[9];
                        objectArray2[0] = MaxSequence.generateKey((Connection)conn, (String)"ISCATPRELOAD", (String)"CATPRELOADID");
                        JobPreload.JobSpecPreload jobSpecPreload = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload = null;
                        }
                        objectArray2[1] = jobSpecPreload.catalogId;
                        JobPreload.JobSpecPreload jobSpecPreload2 = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload2 = null;
                        }
                        objectArray2[2] = jobSpecPreload2.revision;
                        objectArray2[3] = string2;
                        objectArray2[4] = string3;
                        objectArray2[5] = string4;
                        objectArray2[6] = n2;
                        objectArray2[7] = longRef.element;
                        objectArray2[8] = timeNow;
                        n4 = JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"INSERT INTO iscatpreload (catpreloadid,\n    catalogid, revision, partitionname, langcode,\n    preloaduid, recordcount, seqend, preloaddate\n)\nVALUES (?,?,?,?,?,?,?,?,?)", (Object[])objectArray2);
                    } else if (previousUID == null && string2 == null) {
                        objectArray2 = new Object[8];
                        objectArray2[0] = MaxSequence.generateKey((Connection)conn, (String)"ISCATPRELOAD", (String)"CATPRELOADID");
                        JobPreload.JobSpecPreload jobSpecPreload = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload = null;
                        }
                        objectArray2[1] = jobSpecPreload.catalogId;
                        JobPreload.JobSpecPreload jobSpecPreload3 = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload3 = null;
                        }
                        objectArray2[2] = jobSpecPreload3.revision;
                        objectArray2[3] = string3;
                        objectArray2[4] = string4;
                        objectArray2[5] = n2;
                        objectArray2[6] = longRef.element;
                        objectArray2[7] = timeNow;
                        n4 = JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"INSERT INTO iscatpreload (catpreloadid,\n    catalogid, revision, langcode,\n    preloaduid, recordcount, seqend, preloaddate\n)\nVALUES (?,?,?,?,?,?,?,?)", (Object[])objectArray2);
                    } else if (previousUID != null && string2 != null) {
                        objectArray2 = new Object[9];
                        objectArray2[0] = string4;
                        objectArray2[1] = n2;
                        objectArray2[2] = longRef.element;
                        objectArray2[3] = timeNow;
                        JobPreload.JobSpecPreload jobSpecPreload = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload = null;
                        }
                        objectArray2[4] = jobSpecPreload.catalogId;
                        JobPreload.JobSpecPreload jobSpecPreload4 = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload4 = null;
                        }
                        objectArray2[5] = jobSpecPreload4.revision;
                        objectArray2[6] = string2;
                        objectArray2[7] = string3;
                        objectArray2[8] = previousUID;
                        n4 = JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"UPDATE iscatpreload\nSET preloaduid = ?, recordcount = ?, seqend = ?, preloaddate = ?\nWHERE catalogid = ? AND revision = ? AND partitionname = ? AND langcode = ? AND preloaduid = ?", (Object[])objectArray2);
                    } else if (previousUID != null && string2 == null) {
                        objectArray2 = new Object[8];
                        objectArray2[0] = string4;
                        objectArray2[1] = n2;
                        objectArray2[2] = longRef.element;
                        objectArray2[3] = timeNow;
                        JobPreload.JobSpecPreload jobSpecPreload = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload = null;
                        }
                        objectArray2[4] = jobSpecPreload.catalogId;
                        JobPreload.JobSpecPreload jobSpecPreload5 = JobPreloadImpl.access$getParams$p(jobPreloadImpl);
                        if (jobSpecPreload5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                            jobSpecPreload5 = null;
                        }
                        objectArray2[5] = jobSpecPreload5.revision;
                        objectArray2[6] = string3;
                        objectArray2[7] = previousUID;
                        n4 = JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"UPDATE iscatpreload\nSET preloaduid = ?, recordcount = ?, seqend = ?, preloaddate = ?\nWHERE catalogid = ? AND revision = ? AND partitionname IS NULL AND langcode = ? AND preloaduid = ?", (Object[])objectArray2);
                    } else {
                        n4 = numUpdated = 0;
                    }
                    if (numUpdated > 0) {
                        objectArray2 = new Object[]{2, string4};
                        JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"UPDATE iscatprepage SET pagestate = ? WHERE preloaduid = ?", (Object[])objectArray2);
                        String string5 = previousUID;
                        if (string5 != null) {
                            String it2 = string5;
                            boolean bl2 = false;
                            Object[] objectArray3 = new Object[]{previousUID};
                            n3 = JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"DELETE iscatprepage WHERE preloaduid = ?", (Object[])objectArray3);
                        } else {
                            n3 = null;
                        }
                    } else {
                        objectArray2 = new Object[]{string4};
                        n3 = JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"DELETE FROM iscatprepage WHERE preloaduid = ?", (Object[])objectArray2);
                    }
                    Integer result$iv = n3;
                    $this$transaction$iv.commit();
                    n = result$iv;
                }
                finally {
                    $this$transaction$iv.rollback();
                    if (autoCommitWasEnabled$iv) {
                        $this$transaction$iv.setAutoCommit(true);
                    }
                }
                return n;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushToNewPage(CachedCatalog catalogInfo, String partitionName, int pageNum, int pageStart, String newVersion, String langCode, Deque<CatalogEntry> catalogEntries) {
        ByteArrayOutputStream byteArrayOutputStream;
        CatalogObjects catalogObjects;
        UserInfo userInfo;
        int countInPage = catalogEntries.size();
        UserInfo it = userInfo = MXServer.getMXServer().getSystemUserInfo();
        boolean bl = false;
        it.setLangCode(langCode);
        UserInfo userInfo2 = userInfo;
        long startTime = System.currentTimeMillis();
        CatalogObjects objects = new CatalogObjects();
        CollectionExtensionsKt.pollEach(catalogEntries, (Function1)new Function1<CatalogEntry, Unit>(this, userInfo2, catalogInfo, langCode, objects){
            final /* synthetic */ JobPreloadImpl this$0;
            final /* synthetic */ UserInfo $userInfo;
            final /* synthetic */ CachedCatalog $catalogInfo;
            final /* synthetic */ String $langCode;
            final /* synthetic */ CatalogObjects $objects;
            {
                this.this$0 = $receiver;
                this.$userInfo = $userInfo;
                this.$catalogInfo = $catalogInfo;
                this.$langCode = $langCode;
                this.$objects = $objects;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CatalogEntry entry) {
                block10: {
                    Object co;
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    Object object2 = this.this$0;
                    Object object3 = this.$userInfo;
                    CachedCatalog cachedCatalog = this.$catalogInfo;
                    String string = this.$langCode;
                    JobPreloadImpl it = object2;
                    boolean bl = false;
                    Object object4 = entry.getXml();
                    if (!(object4 == null || object4.length() == 0)) {
                        object4 = InformerObjectSerializer.getInstance().deserialize(entry.getXml(), com.interlocsolutions.maximo.notify.CatalogEntry.POLICY_UNMARSHALL_CATALOG_OBJECT);
                        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.CatalogObject");
                        Object obj = object4 = (CatalogObject)object4;
                        boolean bl2 = false;
                        ((CatalogObject)obj).setSeqeunce(entry.getSequence());
                        object = object4;
                    } else {
                        void $this$use$iv$iv$iv$iv;
                        void mboName$iv;
                        void userInfo$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"userInfo");
                        object4 = object3;
                        String string2 = cachedCatalog.objectName;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"catalogInfo.objectName");
                        String obj = string2;
                        long l = entry.getRecordid();
                        boolean readOnly$iv = true;
                        boolean $i$f$mapSingleMbo = false;
                        MboInterface this_$iv$iv = MboInterface.Companion.obtain((UserInfo)userInfo$iv);
                        boolean $i$f$mapSingleMbo2 = false;
                        String whereClause$iv$iv$iv = null;
                        boolean $i$f$useNewMboSet = false;
                        MboSetRemote mboSetRemote = this_$iv$iv.getNewMboSet((String)mboName$iv, whereClause$iv$iv$iv, readOnly$iv);
                        boolean $i$f$use = false;
                        Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv$iv$iv);
                        Throwable throwable = null;
                        try {
                            CatalogObject catalogObject;
                            boolean bl3;
                            MboRemote mbo;
                            void uniqueId$iv;
                            MboSetRemoteClosableWrapper it$iv$iv$iv$iv = (MboSetRemoteClosableWrapper)closeable;
                            boolean bl4 = false;
                            void mboSet$iv$iv = $this$use$iv$iv$iv$iv;
                            boolean bl5 = false;
                            MboRemote mbo$iv$iv = mboSet$iv$iv.getMboForUniqueId((long)uniqueId$iv);
                            if (mbo$iv$iv == null) {
                                mbo = null;
                                bl3 = false;
                                catalogObject = null;
                            } else {
                                mbo = mbo$iv$iv;
                                bl3 = false;
                                MboRemote it2 = mbo;
                                boolean bl6 = false;
                                catalogObject = new CatalogObject(it2, cachedCatalog.attributes, entry.getSequence(), string);
                            }
                            CatalogObject catalogObject2 = catalogObject;
                            object = catalogObject2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    Object object5 = co = object;
                    if (object5 == null) break block10;
                    object2 = object5;
                    object3 = this.$objects;
                    Object it3 = object2;
                    boolean bl7 = false;
                    ((CatalogObjects)object3).addObject((CatalogObject)co);
                }
            }
        });
        int count = pageStart + countInPage;
        CatalogObjects it2 = catalogObjects = objects;
        boolean bl2 = false;
        it2.setDeviceId(-1L);
        it2.setPosition(count);
        it2.setCount(-1);
        it2.setName(catalogInfo.catalogName);
        it2.setPartition(partitionName);
        it2.setPageNumber(pageNum);
        it2.setSequence(it2.getEndSequence());
        JobPreloadImpl it3 = this;
        boolean bl3 = false;
        ByteArrayOutputStream $this$flushToNewPage_u24lambda_u2414_u24lambda_u2413 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl4 = false;
        Closeable closeable = new ObjectOutputStream($this$flushToNewPage_u24lambda_u2414_u24lambda_u2413);
        Throwable throwable = null;
        try {
            ObjectOutputStream it4 = (ObjectOutputStream)closeable;
            boolean bl5 = false;
            it4.writeObject(objects);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] data = byteArrayOutputStream.toByteArray();
        DbConnectionManager.getInstance().getMaximoConnection().useConn((Function1)new Function1<Connection, Unit>(newVersion, pageNum, pageStart, count, objects, data){
            final /* synthetic */ String $newVersion;
            final /* synthetic */ int $pageNum;
            final /* synthetic */ int $pageStart;
            final /* synthetic */ int $count;
            final /* synthetic */ CatalogObjects $objects;
            final /* synthetic */ byte[] $data;
            {
                this.$newVersion = $newVersion;
                this.$pageNum = $pageNum;
                this.$pageStart = $pageStart;
                this.$count = $count;
                this.$objects = $objects;
                this.$data = $data;
                super(1);
            }

            public final void invoke(@NotNull Connection conn) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Object[] objectArray = new Object[]{MaxSequence.generateKey((Connection)conn, (String)"ISCATPREPAGE", (String)"CATPREPAGEID"), this.$newVersion, 1, this.$pageNum, this.$pageStart, this.$count, this.$objects.getStartSequence(), this.$objects.getEndSequence(), Base64.encodeBase64String(this.$data)};
                JDBCExtensionsKt.executeUpdate((Connection)conn, (String)"INSERT INTO iscatprepage (catprepageid, \n    preloaduid, pagestate,\n    pageseq, pagestart, pageend, \n    seqstart, seqend, content)\nVALUES (?,?,?,?,?,?,?,?,?)", (Object[])objectArray);
                JDBCExtensionsKt.commitIfApplicable((Connection)conn);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Saved page " + pageNum + " containing records " + pageStart + " to " + count + " in " + (System.currentTimeMillis() - startTime)));
        }
    }

    public static final /* synthetic */ void access$flushToNewPage(JobPreloadImpl $this, CachedCatalog catalogInfo, String partitionName, int pageNum, int pageStart, String newVersion, String langCode, Deque catalogEntries) {
        $this.flushToNewPage(catalogInfo, partitionName, pageNum, pageStart, newVersion, langCode, catalogEntries);
    }

    public static final /* synthetic */ JobPreload.JobSpecPreload access$getParams$p(JobPreloadImpl $this) {
        return $this.params;
    }

    static {
        MXLogger mXLogger = NotifyConstants.INFORMER_CRQP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_CRQP_LOGGER");
        logger = mXLogger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreloadImpl$CatalogEntry;", "", "recordid", "", "sequence", "partitionName", "", "xml", "(JJLjava/lang/String;Ljava/lang/String;)V", "getPartitionName", "()Ljava/lang/String;", "getRecordid", "()J", "getSequence", "getXml", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "isinformer"})
    private static final class CatalogEntry {
        private final long recordid;
        private final long sequence;
        @Nullable
        private final String partitionName;
        @Nullable
        private final String xml;

        public CatalogEntry(long recordid, long sequence, @Nullable String partitionName, @Nullable String xml) {
            this.recordid = recordid;
            this.sequence = sequence;
            this.partitionName = partitionName;
            this.xml = xml;
        }

        public final long getRecordid() {
            return this.recordid;
        }

        public final long getSequence() {
            return this.sequence;
        }

        @Nullable
        public final String getPartitionName() {
            return this.partitionName;
        }

        @Nullable
        public final String getXml() {
            return this.xml;
        }

        public final long component1() {
            return this.recordid;
        }

        public final long component2() {
            return this.sequence;
        }

        @Nullable
        public final String component3() {
            return this.partitionName;
        }

        @Nullable
        public final String component4() {
            return this.xml;
        }

        @NotNull
        public final CatalogEntry copy(long recordid, long sequence, @Nullable String partitionName, @Nullable String xml) {
            return new CatalogEntry(recordid, sequence, partitionName, xml);
        }

        public static /* synthetic */ CatalogEntry copy$default(CatalogEntry catalogEntry, long l, long l2, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                l = catalogEntry.recordid;
            }
            if ((n & 2) != 0) {
                l2 = catalogEntry.sequence;
            }
            if ((n & 4) != 0) {
                string = catalogEntry.partitionName;
            }
            if ((n & 8) != 0) {
                string2 = catalogEntry.xml;
            }
            return catalogEntry.copy(l, l2, string, string2);
        }

        @NotNull
        public String toString() {
            return "CatalogEntry(recordid=" + this.recordid + ", sequence=" + this.sequence + ", partitionName=" + this.partitionName + ", xml=" + this.xml + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.recordid);
            result = result * 31 + Long.hashCode(this.sequence);
            result = result * 31 + (this.partitionName == null ? 0 : this.partitionName.hashCode());
            result = result * 31 + (this.xml == null ? 0 : this.xml.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CatalogEntry)) {
                return false;
            }
            CatalogEntry catalogEntry = (CatalogEntry)other;
            if (this.recordid != catalogEntry.recordid) {
                return false;
            }
            if (this.sequence != catalogEntry.sequence) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.partitionName, (Object)catalogEntry.partitionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.xml, (Object)catalogEntry.xml);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/catalog/JobPreloadImpl$Companion;", "", "()V", "logger", "Lpsdi/util/logging/MXLogger;", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Catalog.PartitionType.values().length];
            try {
                nArray[Catalog.PartitionType.PARTITIONED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Catalog.PartitionType.UNPARTITIONED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Catalog.PartitionType.BOTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

