/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPartialReconcile;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class JobPartialReconcileImpl
implements JobPartialReconcile {
    protected EvalContext evalContext;
    private JobPartialReconcile.JobSpecPartialReconcile params;
    private int commitBatchSize;
    private JobDispatcher jobDispatcher = JobConfig.getJobDispatcher();

    public JobPartialReconcileImpl() throws RemoteException, MXException {
        this.commitBatchSize = PropUtils.getIntMaxProp("informer.catalog.queue.commitbatchsize", 500);
    }

    @Override
    public void initialize(EvalContext evalContext, JobPartialReconcile.JobSpecPartialReconcile params) {
        this.params = params;
        this.evalContext = evalContext;
        evalContext.setFlag(EvalFlags.RECONCILIATION_PARTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws RemoteException, MXException {
        ArrayList<JobEval.JobSpecEval> jobDefinitions = new ArrayList<JobEval.JobSpecEval>(this.commitBatchSize);
        MboSetRemote catalogRelatedToQueueSet = MXServer.getMXServer().getMboSet(this.params.getCatalogObjectName(), this.evalContext.getUserInfo());
        try {
            catalogRelatedToQueueSet.setWhere(this.params.completeRelatedSetWhere);
            catalogRelatedToQueueSet.reset();
            int currentBatchCount = 0;
            catalogRelatedToQueueSet.setFlag(39L, true);
            MboRemote catalogRelatedMbo = catalogRelatedToQueueSet.moveFirst();
            while (catalogRelatedMbo != null) {
                for (String langCode : NotifyUtil.getLangCodes()) {
                    jobDefinitions.add(new JobEval.JobSpecEval(this.params.catalogId, this.params.revision, catalogRelatedMbo.getUniqueIDValue(), langCode));
                    if (NotifyConstants.INFORMER_CRQP_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_CRQP_LOGGER.debug((Object)String.format("Queued evaluation of object %s with record id %d for catalog %d, langCode %s", catalogRelatedMbo.getName(), catalogRelatedMbo.getUniqueIDValue(), this.params.catalogId, langCode));
                    }
                    if (++currentBatchCount < this.commitBatchSize) continue;
                    this.jobDispatcher.doEvals(this.evalContext.duplicate(), jobDefinitions);
                    jobDefinitions.clear();
                    currentBatchCount = 0;
                }
                catalogRelatedMbo = catalogRelatedToQueueSet.moveNext();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(catalogRelatedToQueueSet);
        }
        this.jobDispatcher.doEvals(this.evalContext.duplicate(), jobDefinitions);
        jobDefinitions.clear();
    }
}

