/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobSpec;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.JobRelationshipEval;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.RelationInfo;
import psdi.mbo.SqlFormat;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public interface JobPartialReconcile {
    public void initialize(EvalContext var1, JobSpecPartialReconcile var2) throws RemoteException, MXException;

    public void invoke() throws RemoteException, MXException;

    public static class JobSpecPartialReconcile
    extends CatalogJobSpec
    implements Serializable {
        private static final long serialVersionUID = 2L;
        @NotNull
        public final String completeRelatedSetWhere;

        public JobSpecPartialReconcile(long catalogId, long revision, @NotNull String completeRelatedSetWhere) {
            super(catalogId, revision);
            this.completeRelatedSetWhere = completeRelatedSetWhere;
        }

        public JobSpecPartialReconcile(JobRelationshipEval.JobSpecRelationshipEval job, @NotNull MboRemote parentMbo) throws RemoteException, MXException {
            super(job.catalogId, job.revision);
            String expression;
            if (!StringUtils.isEmpty(job.relationshipName)) {
                RelationInfo relationInfo = parentMbo.getThisMboSet().getMboSetInfo().getRelationInfo(job.relationshipName);
                if (relationInfo == null) {
                    throw new MXApplicationException("informer", "invalidParameter", new Object[]{JobSpecPartialReconcile.class, String.format("%s could not resolve relationship %s.%s", job.getClass(), parentMbo.getName(), job.relationshipName)});
                }
                expression = relationInfo.getSqlExpr();
            } else if (!StringUtils.isEmpty(job.anonWhereClause)) {
                expression = job.anonWhereClause;
            } else {
                throw new MXApplicationException("informer", "invalidParameter", new Object[]{JobSpecPartialReconcile.class, String.format("%s instance contains neither a named relationship nor an anonymous where-clause", job.getClass())});
            }
            this.completeRelatedSetWhere = new SqlFormat(parentMbo, expression).format();
        }

        public String toString() {
            return String.format("PartialReconcliationJob(catalogId=%d, catalogRevision=%d, whereClause=%s)", this.catalogId, this.revision, this.completeRelatedSetWhere);
        }
    }
}

