/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobInit;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.db.JobFactory;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class JobInitSynchronous
implements JobInit {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_CRQP_LOGGER;
    private EvalContext evalContext;
    private JobInit.JobSpecInit params;

    @Override
    public void initialize(EvalContext evalContext, JobInit.JobSpecInit params) {
        this.params = params;
        this.evalContext = evalContext;
        evalContext.setFlag(EvalFlags.INITIALIZATION);
    }

    @Override
    public void invoke() throws RemoteException, MXException {
        CachedCatalog cachedCatalog;
        final long catalogId = this.params.catalogId;
        final Long[] newRevBox = new Long[1];
        MboUtil.visitSingleMboWithRetry(this.evalContext.getUserInfo(), "ISCATALOG", catalogId, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote catalog) throws RemoteException, MXException {
                newRevBox[0] = ((Catalog)catalog).incrementRevisionNumber();
            }
        }, 5);
        final long revision = newRevBox[0];
        try {
            cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(catalogId, revision);
        }
        catch (NoSuchCatalogException e) {
            LOGGER.warn((Object)String.format("Initialization job %s is no-op because no Catalog with ID %d and Revision %d was found.", this.params, catalogId, revision));
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("Initialization job %s will now clean up any old records, before generating new ones.", this.params));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("Initialization job %s will now evaluate its individual records.", this.params));
        }
        final JobFactory jobFactory = JobConfig.getJobFactory();
        final Collection<String> langCodes = NotifyUtil.getLangCodes();
        MboUtil.visitMbosReadOnly(this.evalContext.getUserInfo(), cachedCatalog.objectName, cachedCatalog.whereClause, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote data) throws RemoteException, MXException {
                for (String langCode : langCodes) {
                    jobFactory.instantiateJobEval(JobInitSynchronous.this.evalContext, new JobEval.JobSpecEval(catalogId, revision, data.getUniqueIDValue(), langCode)).invoke(data);
                }
            }
        });
        if (cachedCatalog.preloadSupported) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)String.format("Initialization job %s has completed evaluation of its individual records, and will now generate a Preload.", this.params));
            }
            jobFactory.instantiateJobPreload(this.evalContext, new JobPreload.JobSpecPreload(catalogId, revision)).invoke();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("Initialization job %s has completed evaluation of its individual records, and Preload is disabled for this Catalog.", this.params));
        }
        MboUtil.visitSingleMboWithRetry(this.evalContext.getUserInfo(), "ISCATALOG", catalogId, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote catalog) throws RemoteException, MXException {
                long currentRevision = catalog.getLong("REVISION");
                if (currentRevision == revision) {
                    catalog.setValue("INITIALIZED", true);
                } else {
                    LOGGER.warn((Object)String.format("Catalog is not being finalized because its revision has changed during our operation from %d to %d. Abandoning this initialization job: %s", revision, currentRevision, JobInitSynchronous.this.params));
                }
            }
        }, 5);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("Initialization job %s has completed, including Preload generation.", this.params));
        }
    }
}

