/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.err.InformerConfException;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPartialReconcile;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class JobEvalImpl
implements JobEval {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_CRQP_LOGGER;
    protected static final Pattern PATTERN_XML_HEADER = Pattern.compile("^<\\?xml.*\\?>");
    private static ThreadLocal<MessageDigest> threadLocalMessageDigest = new ThreadLocal();
    protected JobEval.JobSpecEval params;
    protected EvalContext evalContext;

    @Override
    public void initialize(EvalContext evalContext, JobEval.JobSpecEval params) {
        this.evalContext = evalContext;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws MXException, RemoteException {
        if (this.params == null) {
            throw new InformerConfException(String.format("Parameters were not set. Use %s.initialize(JobEvalParams)", JobEval.class));
        }
        UserInfo languageSpeceficUserInfo = this.evalContext.getUserInfo();
        languageSpeceficUserInfo.setLangCode(this.params.langCode);
        MboSetRemote dataSet = MXServer.getMXServer().getMboSet(this.params.getCatalogObjectName(), languageSpeceficUserInfo);
        try {
            MboRemote data = dataSet.getMboForUniqueId(this.params.recordid);
            this.invoke(data);
        }
        finally {
            NotifyUtil.closeAndCleanup(dataSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(@Nullable MboRemote data) throws MXException, RemoteException {
        if (this.params == null) {
            throw new InformerConfException(String.format("Parameters were not set. Use %s.initialize(JobEvalParams)", JobEval.class));
        }
        try {
            NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(this.params.catalogid, this.params.revision);
        }
        catch (NoSuchCatalogException e) {
            LOGGER.warn((Object)String.format("Evaluation job %1$s is no-op because no Catalog with ID %2$d and Revision %3$d was found.", this.params, this.params.catalogid, this.params.revision));
            return;
        }
        if (!NotifyUtil.getLangCodes().contains(this.params.langCode)) {
            LOGGER.warn((Object)("Evaluation job " + this.params + " is no-op because support for '" + this.params.langCode + "' is not enabled"));
            return;
        }
        boolean storeXml = PropUtils.getBooleanMaxProp("informer.catalog.xml.store", true);
        MboSetRemote catalogDataSet = MXServer.getMXServer().getMboSet("ISCATALOGDATA", this.evalContext.getUserInfo());
        try {
            if (data == null || data.toBeDeleted()) {
                this.deleteExistingEntries(catalogDataSet);
            } else if (this.evalContext.hasFlag(EvalFlags.INITIALIZATION)) {
                String serializedObject = this.getDataPayload(data, this.params);
                String partition = this.determinePartition(data);
                if (this.params.getCatalogInfo().partitionType != Catalog.PartitionType.PARTITIONED || partition != null && !partition.isEmpty()) {
                    if (this.catalogRecordExists(partition)) {
                        LOGGER.warn((Object)String.format("ISCATALOGDATA record already exists for (%s %d for Profile %d, Catalog %d).  Posting a reconciliation job.", this.params.getCatalogObjectName(), this.params.recordid, this.params.getNotifyId(), this.params.catalogId));
                        SqlFormat sf = new SqlFormat(data.getUniqueIDName() + " = :1");
                        sf.setLong(1, data.getUniqueIDValue());
                        EvalContext context = new EvalContext();
                        JobDispatcher jobDispatcher = JobConfig.getJobDispatcher();
                        JobPartialReconcile.JobSpecPartialReconcile jobSpec = new JobPartialReconcile.JobSpecPartialReconcile(this.params.catalogId, this.params.revision, sf.format());
                        jobDispatcher.doPartialReconcile(context, jobSpec);
                    } else {
                        this.createNewEntry(catalogDataSet, serializedObject, partition, storeXml);
                    }
                }
            } else if (this.isInCatalog(data, this.params.catalogId, this.params.revision)) {
                String serializedObject = this.getDataPayload(data, this.params);
                String partition = this.determinePartition(data);
                boolean existingEntryForPartitionUpdated = false;
                SqlFormat sqlf = new SqlFormat("catalogid = :1 AND revision = :2 AND langcode = :3 AND recordid = :4");
                sqlf.setLong(1, this.params.catalogId);
                sqlf.setLong(2, this.params.revision);
                sqlf.setObject(3, "ISCATALOGDATA", "LANGCODE", this.params.langCode);
                sqlf.setLong(4, this.params.recordid);
                catalogDataSet.setWhere(sqlf.format());
                MboRemote mbo = catalogDataSet.moveFirst();
                while (mbo != null) {
                    if (!storeXml && !mbo.isNull("XML")) {
                        mbo.setValueNull("XML");
                    }
                    if (this.partitionMatches(mbo, partition)) {
                        String hash = this.calculateHash(serializedObject);
                        if (!hash.equals(mbo.getString("HASH"))) {
                            mbo.setValue("HASH", hash);
                            if (storeXml) {
                                mbo.setValue("XML", this.stripXmlHeader(serializedObject));
                            }
                        }
                        mbo.setValue("MAINRECORD", true);
                        mbo.setValue("INSCOPE", true);
                        existingEntryForPartitionUpdated = true;
                    } else if (mbo.getBoolean("INSCOPE")) {
                        mbo.setValue("INSCOPE", false);
                        mbo.setValue("MAINRECORD", false);
                        mbo.setValueNull("HASH");
                        mbo.setValueNull("XML");
                    }
                    mbo = catalogDataSet.moveNext();
                }
                if (!existingEntryForPartitionUpdated && (this.params.getCatalogInfo().partitionType != Catalog.PartitionType.PARTITIONED || partition != null && !partition.isEmpty())) {
                    this.createNewEntry(catalogDataSet, serializedObject, partition, storeXml);
                }
            } else {
                this.deleteExistingEntries(catalogDataSet);
            }
            catalogDataSet.save();
        }
        finally {
            NotifyUtil.closeAndCleanup(catalogDataSet);
        }
    }

    private boolean partitionMatches(@NotNull MboRemote existingRecord, @Nullable String partition) throws MXException, RemoteException {
        return partition == null && existingRecord.isNull("PARTITIONNAME") || partition != null && partition.equals(existingRecord.getString("PARTITIONNAME"));
    }

    @Nullable
    private String determinePartition(@NotNull MboRemote data) throws RemoteException, MXException {
        return this.params.getCatalogInfo().partitioner.determineCatalogPartition(data);
    }

    protected MboRemote createNewEntry(@NotNull MboSetRemote catalogDataSet, String serializedObject, String partition, boolean storeXml) throws MXException, RemoteException {
        MboRemote catalogData = catalogDataSet.add();
        catalogData.setValue("CATALOGID", this.params.catalogId);
        catalogData.setValue("REVISION", this.params.revision);
        catalogData.setValue("LANGCODE", this.params.langCode);
        catalogData.setValue("RECORDID", this.params.recordid);
        catalogData.setValue("HASH", this.calculateHash(serializedObject));
        catalogData.setValue("PARTITIONNAME", partition);
        if (storeXml) {
            catalogData.setValue("XML", this.stripXmlHeader(serializedObject));
        }
        catalogData.setValue("INSCOPE", true);
        catalogData.setValue("MAINRECORD", true);
        return catalogData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean catalogRecordExists(String partition) throws RemoteException, MXException {
        boolean bl;
        MboSetRemote msr = null;
        try {
            SqlFormat sf;
            if (partition == null) {
                sf = new SqlFormat("catalogid = :1 and revision = :2 and langcode = :3 and recordid = :4 and partitionname is null");
            } else {
                sf = new SqlFormat("catalogid = :1 and revision = :2 and langcode = :3 and recordid = :4 and partitionname = :5");
                sf.setObject(5, "ISCATALOGDATA", "PARTITIONNAME", partition);
            }
            sf.setLong(1, this.params.catalogId);
            sf.setLong(2, this.params.revision);
            sf.setObject(3, "ISCATALOGDATA", "LANGCODE", this.params.langCode);
            sf.setLong(4, this.params.recordid);
            msr = MXServer.getMXServer().getMboSet("ISCATALOGDATA", MXServer.getMXServer().getSystemUserInfo());
            msr.setWhere(sf.format());
            bl = !msr.isEmpty();
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(msr);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(msr);
        return bl;
    }

    private void deleteExistingEntries(MboSetRemote catalogDataSet) throws MXException, RemoteException {
        SqlFormat sqlf = new SqlFormat("catalogid = :1 AND revision = :2 AND langcode = :3 AND recordid = :4 AND inscope = :yes");
        sqlf.setLong(1, this.params.catalogId);
        sqlf.setLong(2, this.params.revision);
        sqlf.setObject(3, "ISCATALOGDATA", "LANGCODE", this.params.langCode);
        sqlf.setLong(4, this.params.recordid);
        catalogDataSet.setWhere(sqlf.format());
        MboRemote mbo = catalogDataSet.moveFirst();
        while (mbo != null) {
            mbo.setValue("INSCOPE", false);
            mbo.setValueNull("HASH");
            mbo.setValueNull("XML");
            mbo = catalogDataSet.moveNext();
        }
    }

    protected String getDataPayload(MboRemote data, JobEval.JobSpecEval params) throws RemoteException, MXException {
        String serializedObject;
        CatalogObject co;
        CachedCatalog catalog;
        try {
            catalog = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(params.catalogid, params.revision);
        }
        catch (NoSuchCatalogException e) {
            throw new MXApplicationException("informer", "noSuchCatalogRevCombo", new Object[]{params.catalogId, params.revision});
        }
        final String langCode = params.langCode;
        if (langCode.equals(data.getUserInfo().getLangCode())) {
            co = new CatalogObject(data, catalog.attributes, 0L, langCode);
        } else {
            UserInfo languageSpeceficUserInfo = this.evalContext.getUserInfo();
            languageSpeceficUserInfo.setLangCode(langCode);
            final CatalogObject[] resultHolder = new CatalogObject[1];
            MboUtil.visitSingleMboReadOnly(languageSpeceficUserInfo, data.getName(), data.getUniqueIDValue(), new NotifyUtil.MboVisitor(){

                @Override
                public void visit(@NotNull MboRemote languageSpecificMbo) throws RemoteException, MXException {
                    resultHolder[0] = new CatalogObject(languageSpecificMbo, catalog.attributes, 0L, langCode);
                }
            });
            co = resultHolder[0];
        }
        try {
            serializedObject = InformerObjectSerializer.getInstance().serialize(co);
        }
        catch (JAXBException e) {
            throw new MXApplicationException("informer", "jaxberror", (Object[])new String[]{data.getName(), String.format("Error generating hash for catalog %d with record id %d", params.catalogId, co.getRecordId())}, (Throwable)e);
        }
        return serializedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInCatalog(MboRemote data, long catalogid, long revision) throws RemoteException, MXException {
        CachedCatalog catalog;
        if (data == null || catalogid <= 0L || revision <= 0L) {
            return false;
        }
        try {
            catalog = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(catalogid, revision);
        }
        catch (NoSuchCatalogException e) {
            throw new MXApplicationException("informer", "noSuchCatalogRevCombo", new Object[]{this.params.catalogid, this.params.revision});
        }
        Boolean conditionResult = NotifyUtil.evalCatalogCondition(catalog, data);
        if (conditionResult != null) {
            return conditionResult;
        }
        if (StringUtils.isEmpty(catalog.whereClause)) {
            return true;
        }
        MXServer mxServer = MXServer.getMXServer();
        UserInfo userInfo = this.evalContext.getUserInfo();
        MboSetRemote dataSet = mxServer.getMboSet(data.getThisMboSet().getMboSetInfo().getObjectName(), userInfo);
        try {
            String stmt = data.getUniqueIDName() + " = :1";
            if (!StringUtils.isEmpty(catalog.whereClause)) {
                stmt = stmt + " AND (" + catalog.whereClause + ")";
            }
            SqlFormat sqlf = new SqlFormat(stmt);
            sqlf.setLong(1, data.getUniqueIDValue());
            dataSet.setWhere(sqlf.format());
            boolean bl = !dataSet.isEmpty();
            return bl;
        }
        finally {
            NotifyUtil.closeAndCleanup(dataSet);
        }
    }

    protected String stripXmlHeader(String xmlDocument) {
        Matcher matcher = PATTERN_XML_HEADER.matcher(xmlDocument);
        if (matcher.find()) {
            xmlDocument = xmlDocument.substring(matcher.end());
        }
        return xmlDocument;
    }

    protected String calculateHash(String serializedObject) throws MXException, RemoteException {
        MessageDigest md = threadLocalMessageDigest.get();
        try {
            if (md == null) {
                md = MessageDigest.getInstance("MD5");
                threadLocalMessageDigest.set(md);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new MXApplicationException("informer", "evalError", (Object[])new String[]{String.format("(%s %d for Profile %d, Catalog %d)", this.params.getCatalogObjectName(), this.params.recordid, this.params.getNotifyId(), this.params.catalogId), "Message digest could not be obtained."}, (Throwable)e);
        }
        return Base64.encodeBase64String(md.digest(serializedObject.getBytes())).trim();
    }
}

