/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.classloader.ChangeableClassAccessor;
import com.interlocsolutions.maximo.notify.err.InformerConfException;
import com.interlocsolutions.maximo.notify.queue.catalog.DisabledCatalogJobQueueProcessor;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobQueueProcessor;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherDBImpl;
import com.interlocsolutions.maximo.notify.queue.db.JobFactory;
import com.interlocsolutions.maximo.notify.queue.db.JobFactoryDBImpl;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import psdi.util.MXException;

public class JobConfig {
    public static final String PROP_COMMIT_BATCH_SIZE = "informer.catalog.queue.commitbatchsize";
    public static final String PROP_JOB_QUEUE_PROCESSOR = "informer.catalog.queue.QueueProcessor";
    public static final String PROP_JOB_FACTORY = "informer.catalog.queue.JobFactory";
    public static final String PROP_JOB_DISPATCHER = "informer.catalog.queue.JobDispatcher";
    public static final String PROP_CATALOG_ORDER_BY = "informer.catalog.queue.ordering";
    public static final String PROP_CATALOG_BATCH_SIZE = "informer.max.QueueBatchSize";
    public static final String PROP_CATALOG_SERIALIZE_CLAIMING = "informer.queue.serializeClaiming.catalog";
    @NotNull
    private static final JobConfig singleton = new JobConfig();
    @NotNull
    private final JobDispatcherContainer dispatcherContainer = new JobDispatcherContainer();
    @NotNull
    private final JobFactoryContainer factoryContainer = new JobFactoryContainer();
    @NotNull
    private final JobQueueProcessorContainer processorContainer = new JobQueueProcessorContainer();

    @NotNull
    public static JobConfig getInstance() {
        return singleton;
    }

    @NotNull
    public static JobDispatcher getJobDispatcher() throws MXException, RemoteException {
        return singleton.getJobDispatcherInstance();
    }

    @NotNull
    public static JobFactory getJobFactory() throws MXException, RemoteException {
        return singleton.getJobFactoryInstance();
    }

    @NotNull
    public static JobQueueProcessor getJobQueueProcessor() throws MXException, RemoteException {
        return singleton.getJobQueueProcessorInstance();
    }

    @NotNull
    public JobDispatcher getJobDispatcherInstance() throws MXException, RemoteException {
        return (JobDispatcher)this.dispatcherContainer.getInstance();
    }

    @NotNull
    public JobFactory getJobFactoryInstance() throws MXException, RemoteException {
        return (JobFactory)this.factoryContainer.getInstance();
    }

    @NotNull
    public JobQueueProcessor getJobQueueProcessorInstance() throws MXException, RemoteException {
        return (JobQueueProcessor)this.processorContainer.getInstance();
    }

    public void invalidate() {
        this.dispatcherContainer.invalidate();
        this.factoryContainer.invalidate();
        this.processorContainer.invalidate();
    }

    private static class JobDispatcherContainer
    extends ChangeableClassAccessor<JobDispatcher> {
        public JobDispatcherContainer() {
            super("JobDispatcher");
        }

        @Override
        @NotNull
        protected String getClassName() {
            return PropUtils.getMaxProp(JobConfig.PROP_JOB_DISPATCHER, JobDispatcherDBImpl.class.getName());
        }

        @Override
        protected boolean permitCaching() {
            return true;
        }

        @Override
        protected boolean permitEventualRollover() {
            return true;
        }

        @Override
        protected void commission(@NotNull JobDispatcher newInstance) throws MXException, RemoteException {
            newInstance.startUp();
        }

        @Override
        protected void decommission(@NotNull JobDispatcher oldInstance) throws MXException, RemoteException {
            TimeUnit timeoutUnits;
            int timeout;
            if (this.permitEventualRollover()) {
                timeout = 1;
                timeoutUnits = TimeUnit.HOURS;
            } else {
                timeout = 10;
                timeoutUnits = TimeUnit.SECONDS;
            }
            try {
                oldInstance.shutDown(timeout, timeoutUnits);
            }
            catch (TimeoutException e) {
                throw new InformerConfException(String.format("The existing " + this.humanReadableClassType + " did not shut down after %d %s.", new Object[]{timeout, timeoutUnits}), e);
            }
        }
    }

    private static class JobFactoryContainer
    extends ChangeableClassAccessor<JobFactory> {
        public JobFactoryContainer() {
            super("JobFactory");
        }

        @Override
        @NotNull
        protected String getClassName() {
            return PropUtils.getMaxProp(JobConfig.PROP_JOB_FACTORY, JobFactoryDBImpl.class.getName());
        }

        @Override
        protected boolean permitCaching() {
            return true;
        }

        @Override
        protected boolean permitEventualRollover() {
            return true;
        }

        @Override
        protected void commission(@NotNull JobFactory newInstance) throws MXException, RemoteException {
        }

        @Override
        protected void decommission(@NotNull JobFactory oldInstance) throws MXException, RemoteException {
        }
    }

    private static class JobQueueProcessorContainer
    extends ChangeableClassAccessor<JobQueueProcessor> {
        public JobQueueProcessorContainer() {
            super("CatalogJobQueueProcessor");
        }

        @Override
        @NotNull
        protected String getClassName() {
            return PropUtils.getMaxProp(JobConfig.PROP_JOB_QUEUE_PROCESSOR, DisabledCatalogJobQueueProcessor.class.getName());
        }

        @Override
        protected boolean permitCaching() {
            return true;
        }

        @Override
        protected boolean permitEventualRollover() {
            return false;
        }

        @Override
        protected void commission(@NotNull JobQueueProcessor newInstance) throws MXException, RemoteException {
            newInstance.startup();
        }

        @Override
        protected void decommission(@NotNull JobQueueProcessor oldInstance) throws MXException, RemoteException {
            oldInstance.shutdown();
        }
    }
}

