/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.err.InformerConfException;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobRepo;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogQueueJob;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobInit;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPartialReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.catalog.JobReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobSqliteGeneration;
import com.interlocsolutions.maximo.notify.queue.db.JobFactory;
import com.interlocsolutions.maximo.notify.queue.db.JobFactoryDB;
import com.interlocsolutions.maximo.notify.queue.db.JobInitFinalize;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"evaluate", "", "job", "Lcom/interlocsolutions/maximo/notify/queue/catalog/CatalogQueueJob;", "isinformer"})
public final class CatalogQueueJobEvaluatorKt {
    public static final void evaluate(@NotNull CatalogQueueJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        switch (job.getJobType()) {
            case 0: {
                if (job.getRecordid() == null) {
                    boolean $i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$32 = false;
                    String $i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$32 = "Jobs of type 0 must have a RecordId";
                    throw new IllegalArgumentException($i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$32.toString());
                }
                if (job.getLangCode() == null) {
                    boolean $i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$62 = false;
                    String $i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$62 = "Jobs of type 0 must have a LangCode";
                    throw new IllegalArgumentException($i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$62.toString());
                }
                CachedCatalog cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrNull(job.getCatalogid(), job.getRevision());
                if (cachedCatalog != null) {
                    EvalContext evalContext;
                    CachedCatalog it = cachedCatalog;
                    boolean bl = false;
                    EvalContext $this$evaluate_u24lambda_u243_u24lambda_u242 = evalContext = new EvalContext(null, null, null, 7, null);
                    boolean bl2 = false;
                    $this$evaluate_u24lambda_u243_u24lambda_u242.setFlag(EvalFlags.DEFERRED);
                    if (job.getParent() != null) {
                        $this$evaluate_u24lambda_u243_u24lambda_u242.setFlag(EvalFlags.INITIALIZATION);
                    }
                    EvalContext evalContext2 = evalContext;
                    JobConfig.getJobFactory().instantiateJobEval(evalContext2, new JobEval.JobSpecEval(job.getCatalogid(), job.getRevision(), (long)job.getRecordid(), job.getLangCode())).invoke();
                }
                InformerTracking.catalogRefreshStopped(job.getJobId());
                break;
            }
            case 1: {
                CatalogJobRepo.INSTANCE.cancelPreviousInits(job.getCatalogid(), job.getRevision());
                InformerTracking.catalogInitStart(job.getCatalogid(), job.getJobId());
                JobFactory jobFactory = JobConfig.getJobFactory();
                JobFactoryDB jobFactoryDB = jobFactory instanceof JobFactoryDB ? (JobFactoryDB)jobFactory : null;
                if (jobFactoryDB == null) {
                    throw new InformerConfException("When using a database-backed Catalog Refresh Queue Processor, the configured implementation of " + JobFactory.class + " must implement " + JobFactoryDB.class);
                }
                JobFactoryDB factory = jobFactoryDB;
                factory.instantiateJobInit(new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.DEFERRED), new JobInit.JobSpecInit(job.getJobId(), job.getCatalogid(), job.getRevision())).invoke();
                break;
            }
            case 2: {
                if (job.getParent() == null) {
                    boolean $i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$72 = false;
                    String $i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$72 = "Jobs of type 2 must have a Parent";
                    throw new IllegalArgumentException($i$a$-requireNotNull-CatalogQueueJobEvaluatorKt$evaluate$72.toString());
                }
                JobFactory jobFactory = JobConfig.getJobFactory();
                JobFactoryDB jobFactoryDB = jobFactory instanceof JobFactoryDB ? (JobFactoryDB)jobFactory : null;
                if (jobFactoryDB == null) {
                    throw new InformerConfException("When using a database-backed Catalog Refresh Queue Processor, the configured implementation of " + JobFactory.class + " must implement " + JobFactoryDB.class);
                }
                JobFactoryDB factory = jobFactoryDB;
                factory.instantiateJobDbInitFinalize(new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.DEFERRED), new JobInitFinalize.JobSpecInitFinalize(job.getCatalogid(), job.getRevision(), job.getParent(), job.getJobId())).invoke();
                break;
            }
            case 3: {
                JobConfig.getJobFactory().instantiateJobPreload(new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.DEFERRED), new JobPreload.JobSpecPreload(job.getJobId(), job.getCatalogid(), job.getRevision(), job.getWhereClause())).invoke();
                break;
            }
            case 4: {
                long trackingId = InformerTracking.catalogReloadStart(job.getCatalogid(), job.getJobId());
                JobConfig.getJobFactory().instantiateJobReconcile(new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.DEFERRED), new JobReconcile.JobSpecReconcile(job.getCatalogid(), job.getRevision())).invoke();
                InformerTracking.catalogReloadStop(trackingId);
                break;
            }
            case 5: {
                if (job.getWhereClause() == null) {
                    boolean bl = false;
                    String string = "Jobs of type 5 must have a WhereClause";
                    throw new IllegalArgumentException(string.toString());
                }
                JobConfig.getJobFactory().instantiateJobPartialReconcile(new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.DEFERRED), new JobPartialReconcile.JobSpecPartialReconcile(job.getCatalogid(), job.getRevision(), job.getWhereClause())).invoke();
                break;
            }
            case 6: {
                JobConfig.getJobFactory().instantiateJobSqliteGeneration(new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.DEFERRED), new JobSqliteGeneration.JobSpecSqliteGeneration(job.getCatalogid(), job.getLangCode(), false, 4, null)).invoke();
                break;
            }
            default: {
                throw new Exception("Unrecognized Job type: " + job.getJobType());
            }
        }
    }
}

