/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue;

import com.interlocsolutions.maximo.notify.queue.LockType;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.io.Closeable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"db2DisableNoWait", "", "connection", "Ljava/sql/Connection;", "db2EnableNoWait", "mySqlLock", "lockName", "", "mySqlUnlock", "nextSequenceValue", "", "sequenceName", "sqlServerLock", "lockType", "Lcom/interlocsolutions/maximo/notify/queue/LockType;", "sqlServerUnlock", "isinformer"})
public final class DatabaseFunctionsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sqlServerLock(@NotNull Connection connection, @NotNull String lockName, @NotNull LockType lockType) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        Intrinsics.checkNotNullParameter((Object)((Object)lockType), (String)"lockType");
        AutoCloseable autoCloseable = connection.prepareCall("{ ? = call sp_getapplock(?, ?, 'Session') } ");
        Throwable throwable = null;
        try {
            CallableStatement it = (CallableStatement)autoCloseable;
            boolean bl = false;
            it.registerOutParameter(1, 4);
            it.setString(2, lockName);
            switch (WhenMappings.$EnumSwitchMapping$0[lockType.ordinal()]) {
                case 1: {
                    it.setString(3, "Exclusive");
                    break;
                }
                case 2: {
                    it.setString(3, "Shared");
                }
            }
            it.execute();
            if (!(it.getInt(1) >= 0)) {
                boolean bl2 = false;
                String string = "Unable to claim " + lockName + " (" + (Object)((Object)lockType) + ").  Return Code: " + it.getInt(1);
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sqlServerUnlock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        AutoCloseable autoCloseable = connection.prepareCall("{ ? = call sp_releaseapplock(?, 'Session') } ");
        Throwable throwable = null;
        try {
            CallableStatement it = (CallableStatement)autoCloseable;
            boolean bl = false;
            it.setString(2, lockName);
            it.registerOutParameter(1, 4);
            it.execute();
            if (!(it.getInt(1) == 0)) {
                boolean bl2 = false;
                String string = "Unable to release " + lockName + ".  Return Code: " + it.getInt(1);
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void mySqlLock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        AutoCloseable autoCloseable = connection.prepareCall("{ ? = call GET_LOCK(?, 60) } ");
        Throwable throwable = null;
        try {
            CallableStatement it = (CallableStatement)autoCloseable;
            boolean bl = false;
            it.setString(2, lockName);
            it.registerOutParameter(1, 4);
            it.execute();
            if (!(it.getInt(1) == 1)) {
                boolean bl2 = false;
                String string = it.wasNull() ? "Unable to claim " + lockName + ".  Return Code: null" : "Unable to claim " + lockName + ".  Return Code: " + it.getInt(1);
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void mySqlUnlock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        AutoCloseable autoCloseable = connection.prepareCall("{ ? = call RELEASE_LOCK(?) } ");
        Throwable throwable = null;
        try {
            CallableStatement it = (CallableStatement)autoCloseable;
            boolean bl = false;
            it.setString(2, lockName);
            it.registerOutParameter(1, 4);
            it.execute();
            if (!(it.getInt(1) == 1)) {
                boolean bl2 = false;
                String string = it.wasNull() ? "Unable to release " + lockName + ".  Return Code: null" : "Unable to release " + lockName + ".  Return Code: " + it.getInt(1);
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final void db2EnableNoWait(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        JDBCExtensionsKt.executeUpdate$default((Connection)connection, (String)"SET CURRENT LOCK TIMEOUT NOT WAIT", null, (int)2, null);
    }

    public static final void db2DisableNoWait(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        JDBCExtensionsKt.executeUpdate$default((Connection)connection, (String)"SET CURRENT LOCK TIMEOUT NULL", null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long nextSequenceValue(@NotNull Connection connection, @NotNull String sequenceName) {
        long l;
        String string;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sequenceName, (String)"sequenceName");
        DbServerType dbServerType = DbServerType.identify((Connection)connection);
        switch (dbServerType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[dbServerType.ordinal()]) {
            case 1: {
                string = "select " + sequenceName + ".nextval from dual";
                break;
            }
            case 2: {
                string = "select NEXT VALUE FOR " + sequenceName;
                break;
            }
            case 3: {
                string = "select NEXT VALUE FOR " + sequenceName + " from SYSIBM.SYSDUMMY1";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported database type.".toString());
            }
        }
        String query = string;
        Connection $this$executeQuery_u24default$iv = connection;
        Object bindArgs$iv = null;
        boolean $i$f$executeQuery = false;
        Statement $this$use$iv$iv = $this$executeQuery_u24default$iv.createStatement();
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)new StatementCloseableWrapper($this$use$iv$iv);
        Throwable throwable = null;
        try {
            StatementCloseableWrapper it$iv$iv = (StatementCloseableWrapper)closeable;
            boolean bl = false;
            Statement it$iv = $this$use$iv$iv;
            boolean bl2 = false;
            ResultSet resultSet = it$iv.executeQuery(query);
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(sqlStr)");
            ResultSet rs = resultSet;
            boolean bl3 = false;
            if (!rs.next()) {
                throw new IllegalStateException(("Unable to find a value for sequence " + sequenceName + '.').toString());
            }
            l = rs.getLong(1);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LockType.values().length];
            try {
                nArray[LockType.EXCLUSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LockType.SHARED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DbServerType.values().length];
            try {
                nArray[DbServerType.ORACLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.MSSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbServerType.DB2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

