/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue;

import com.interlocsolutions.maximo.notify.err.ErrorHandlerAccessor;
import com.interlocsolutions.maximo.notify.queue.BulkByJvmWriterSql;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.ProcessorMonitorable;
import com.interlocsolutions.maximo.notify.util.ProcessorState;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0001ABC\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010(\u001a\u00020\u001eH$J\u0016\u0010)\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\bH$J\b\u0010+\u001a\u00020\u0015H\u0016J\b\u0010,\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H$J.\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u0005H$J.\u00107\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u0005H$J\u001e\u00108\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\bH$J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u000202H\u0002J\u0006\u0010;\u001a\u000202J\b\u0010<\u001a\u000202H\u0014J \u0010=\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020@H\u0002R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0014R\u001e\u0010&\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread;", "T", "Lcom/interlocsolutions/maximo/notify/util/InformerThread;", "Lcom/interlocsolutions/maximo/notify/util/ProcessorMonitorable;", "threadName", "", "writerQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "mErrorHandlerAccessor", "Lcom/interlocsolutions/maximo/notify/err/ErrorHandlerAccessor;", "logName", "lockName", "logger", "Lpsdi/util/logging/MXLogger;", "(Ljava/lang/String;Ljava/util/concurrent/BlockingQueue;Lcom/interlocsolutions/maximo/notify/err/ErrorHandlerAccessor;Ljava/lang/String;Ljava/lang/String;Lpsdi/util/logging/MXLogger;)V", "<set-?>", "", "cummulativeTimeAvg", "getCummulativeTimeAvg", "()J", "Lcom/interlocsolutions/maximo/notify/util/ProcessorState;", "currentState", "getCurrentState", "()Lcom/interlocsolutions/maximo/notify/util/ProcessorState;", "dbAccessor", "Lcom/interlocsolutions/maximo/notify/util/db/DbConnectionAccessor;", "getDbAccessor", "()Lcom/interlocsolutions/maximo/notify/util/db/DbConnectionAccessor;", "defaultBatchSize", "", "getDefaultBatchSize", "()I", "defaultMaxErrors", "getLogName", "()Ljava/lang/String;", "recordsSeenAvg", "getRecordsSeenAvg", "recordsSeenTotal", "getRecordsSeenTotal", "getBatchSize", "getCurrentErrorCount", "payload", "getProcessorState", "getProcessorType", "getWriterSql", "Lcom/interlocsolutions/maximo/notify/queue/BulkByJvmWriterSql;", "serverType", "Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "handleError", "", "statement", "Ljava/sql/PreparedStatement;", "newErrorCount", "errorMessage", "handleErrorExceeded", "handleSuccess", "logAdditionalInformation", "processQueue", "resetAverage", "runInformerTask", "safePoll", "timeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "Payload", "isinformer"})
public abstract class AbstractBulkByJvmWriterThread<T>
extends InformerThread
implements ProcessorMonitorable {
    @NotNull
    private final BlockingQueue<Payload<T>> writerQueue;
    @NotNull
    private final ErrorHandlerAccessor mErrorHandlerAccessor;
    @NotNull
    private final String logName;
    @NotNull
    private final String lockName;
    private final int defaultMaxErrors;
    private final int defaultBatchSize;
    private long recordsSeenTotal;
    private long cummulativeTimeAvg;
    private long recordsSeenAvg;
    @NotNull
    private ProcessorState currentState;

    public AbstractBulkByJvmWriterThread(@Nullable String threadName, @NotNull BlockingQueue<Payload<T>> writerQueue, @NotNull ErrorHandlerAccessor mErrorHandlerAccessor, @NotNull String logName, @NotNull String lockName, @NotNull MXLogger logger2) {
        Intrinsics.checkNotNullParameter(writerQueue, (String)"writerQueue");
        Intrinsics.checkNotNullParameter((Object)mErrorHandlerAccessor, (String)"mErrorHandlerAccessor");
        Intrinsics.checkNotNullParameter((Object)logName, (String)"logName");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super((ThreadGroup)InformerThreadGroup.getInformerThreadGroup(), threadName, logger2);
        this.writerQueue = writerQueue;
        this.mErrorHandlerAccessor = mErrorHandlerAccessor;
        this.logName = logName;
        this.lockName = lockName;
        this.setPriority(1);
        this.defaultMaxErrors = 5;
        this.defaultBatchSize = 50;
        this.currentState = ProcessorState.STARTING;
    }

    @NotNull
    protected final String getLogName() {
        return this.logName;
    }

    protected final int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    private final DbConnectionAccessor getDbAccessor() {
        DbConnectionAccessor dbConnectionAccessor = DbConnectionManager.getInstance().getQueueConnection();
        Intrinsics.checkNotNullExpressionValue((Object)dbConnectionAccessor, (String)"getInstance().queueConnection");
        return dbConnectionAccessor;
    }

    public final long getRecordsSeenTotal() {
        return this.recordsSeenTotal;
    }

    public final long getCummulativeTimeAvg() {
        return this.cummulativeTimeAvg;
    }

    public final long getRecordsSeenAvg() {
        return this.recordsSeenAvg;
    }

    @NotNull
    public final ProcessorState getCurrentState() {
        return this.currentState;
    }

    @Override
    protected void runInformerTask() {
        while (!this.shutdownRequested()) {
            try {
                this.processQueue();
            }
            catch (Exception e) {
                this.logger.warn((Object)"An unhandled error occurred.", (Throwable)e);
            }
        }
    }

    private final void processQueue() {
        BulkByJvmWriterSql writerSql = this.getWriterSql(this.getDbAccessor().getDbServerType());
        this.currentState = ProcessorState.WAITING;
        this.logger.debug((Object)"Entering WAITING state.");
        Ref.ObjectRef wakeUpPayload = new Ref.ObjectRef();
        wakeUpPayload.element = this.safePoll(1L, TimeUnit.SECONDS);
        if (wakeUpPayload.element != null) {
            this.currentState = ProcessorState.RUNNING;
            this.logger.debug((Object)"Entering RUNNING state.");
            this.getDbAccessor().useConn((Function1)new Function1<Connection, Unit>(writerSql, this, wakeUpPayload){
                final /* synthetic */ BulkByJvmWriterSql $writerSql;
                final /* synthetic */ AbstractBulkByJvmWriterThread<T> this$0;
                final /* synthetic */ Ref.ObjectRef<Payload<T>> $wakeUpPayload;
                {
                    this.$writerSql = $writerSql;
                    this.this$0 = $receiver;
                    this.$wakeUpPayload = $wakeUpPayload;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Connection conn) {
                    void $this$transaction$iv;
                    Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                    Connection connection = conn;
                    BulkByJvmWriterSql bulkByJvmWriterSql = this.$writerSql;
                    AbstractBulkByJvmWriterThread<T> abstractBulkByJvmWriterThread = this.this$0;
                    Ref.ObjectRef<Payload<T>> objectRef = this.$wakeUpPayload;
                    boolean $i$f$transaction = false;
                    boolean autoCommitWasEnabled$iv = $this$transaction$iv.getAutoCommit();
                    try {
                        if (autoCommitWasEnabled$iv) {
                            $this$transaction$iv.setAutoCommit(false);
                        } else {
                            $this$transaction$iv.rollback();
                        }
                        void it = $this$transaction$iv;
                        boolean bl = false;
                        AutoCloseable autoCloseable = conn.prepareStatement(bulkByJvmWriterSql.successSql());
                        Throwable throwable = null;
                        try {
                            int[] nArray;
                            PreparedStatement successStatement = (PreparedStatement)autoCloseable;
                            boolean bl2 = false;
                            AutoCloseable autoCloseable2 = conn.prepareStatement(bulkByJvmWriterSql.errorSql());
                            Throwable throwable2 = null;
                            try {
                                int[] nArray2;
                                PreparedStatement errorStatement = (PreparedStatement)autoCloseable2;
                                boolean bl3 = false;
                                AutoCloseable autoCloseable3 = conn.prepareStatement(bulkByJvmWriterSql.stopSql());
                                Throwable throwable3 = null;
                                try {
                                    int[] nArray3;
                                    PreparedStatement stopStatement = (PreparedStatement)autoCloseable3;
                                    boolean bl4 = false;
                                    int batchItem = 0;
                                    Payload payload = (Payload)objectRef.element;
                                    while (payload != null) {
                                        AbstractBulkByJvmWriterThread.access$getLogger$p$s-981638093(abstractBulkByJvmWriterThread).debug((Object)("Retrieved " + payload.getJob() + " of queue."));
                                        AbstractBulkByJvmWriterThread.access$setRecordsSeenTotal$p(abstractBulkByJvmWriterThread, abstractBulkByJvmWriterThread.getRecordsSeenTotal() + 1L);
                                        AbstractBulkByJvmWriterThread.access$setRecordsSeenAvg$p(abstractBulkByJvmWriterThread, abstractBulkByJvmWriterThread.getRecordsSeenAvg() + 1L);
                                        AbstractBulkByJvmWriterThread.access$setCummulativeTimeAvg$p(abstractBulkByJvmWriterThread, abstractBulkByJvmWriterThread.getCummulativeTimeAvg() + payload.getExecutionTime());
                                        ++batchItem;
                                        if (Result.isSuccess-impl((Object)payload.getJobEvaluation-d1pmJ48())) {
                                            Intrinsics.checkNotNullExpressionValue((Object)successStatement, (String)"successStatement");
                                            abstractBulkByJvmWriterThread.handleSuccess(successStatement, payload);
                                            successStatement.addBatch();
                                        } else if (Result.isFailure-impl((Object)payload.getJobEvaluation-d1pmJ48())) {
                                            Throwable exception = Result.exceptionOrNull-impl((Object)payload.getJobEvaluation-d1pmJ48());
                                            Object object = exception;
                                            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                                                object = "Unknown error";
                                            }
                                            Object errMsg2 = object;
                                            AbstractBulkByJvmWriterThread.access$getMErrorHandlerAccessor$p(abstractBulkByJvmWriterThread).getErrorHandler().handleError(exception);
                                            Object object2 = PropUtil.INSTANCE.getProp("informer.queue.maxerror");
                                            int maxErrorCount = object2 != null && (object2 = ((InformerProp)object2).asInt()) != null ? (Integer)object2 : AbstractBulkByJvmWriterThread.access$getDefaultMaxErrors$p(abstractBulkByJvmWriterThread);
                                            int newErrorCount = abstractBulkByJvmWriterThread.getCurrentErrorCount(payload) + 1;
                                            if (newErrorCount < maxErrorCount) {
                                                Intrinsics.checkNotNullExpressionValue((Object)errorStatement, (String)"errorStatement");
                                                abstractBulkByJvmWriterThread.handleError(errorStatement, payload, newErrorCount, (String)errMsg2);
                                                errorStatement.addBatch();
                                            } else {
                                                Intrinsics.checkNotNullExpressionValue((Object)stopStatement, (String)"stopStatement");
                                                abstractBulkByJvmWriterThread.handleErrorExceeded(stopStatement, payload, newErrorCount, (String)errMsg2);
                                                stopStatement.addBatch();
                                            }
                                        }
                                        payload = batchItem < abstractBulkByJvmWriterThread.getBatchSize() ? (Payload)AbstractBulkByJvmWriterThread.access$getWriterQueue$p(abstractBulkByJvmWriterThread).poll() : null;
                                    }
                                    bulkByJvmWriterSql.lock(conn, AbstractBulkByJvmWriterThread.access$getLockName$p(abstractBulkByJvmWriterThread));
                                    try {
                                        nArray3 = (int[])JDBCExtensionsKt.repeatOnDeadlock((Connection)conn, (Function0)((Function0)new Function0<int[]>(abstractBulkByJvmWriterThread, successStatement, errorStatement, stopStatement){
                                            final /* synthetic */ AbstractBulkByJvmWriterThread<T> this$0;
                                            final /* synthetic */ PreparedStatement $successStatement;
                                            final /* synthetic */ PreparedStatement $errorStatement;
                                            final /* synthetic */ PreparedStatement $stopStatement;
                                            {
                                                this.this$0 = $receiver;
                                                this.$successStatement = $successStatement;
                                                this.$errorStatement = $errorStatement;
                                                this.$stopStatement = $stopStatement;
                                                super(0);
                                            }

                                            public final int[] invoke() {
                                                AbstractBulkByJvmWriterThread.access$getLogger$p$s-981638093(this.this$0).debug((Object)"Executing batch.");
                                                this.$successStatement.executeBatch();
                                                this.$errorStatement.executeBatch();
                                                return this.$stopStatement.executeBatch();
                                            }
                                        }));
                                    }
                                    finally {
                                        bulkByJvmWriterSql.unlock(conn, AbstractBulkByJvmWriterThread.access$getLockName$p(abstractBulkByJvmWriterThread));
                                    }
                                    nArray2 = nArray3;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                                }
                                nArray = nArray2;
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            int[] nArray4 = nArray;
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        AbstractBulkByJvmWriterThread.access$getLogger$p$s-981638093(abstractBulkByJvmWriterThread).debug((Object)"Committing batch.");
                        conn.commit();
                        AbstractBulkByJvmWriterThread.access$getLogger$p$s-981638093(abstractBulkByJvmWriterThread).debug((Object)"Committed batch.");
                        Unit result$iv = Unit.INSTANCE;
                        $this$transaction$iv.commit();
                        Unit unit = result$iv;
                    }
                    finally {
                        $this$transaction$iv.rollback();
                        if (autoCommitWasEnabled$iv) {
                            $this$transaction$iv.setAutoCommit(true);
                        }
                    }
                }
            });
        }
    }

    public final void resetAverage() {
        this.recordsSeenAvg = 0L;
        this.cummulativeTimeAvg = 0L;
    }

    private final Payload<T> safePoll(long timeout, TimeUnit timeUnit) {
        Payload<T> payload;
        try {
            payload = this.writerQueue.poll(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            payload = null;
        }
        return payload;
    }

    protected abstract int getBatchSize();

    protected abstract void handleSuccess(@NotNull PreparedStatement var1, @NotNull Payload<T> var2);

    protected abstract void handleError(@NotNull PreparedStatement var1, @NotNull Payload<T> var2, int var3, @NotNull String var4);

    protected abstract void handleErrorExceeded(@NotNull PreparedStatement var1, @NotNull Payload<T> var2, int var3, @NotNull String var4);

    protected abstract int getCurrentErrorCount(@NotNull Payload<T> var1);

    @NotNull
    protected abstract BulkByJvmWriterSql getWriterSql(@NotNull DbServerType var1);

    @Override
    @NotNull
    public ProcessorState getProcessorState() {
        return this.currentState;
    }

    @Override
    @NotNull
    public String getProcessorType() {
        return "Writer";
    }

    @Override
    public void logAdditionalInformation() {
        long avgWriterQueue = this.recordsSeenAvg == 0L ? 0L : this.cummulativeTimeAvg / this.recordsSeenAvg;
        this.logger.info((Object)(this.logName + " Performance: Total: " + this.recordsSeenTotal + "; Average Time in Queue (ms/record): " + avgWriterQueue + "; Queue Size: " + this.writerQueue.size()));
        this.resetAverage();
    }

    public static final /* synthetic */ MXLogger access$getLogger$p$s-981638093(AbstractBulkByJvmWriterThread $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setRecordsSeenTotal$p(AbstractBulkByJvmWriterThread $this, long l) {
        $this.recordsSeenTotal = l;
    }

    public static final /* synthetic */ void access$setRecordsSeenAvg$p(AbstractBulkByJvmWriterThread $this, long l) {
        $this.recordsSeenAvg = l;
    }

    public static final /* synthetic */ void access$setCummulativeTimeAvg$p(AbstractBulkByJvmWriterThread $this, long l) {
        $this.cummulativeTimeAvg = l;
    }

    public static final /* synthetic */ ErrorHandlerAccessor access$getMErrorHandlerAccessor$p(AbstractBulkByJvmWriterThread $this) {
        return $this.mErrorHandlerAccessor;
    }

    public static final /* synthetic */ int access$getDefaultMaxErrors$p(AbstractBulkByJvmWriterThread $this) {
        return $this.defaultMaxErrors;
    }

    public static final /* synthetic */ BlockingQueue access$getWriterQueue$p(AbstractBulkByJvmWriterThread $this) {
        return $this.writerQueue;
    }

    public static final /* synthetic */ String access$getLockName$p(AbstractBulkByJvmWriterThread $this) {
        return $this.lockName;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B&\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\rJ\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J;\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\r\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001d"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "T", "", "job", "jobEvaluation", "Lkotlin/Result;", "", "executionTime", "", "(Ljava/lang/Object;Ljava/lang/Object;J)V", "getExecutionTime", "()J", "getJob", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getJobEvaluation-d1pmJ48", "component1", "component2", "component2-d1pmJ48", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Object;J)Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "equals", "", "other", "hashCode", "", "toString", "", "isinformer"})
    public static final class Payload<T> {
        private final T job;
        @NotNull
        private final Object jobEvaluation;
        private final long executionTime;

        public Payload(T job, @NotNull Object jobEvaluation, long executionTime) {
            this.job = job;
            this.jobEvaluation = jobEvaluation;
            this.executionTime = executionTime;
        }

        public final T getJob() {
            return this.job;
        }

        @NotNull
        public final Object getJobEvaluation-d1pmJ48() {
            return this.jobEvaluation;
        }

        public final long getExecutionTime() {
            return this.executionTime;
        }

        public final T component1() {
            return this.job;
        }

        @NotNull
        public final Object component2-d1pmJ48() {
            return this.jobEvaluation;
        }

        public final long component3() {
            return this.executionTime;
        }

        @NotNull
        public final Payload<T> copy(T job, @NotNull Object jobEvaluation, long executionTime) {
            return new Payload<T>(job, jobEvaluation, executionTime);
        }

        public static /* synthetic */ Payload copy$default(Payload payload, Object object, Result result, long l, int n, Object object2) {
            if ((n & 1) != 0) {
                object = payload.job;
            }
            if ((n & 2) != 0) {
                result = Result.box-impl((Object)payload.jobEvaluation);
            }
            if ((n & 4) != 0) {
                l = payload.executionTime;
            }
            return payload.copy(object, result.unbox-impl(), l);
        }

        @NotNull
        public String toString() {
            return "Payload(job=" + this.job + ", jobEvaluation=" + Result.toString-impl((Object)this.jobEvaluation) + ", executionTime=" + this.executionTime + ')';
        }

        public int hashCode() {
            int result = this.job == null ? 0 : this.job.hashCode();
            result = result * 31 + Result.hashCode-impl((Object)this.jobEvaluation);
            result = result * 31 + Long.hashCode(this.executionTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Payload)) {
                return false;
            }
            Payload payload = (Payload)other;
            if (!Intrinsics.areEqual(this.job, payload.job)) {
                return false;
            }
            if (!Result.equals-impl0((Object)this.jobEvaluation, (Object)payload.jobEvaluation)) {
                return false;
            }
            return this.executionTime == payload.executionTime;
        }
    }
}

