/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.PushDevice;
import com.interlocsolutions.maximo.notify.PushReg;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.push.IPushService;
import com.interlocsolutions.maximo.notify.push.PushProvider;
import com.interlocsolutions.maximo.notify.push.PushService;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.push.message.Message;
import java.rmi.RemoteException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.MXException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushRegistry;", "", "()V", "getPushProvider", "Lcom/interlocsolutions/maximo/notify/push/PushProvider;", "pushReg", "Lcom/interlocsolutions/maximo/notify/PushReg;", "getPushProviderFromDevice", "pushDevice", "Lcom/interlocsolutions/maximo/notify/PushDevice;", "isinformer"})
public final class PushRegistry {
    @NotNull
    public static final PushRegistry INSTANCE = new PushRegistry();

    private PushRegistry() {
    }

    @NotNull
    public final PushProvider getPushProvider(@NotNull PushReg pushReg2) throws RemoteException, MXException {
        PushProvider pushProvider2;
        Intrinsics.checkNotNullParameter((Object)pushReg2, (String)"pushReg");
        String string = pushReg2.getString("TYPE");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pushReg.getString(\"TYPE\")");
        String type = string;
        String appName = pushReg2.getString("APPNAME");
        long pushRegId = pushReg2.getLong("PUSHREGID");
        String string2 = type;
        if (Intrinsics.areEqual((Object)string2, (Object)"IOS")) {
            IPushService iPushService = new PushService(Message.Channels.iOS);
            Intrinsics.checkNotNullExpressionValue((Object)appName, (String)"appName");
            pushProvider2 = new PushProvider(iPushService, pushRegId, appName, pushReg2.getBoolean("USESANDBOX"));
        } else if (Intrinsics.areEqual((Object)string2, (Object)"ANDROID")) {
            IPushService iPushService = new PushService(Message.Channels.Android);
            Intrinsics.checkNotNullExpressionValue((Object)appName, (String)"appName");
            pushProvider2 = new PushProvider(iPushService, pushRegId, appName, false);
        } else {
            Object[] objectArray = new String[]{"Unsupported push registration type: " + type};
            throw new InformerException("invalidConfig", objectArray);
        }
        PushProvider provider = pushProvider2;
        return provider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PushProvider getPushProviderFromDevice(@NotNull PushDevice pushDevice) throws RemoteException, MXException {
        PushReg pushReg2;
        MboRemote mboRemote;
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)pushDevice, (String)"pushDevice");
            Sequence sequence = MboExtensionsKt.ownerChain$default((MboRemote)pushDevice, false, 1, null);
            for (Object e : sequence) {
                MboRemote it = (MboRemote)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"ISPUSHREG")) continue;
                object = e;
                break block4;
            }
            object = mboRemote = null;
        }
        if ((pushReg2 = mboRemote instanceof PushReg ? (PushReg)mboRemote : null) == null) {
            Object[] objectArray;
            void $this$resolveUnaryRelationship$iv;
            mboRemote = (MboRemote)pushDevice;
            String relationshipName$iv = "PUSHREG";
            boolean $i$f$resolveUnaryRelationship = false;
            void origin$iv = $this$resolveUnaryRelationship$iv;
            MboRemote resolved$iv = origin$iv.getMboSet(relationshipName$iv).getMbo(0);
            if (resolved$iv == null) {
                objectArray = new String[]{"" + origin$iv + '(' + origin$iv.getUniqueIDName() + '=' + origin$iv.getUniqueIDValue() + ") found no record via its \"" + relationshipName$iv + "\" relationship"};
                throw new InformerException("dataError", objectArray);
            }
            if (!(resolved$iv instanceof PushReg)) {
                objectArray = new String[]{"" + origin$iv + '(' + origin$iv.getUniqueIDName() + '=' + origin$iv.getUniqueIDValue() + ") found a record of an unexpected type via its \"" + relationshipName$iv + "\" relationship. Expected " + Reflection.getOrCreateKotlinClass(PushReg.class).getQualifiedName() + ", but found " + Reflection.getOrCreateKotlinClass(resolved$iv.getClass()).getQualifiedName() + '.'};
                throw new InformerException("dataError", objectArray);
            }
            pushReg2 = (PushReg)resolved$iv;
        }
        PushReg pushReg3 = pushReg2;
        return this.getPushProvider(pushReg3);
    }
}

