/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.err.MXExceptionUtilsKt;
import com.interlocsolutions.maximo.notify.push.PushJobConfig;
import com.interlocsolutions.maximo.notify.push.PushQueueJob;
import com.interlocsolutions.maximo.notify.push.PushQueueRepo;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.MXException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J7\u0010\u0013\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004J0\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004J0\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushQueueManager;", "", "()V", "PROCESSOR_CATEGORY_PUSHQ", "", "instance", "getInstance$annotations", "getInstance", "()Lcom/interlocsolutions/maximo/notify/push/PushQueueManager;", "pushQueueRepo", "Lcom/interlocsolutions/maximo/notify/push/PushQueueRepo;", "addQueuedItem", "", "pushQueueJob", "Lcom/interlocsolutions/maximo/notify/push/PushQueueJob;", "pushDeviceId", "", "pushType", "Lcom/interlocsolutions/maximo/notify/push/PushQueueManager$PushType;", "addQueuedItemForCatalog", "profileName", "catalogName", "partitionName", "langCode", "(Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "addQueuedItemForNotification", "addQueuedItemForTopicReg", "addQueuedItemForTopicUnreg", "shutDown", "maxTime", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "startUp", "PushType", "TopicDetails", "isinformer"})
public final class PushQueueManager {
    @NotNull
    public static final PushQueueManager INSTANCE = new PushQueueManager();
    @NotNull
    public static final String PROCESSOR_CATEGORY_PUSHQ = "PUSH.Q";
    @NotNull
    private static final PushQueueRepo pushQueueRepo = PushQueueRepo.INSTANCE;

    private PushQueueManager() {
    }

    public final void shutDown(long maxTime, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        PushJobConfig.INSTANCE.getPushQueueProcessor().shutdown();
    }

    public final void startUp() {
        PushJobConfig.INSTANCE.getPushQueueProcessor().startup();
    }

    public final void addQueuedItem(@NotNull PushQueueJob pushQueueJob) throws MXException {
        Intrinsics.checkNotNullParameter((Object)pushQueueJob, (String)"pushQueueJob");
        try {
            pushQueueRepo.add(pushQueueJob);
            PushJobConfig.INSTANCE.getPushQueueProcessor().process();
        }
        catch (Exception e) {
            throw MXExceptionUtilsKt.toMXException$default(e, "Create push job", null, 2, null);
        }
    }

    public final void addQueuedItem(long pushDeviceId, @NotNull PushType pushType) throws MXException {
        Intrinsics.checkNotNullParameter((Object)((Object)pushType), (String)"pushType");
        this.addQueuedItem(PushQueueJob.Companion.generalJob(pushDeviceId, pushType));
    }

    public final void addQueuedItemForNotification(long pushDeviceId, @NotNull String profileName) throws MXException {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        this.addQueuedItem(PushQueueJob.Companion.notificationJob(pushDeviceId, profileName));
    }

    public final void addQueuedItemForCatalog(@Nullable Long pushDeviceId, @NotNull String profileName, @NotNull String catalogName, @Nullable String partitionName, @NotNull String langCode) throws MXException {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        this.addQueuedItem(PushQueueJob.Companion.catalogJob(pushDeviceId, profileName, catalogName, partitionName, langCode));
    }

    public final void addQueuedItemForTopicReg(long pushDeviceId, @NotNull String profileName, @NotNull String catalogName, @Nullable String partitionName, @NotNull String langCode) throws MXException {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        this.addQueuedItem(PushQueueJob.Companion.topicRegJob(pushDeviceId, profileName, catalogName, partitionName, langCode));
    }

    public final void addQueuedItemForTopicUnreg(long pushDeviceId, @NotNull String profileName, @NotNull String catalogName, @Nullable String partitionName, @NotNull String langCode) throws MXException {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        this.addQueuedItem(PushQueueJob.Companion.topicUnregJob(pushDeviceId, profileName, catalogName, partitionName, langCode));
    }

    @NotNull
    public static final PushQueueManager getInstance() {
        return INSTANCE;
    }

    @JvmStatic
    public static /* synthetic */ void getInstance$annotations() {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushQueueManager$PushType;", "", "(Ljava/lang/String;I)V", "BLOCK", "NOTIFICATION", "INSTRUMENTATION", "LOG", "WIPE", "TEST", "SCREENSHOT", "LOG_LEVEL", "ERROR_RESOLVED", "CATALOG", "TOPIC_REG", "TOPIC_UNREG", "isinformer"})
    public static final class PushType
    extends Enum<PushType> {
        public static final /* enum */ PushType BLOCK = new PushType();
        public static final /* enum */ PushType NOTIFICATION = new PushType();
        public static final /* enum */ PushType INSTRUMENTATION = new PushType();
        public static final /* enum */ PushType LOG = new PushType();
        public static final /* enum */ PushType WIPE = new PushType();
        public static final /* enum */ PushType TEST = new PushType();
        public static final /* enum */ PushType SCREENSHOT = new PushType();
        public static final /* enum */ PushType LOG_LEVEL = new PushType();
        public static final /* enum */ PushType ERROR_RESOLVED = new PushType();
        public static final /* enum */ PushType CATALOG = new PushType();
        public static final /* enum */ PushType TOPIC_REG = new PushType();
        public static final /* enum */ PushType TOPIC_UNREG = new PushType();
        private static final /* synthetic */ PushType[] $VALUES;

        public static PushType[] values() {
            return (PushType[])$VALUES.clone();
        }

        public static PushType valueOf(String value) {
            return Enum.valueOf(PushType.class, value);
        }

        static {
            $VALUES = pushTypeArray = new PushType[]{PushType.BLOCK, PushType.NOTIFICATION, PushType.INSTRUMENTATION, PushType.LOG, PushType.WIPE, PushType.TEST, PushType.SCREENSHOT, PushType.LOG_LEVEL, PushType.ERROR_RESOLVED, PushType.CATALOG, PushType.TOPIC_REG, PushType.TOPIC_UNREG};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushQueueManager$TopicDetails;", "", "profileName", "", "catalogName", "partitionName", "langCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCatalogName", "()Ljava/lang/String;", "getLangCode", "getPartitionName", "getProfileName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "isinformer"})
    public static final class TopicDetails {
        @NotNull
        private final String profileName;
        @NotNull
        private final String catalogName;
        @Nullable
        private final String partitionName;
        @NotNull
        private final String langCode;

        public TopicDetails(@NotNull String profileName, @NotNull String catalogName, @Nullable String partitionName, @NotNull String langCode) {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
            Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
            this.profileName = profileName;
            this.catalogName = catalogName;
            this.partitionName = partitionName;
            this.langCode = langCode;
        }

        @NotNull
        public final String getProfileName() {
            return this.profileName;
        }

        @NotNull
        public final String getCatalogName() {
            return this.catalogName;
        }

        @Nullable
        public final String getPartitionName() {
            return this.partitionName;
        }

        @NotNull
        public final String getLangCode() {
            return this.langCode;
        }

        @NotNull
        public final String component1() {
            return this.profileName;
        }

        @NotNull
        public final String component2() {
            return this.catalogName;
        }

        @Nullable
        public final String component3() {
            return this.partitionName;
        }

        @NotNull
        public final String component4() {
            return this.langCode;
        }

        @NotNull
        public final TopicDetails copy(@NotNull String profileName, @NotNull String catalogName, @Nullable String partitionName, @NotNull String langCode) {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
            Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
            return new TopicDetails(profileName, catalogName, partitionName, langCode);
        }

        public static /* synthetic */ TopicDetails copy$default(TopicDetails topicDetails, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = topicDetails.profileName;
            }
            if ((n & 2) != 0) {
                string2 = topicDetails.catalogName;
            }
            if ((n & 4) != 0) {
                string3 = topicDetails.partitionName;
            }
            if ((n & 8) != 0) {
                string4 = topicDetails.langCode;
            }
            return topicDetails.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "TopicDetails(profileName=" + this.profileName + ", catalogName=" + this.catalogName + ", partitionName=" + this.partitionName + ", langCode=" + this.langCode + ')';
        }

        public int hashCode() {
            int result = this.profileName.hashCode();
            result = result * 31 + this.catalogName.hashCode();
            result = result * 31 + (this.partitionName == null ? 0 : this.partitionName.hashCode());
            result = result * 31 + this.langCode.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TopicDetails)) {
                return false;
            }
            TopicDetails topicDetails = (TopicDetails)other;
            if (!Intrinsics.areEqual((Object)this.profileName, (Object)topicDetails.profileName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.catalogName, (Object)topicDetails.catalogName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.partitionName, (Object)topicDetails.partitionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.langCode, (Object)topicDetails.langCode);
        }
    }
}

