/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.push.IPushService;
import com.interlocsolutions.maximo.notify.push.PushProvider;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.util.GenericLogger;
import com.interlocsolutions.maximo.notify.util.MXLoggerAdapterKt;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.push.Identification;
import com.interlocsolutions.push.message.Message;
import com.interlocsolutions.push.message.MessageType;
import com.interlocsolutions.push.message.PushPayload;
import com.interlocsolutions.push.message.PushPayloadCatalog;
import com.interlocsolutions.push.message.PushResult;
import com.interlocsolutions.push.message.PushTargets;
import com.interlocsolutions.push.message.PushUserNotification;
import com.interlocsolutions.push.message.RelayResponse;
import com.interlocsolutions.push.message.TargetType;
import com.interlocsolutions.push.message.TopicRegError;
import com.interlocsolutions.push.message.TopicRegMessage;
import com.interlocsolutions.push.message.TopicRegResponse;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 C2\u00020\u0001:\u0001CB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u001d\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ9\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010$\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ \u0010'\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J\u001d\u0010,\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ'\u0010-\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u00100J9\u00101\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u00106J\u001d\u00107\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001cJ\u000e\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020=H\u0002J\u001c\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00070AJ\u001c\u0010B\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00070AR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006D"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushProvider;", "", "api", "Lcom/interlocsolutions/maximo/notify/push/IPushService;", "pushRegId", "", "appName", "", "useSandbox", "", "(Lcom/interlocsolutions/maximo/notify/push/IPushService;JLjava/lang/String;Ljava/lang/Boolean;)V", "getApi", "()Lcom/interlocsolutions/maximo/notify/push/IPushService;", "getAppName", "()Ljava/lang/String;", "logger", "Lcom/interlocsolutions/maximo/notify/util/GenericLogger;", "getPushRegId", "()J", "getUseSandbox", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "discardToken", "", "deviceToken", "pushBlockRequest", "authToken", "trackingId", "(Ljava/lang/String;Ljava/lang/Long;)V", "pushCatalog", "profileName", "catalogName", "partitionName", "langCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)V", "pushErrorResolved", "pushInstrumentRequest", "pushLogLevelRequest", "pushLogRequest", "pushNotificationUpdate", "pushNotification", "Lcom/interlocsolutions/push/message/PushUserNotification;", "dataPayload", "Lcom/interlocsolutions/push/message/PushPayload;", "pushScreenShotRequest", "pushSignal", "type", "Lcom/interlocsolutions/push/message/MessageType;", "(Ljava/lang/String;Lcom/interlocsolutions/push/message/MessageType;Ljava/lang/Long;)V", "pushTestMessage", "message", "msgCount", "", "sound", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Long;)V", "pushWipeRequest", "registerIdentifications", "identification", "Lcom/interlocsolutions/push/Identification;", "sendMessage", "msg", "Lcom/interlocsolutions/push/message/Message;", "topicSubscribe", "topic", "regIds", "", "topicUnsubscribe", "Companion", "isinformer"})
public final class PushProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPushService api;
    private final long pushRegId;
    @NotNull
    private final String appName;
    @Nullable
    private final Boolean useSandbox;
    @NotNull
    private final GenericLogger logger;
    @NotNull
    private static final String topicDelimiter = "~";

    public PushProvider(@NotNull IPushService api, long pushRegId, @NotNull String appName, @Nullable Boolean useSandbox) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.api = api;
        this.pushRegId = pushRegId;
        this.appName = appName;
        this.useSandbox = useSandbox;
        MXLogger mXLogger = NotifyConstants.INFORMER_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_LOGGER");
        this.logger = MXLoggerAdapterKt.toGenericLogger(mXLogger);
    }

    @NotNull
    public final IPushService getApi() {
        return this.api;
    }

    public final long getPushRegId() {
        return this.pushRegId;
    }

    @NotNull
    public final String getAppName() {
        return this.appName;
    }

    @Nullable
    public final Boolean getUseSandbox() {
        return this.useSandbox;
    }

    public final void pushNotificationUpdate(@NotNull String authToken, @Nullable PushUserNotification pushNotification, @NotNull PushPayload dataPayload) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)dataPayload, (String)"dataPayload");
        PushTargets targets = PushTargets.Companion.targetDevice(authToken);
        Message.Channels channels = this.api.getChannel();
        String string = this.appName;
        Boolean bl = this.useSandbox;
        Message msg = new Message(string, pushNotification, channels, bl, dataPayload, targets);
        this.sendMessage(msg);
    }

    public final void pushCatalog(@NotNull String profileName, @NotNull String catalogName, @Nullable String partitionName, @Nullable String langCode, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
        String topic = Companion.buildTopic(profileName, catalogName, partitionName);
        PushTargets targets = PushTargets.Companion.targetTopic(topic);
        MessageType messageType = MessageType.TYPE_CATALOG;
        PushPayloadCatalog pushPayloadCatalog = new PushPayloadCatalog(catalogName, partitionName, langCode);
        PushPayload dataPayload = new PushPayload(messageType, profileName, pushPayloadCatalog, trackingId, Boolean.valueOf(false));
        pushPayloadCatalog = this.api.getChannel();
        String string = this.appName;
        Boolean bl = this.useSandbox;
        Message msg = new Message(string, null, (Message.Channels)pushPayloadCatalog, bl, dataPayload, targets, 2, null);
        this.sendMessage(msg);
    }

    public final void pushTestMessage(@NotNull String authToken, @Nullable String message2, int msgCount, @Nullable String sound, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        PushUserNotification notification = new PushUserNotification(sound, message2, Integer.valueOf(msgCount));
        PushTargets targets = PushTargets.Companion.targetDevice(authToken);
        PushPayload dataPayload = new PushPayload(MessageType.TYPE_TEST, null, null, trackingId, null, 22, null);
        Message.Channels channels = this.api.getChannel();
        String string = this.appName;
        Boolean bl = this.useSandbox;
        Message msg = new Message(string, notification, channels, bl, dataPayload, targets);
        this.sendMessage(msg);
    }

    private final void pushSignal(String authToken, MessageType type, Long trackingId) {
        PushPayload dataPayload = new PushPayload(type, null, null, trackingId, null, 22, null);
        Message msg = new Message(this.appName, null, this.api.getChannel(), null, dataPayload, PushTargets.Companion.targetDevice(authToken), 10, null);
        this.sendMessage(msg);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendMessage(Message msg) {
        String msg$iv$iv;
        Object object;
        GenericLogger $this$logLazy$iv$iv;
        boolean $i$f$logLazy;
        GenericLogger.LogLevel level$iv$iv;
        SqlFormat e$iv;
        RelayResponse feedback = this.api.sendMessage(msg);
        Iterable $this$forEach$iv = feedback.getResults();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PushResult result = (PushResult)element$iv;
            boolean bl = false;
            if (result.getAccepted()) continue;
            if (result.getType() == TargetType.DEVICE && feedback.getInvalidTokens().contains(result.getTarget())) {
                GenericLogger $this$infoLazy_u24default$iv = this.logger;
                e$iv = null;
                boolean $i$f$infoLazy = false;
                GenericLogger genericLogger = $this$infoLazy_u24default$iv;
                level$iv$iv = GenericLogger.LogLevel.INFO;
                $i$f$logLazy = false;
                if (!$this$logLazy$iv$iv.isEnabled(level$iv$iv)) continue;
                try {
                    boolean bl2 = false;
                    object = Result.constructor-impl((Object)("Token " + result.getTarget() + " is invalid or expired, and will be purged: " + result));
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                String bl2 = "(Unable to form error msg)";
                msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? bl2 : object);
                GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
                continue;
            }
            GenericLogger $this$warnLazy_u24default$iv = this.logger;
            e$iv = null;
            boolean $i$f$warnLazy = false;
            $this$logLazy$iv$iv = $this$warnLazy_u24default$iv;
            level$iv$iv = GenericLogger.LogLevel.WARN;
            $i$f$logLazy = false;
            if (!$this$logLazy$iv$iv.isEnabled(level$iv$iv)) continue;
            try {
                boolean bl3 = false;
                object = Result.constructor-impl((Object)("Error received from push relay: " + result));
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            String bl3 = "(Unable to form error msg)";
            msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? bl3 : object);
            GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
        }
        $this$forEach$iv = feedback.getInvalidTokens();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$sendMessage_u24lambda_u246_u24lambda_u244;
            SqlFormat sqlFormat;
            String deviceToken = (String)element$iv;
            boolean bl = false;
            GenericLogger $this$debugLazy_u24default$iv = this.logger;
            e$iv = null;
            boolean $i$f$debugLazy = false;
            $this$logLazy$iv$iv = $this$debugLazy_u24default$iv;
            level$iv$iv = GenericLogger.LogLevel.DEBUG;
            $i$f$logLazy = false;
            if ($this$logLazy$iv$iv.isEnabled(level$iv$iv)) {
                try {
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)("Purging device token " + deviceToken));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string = "(Unable to form error msg)";
                msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
            }
            e$iv = sqlFormat = new SqlFormat("pushregid = :1");
            String string = "ISPUSHDEVICE";
            UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
            boolean bl5 = false;
            $this$sendMessage_u24lambda_u246_u24lambda_u244.setLong(1, this.pushRegId);
            Unit unit = Unit.INSTANCE;
            MboUtil.visitMbos(userInfo, string, sqlFormat.format(), arg_0 -> PushProvider.sendMessage$lambda$6$lambda$5(deviceToken, arg_0));
        }
    }

    public final void registerIdentifications(@NotNull Identification identification) {
        Intrinsics.checkNotNullParameter((Object)identification, (String)"identification");
        this.api.registerIdentifications(identification);
    }

    /*
     * WARNING - void declaration
     */
    public final void topicSubscribe(@NotNull String topic, @NotNull List<String> regIds) {
        String invalidToken;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(regIds, (String)"regIds");
        Message.Channels channels = this.api.getChannel();
        String string = this.appName;
        Boolean bl = this.useSandbox;
        TopicRegMessage msg = new TopicRegMessage(channels, bl, string, topic, regIds);
        TopicRegResponse feedback = this.api.subscribeToTopic(msg);
        Iterable $this$forEach$iv = feedback.getErrors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$logLazy$iv$iv;
            TopicRegError error = (TopicRegError)element$iv;
            boolean bl2 = false;
            GenericLogger $this$infoLazy_u24default$iv = this.logger;
            Object e$iv = null;
            boolean $i$f$infoLazy = false;
            GenericLogger genericLogger = $this$infoLazy_u24default$iv;
            GenericLogger.LogLevel level$iv$iv = GenericLogger.LogLevel.INFO;
            boolean $i$f$logLazy = false;
            if (!$this$logLazy$iv$iv.isEnabled(level$iv$iv)) continue;
            try {
                boolean bl3 = false;
                object = Result.constructor-impl((Object)("Push notification broadcasting unregistration for device: " + error.getRegId() + " was unsuccessful. Cause: " + error.getReason()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string2 = "(Unable to form error msg)";
            String msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? string2 : object);
            GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
        }
        $this$forEach$iv = feedback.getInvalidTokens();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            invalidToken = (String)element$iv;
            boolean bl4 = false;
            this.discardToken(invalidToken);
        }
        if (!((Collection)feedback.getErrors()).isEmpty()) {
            void $this$logLazy$iv$iv;
            String errMsg2 = CollectionsKt.joinToString$default((Iterable)feedback.getErrors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)topicSubscribe.errMsg.1.INSTANCE, (int)30, null) + "\nRaw response: " + feedback;
            GenericLogger $this$errorLazy_u24default$iv = this.logger;
            Object e$iv = null;
            boolean $i$f$errorLazy = false;
            invalidToken = $this$errorLazy_u24default$iv;
            GenericLogger.LogLevel level$iv$iv = GenericLogger.LogLevel.ERROR;
            boolean $i$f$logLazy = false;
            if ($this$logLazy$iv$iv.isEnabled(level$iv$iv)) {
                Object object;
                try {
                    boolean bl5 = false;
                    object = Result.constructor-impl((Object)errMsg2);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string3 = "(Unable to form error msg)";
                String msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? string3 : object);
                GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
            }
            throw new Exception(errMsg2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void topicUnsubscribe(@NotNull String topic, @NotNull List<String> regIds) {
        String invalidToken;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(regIds, (String)"regIds");
        Message.Channels channels = this.api.getChannel();
        String string = this.appName;
        Boolean bl = this.useSandbox;
        TopicRegMessage msg = new TopicRegMessage(channels, bl, string, topic, regIds);
        TopicRegResponse feedback = this.api.unsubscribeFromTopic(msg);
        Iterable $this$forEach$iv = feedback.getErrors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$logLazy$iv$iv;
            TopicRegError error = (TopicRegError)element$iv;
            boolean bl2 = false;
            GenericLogger $this$infoLazy_u24default$iv = this.logger;
            Object e$iv = null;
            boolean $i$f$infoLazy = false;
            GenericLogger genericLogger = $this$infoLazy_u24default$iv;
            GenericLogger.LogLevel level$iv$iv = GenericLogger.LogLevel.INFO;
            boolean $i$f$logLazy = false;
            if (!$this$logLazy$iv$iv.isEnabled(level$iv$iv)) continue;
            try {
                boolean bl3 = false;
                object = Result.constructor-impl((Object)("Push notification broadcasting unregistration for device: " + error.getRegId() + " was unsuccessful. Cause: " + error.getReason()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string2 = "(Unable to form error msg)";
            String msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? string2 : object);
            GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
        }
        $this$forEach$iv = feedback.getInvalidTokens();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            invalidToken = (String)element$iv;
            boolean bl4 = false;
            this.discardToken(invalidToken);
        }
        if (!((Collection)feedback.getErrors()).isEmpty()) {
            void $this$logLazy$iv$iv;
            String errMsg2 = CollectionsKt.joinToString$default((Iterable)feedback.getErrors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)topicUnsubscribe.errMsg.1.INSTANCE, (int)30, null) + "\nRaw response: " + feedback;
            GenericLogger $this$errorLazy_u24default$iv = this.logger;
            Object e$iv = null;
            boolean $i$f$errorLazy = false;
            invalidToken = $this$errorLazy_u24default$iv;
            GenericLogger.LogLevel level$iv$iv = GenericLogger.LogLevel.ERROR;
            boolean $i$f$logLazy = false;
            if ($this$logLazy$iv$iv.isEnabled(level$iv$iv)) {
                Object object;
                try {
                    boolean bl5 = false;
                    object = Result.constructor-impl((Object)errMsg2);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string3 = "(Unable to form error msg)";
                String msg$iv$iv = (String)(Result.isFailure-impl((Object)object) ? string3 : object);
                GenericLogger.DefaultImpls.log$default((GenericLogger)$this$logLazy$iv$iv, (GenericLogger.LogLevel)level$iv$iv, (String)msg$iv$iv, null, (int)4, null);
            }
            throw new Exception(errMsg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void discardToken(String deviceToken) {
        MboSetRemote $this$use$iv = MboExtensionsKt.getNewMboSet$default("ISPUSHDEVICE", MboExtensionsKt.sqlFormat$default("pushregid = :1 AND token = :2", null, null, (Function1)new Function1<SqlFormat, Unit>(this, deviceToken){
            final /* synthetic */ PushProvider this$0;
            final /* synthetic */ String $deviceToken;
            {
                this.this$0 = $receiver;
                this.$deviceToken = $deviceToken;
                super(1);
            }

            public final void invoke(@NotNull SqlFormat $this$sqlFormat) {
                Intrinsics.checkNotNullParameter((Object)$this$sqlFormat, (String)"$this$sqlFormat");
                $this$sqlFormat.setLong(1, this.this$0.getPushRegId());
                $this$sqlFormat.setObject(2, "ISPUSHDEVICE", "TOKEN", this.$deviceToken);
            }
        }, 3, null), null, false, 12, null);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl = false;
            MboSetRemote deviceSet = $this$use$iv;
            boolean bl2 = false;
            deviceSet.deleteAll();
            deviceSet.save();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void pushInstrumentRequest(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_INSTRUMENT, trackingId);
    }

    public final void pushWipeRequest(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_WIPE, trackingId);
    }

    public final void pushBlockRequest(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_BLOCK, trackingId);
    }

    public final void pushScreenShotRequest(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_SCREEN, trackingId);
    }

    public final void pushLogRequest(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_LOG, trackingId);
    }

    public final void pushErrorResolved(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_ERROR, trackingId);
    }

    public final void pushLogLevelRequest(@NotNull String authToken, @Nullable Long trackingId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        this.pushSignal(authToken, MessageType.TYPE_LOG_LEVEL, trackingId);
    }

    private static final void sendMessage$lambda$6$lambda$5(String $deviceToken, MboRemote pushDevice) {
        Intrinsics.checkNotNullParameter((Object)$deviceToken, (String)"$deviceToken");
        Intrinsics.checkNotNullParameter((Object)pushDevice, (String)"pushDevice");
        if (pushDevice.getString("TOKEN").equals($deviceToken)) {
            pushDevice.delete();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushProvider$Companion;", "", "()V", "topicDelimiter", "", "buildTopic", "profileName", "catalogName", "partition", "parseTopic", "Lcom/interlocsolutions/maximo/notify/push/PushQueueManager$TopicDetails;", "topic", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String buildTopic(@NotNull String profileName, @NotNull String catalogName, @Nullable String partition) {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
            return partition != null ? profileName + '~' + catalogName + '~' + partition : profileName + '~' + catalogName;
        }

        @Nullable
        public final PushQueueManager.TopicDetails parseTopic(@NotNull String topic) {
            PushQueueManager.TopicDetails topicDetails;
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            String[] stringArray = new String[]{PushProvider.topicDelimiter};
            List it = StringsKt.split$default((CharSequence)topic, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            switch (it.size()) {
                case 3: {
                    topicDetails = new PushQueueManager.TopicDetails((String)it.get(0), (String)it.get(2), null, (String)it.get(1));
                    break;
                }
                case 4: {
                    topicDetails = new PushQueueManager.TopicDetails((String)it.get(0), (String)it.get(2), (String)it.get(3), (String)it.get(1));
                    break;
                }
                default: {
                    topicDetails = null;
                }
            }
            return topicDetails;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

