/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.configure.QueuePropertyMigrator;
import com.interlocsolutions.maximo.notify.push.BulkByThreadProcessor;
import com.interlocsolutions.maximo.notify.push.PushJobQueueProcessor;
import com.interlocsolutions.maximo.notify.push.PushQueueRepo;
import com.interlocsolutions.maximo.notify.queue.AbstractQueueProcessor;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0010H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/interlocsolutions/maximo/notify/push/BulkByThreadPushJobQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/push/PushJobQueueProcessor;", "()V", "activeProcessor", "Lcom/interlocsolutions/maximo/notify/push/BulkByThreadProcessor;", "defaultPushConfig", "Lcom/interlocsolutions/maximo/notify/push/BulkByThreadPushJobQueueProcessor$PushPoolConfig;", "processorNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "pushPool", "getPushPool", "()Lcom/interlocsolutions/maximo/notify/push/BulkByThreadPushJobQueueProcessor$PushPoolConfig;", "pushQueueRepo", "Lcom/interlocsolutions/maximo/notify/push/PushQueueRepo;", "determineShutdown", "", "findLegacyPushConfig", "Lcom/interlocsolutions/maximo/notify/util/InformerProp;", "logDeprecationWarning", "", "it", "performProcess", "performShutdown", "performStartup", "PushPoolConfig", "PushProcessorThreadGroup", "isinformer"})
public final class BulkByThreadPushJobQueueProcessor
extends AbstractQueueProcessor
implements PushJobQueueProcessor {
    @NotNull
    private final PushQueueRepo pushQueueRepo;
    @Nullable
    private BulkByThreadProcessor activeProcessor;
    @NotNull
    private final AtomicInteger processorNumber;
    @NotNull
    private final PushPoolConfig defaultPushConfig;

    public BulkByThreadPushJobQueueProcessor() {
        MXLogger mXLogger = NotifyConstants.INFORMER_PUSH_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_PUSH_LOGGER");
        super(mXLogger);
        this.pushQueueRepo = PushQueueRepo.INSTANCE;
        this.processorNumber = new AtomicInteger();
        this.defaultPushConfig = new PushPoolConfig(1);
    }

    private final InformerProp findLegacyPushConfig() {
        InformerProp informerProp = PropUtil.INSTANCE.getProp("informer.queue.donotrun");
        if (informerProp == null && (informerProp = PropUtil.INSTANCE.getProp("informer.queue.pool")) == null && (informerProp = PropUtil.INSTANCE.getProp("informer.push.queue.donotrun")) == null) {
            informerProp = PropUtil.INSTANCE.getProp("informer.push.queue.pool");
        }
        return informerProp;
    }

    @NotNull
    public final PushPoolConfig getPushPool() {
        Object object;
        InformerProp informerProp;
        InformerProp informerProp2 = this.findLegacyPushConfig();
        if (informerProp2 != null) {
            InformerProp it = informerProp2;
            boolean bl = false;
            this.logDeprecationWarning(it);
            informerProp = new InformerProp("informer.queue.pool.push", QueuePropertyMigrator.INSTANCE.determineNewPushQProp((Function1<? super String, InformerProp>)((Function1)new Function1<String, InformerProp>((Object)PropUtil.INSTANCE){

                @Nullable
                public final InformerProp invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((PropUtil)this.receiver).getProp(p0);
                }
            })));
        } else {
            informerProp = PropUtil.INSTANCE.getProp("informer.queue.pool.push");
        }
        InformerProp poolProp2 = informerProp;
        try {
            Object object2;
            block12: {
                block11: {
                    PushPoolConfig pushPoolConfig;
                    object2 = poolProp2;
                    if (object2 == null || (object2 = ((InformerProp)object2).asInt()) == null) break block11;
                    int poolSize = ((Number)object2).intValue();
                    boolean bl = false;
                    if (poolSize < 1) {
                        pushPoolConfig = new PushPoolConfig(0);
                    } else if (poolSize == 1) {
                        pushPoolConfig = new PushPoolConfig(1);
                    } else {
                        this.getLogger().warn((Object)("informer.queue.pool.push=" + poolProp2 + " is greater than 1, but currently only a single Push processor is supported per JVM. Defaults will be used."));
                        pushPoolConfig = this.defaultPushConfig;
                    }
                    object2 = pushPoolConfig;
                    if (pushPoolConfig != null) break block12;
                }
                object2 = this.defaultPushConfig;
            }
            object = object2;
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Unable to parse queue pool size from informer.queue.pool.push=" + poolProp2 + ".Pool sizes will be set to default values.\nCause: " + e));
            object = this.defaultPushConfig;
        }
        return object;
    }

    private final void logDeprecationWarning(InformerProp it) {
        this.getLogger().warn((Object)StringsKt.trimIndent((String)("\n                **** **** **** ****\n                **** **** **** ****\n                Use of JVM or System Property '" + it.getPropName() + "' is deprecated, and will be removed in a later version.\n                Please use the 'informer.queue.pool.notification', and 'informer.queue.pool.push'\n                Maximo System Properties to control your queues, globally and/or using Instance properties.\n                **** **** **** ****\n                **** **** **** ****\n                ")));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean performStartup() {
        boolean bl;
        if (this.getPushPool().getNumPush() > 0) {
            void $this$performStartup_u24lambda_u242;
            BulkByThreadProcessor bulkByThreadProcessor;
            BulkByThreadProcessor bulkByThreadProcessor2 = bulkByThreadProcessor = new BulkByThreadProcessor((ThreadGroup)PushProcessorThreadGroup.INSTANCE, this.pushQueueRepo, this.processorNumber.incrementAndGet());
            BulkByThreadPushJobQueueProcessor bulkByThreadPushJobQueueProcessor = this;
            boolean bl2 = false;
            $this$performStartup_u24lambda_u242.start();
            bulkByThreadPushJobQueueProcessor.activeProcessor = bulkByThreadProcessor;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void performShutdown() {
        this.activeProcessor = null;
        PushProcessorThreadGroup.INSTANCE.awaitShutdown(10L, TimeUnit.SECONDS);
    }

    @Override
    protected void performProcess() {
        block0: {
            BulkByThreadProcessor bulkByThreadProcessor = this.activeProcessor;
            if (bulkByThreadProcessor == null) break block0;
            bulkByThreadProcessor.wake();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean determineShutdown() {
        if (this.activeProcessor == null) return true;
        BulkByThreadProcessor bulkByThreadProcessor = this.activeProcessor;
        Intrinsics.checkNotNull((Object)bulkByThreadProcessor);
        if (bulkByThreadProcessor.isAlive()) return false;
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/interlocsolutions/maximo/notify/push/BulkByThreadPushJobQueueProcessor$PushProcessorThreadGroup;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;", "()V", "isinformer"})
    private static final class PushProcessorThreadGroup
    extends InformerThreadGroup {
        @NotNull
        public static final PushProcessorThreadGroup INSTANCE = new PushProcessorThreadGroup();

        private PushProcessorThreadGroup() {
            super(InformerThreadGroup.getInformerThreadGroup());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/interlocsolutions/maximo/notify/push/BulkByThreadPushJobQueueProcessor$PushPoolConfig;", "", "numPush", "", "(I)V", "getNumPush", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "isinformer"})
    public static final class PushPoolConfig {
        private final int numPush;

        public PushPoolConfig(int numPush) {
            this.numPush = numPush;
        }

        public final int getNumPush() {
            return this.numPush;
        }

        public final int component1() {
            return this.numPush;
        }

        @NotNull
        public final PushPoolConfig copy(int numPush) {
            return new PushPoolConfig(numPush);
        }

        public static /* synthetic */ PushPoolConfig copy$default(PushPoolConfig pushPoolConfig, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pushPoolConfig.numPush;
            }
            return pushPoolConfig.copy(n);
        }

        @NotNull
        public String toString() {
            return "PushPoolConfig(numPush=" + this.numPush + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.numPush);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PushPoolConfig)) {
                return false;
            }
            PushPoolConfig pushPoolConfig = (PushPoolConfig)other;
            return this.numPush == pushPoolConfig.numPush;
        }
    }
}

