/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.filter;

import com.interlocsolutions.maximo.notify.filter.EventFilter;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.util.MXException;

public class StringValueWhitelistFilter
implements EventFilter {
    protected final String attributeName;
    protected final Set<String> allowedValues;
    protected final String singleValue;
    protected final boolean singleValueSpecified;

    public StringValueWhitelistFilter(String attributeName, Set<String> allowedValues) {
        this.attributeName = attributeName;
        this.allowedValues = allowedValues;
        if (allowedValues.size() == 1) {
            this.singleValueSpecified = true;
            this.singleValue = allowedValues.iterator().next();
        } else {
            this.singleValueSpecified = false;
            this.singleValue = null;
        }
    }

    public StringValueWhitelistFilter(String attributeName, String ... allowedValues) {
        this(attributeName, new HashSet<String>(Arrays.asList(allowedValues)));
    }

    protected boolean match(String compareValue) {
        if (this.singleValueSpecified) {
            return this.singleValue.equals(compareValue);
        }
        return this.allowedValues.contains(compareValue);
    }

    @Override
    public boolean filterEvent(MboRemote mbo) throws RemoteException, MXException {
        if (mbo.toBeAdded()) {
            return this.match(mbo.getString(this.attributeName));
        }
        if (this.match(mbo.getString(this.attributeName))) {
            return true;
        }
        if (mbo instanceof Mbo) {
            String prevStatus = ((Mbo)mbo).getMboValue(this.attributeName).getInitialValue().asString();
            return this.match(prevStatus);
        }
        NotifyConstants.INFORMER_LOGGER.debug((Object)"Cannot evaluate previous values of a remote object. Skipping filter.");
        return true;
    }

    public String toString() {
        if (this.singleValueSpecified) {
            return String.format("%s == '%s'", this.attributeName, this.singleValue);
        }
        return String.format("%s IN ('%s')", this.attributeName, StringUtils.join(this.allowedValues, "', '"));
    }
}

