/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.filter;

import com.interlocsolutions.maximo.notify.filter.EventFilter;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import psdi.mbo.MboRemote;
import psdi.util.MXException;

public class FilterChain
implements EventFilter {
    protected List<EventFilter> mFilters;

    public FilterChain(List<EventFilter> filters) {
        this.mFilters = filters;
    }

    public FilterChain() {
        this(new ArrayList<EventFilter>());
    }

    public FilterChain(EventFilter ... filters) {
        this(Arrays.asList(filters));
    }

    public void addFilter(EventFilter filter) {
        this.mFilters.add(filter);
    }

    @Override
    public boolean filterEvent(MboRemote mbo) throws RemoteException, MXException {
        boolean allowed = true;
        Iterator<EventFilter> filterItr = this.mFilters.iterator();
        while (allowed && filterItr.hasNext()) {
            allowed = filterItr.next().filterEvent(mbo);
        }
        return allowed;
    }

    public String toString() {
        return StringUtils.join(this.mFilters, " && ");
    }
}

