/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.UserNotification;
import com.interlocsolutions.maximo.notify.commands.BasicCommand;
import com.interlocsolutions.maximo.notify.commands.WFActionDO;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.workflow.WFActionRemote;
import psdi.workflow.WFActionSetRemote;
import psdi.workflow.WFAssignment;

@XmlRootElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
public class WorkflowCommand
extends BasicCommand {
    private static final String NAME = "WORKFLOW";
    private boolean positiveAction = true;
    private int sequence = -1;
    private String memo = null;
    private boolean interactive = false;
    private long notificationId = -1L;
    private UserNotification mbo = null;
    private SessionInfo session = null;
    private List<WFActionDO> availableActions = new LinkedList<WFActionDO>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() throws NotifyFault {
        try {
            if (this.mbo != null) {
                MboSetRemote mboSet;
                block8: {
                    MboSetRemote assignmentSet = this.mbo.getMboSet("WFASSIGNMENT");
                    if (assignmentSet.isEmpty()) {
                        throw new MXApplicationException("informer", "noWFAssignment");
                    }
                    WFAssignment assignment = (WFAssignment)assignmentSet.getMbo(0);
                    long id = this.mbo.getLong("RECORDID");
                    String objectName = this.mbo.getString("OBJECTNAME");
                    String userId = this.mbo.getString("USERID");
                    mboSet = null;
                    try {
                        mboSet = MXServer.getMXServer().getMboSet(objectName, NotifyUtil.getLocalUserInfo(userId));
                        MboRemote obj = mboSet.getMboForUniqueId(id);
                        if (obj == null) break block8;
                        this.actionAssignment(assignment);
                    }
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(mboSet);
                        throw throwable;
                    }
                }
                NotifyUtil.closeAndCleanup(mboSet);
            }
            return null;
        }
        catch (NotifyFault e) {
            throw e;
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (RemoteException e) {
            throw new NotifyFault("system", "remoteexception", e);
        }
    }

    @Override
    @XmlAttribute(name="name", required=true)
    public String getName() {
        return NAME;
    }

    @XmlElement(name="interactive", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private void setName(String name) {
    }

    @XmlElement(name="sequence", namespace="http://www.interlocsolutions.com/maximo/notify")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @XmlElement(name="positiveAction", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isPositiveAction() {
        return this.positiveAction;
    }

    public void setPositiveAction(boolean positiveAction) {
        this.positiveAction = positiveAction;
    }

    @XmlElement(name="memo", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @XmlElement(name="notificationId", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    @Override
    public void setNotifyMbo(UserNotification mbo) throws MXException, RemoteException {
        this.mbo = mbo;
        this.notificationId = mbo.getUniqueIDValue();
        this.setAvailableActions();
    }

    public void setAvailableActions(List<WFActionDO> availableActions) {
        this.availableActions = availableActions;
    }

    @XmlElementWrapper(name="actions", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="action", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<WFActionDO> getAvailableActions() {
        return this.availableActions;
    }

    @Override
    public String getSchemaPath() {
        return "/resources/schemas/workflow.xsd";
    }

    private void setAvailableActions() throws RemoteException, MXException {
        if (this.mbo != null && this.notificationId != -1L) {
            this.availableActions = new LinkedList<WFActionDO>();
            MboSetRemote assignmentSet = this.mbo.getMboSet("WFASSIGNMENT");
            if (assignmentSet.isEmpty()) {
                throw new MXApplicationException("informer", "missingWFAssignment");
            }
            WFAssignment assignment = (WFAssignment)assignmentSet.getMbo(0);
            WFActionSetRemote actionList = assignment.getWFInstance().getActions();
            boolean displayOne = assignment.getNode().getMboSet("TASK").getMbo(0).getBoolean("DISPLAYONE");
            if (!displayOne && actionList.getMbo(0) != null && actionList.getMbo(1) == null) {
                assignment.getWFInstance().completeWorkflowAssignment(assignment.getInt("ASSIGNID"), actionList.getMbo(0).getInt("ACTIONID"), null);
                actionList = assignment.getWFInstance().getActions();
                this.interactive = true;
            }
            MboRemote action2 = null;
            int i = 0;
            while ((action2 = actionList.getMbo(i++)) != null) {
                if (action2.isNull("SEQUENCE")) {
                    this.availableActions.add(new WFActionDO(action2.getString("INSTRUCTION"), action2.getBoolean("ISPOSITIVE")));
                    continue;
                }
                this.availableActions.add(new WFActionDO(action2.getString("INSTRUCTION"), action2.getBoolean("ISPOSITIVE"), action2.getInt("SEQUENCE")));
            }
        }
    }

    private void actionAssignment(WFAssignment assignment) throws RemoteException, MXException {
        WFActionRemote action2 = null;
        if (this.sequence >= 0) {
            boolean displayOne = assignment.getNode().getMboSet("TASK").getMbo(0).getBoolean("DISPLAYONE");
            WFActionSetRemote actionList = assignment.getWFInstance().getActions();
            if (!displayOne && actionList.getMbo(0) != null && actionList.getMbo(1) == null) {
                assignment.getWFInstance().completeWorkflowAssignment(assignment.getInt("ASSIGNID"), actionList.getMbo(0).getInt("ACTIONID"), null);
                actionList = assignment.getWFInstance().getActions();
            }
            for (int i = 0; i < actionList.count(); ++i) {
                WFActionRemote checkAction = (WFActionRemote)assignment.getWFInstance().getActions().getMbo(i);
                if (checkAction.getInt("SEQUENCE") != this.sequence) continue;
                action2 = checkAction;
                break;
            }
        } else {
            action2 = assignment.getWFInstance().getActions().getAction(this.positiveAction);
        }
        if (action2 == null) {
            throw new MXApplicationException("informer", "noWFAction");
        }
        assignment.getWFInstance().completeWorkflowAssignment(assignment.getInt("ASSIGNID"), action2.getInt("ACTIONID"), this.memo != null ? this.memo : "");
    }

    public void setSession(SessionInfo session) {
        this.session = session;
    }

    @Override
    public String getVersion() {
        return "1.0.1";
    }
}

