/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import java.text.ParseException;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@XmlRootElement(name="value", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"attribute", "value", "index", "ignoreReadOnly", "ignoreValidation", "ignoreAction", "type"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class ValueDO {
    private String attribute;
    private String value;
    private int index = Integer.MAX_VALUE;
    private boolean ignoreReadOnly = false;
    private boolean ignoreValidation = false;
    private boolean ignoreAction = false;
    private DataType type = DataType.STRING;

    public ValueDO() {
    }

    public ValueDO(String attribute, String value) {
        this.attribute = attribute;
        this.value = value;
    }

    public ValueDO(String attribute, String value, DataType type) {
        this.attribute = attribute;
        this.type = type;
        this.value = value;
    }

    @XmlElement(name="attribute", namespace="http://www.interlocsolutions.com/maximo/notify", required=true)
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @XmlElement(name="value", namespace="http://www.interlocsolutions.com/maximo/notify", required=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @XmlElement(name="index", namespace="http://www.interlocsolutions.com/maximo/notify")
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @XmlElement(name="ignoreReadOnly", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isIgnoreReadOnly() {
        return this.ignoreReadOnly;
    }

    public void setIgnoreReadOnly(boolean ignoreReadOnly) {
        this.ignoreReadOnly = ignoreReadOnly;
    }

    @XmlElement(name="ignoreValidation", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isIgnoreValidation() {
        return this.ignoreValidation;
    }

    public void setIgnoreValidation(boolean ignoreValidation) {
        this.ignoreValidation = ignoreValidation;
    }

    @XmlElement(name="ignoreAction", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isIgnoreAction() {
        return this.ignoreAction;
    }

    public void setIgnoreAction(boolean ignoreAction) {
        this.ignoreAction = ignoreAction;
    }

    @XmlElement(name="type", namespace="http://www.interlocsolutions.com/maximo/notify")
    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        if (type != null) {
            this.type = type;
        }
    }

    public Date getAsDate() throws NotifyFault {
        try {
            return ISO8601Formatter.parse(this.value);
        }
        catch (ParseException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "valueParseError", args));
        }
    }

    public double getAsDecimal() throws NotifyFault {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "valueParseError", args));
        }
    }

    public long getAsNumber() throws NotifyFault {
        try {
            return Long.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "valueParseError", args));
        }
    }

    public String getAsString() {
        return this.value;
    }

    public boolean getAsBoolean() {
        if (this.value != null) {
            if ("true".equalsIgnoreCase(this.value.trim())) {
                return true;
            }
            if ("1".equalsIgnoreCase(this.value.trim())) {
                return true;
            }
            return "Y".equalsIgnoreCase(this.value);
        }
        return false;
    }

    public long getMboFlag() {
        long flag = 0L;
        if (this.ignoreReadOnly) {
            flag = 2L;
        }
        if (this.ignoreAction) {
            flag |= 8L;
        }
        if (this.ignoreValidation) {
            flag |= 1L;
        }
        return flag;
    }

    @XmlRootElement(name="attribute", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlType(namespace="http://www.interlocsolutions.com/maximo/notify")
    public static enum DataType {
        DATETIME,
        NUMBER,
        DECIMAL,
        STRING,
        BOOLEAN;

    }
}

