/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.ibm.tivoli.maximo.report.birt.admin.ReportAdminServiceRemote;
import com.ibm.tivoli.maximo.report.birt.runtime.ReportParameterData;
import com.interlocsolutions.maximo.notify.UserNotification;
import com.interlocsolutions.maximo.notify.commands.BasicCommand;
import com.interlocsolutions.maximo.notify.commands.PrintReportParam;
import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.print.PrintService;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@XmlRootElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(namespace="http://www.interlocsolutions.com/maximo/notify")
public class PrintReportCommand
extends BasicCommand {
    public static final String COMMAND_NAME = "PRINT_REPORT";
    private String reportName;
    private String appName;
    private String printerName;
    private String emailAddress;
    private ArrayList<PrintReportParam> params = new ArrayList();
    private ArrayList<String> availablePrinters = new ArrayList();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execute() throws NotifyFault {
        if (this.reportName == null) throw new NotifyFault((MXException)new MXApplicationException("informer", "reportNameRequired"));
        if (this.reportName.trim().length() <= 0) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "reportNameRequired"));
        }
        if (this.appName == null) throw new NotifyFault((MXException)new MXApplicationException("informer", "reportAppRequired"));
        if (this.appName.trim().length() <= 0) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "reportAppRequired"));
        }
        MboSetRemote reportSet = null;
        try {
            PrintService[] printers;
            if (this.printerName == null || this.printerName.length() <= 0) {
                this.printerName = MXServer.getMXServer().getProperty("informer.report.defaultprinter");
            }
            if (this.printerName == null) throw new NotifyFault((MXException)new MXApplicationException("informer", "reportPrinterRequired"));
            if (this.printerName.length() <= 0) {
                throw new NotifyFault((MXException)new MXApplicationException("informer", "reportPrinterRequired"));
            }
            PrintService selectedPrinter = null;
            for (PrintService printer : printers = PrinterJob.lookupPrintServices()) {
                if (!this.printerName.equalsIgnoreCase(printer.getName())) continue;
                selectedPrinter = printer;
                break;
            }
            if (selectedPrinter == null) {
                Object[] args = new String[]{this.printerName};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "reportPrinterNotFound", args));
            }
            reportSet = MXServer.getMXServer().getMboSet("REPORT", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("reportname = :1");
            sqlf.setObject(1, "REPORT", "REPORTNAME", this.reportName);
            reportSet.setWhere(sqlf.format());
            reportSet.reset();
            if (reportSet.isEmpty() && !this.reportName.endsWith(".rptdesign")) {
                this.reportName = this.reportName + ".rptdesign";
                sqlf.setObject(1, "REPORT", "REPORTNAME", this.reportName);
                reportSet.setWhere(sqlf.format());
                reportSet.reset();
                if (reportSet.isEmpty()) {
                    Object[] args = new String[]{this.reportName};
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "reportNotFound", args));
                }
            }
            sqlf = new SqlFormat("reportname = :1 and appname = :2");
            sqlf.setObject(1, "REPORT", "REPORTNAME", this.reportName);
            sqlf.setObject(2, "REPORT", "APPNAME", this.appName);
            reportSet.setWhere(sqlf.format());
            reportSet.reset();
            if (reportSet.isEmpty()) {
                Object[] args = new String[]{this.reportName, this.appName};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "reportAppNotFound", args));
            }
            final String userId = this.session.getUserId();
            new InformerThread("Informer Print Report Command", NotifyConstants.INFORMER_COMMAND_LOGGER){

                @Override
                protected void runInformerTask() {
                    try {
                        ReportAdminServiceRemote reportservice = (ReportAdminServiceRemote)MXServer.getMXServer().lookup("BIRTREPORT");
                        ReportParameterData para = new ReportParameterData();
                        for (PrintReportParam p : PrintReportCommand.this.params) {
                            para.addParameter(p.getName(), p.getValue());
                        }
                        byte[] reportOutput = reportservice.runReport(NotifyUtil.getLocalUserInfo(userId), PrintReportCommand.this.reportName, PrintReportCommand.this.appName, para, "report.pdf", "pdf");
                        if (PrintReportCommand.this.emailAddress != null) {
                            PrintReportCommand.this.sendReport("maximo@cenovus.com", PrintReportCommand.this.emailAddress, "Report from Maximo", "", reportOutput);
                        }
                        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(reportOutput));
                        PDDocument doc = PDDocument.load((InputStream)bis);
                        PrinterJob pj = PrinterJob.getPrinterJob();
                        PrintService[] printers = PrinterJob.lookupPrintServices();
                        PrintService selectedPrinter = null;
                        for (PrintService printer : printers) {
                            if (!PrintReportCommand.this.printerName.equalsIgnoreCase(printer.getName())) continue;
                            selectedPrinter = printer;
                            break;
                        }
                        pj.setPrintService(selectedPrinter);
                        pj.setPageable((Pageable)new PDFPageable(doc));
                        pj.print();
                        doc.close();
                    }
                    catch (Exception e) {
                        NotifyConstants.INFORMER_COMMAND_LOGGER.error((Object)("Error printing report " + PrintReportCommand.this.reportName), (Throwable)e);
                    }
                }
            }.start();
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(reportSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(reportSet);
        return null;
    }

    @Override
    public void setNotifyMbo(UserNotification mbo) throws MXException, RemoteException {
        super.setNotifyMbo(mbo);
        this.setAvailablePrinters();
    }

    @XmlElement(name="reportname", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @XmlElement(name="printername", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    @XmlElementWrapper(name="params", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="param", namespace="http://www.interlocsolutions.com/maximo/notify")
    public ArrayList<PrintReportParam> getParams() {
        return this.params;
    }

    public void setParams(ArrayList<PrintReportParam> params) {
        this.params = params;
    }

    @XmlElement(name="appname", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @XmlElementWrapper(name="printers", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="printer", namespace="http://www.interlocsolutions.com/maximo/notify")
    public ArrayList<String> getAvailablePrinters() {
        return this.availablePrinters;
    }

    private void setAvailablePrinters() {
        PrintService[] printers;
        for (PrintService printer : printers = PrinterJob.lookupPrintServices()) {
            this.availablePrinters.add(printer.getName());
        }
    }

    @XmlElement(name="emailaddress", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    private void sendReport(String sendFrom, String address, String subject, String body, byte[] pdf) throws MessagingException {
        if (NotifyConstants.INFORMER_COMMAND_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_COMMAND_LOGGER.debug((Object)("Sending mail from " + sendFrom + " to " + address + "\nsubject: " + subject + "\nbody:\n" + body));
        }
        if (address == null || address.length() == 0) {
            NotifyConstants.INFORMER_COMMAND_LOGGER.warn((Object)"A destination email address was not provided for the Maximo Mailer message, message will not be sent.");
            return;
        }
        try {
            String fromEmail;
            String password;
            MXServer server = MXServer.getMXServer();
            Properties mailProps = System.getProperties();
            SmtpAuthenticator mailAuth = null;
            String user = server.getProperty("informer.smtp.user");
            if (user == null || user.length() == 0) {
                user = server.getProperty("mxe.smtp.user");
            }
            if ((password = server.getProperty("informer.smtp.password")) == null || password.length() == 0) {
                password = server.getProperty("mxe.smtp.password");
            }
            if (user != null && user.length() > 0 && password != null && password.length() > 0) {
                mailAuth = new SmtpAuthenticator(user, password);
                mailProps.put("mail.smtp.auth", "true");
            }
            String useTLS = null;
            String tlsPortProp = null;
            String smtpHost = null;
            try {
                smtpHost = server.getProperty("informer.smtp.host");
                if (smtpHost == null) {
                    smtpHost = server.getProperty("mail.smtp.host");
                }
                useTLS = MXServer.getMXServer().getConfig().getProperty("informer.smtp.useTLS");
                tlsPortProp = MXServer.getMXServer().getConfig().getProperty("informer.smtp.tlsPort");
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.error((Object)e);
            }
            if (smtpHost != null && !smtpHost.equals("")) {
                mailProps.put("mail.smtp.host", smtpHost);
            }
            if (useTLS != null && ("true".equalsIgnoreCase(useTLS) || "1".equals(useTLS) || "Y".equalsIgnoreCase(useTLS))) {
                if (tlsPortProp != null) {
                    mailProps.put("mail.smtp.port", tlsPortProp);
                } else {
                    mailProps.put("mail.smtp.port", "587");
                }
                mailProps.put("mail.smtp.starttls.enable", "true");
                mailProps.put("mail.smtp.starttls.required", "true");
            }
            if ((fromEmail = sendFrom) == null) {
                fromEmail = server.getProperty("mxe.adminEmail");
            }
            if (fromEmail == null || fromEmail.length() == 0) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.error((Object)"The property mxe.adminEmail has not been set and therefore an email cannot be sent at this time.");
                return;
            }
            Session session = Session.getInstance((Properties)mailProps, (Authenticator)mailAuth);
            MimeMessage msg = new MimeMessage(session);
            InternetAddress fromAddr = null;
            try {
                InternetAddress[] fromAddrArray = null;
                fromAddrArray = InternetAddress.parse((String)fromEmail);
                fromAddr = fromAddrArray[0];
            }
            catch (AddressException e) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.error((Object)e);
                return;
            }
            try {
                if (fromAddr == null) {
                    fromAddr = new InternetAddress();
                }
                fromAddr.setPersonal(fromEmail);
            }
            catch (UnsupportedEncodingException e) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.error((Object)e);
                return;
            }
            msg.setFrom((Address)fromAddr);
            InternetAddress[] toAddress = InternetAddress.parse((String)address);
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            try {
                msg.setSentDate(server.getDate());
            }
            catch (Exception e) {
                msg.setSentDate(new Date());
            }
            if (subject != null && subject.contains("\n")) {
                subject = subject.replaceAll("\n", "");
            }
            msg.setSubject(subject);
            MimeMultipart mp = new MimeMultipart();
            if (body != null) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setContent((Object)body, "text/html");
                mp.addBodyPart((BodyPart)mbp);
            }
            msg.setContent((Object)body, "text/html");
            String charset = MXServer.getMXServer().getConfig().getProperty("mxe.email.charset");
            if (pdf != null) {
                ByteArrayDataSource bads = new ByteArrayDataSource(pdf, "application/pdf");
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setDataHandler(new DataHandler((DataSource)bads));
                mbp.setFileName(this.reportName);
                mp.addBodyPart((BodyPart)mbp);
            }
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
            if (NotifyConstants.INFORMER_COMMAND_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_COMMAND_LOGGER.debug((Object)"Mail successfully sent");
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_COMMAND_LOGGER.error((Object)e);
        }
    }

    public class SmtpAuthenticator
    extends Authenticator {
        PasswordAuthentication pwAuth = null;

        public SmtpAuthenticator(String user, String password) {
            this.pwAuth = new PasswordAuthentication(user, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pwAuth;
        }
    }
}

