/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.security.NotifySession;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.JAXBException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValueInfo;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;
import psdi.workflow.virtual.InitiateWorkflowMboSetRemote;

public class CommandUtilities {
    private static MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    public static void handleError(JAXBException error, String commandName, long id, NotifySession session, String notificationName, String guid) throws NotifyFault {
        CommandUtilities.logError(error, commandName, null, id, session, notificationName, guid);
    }

    public static void handleError(JAXBException error, String commandName, String xml, long id, NotifySession session, String notificationName, String guid) throws NotifyFault {
        CommandUtilities.logError(error, commandName, xml, id, session, notificationName, guid);
    }

    public static void handleError(MXException error, String commandName, long id, NotifySession session, String notificationName, String guid) throws NotifyFault {
        CommandUtilities.logError(error, commandName, null, id, session, notificationName, guid);
        NotifyFault nf = new NotifyFault(error);
        try {
            nf.setLangCode(NotifyUtil.getLocalUserInfo(session.getUserId()).getLangCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw nf;
    }

    public static void handleError(MXException error, String commandName, String xml, long id, NotifySession session, String notificationName, String guid) throws NotifyFault {
        CommandUtilities.logError(error, commandName, xml, id, session, notificationName, guid);
        NotifyFault nf = new NotifyFault(error);
        try {
            nf.setLangCode(NotifyUtil.getLocalUserInfo(session.getUserId()).getLangCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw nf;
    }

    public static void handleError(Throwable error, String commandName, long id, NotifySession session, String notificationName, String guid) throws NotifyFault {
        CommandUtilities.logError(error, commandName, null, id, session, notificationName, guid);
        NotifyFault nf = new NotifyFault(error);
        try {
            nf.setLangCode(NotifyUtil.getLocalUserInfo(session.getUserId()).getLangCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw nf;
    }

    public static void handleError(Throwable error, String commandName, String xml, long id, NotifySession session, String notificationName, String guid) throws NotifyFault {
        CommandUtilities.logError(error, commandName, xml, id, session, notificationName, guid);
        NotifyFault nf = new NotifyFault(error);
        try {
            nf.setLangCode(NotifyUtil.getLocalUserInfo(session.getUserId()).getLangCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw nf;
    }

    public static void logError(NotifyFault error, String commandName, String xml, long id, NotifySession session, String notificationName, String guid) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        CommandUtilities.logMessage(error.getFaultString(), sw.toString(), commandName, xml, id, session, notificationName, guid);
    }

    public static void logError(Throwable error, String commandName, String xml, long id, NotifySession session, String notificationName, String guid) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ArrayList<Throwable> causes = new ArrayList<Throwable>(10);
        for (Throwable cause = error; cause != null && !causes.contains(cause); cause = cause.getCause()) {
            if (cause != error) {
                pw.append('\n');
            }
            causes.add(cause);
            cause.printStackTrace(pw);
        }
        CommandUtilities.logMessage(error.getLocalizedMessage(), sw.toString(), commandName, xml, id, session, notificationName, guid);
    }

    public static void logMessage(String subject, String detail, String commandName, long id, NotifySession session, String notificationName, String guid) {
        CommandUtilities.logMessage(subject, detail, commandName, null, id, session, notificationName, guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMessage(String subject, String detail, String commandName, String xml, long id, NotifySession session, String notificationName, String guid) {
        MboSetRemote notifySet;
        MboSetRemote logSet;
        block21: {
            if (session == null) {
                logger.error((Object)("An error occurred while attempting to log a command failure for the command; " + commandName + "The command session has not been set and there user diagnostic information cannot be provided.\n" + subject + "\n" + detail));
                return;
            }
            logSet = null;
            notifySet = null;
            try {
                String createSR;
                String guidRemovedXML;
                Date errorDate = MXServer.getMXServer().getDate();
                logSet = MXServer.getMXServer().getMboSet("ISNOTIFYCOMMANDLOG", MXServer.getMXServer().getSystemUserInfo());
                if (guid == null) {
                    guid = "";
                    guidRemovedXML = xml;
                } else {
                    guidRemovedXML = xml.replaceFirst("<([^>]*?:?)guid>([^<]*)</.*:?guid>", "");
                }
                SqlFormat sqlf = new SqlFormat("guid = :1");
                sqlf.setObject(1, "ISNOTIFYCOMMANDLOG", "GUID", guid);
                logSet.setWhere(sqlf.format());
                MboRemote log = null;
                if (logSet.isEmpty()) {
                    log = logSet.add();
                    log.setValue("ORIGERRORDATE", errorDate);
                } else {
                    log = logSet.getMbo(0);
                }
                log.setValue("DEVICENAME", session.getDeviceName());
                log.setValue("DEVICEOS", session.getDeviceOS());
                log.setValue("DEVICESERIALNUM", session.getDeviceSerialNumber());
                CommandUtilities.setValueTrunc(log, "SUBJECT", subject);
                log.setValue("DETAIL", detail);
                log.setValue("XML", CommandUtilities.formatXML(guidRemovedXML), 2L);
                log.setValue("USERID", session.getUserId());
                log.setValue("SESSIONKEY", session.getSessionKey());
                log.setValue("COMMANDNAME", commandName);
                log.setValue("ERRORDATE", errorDate);
                log.setValue("USERNOTIFICATIONID", id);
                log.setValue("ACTIVE", true);
                if (guid != null) {
                    log.setValue("GUID", guid);
                }
                log.getMboSet("USERNOTIFICATION").reset();
                long notifyId = -1L;
                if (!log.getMboSet("USERNOTIFICATION").isEmpty()) {
                    notifyId = log.getMboSet("USERNOTIFICATION").getMbo(0).getLong("NOTIFYID");
                } else {
                    notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
                    sqlf = new SqlFormat("notifynum = :1");
                    sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notificationName);
                    notifySet.setWhere(sqlf.format());
                    if (!notifySet.isEmpty()) {
                        notifyId = notifySet.getMbo(0).getUniqueIDValue();
                    }
                }
                if (notifyId > 0L) {
                    log.setValue("NOTIFYID", notifyId);
                }
                logSet.save();
                if (!guid.isEmpty()) {
                    CommandUtilities.finalizeCommandHistory(guid, notifyId, null, ExecutionStatus.FAILED, xml);
                }
                if (!"1".equals(createSR = MXServer.getMXServer().getProperty("informer.onerror.createsr")) && !"true".equalsIgnoreCase(createSR)) break block21;
                long logId = log.getUniqueIDValue();
                logSet.reset();
                log = logSet.getMboForUniqueId(logId);
                String type = MXServer.getMXServer().getProperty("informer.createsrtype") != null ? MXServer.getMXServer().getProperty("informer.createsrtype") : "SR";
                MboSetRemote incidentSet = log.getMboSet("$sr", type, "1=1");
                MboRemote incident = incidentSet.add();
                int length = incidentSet.getMboSetInfo().getMboValueInfo("DESCRIPTION").getLength();
                subject = "Error executing command " + log.getString("COMMANDNAME") + " on device " + log.getString("DEVICENAME") + "; Serial Number " + log.getString("DEVICESERIALNUM");
                if (subject.length() > length) {
                    subject = subject.substring(0, length);
                }
                incident.setValue("DESCRIPTION", subject);
                incident.setValue("DESCRIPTION_LONGDESCRIPTION", "Error:\n" + log.getString("DETAIL") + "\n\nXML:\n" + log.getString("XML"));
                incident.setValue("AFFECTEDPERSON", log.getString("PERSON.PERSONID"));
                incident.setValue("SOURCE", "INFORMER");
                incident.setValue("REPORTEDBYID", incident.getUserInfo().getPersonId());
                log.setValue("TICKETID", incident.getString("TICKETID"));
                log.delete();
                logSet.save();
                String wfProcName = MXServer.getMXServer().getProperty("informer.onerror.wfprocess");
                if (wfProcName == null || wfProcName.trim().length() <= 0) break block21;
                try {
                    InitiateWorkflowMboSetRemote iwSet = (InitiateWorkflowMboSetRemote)incident.getMboSet("INITIATEWORKFLOW");
                    iwSet.setControlee(log);
                    iwSet.setup();
                    MboRemote paramMbo = iwSet.setup();
                    paramMbo.setValue("PROCESSNAME", wfProcName);
                    iwSet.execute();
                }
                catch (Throwable t) {
                    logger.error((Object)("An error occurred while attempting to initiate the Service Request workflow process " + wfProcName));
                }
            }
            catch (Throwable e) {
                try {
                    try {
                        logger.error((Object)String.format("An error occurred while attempting to log the error; Details about the execution error will not be retained in the Command log, and are printed here instead.\nUser: %s\nSession Key: %s\nDevice: %s\nDevice OS: %s\nDevice Serial Number: %s\nOriginal Error Subject: %s\nOriginal Error Detail: %s\nCause for this error-reporting error follows.", session.getUserId(), session.getSessionKey(), session.getDeviceName(), session.getDeviceOS(), session.getDeviceSerialNumber(), subject, detail), e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    CommandUtilities.close(logSet);
                    CommandUtilities.close(notifySet);
                }
            }
        }
        CommandUtilities.close(logSet);
        CommandUtilities.close(notifySet);
    }

    public static void close(MboSetRemote set) {
        NotifyUtil.closeAndCleanup(set);
    }

    private static String formatXML(String input) {
        try {
            StringWriter sw = new StringWriter();
            SAXBuilder builder = new SAXBuilder();
            XMLOutputter out = new XMLOutputter();
            out.setFormat(Format.getPrettyFormat());
            out.output(builder.build((Reader)new StringReader(input)), (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"Error formatting command XML;", (Throwable)e);
            return input;
        }
    }

    public static boolean setValueTrunc(MboRemote mbo, String name, String value) throws RemoteException, MXException {
        MboValueInfo valueInfo;
        boolean truncated = false;
        if (value != null && (valueInfo = MboUtilKt.getNaryMboValueInfo(mbo.getName(), name)) != null) {
            int subjectLen = valueInfo.getLength();
            if (value.length() > subjectLen) {
                value = value.substring(0, subjectLen - 3) + "...";
                truncated = true;
            }
        }
        mbo.setValue(name, value);
        return truncated;
    }

    public static void finalizeCommandHistory(String guid, long notifyId, String result, ExecutionStatus status, String xml) throws RemoteException, MXException {
        if (guid != null) {
            MXServer mxServer = MXServer.getMXServer();
            SqlFormat sql = new SqlFormat("guid = :1");
            sql.setObject(1, "ISCOMMANDHISTORY", "GUID", guid);
            MboExtensionsKt.useNewMboSet("ISCOMMANDHISTORY", sql.format(), mxServer.getSystemUserInfo(), false, commandHistorySet -> {
                try {
                    MboRemote commandHistory = commandHistorySet.getMbo(0);
                    commandHistory.setValue("INEXECUTION", status.getValue());
                    commandHistory.setValue("EXECUTIONDATE", mxServer.getDate(), 2L);
                    if (CommandUtilities.isXmlBeStored()) {
                        commandHistory.setValue("XML", xml);
                    }
                    if (notifyId > 0L) {
                        commandHistory.setValue("NOTIFYID", notifyId);
                    }
                    if (result != null) {
                        commandHistory.setValue("RESPONSE", result);
                    }
                    commandHistorySet.save();
                }
                catch (RemoteException | MXException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
    }

    public static boolean isXmlBeStored() {
        InformerProp xmlStoreProp = PropUtil.INSTANCE.getProp("informer.commandHistory.xml.store");
        if (xmlStoreProp != null) {
            return xmlStoreProp.asBoolean(false);
        }
        return false;
    }

    public static boolean commandWasSuccessful(String guid, final Boolean throwNotifyFaultInError) throws MXException, RemoteException, SQLException {
        UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
        SqlFormat sqlfLog = new SqlFormat("GUID = :1 and ACTIVE = :2");
        sqlfLog.setObject(1, "ISNOTIFYCOMMANDLOG", "GUID", guid);
        sqlfLog.setBoolean(2, true);
        int logRecordVisited = MboUtil.visitMbosReadOnly(userInfo, "ISNOTIFYCOMMANDLOG", sqlfLog.format(), new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote commandLog) throws MXException, RemoteException {
                if (throwNotifyFaultInError.booleanValue()) {
                    throw new NotifyFault(commandLog.getString("SUBJECT"));
                }
            }
        });
        if (logRecordVisited == 0) {
            SqlFormat sqlfHistory = new SqlFormat("GUID = :1 and INEXECUTION = :2");
            sqlfHistory.setObject(1, "ISCOMMANDHISTORY", "GUID", guid);
            sqlfHistory.setInt(2, ExecutionStatus.SUCCEEDED.value);
            return MboUtil.exists(userInfo, "ISCOMMANDHISTORY", sqlfHistory.format());
        }
        return false;
    }

    public static enum ExecutionStatus {
        SUCCEEDED(0),
        RUNNING(1),
        FAILED(2);

        private final int value;

        private ExecutionStatus(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

