/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.NotifyCommandRemote;
import com.interlocsolutions.maximo.notify.NotifyService;
import com.interlocsolutions.maximo.notify.NotifySesssionSetRemote;
import com.interlocsolutions.maximo.notify.commands.BasicCommand;
import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.SessionManager;
import com.interlocsolutions.maximo.notify.util.InformerCommandSerializer;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.input.ReaderInputStream;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class CommandResubmissionUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resubmitCommandInError(MboRemote error) throws MXException, RemoteException {
        try {
            if (error.isNull("GUID")) {
                throw new MXApplicationException("informer", "missingGUID");
            }
            MXServer mxServer = MXServer.getMXServer();
            String userId = error.getString("USERID");
            SessionInfo sessionInfo = new SessionInfo(userId, error.getString("DEVICENAME"), error.getString("DEVICESERIALNUM"), error.getString("DEVICEOS"), true, error.getString("NOTIFY.NOTIFYNUM"), NotifyUtil.getLocalUserInfo(userId).getDefaultLang(), NotifyUtil.getLocalUserInfo(userId).getLoginID(), false);
            NotifySesssionSetRemote sessionSet = (NotifySesssionSetRemote)mxServer.getMboSet("ISSESSION", mxServer.getSystemUserInfo());
            try {
                MboRemote sessionMbo = sessionSet.addSession(sessionInfo);
                try {
                    NotificationSession sessionHandle = new NotificationSession();
                    sessionHandle.setAuthenticated(true);
                    sessionHandle.setSessionId(sessionInfo.getSessionKey());
                    sessionHandle.setExpires(sessionMbo.getDate("EXPIRES"));
                    MboSetRemote commands = error.getMboSet("$isnotifycommand", "ISNOTIFYCOMMAND", "name = :commandname");
                    NotifyCommandRemote cmd = (NotifyCommandRemote)commands.getMbo(0);
                    if (cmd == null) {
                        String message2 = "No such Command found: " + error.getString("COMMANDNAME");
                        Object[] args = new String[]{message2};
                        throw new MXApplicationException("informer", "resubmitError", args);
                    }
                    InformerCommandSerializer serializer2 = InformerCommandSerializer.getInstance();
                    ReaderInputStream is = new ReaderInputStream((Reader)new StringReader(error.getString("XML")), "UTF-8");
                    Command c = serializer2.deserialize(cmd, (InputStream)is);
                    ((BasicCommand)c).setGuid(error.getString("GUID"));
                    String reconstitutedXML = serializer2.serialize(cmd, c, InformerObjectSerializer.MARSHAL_BASIC);
                    NotifyService service = new NotifyService(mxServer);
                    service.internalExecuteCommand(error.getLong("USERNOTIFICATIONID"), sessionHandle.getSessionId(), error.getString("NOTIFY.NOTIFYNUM"), error.getString("COMMANDNAME"), reconstitutedXML, false, false, mxServer.getUserInfo(userId));
                    error.setValue("ACTIVE", false);
                    MboSetRemote pushDeviceSet = error.getMboSet("DEVICE.PUSHDEVICE");
                    MboRemote pushDevice = pushDeviceSet.moveFirst();
                    while (pushDevice != null) {
                        if (pushDevice.getString("PUSHREG.NOTIFY.NOTIFYNUM").equalsIgnoreCase(error.getString("NOTIFY.NOTIFYNUM"))) {
                            PushQueueManager.getInstance().addQueuedItem(pushDevice.getUniqueIDValue(), PushQueueManager.PushType.ERROR_RESOLVED);
                        }
                        pushDevice = pushDeviceSet.moveNext();
                    }
                }
                finally {
                    SessionManager.removeSession(sessionInfo.getSessionKey());
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(sessionSet);
            }
        }
        catch (NotifyFault e) {
            Object[] args = new String[]{""};
            throw new MXApplicationException("informer", "resubmitError", args, (Throwable)((Object)e));
        }
        catch (JAXBException e) {
            Object[] args = new String[]{""};
            throw new MXApplicationException("informer", "resubmitError", args, (Throwable)e);
        }
        catch (XMLStreamException e) {
            Object[] args = new String[]{""};
            throw new MXApplicationException("informer", "resubmitError", args, (Throwable)e);
        }
        catch (RuntimeException e) {
            Object[] args = new String[]{""};
            throw new MXApplicationException("informer", "resubmitError", args, (Throwable)e);
        }
    }
}

