/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.commands.SimplifiedCommand;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.AttachDocumentCommandResponse;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.app.doclink.DocinfoSetRemote;
import psdi.app.doclink.DoclinksSetRemote;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.util.MXException;

@XmlRootElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
public class AttachDocumentCommand
extends SimplifiedCommand {
    private String objectName = null;
    private long recordId = -1L;
    private long documentId = -1L;
    private boolean addFolderToType = true;
    private String doctype = null;
    private String app = null;
    private String clientid = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected String execute(@NotNull UserInfo userInfo) throws NotifyFault {
        String string;
        if (this.recordId <= 0L) {
            throw new NotifyFault("The record Id for the object must be provided.");
        }
        if (this.documentId <= 0L) {
            throw new NotifyFault("The document Id for the document to attach must be provided.");
        }
        if (this.objectName == null || this.objectName.trim().length() < 1) {
            throw new NotifyFault("The object name must be provided.");
        }
        MboSetRemote objSet = null;
        MboSetRemote docInfoSet = null;
        MboSetRemote appdoctypeSet = null;
        MboSetRemote maxappSet = null;
        try {
            objSet = this.getNewReadWriteMboSet(this.objectName);
            MboRemote obj = objSet.getMboForUniqueId(this.recordId);
            if (obj == null) {
                throw new NotifyFault("The " + this.objectName + " record for Id " + this.recordId + " was not found.");
            }
            docInfoSet = this.getNewReadWriteMboSet("DOCINFO");
            SqlFormat sqlf = new SqlFormat(docInfoSet.getMboSetInfo().getUniqueIDName() + " = :1");
            sqlf.setLong(1, this.documentId);
            docInfoSet.setWhere(sqlf.format());
            if (docInfoSet.isEmpty()) {
                throw new NotifyFault("The document for document Id " + this.documentId + " was not found.");
            }
            if (this.addFolderToType) {
                if (this.app == null) {
                    this.app = objSet.getApp();
                    if (this.app == null) {
                        maxappSet = this.getNewReadOnlyMboSet("MAXAPPS", false);
                        sqlf = new SqlFormat("maintbname = :1");
                        sqlf.setObject(1, "MAXAPPS", "MAINTBNAME", this.objectName);
                        maxappSet.setWhere(sqlf.format());
                        maxappSet.reset();
                        if (maxappSet.isEmpty()) {
                            throw new NotifyFault("An application could not be found and was not provided for " + objSet.getName());
                        }
                        this.app = maxappSet.getMbo(0).getString("APP");
                    }
                }
                appdoctypeSet = this.getNewReadWriteMboSet("APPDOCTYPE");
                sqlf = new SqlFormat("app=:1 and doctype =:2");
                sqlf.setObject(1, "APPDOCTYPE", "APP", this.app);
                sqlf.setObject(2, "APPDOCTYPE", "DOCTYPE", this.doctype);
                appdoctypeSet.setWhere(sqlf.format());
                appdoctypeSet.reset();
                if (appdoctypeSet.isEmpty()) {
                    MboRemote appdoctype = appdoctypeSet.add();
                    appdoctype.setValue("APP", this.app);
                    appdoctype.setValue("DOCTYPE", this.doctype);
                }
                appdoctypeSet.save();
            }
            DoclinksSetRemote docLinksSet = (DoclinksSetRemote)obj.getMboSet("DOCLINKS");
            docInfoSet.selectAll();
            docLinksSet.addDoclinksForSelectedDocinfo((DocinfoSetRemote)docInfoSet, this.app, this.doctype);
            docLinksSet.save();
            docLinksSet.setWhere("docinfoid = " + this.documentId);
            docLinksSet.reset();
            MboRemote doclink = docLinksSet.getMbo(0);
            doclink.getThisMboSet().save();
            AttachDocumentCommandResponse resp = new AttachDocumentCommandResponse(this.clientid, doclink.getUniqueIDValue(), doclink.getString("WEBURL"), doclink.isNull("CHANGEDATE") ? new Date() : doclink.getDate("CHANGEDATE"), doclink.getLong("DOCINFO.DOCINFOID"), doclink.getString("DOCINFO.DOCUMENT"));
            string = InformerObjectSerializer.getInstance().serialize(resp, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (MXException e) {
            try {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
                throw new NotifyFault(e);
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault(e2);
                }
                catch (JAXBException e3) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e3);
                    throw new NotifyFault((Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(objSet);
                NotifyUtil.closeAndCleanup(docInfoSet);
                NotifyUtil.closeAndCleanup(appdoctypeSet);
                NotifyUtil.closeAndCleanup(maxappSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(objSet);
        NotifyUtil.closeAndCleanup(docInfoSet);
        NotifyUtil.closeAndCleanup(appdoctypeSet);
        NotifyUtil.closeAndCleanup(maxappSet);
        return string;
    }

    @Override
    public String getName() {
        return "ATTACHDOCUMENT";
    }

    private void setName(String name) {
    }

    @XmlElement(name="objectName", namespace="http://www.interlocsolutions.com/maximo/notify", required=true)
    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @XmlElement(name="recordId", namespace="http://www.interlocsolutions.com/maximo/notify", required=true)
    public long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    @XmlElement(name="documentId", namespace="http://www.interlocsolutions.com/maximo/notify", required=true)
    public long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(long documentId) {
        this.documentId = documentId;
    }

    @XmlElement(name="addFolderToType", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isAddFolderToType() {
        return this.addFolderToType;
    }

    public void setAddFolderToType(boolean addFolderToType) {
        this.addFolderToType = addFolderToType;
    }

    @XmlElement(name="doctype", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    @XmlElement(name="app", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    @Override
    public String getVersion() {
        return "2.0.3";
    }

    @XmlElement(name="clientid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getClientid() {
        return this.clientid;
    }

    public void setClientid(String clientid) {
        this.clientid = clientid;
    }
}

