/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.classloader;

import com.interlocsolutions.maximo.notify.classloader.ChangeableClassAccessor;
import com.interlocsolutions.maximo.notify.filter.FilterConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.util.InformerCommandSerializer;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import psdi.mbo.MaximoCache;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.MXSystemException;
import psdi.util.logging.MXLogger;

class InformerClassLoaderManager
implements MaximoCache {
    private static final MXLogger LOGGER = NotifyConstants.INFORMER_CLASSES_LOGGER;
    private volatile ClassLoader loader;
    private volatile List<String> classNames;
    private static final String CLASS_EXTENSION = ".class";

    InformerClassLoaderManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader getLoader() {
        Object object = ChangeableClassAccessor.CLASS_LOADER_LOCK;
        synchronized (object) {
            return this.loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getClassNames() {
        Object object = ChangeableClassAccessor.CLASS_LOADER_LOCK;
        synchronized (object) {
            return this.classNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewClassLoader() throws MXException {
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            MXServer mxServer = MXServer.getMXServer();
            MboSetRemote jarSet = mxServer.getMboSet("ISNOTIFYJARS", mxServer.getSystemUserInfo());
            try {
                jarSet.setWhere("active = :yes");
                jarSet.setOrderBy("sequence");
                jarSet.setFlag(39L, true);
                MboRemote jarMbo = jarSet.moveFirst();
                while (jarMbo != null) {
                    try {
                        URL jarFile = this.extractJar(jarMbo);
                        jarFiles.add(jarFile);
                        classNames.addAll(this.extractClassNames(jarFile));
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Problem encountered adding " + jarMbo.getString("NAME") + " to the classpath."), (Throwable)e);
                    }
                    jarMbo = jarSet.moveNext();
                }
            }
            finally {
                try {
                    jarSet.cleanup();
                    jarSet.clear();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Failed to clean up ISNOTIFYCLASSES MboSet", (Throwable)e);
                }
            }
        }
        catch (RemoteException re) {
            throw new MXSystemException("system", "major", (Throwable)re);
        }
        Object object = ChangeableClassAccessor.CLASS_LOADER_LOCK;
        synchronized (object) {
            this.loader = new URLClassLoader(jarFiles.toArray(new URL[0]), this.getClass().getClassLoader());
            this.classNames = classNames;
        }
    }

    private URL extractJar(MboRemote jarMbo) throws IOException, MXException {
        File f = File.createTempFile("informer-", ".jar");
        f.deleteOnExit();
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
            fos.write(jarMbo.getBytes("DATA"));
        }
        return f.toURI().toURL();
    }

    private List<String> extractClassNames(URL jarFile) throws IOException {
        ArrayList<String> rc2 = new ArrayList<String>();
        try (JarInputStream jis = new JarInputStream(new BufferedInputStream(jarFile.openStream()));){
            JarEntry jarEntry = jis.getNextJarEntry();
            while (jarEntry != null) {
                if (!jarEntry.isDirectory() && jarEntry.getName().endsWith(CLASS_EXTENSION)) {
                    String name = jarEntry.getName();
                    String className = name.substring(0, name.length() - CLASS_EXTENSION.length()).replace('/', '.');
                    rc2.add(className);
                }
                jarEntry = jis.getNextJarEntry();
            }
        }
        return rc2;
    }

    public void init() throws MXException {
        this.createNewClassLoader();
    }

    public void reload() throws MXException {
        try {
            if (MXServer.getMXServer().getMaximoDD().getMboSetInfo("ISNOTIFYJARS") != null) {
                this.createNewClassLoader();
            }
            JobConfig.getInstance().invalidate();
            FilterConfig.getInstance().invalidate();
            InformerCommandSerializer.getInstance().clearContexts();
        }
        catch (RemoteException e) {
            throw new MXApplicationException("system", "remoteexception", (Throwable)e);
        }
    }

    public void reload(String s) throws MXException {
        this.reload();
    }

    public String getName() {
        return "NOTIFYCLASSES";
    }
}

