/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class UserNotificationRefresh
extends InformerThread {
    long notifyUserId;

    public UserNotificationRefresh(long notifyUserId) {
        super(UserNotificationRefresh.class.getSimpleName() + " User " + notifyUserId, NotifyConstants.INFORMER_LOGGER);
        this.notifyUserId = notifyUserId;
    }

    @Override
    protected void runInformerTask() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Queueing refresh for notify user Id " + this.notifyUserId));
            }
            MboSetRemote notifyUserSet = null;
            try {
                notifyUserSet = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
                MboRemote notifyUserMbo = notifyUserSet.getMboForUniqueId(this.notifyUserId);
                if (notifyUserMbo != null) {
                    ((NotifyUserRemote)notifyUserMbo).markForRefresh();
                }
                notifyUserSet.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(notifyUserSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(notifyUserSet);
        }
        catch (RemoteException e) {
            this.logger.error((Object)e);
        }
        catch (MXException e) {
            this.logger.error((Object)e);
        }
    }
}

