/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.DeleteTransactableOwner;
import com.interlocsolutions.maximo.notify.UserNotificationDeleteTransactable;
import com.interlocsolutions.maximo.notify.UserNotificationRemote;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.queue.DatabaseFunctionsKt;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecNotificationEval;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValueInfo;
import psdi.security.ConnectionKey;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class UserNotification
extends Mbo
implements UserNotificationRemote,
DeleteTransactableOwner<UserNotificationDeleteTransactable> {
    public static final long serialVersionUID = 2180949490149213718L;
    private UserNotificationDeleteTransactable deleteTransactable;
    private static MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    private final NotificationJobManager notificationJobManager = NotificationJobManager.INSTANCE;

    public UserNotification(MboSet ms) throws RemoteException {
        super(ms);
    }

    @Override
    public MboRemote getMainObject() throws RemoteException, MXException {
        MboSetRemote objectSet = this.getMboSet("$object", this.getString("OBJECTNAME"));
        return objectSet.getMboForUniqueId(this.getLong("RECORDID"));
    }

    public void delete(long accessModifier) throws MXException, RemoteException {
        super.delete(accessModifier);
        if (this.shouldDeleteForReal()) {
            DeleteTransactable.onDelete(this);
            MboSetRemote fileFragmentSet = this.getMboSet("$filefragment", "ISFILEFRAGMENT", "usernotificationid = :usernotificationid");
            fileFragmentSet.deleteAll();
        }
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        if (this.shouldDeleteForReal()) {
            DeleteTransactable.onUndelete(this);
            MboSetRemote fileFragmentSet = this.getMboSet("$filefragment", "ISFILEFRAGMENT", "usernotificationid = :usernotificationid");
            fileFragmentSet.undeleteAll();
        }
    }

    public void save() throws RemoteException, MXException {
        String title;
        if (this.toBeDeleted()) {
            if (!this.shouldDeleteForReal()) {
                this.undelete();
                this.setValue("ACTIVE", false, 2L);
                this.updateSequence();
            }
        } else if (this.toBeUpdated()) {
            String title2;
            boolean updateDateOnly = false;
            if (this.getMboValue("DATEVIEWED").isModified()) {
                updateDateOnly = true;
            }
            MboSetInfo msi = this.getThisMboSet().getMboSetInfo();
            Enumeration msis = msi.getMboValuesInfo();
            while (msis.hasMoreElements()) {
                MboValueInfo mvi = (MboValueInfo)msis.nextElement();
                if (mvi.getName().equalsIgnoreCase("DATEVIEWED") || !this.getMboValue(mvi.getName()).isModified() || !mvi.isPersistent()) continue;
                updateDateOnly = false;
                break;
            }
            if (!updateDateOnly) {
                this.updateSequence();
            }
            if ((title2 = this.getTitle()) != null) {
                this.setValue("PERSISTENTTITLE", title2);
            }
        } else if (this.toBeAdded() && (title = this.getTitle()) != null) {
            this.setValue("PERSISTENTTITLE", title);
        }
        super.save();
    }

    private boolean shouldDeleteForReal() throws MXException, RemoteException {
        return this.getBoolean("DIRECTDELETE") || this.getOwner() != null && this.getOwner().isBasedOn("ISNOTIFYUSER") && this.getOwner().toBeDeleted();
    }

    public void add() throws RemoteException, MXException {
        super.add();
        this.updateSequence();
    }

    private void updateSequence() throws RemoteException, MXException {
        ConnectionKey key = new ConnectionKey(this.getUserInfo());
        Connection c = MXServer.getMXServer().getDBManager().getConnection(key);
        try {
            this.setValue("SEQUENCE", DatabaseFunctionsKt.nextSequenceValue(c, "ISUSERNOTIFICATIONSEQ"), 2L);
        }
        finally {
            if (key != null) {
                MXServer.getMXServer().getDBManager().freeConnection(key);
            }
        }
    }

    public void init() throws MXException {
        super.init();
        if (!this.toBeAdded()) {
            String[] readonlyFields = new String[]{"LASTUPDATE", "OBJECTNAME", "APP", "USERID", "TITLE"};
            this.setFieldFlag(readonlyFields, 7L, true);
        }
    }

    @Override
    public void markForRefresh(long refreshQueueId) throws RemoteException, MXException {
        long recordId;
        long notifyId = this.getLong("NOTIFYID");
        Long newJobId = this.notificationJobManager.enqueue(new JobSpecNotificationEval(notifyId, recordId = this.getLong("RECORDID")));
        if (newJobId != null) {
            InformerTracking.notificationAdd(this, newJobId, refreshQueueId, notifyId, recordId);
        }
    }

    @Override
    public void sendPushMessage() throws RemoteException, MXException {
        this.sendPushMessage(-1L);
    }

    @Override
    public void sendPushMessage(long queueid) throws RemoteException, MXException {
        if (this.isNull("NOTIFY.NOTIFYNUM")) {
            return;
        }
        String notifyNum = this.getString("NOTIFY.NOTIFYNUM");
        MboSetIterator pushDeviceItr = new MboSetIterator(this.getMboSet("PUSHDEVICE"));
        MboRemote device = pushDeviceItr.moveFirst();
        while (device != null) {
            PushQueueManager.getInstance().addQueuedItemForNotification(device.getUniqueIDValue(), notifyNum);
            device = pushDeviceItr.moveNext();
        }
    }

    private String getTitle() throws MXException {
        return NotifyUtil.getTitle(this);
    }

    @Override
    public void setDeleteTransactable(@Nullable UserNotificationDeleteTransactable transactable) {
        this.deleteTransactable = transactable;
    }

    @Override
    @Nullable
    public UserNotificationDeleteTransactable getDeleteTransactable() {
        return this.deleteTransactable;
    }

    @Override
    @NotNull
    public UserNotificationDeleteTransactable newDeleteTransactable() {
        return new UserNotificationDeleteTransactable(this);
    }
}

