/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.NotifyResourceRemote;
import com.interlocsolutions.maximo.notify.NotifySessionRemote;
import com.interlocsolutions.maximo.notify.NotifySessionResourceRemote;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.ProfileResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXException;

public class NotifySession
extends Mbo
implements NotifySessionRemote {
    private static final long serialVersionUID = 649485473400684894L;

    public NotifySession(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void init() throws MXException {
        super.init();
        this.setFieldFlag("PROFILEDISPLAY", 7L, true);
    }

    protected void save() throws MXException, RemoteException {
        this.setValue("NODE", MXServer.getMXServer().getName());
        this.setValue("HOSTNAME", MXServer.getMXServer().getRegistryHostName());
        super.save();
    }

    public void delete(long flag) throws RemoteException, MXException {
        super.delete(flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("SESSIONCATALOG"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("SESSIONRESOURCE"), flag);
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        this.getMboSet("SESSIONCATALOG").undeleteAll();
        this.getMboSet("SESSIONRESOURCE").undeleteAll();
    }

    @Override
    public void removeCatalog(String notification, String catalog) throws RemoteException, MXException {
        SqlFormat sqlf = new SqlFormat("sessionid = :1 and notifynum = :2 and catalog = :3");
        sqlf.setLong(1, this.getUniqueIDValue());
        sqlf.setObject(2, "ISSESSIONCATALOG", "NOTIFYNUM", notification);
        sqlf.setObject(3, "ISSESSIONCATALOG", "CATALOG", catalog);
        MboSetRemote catalogSet = this.getMboSet("$issessioncatatlog", "ISSESSIONCATALOG", sqlf.format());
        catalogSet.reset();
        catalogSet.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProfileResource getNextCatalogDBFragment(String notification, String catalog, String langCode) throws MXException, RemoteException {
        ProfileResource profileResource;
        MboSetRemote sessionResourceSet;
        block9: {
            MboSetRemote resourceSet;
            NotifySessionResourceRemote resource;
            block10: {
                sessionResourceSet = null;
                sessionResourceSet = MXServer.getMXServer().getMboSet("ISSESSIONRESOURCE", MXServer.getMXServer().getSystemUserInfo());
                SqlFormat sqlf = new SqlFormat("sessionid = :1 and notifyresourceid in (select notifyresourceid from isnotifyresource where notifyid = (select notifyid from isnotify where notifynum = :2) and name = :3 and resourcetype = :4 and langcode = :5)");
                sqlf.setLong(1, this.getUniqueIDValue());
                sqlf.setObject(2, "ISNOTIFY", "NOTIFYNUM", notification);
                sqlf.setObject(3, "ISNOTIFYRESOURCE", "NAME", catalog);
                sqlf.setObject(4, "ISNOTIFYRESOURCE", "RESOURCETYPE", "CATALOG");
                sqlf.setObject(5, "ISNOTIFYRESOURCE", "LANGCODE", langCode);
                sessionResourceSet.setWhere(sqlf.format());
                if (sessionResourceSet.isEmpty()) break block9;
                resource = (NotifySessionResourceRemote)sessionResourceSet.getMbo(0);
                resourceSet = resource.getMboSet("NOTIFYRESOURCE");
                if (!resourceSet.isEmpty()) break block10;
                ProfileResource profileResource2 = null;
                NotifyUtil.closeAndCleanup(sessionResourceSet);
                return profileResource2;
            }
            NotifyResourceRemote r = (NotifyResourceRemote)resourceSet.getMbo(0);
            String data = r.getString("DATA");
            byte[] bytes = Base64.decodeBase64(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            bais.skip(resource.getOffset());
            int length = 262144;
            byte[] result = new byte[length];
            int res = bais.read(result);
            if (res < length) {
                byte[] tmp = new byte[res];
                System.arraycopy(result, 0, tmp, 0, res);
                result = tmp;
            }
            ProfileResource pr = new ProfileResource((long)bytes.length, resource.getOffset(), (long)result.length, result);
            long newOffSet = resource.getOffset() + (long)result.length;
            if (newOffSet == (long)bytes.length) {
                r.removeFromSession(this.getString("SESSIONKEY"));
            } else {
                resource.setOffset(newOffSet);
                sessionResourceSet.save();
            }
            ProfileResource profileResource3 = pr;
            NotifyUtil.closeAndCleanup(sessionResourceSet);
            return profileResource3;
        }
        try {
            profileResource = null;
        }
        catch (IOException e) {
            try {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(sessionResourceSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(sessionResourceSet);
            return null;
        }
        NotifyUtil.closeAndCleanup(sessionResourceSet);
        return profileResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateCatalogDB(String notification, String catalog, String langCode) throws MXException, RemoteException {
        MboSetRemote resourceSet;
        block2: {
            boolean bl;
            resourceSet = null;
            try {
                resourceSet = MXServer.getMXServer().getMboSet("ISNOTIFYRESOURCE", MXServer.getMXServer().getSystemUserInfo());
                SqlFormat sqlf = new SqlFormat("notifyid = (select notifyid from isnotify where notifynum = :1) and name = :2 and resourcetype = :3 and langcode = :4");
                sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notification);
                sqlf.setObject(2, "ISNOTIFYRESOURCE", "NAME", catalog);
                sqlf.setObject(3, "ISNOTIFYRESOURCE", "RESOURCETYPE", "CATALOG");
                sqlf.setObject(4, "ISNOTIFYRESOURCE", "LANGCODE", langCode);
                resourceSet.setWhere(sqlf.format());
                resourceSet.setOrderBy("version desc");
                if (resourceSet.isEmpty()) break block2;
                NotifyResourceRemote resource = (NotifyResourceRemote)resourceSet.getMbo(0);
                resource.addToSession(this.getString("SESSIONKEY"));
                bl = true;
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(resourceSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(resourceSet);
            return bl;
        }
        NotifyUtil.closeAndCleanup(resourceSet);
        return false;
    }
}

