/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifyDeviceAssetListener;
import com.interlocsolutions.maximo.notify.NotifyRefreshQueueListener;
import com.interlocsolutions.maximo.notify.NotifyServiceCompanion;
import com.interlocsolutions.maximo.notify.SecurityChangeListener;
import com.interlocsolutions.maximo.notify.SecurityUserChangeListener;
import com.interlocsolutions.maximo.notify.StartupMonitor;
import com.interlocsolutions.maximo.notify.commands.CommandRegistrar;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.push.PushJobConfig;
import com.interlocsolutions.maximo.notify.queue.QueueProcessorsCache;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobConfig;
import com.interlocsolutions.maximo.notify.security.SessionMonitor;
import com.interlocsolutions.maximo.notify.util.AdminModeMonitor;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.InformerMonitorThread;
import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.LicenseManager;
import com.interlocsolutions.maximo.notify.util.ListenerRegistrations;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessorKt;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import com.interlocsolutions.maximo.util.MboSetIterator;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MaximoCache;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u0006\u0010 \u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/interlocsolutions/maximo/notify/NotifyServiceCompanion;", "", "mxServer", "Lpsdi/server/MXServer;", "(Lpsdi/server/MXServer;)V", "coroutineExceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "informerScope", "Lkotlinx/coroutines/CoroutineScope;", "getInformerScope", "()Lkotlinx/coroutines/CoroutineScope;", "listenerRegistrations", "Lcom/interlocsolutions/maximo/notify/util/ListenerRegistrations;", "logger", "Lpsdi/util/logging/MXLogger;", "kotlin.jvm.PlatformType", "startupMonitor", "Lcom/interlocsolutions/maximo/notify/StartupMonitor;", "getStartupMonitor", "()Lcom/interlocsolutions/maximo/notify/StartupMonitor;", "activateNow", "", "profile", "Lpsdi/mbo/MboRemote;", "activateProfile", "allCatalogsInitialized", "", "destroy", "init", "initializeAndActivate", "initializeCatalogs", "preloadAllCatalogs", "purgeUnsupportedLanguage", "Companion", "isinformer"})
public final class NotifyServiceCompanion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MXServer mxServer;
    private final MXLogger logger;
    @NotNull
    private final CoroutineExceptionHandler coroutineExceptionHandler;
    @NotNull
    private final CoroutineScope informerScope;
    @NotNull
    private final StartupMonitor startupMonitor;
    @Nullable
    private ListenerRegistrations listenerRegistrations;
    private static final long SHUTDOWN_TIMEOUT = 3L;

    public NotifyServiceCompanion(@NotNull MXServer mxServer) {
        Intrinsics.checkNotNullParameter((Object)mxServer, (String)"mxServer");
        this.mxServer = mxServer;
        this.logger = NotifyConstants.INFORMER_LOGGER;
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.coroutineExceptionHandler = new CoroutineExceptionHandler(key, this){
            final /* synthetic */ NotifyServiceCompanion this$0;
            {
                this.this$0 = notifyServiceCompanion;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable exception2 = exception;
                boolean bl = false;
                MXLogger mXLogger = NotifyServiceCompanion.access$getLogger$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                MXLogger $this$errorLazy$iv = mXLogger;
                boolean $i$f$errorLazy = false;
                if ($this$errorLazy$iv.isErrorEnabled()) {
                    Object object;
                    try {
                        boolean bl2 = false;
                        object = Result.constructor-impl((Object)"An unhandled error occurred");
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                    if (exception2 != null) {
                        $this$errorLazy$iv.error((Object)msg$iv, exception2);
                    } else {
                        $this$errorLazy$iv.error((Object)msg$iv);
                    }
                }
            }
        };
        this.informerScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)this.coroutineExceptionHandler));
        this.startupMonitor = new StartupMonitor(this.informerScope);
    }

    @NotNull
    public final CoroutineScope getInformerScope() {
        return this.informerScope;
    }

    @NotNull
    public final StartupMonitor getStartupMonitor() {
        return this.startupMonitor;
    }

    public final void init() {
        Object object;
        Object $this$init_u24lambda_u2412;
        Object $this$init_u24lambda_u249;
        Object $this$init_u24lambda_u246;
        String msg$iv;
        String string;
        Object object2;
        boolean $i$f$errorLazy;
        MXLogger $this$errorLazy$iv;
        Object $this$init_u24lambda_u243;
        Object $this$init_u24lambda_u242;
        ListenerRegistrations listenerRegistrations;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotifyServiceCompanion this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getStartupMonitor().init((Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.this$0.getStartupMonitor().getInformerInstalled().release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        ListenerRegistrations listenerRegistrations2 = listenerRegistrations = new ListenerRegistrations();
        NotifyServiceCompanion notifyServiceCompanion = this;
        boolean bl = false;
        String[] stringArray = new String[]{"maximo.maxuser.delete", "maximo.applicationauth.add", "maximo.applicationauth.update", "maximo.applicationauth.delete", "maximo.groupuser.add", "maximo.groupuser.update", "maximo.groupuser.delete", "maximo.isnotifyassocapp.add", "maximo.isnotifyassocapp.update", "maximo.isnotifyassocapp.delete"};
        ((ListenerRegistrations)$this$init_u24lambda_u242).add(new SecurityChangeListener(), stringArray);
        stringArray = new String[]{"maximo.maxuser.update"};
        ((ListenerRegistrations)$this$init_u24lambda_u242).add(new SecurityUserChangeListener(), stringArray);
        stringArray = new String[]{"maximo.isnotifyrefreshqueue.add"};
        ((ListenerRegistrations)$this$init_u24lambda_u242).add(new NotifyRefreshQueueListener(), stringArray);
        stringArray = new String[]{"maximo.asset.delete"};
        ((ListenerRegistrations)$this$init_u24lambda_u242).add(new NotifyDeviceAssetListener(), stringArray);
        notifyServiceCompanion.listenerRegistrations = listenerRegistrations.registerAll();
        new CommandRegistrar().start();
        NotificationEventListenerManager notificationEventManager = new NotificationEventListenerManager("Informer-EventListenerManager");
        notificationEventManager.start();
        new AdminModeMonitor("Informer-AdminMonitor").start();
        LicenseManager.INSTANCE.start();
        new SessionMonitor().start();
        $this$init_u24lambda_u242 = this;
        try {
            $this$init_u24lambda_u243 = $this$init_u24lambda_u242;
            boolean bl2 = false;
            $this$init_u24lambda_u243 = Result.constructor-impl((Object)JobConfig.getJobDispatcher());
        }
        catch (Throwable bl2) {
            $this$init_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        $this$init_u24lambda_u242 = $this$init_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$this$init_u24lambda_u242);
        if (throwable != null) {
            Object e = $this$init_u24lambda_u243 = throwable;
            boolean bl3 = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl4 = false;
                    object2 = Result.constructor-impl((Object)"Failed to proactively initialize the configured JobDispatcher.");
                }
                catch (Throwable throwable2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                string = "(Unable to form error msg)";
                msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (e != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, (Throwable)e);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        $this$init_u24lambda_u242 = this;
        try {
            $this$init_u24lambda_u246 = (NotifyServiceCompanion)$this$init_u24lambda_u242;
            boolean bl5 = false;
            $this$init_u24lambda_u246 = Result.constructor-impl((Object)JobConfig.getJobFactory());
        }
        catch (Throwable bl5) {
            $this$init_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
        }
        $this$init_u24lambda_u242 = $this$init_u24lambda_u246;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)$this$init_u24lambda_u242);
        if (throwable3 != null) {
            Object e = $this$init_u24lambda_u246 = throwable3;
            boolean bl6 = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl7 = false;
                    object2 = Result.constructor-impl((Object)"Failed to proactively initialize the configured JobFactory.");
                }
                catch (Throwable throwable4) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
                }
                string = "(Unable to form error msg)";
                msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (e != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, (Throwable)e);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        $this$init_u24lambda_u242 = this;
        try {
            $this$init_u24lambda_u249 = (NotifyServiceCompanion)$this$init_u24lambda_u242;
            boolean bl8 = false;
            $this$init_u24lambda_u249 = Result.constructor-impl((Object)JobConfig.getJobQueueProcessor());
        }
        catch (Throwable bl8) {
            $this$init_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl8));
        }
        $this$init_u24lambda_u242 = $this$init_u24lambda_u249;
        Throwable throwable5 = Result.exceptionOrNull-impl((Object)$this$init_u24lambda_u242);
        if (throwable5 != null) {
            Object e = $this$init_u24lambda_u249 = throwable5;
            boolean bl9 = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl10 = false;
                    object2 = Result.constructor-impl((Object)"Failed to proactively initialize the configured JobQueueProcessor.");
                }
                catch (Throwable throwable6) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable6));
                }
                string = "(Unable to form error msg)";
                msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (e != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, (Throwable)e);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        $this$init_u24lambda_u242 = this;
        try {
            $this$init_u24lambda_u2412 = (NotifyServiceCompanion)$this$init_u24lambda_u242;
            boolean bl11 = false;
            $this$init_u24lambda_u2412 = Result.constructor-impl((Object)NotificationJobConfig.INSTANCE.getNotificationJobQueueProcessor());
        }
        catch (Throwable bl11) {
            $this$init_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl11));
        }
        $this$init_u24lambda_u242 = $this$init_u24lambda_u2412;
        Throwable throwable7 = Result.exceptionOrNull-impl((Object)$this$init_u24lambda_u242);
        if (throwable7 != null) {
            Object e = $this$init_u24lambda_u2412 = throwable7;
            boolean bl12 = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl13 = false;
                    object2 = Result.constructor-impl((Object)"Failed to proactively initialize the configured NotificationJobQueueProcessor.");
                }
                catch (Throwable throwable8) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable8));
                }
                string = "(Unable to form error msg)";
                msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (e != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, (Throwable)e);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        $this$init_u24lambda_u242 = this;
        try {
            NotifyServiceCompanion $this$init_u24lambda_u2415 = (NotifyServiceCompanion)$this$init_u24lambda_u242;
            boolean bl14 = false;
            object = Result.constructor-impl((Object)PushJobConfig.INSTANCE.getPushQueueProcessor());
        }
        catch (Throwable bl14) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl14));
        }
        $this$init_u24lambda_u242 = object;
        Throwable throwable9 = Result.exceptionOrNull-impl((Object)$this$init_u24lambda_u242);
        if (throwable9 != null) {
            Object e = object = throwable9;
            boolean bl15 = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl16 = false;
                    object2 = Result.constructor-impl((Object)"Failed to proactively initialize the configured PushJobQueueProcessor.");
                }
                catch (Throwable throwable10) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable10));
                }
                string = "(Unable to form error msg)";
                String msg$iv2 = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (e != null) {
                    $this$errorLazy$iv.error((Object)msg$iv2, (Throwable)e);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv2);
                }
            }
        }
        QueueProcessorsCache queueProcessorsCache = new QueueProcessorsCache();
        this.mxServer.addToMaximoCache(queueProcessorsCache.getName(), (MaximoCache)queueProcessorsCache);
        queueProcessorsCache.init();
        new InformerMonitorThread("InformerProcessMonitor").start();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotifyServiceCompanion this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getStartupMonitor().getInformerInitialized().release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        notificationEventManager.waitForInitCompletion();
        this.purgeUnsupportedLanguage();
        this.preloadAllCatalogs();
    }

    public final void destroy() {
        Object object;
        String string;
        Object object2;
        boolean $i$f$errorLazy;
        MXLogger $this$errorLazy$iv;
        Object $this$destroy_u24lambda_u2418;
        Object object3 = this;
        try {
            $this$destroy_u24lambda_u2418 = object3;
            boolean bl = false;
            ListenerRegistrations listenerRegistrations = ((NotifyServiceCompanion)$this$destroy_u24lambda_u2418).listenerRegistrations;
            if (listenerRegistrations != null) {
                listenerRegistrations.unregisterAll();
            }
            ((NotifyServiceCompanion)$this$destroy_u24lambda_u2418).listenerRegistrations = null;
            $this$destroy_u24lambda_u2418 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$destroy_u24lambda_u2418 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$destroy_u24lambda_u2418;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Object it = $this$destroy_u24lambda_u2418 = throwable;
            boolean bl = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl2 = false;
                    object2 = Result.constructor-impl((Object)"Error encountered during cleanup, during service shutdown");
                }
                catch (Throwable throwable2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                string = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (it != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, (Throwable)it);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        object3 = this;
        try {
            NotifyServiceCompanion $this$destroy_u24lambda_u2421 = (NotifyServiceCompanion)object3;
            boolean bl = false;
            InformerThreadGroup.getInformerThreadGroup().awaitShutdown(3L, TimeUnit.MINUTES);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = object;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object3);
        if (throwable3 != null) {
            Object it = object = throwable3;
            boolean bl = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            $this$errorLazy$iv = mXLogger;
            $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                try {
                    boolean bl3 = false;
                    object2 = Result.constructor-impl((Object)"Error encountered during cleanup, during service shutdown");
                }
                catch (Throwable throwable4) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
                }
                string = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
                if (it != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, (Throwable)it);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.informerScope, (String)"Informer Service shutting down", null, (int)2, null);
    }

    private final void preloadAllCatalogs() {
        if (DataUtils.systemRawCUD("update maxvars set varvalue = 'N' where varname = 'ISINFPRELOAD' and varvalue = 'Y'") > 0) {
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"com/interlocsolutions/maximo/notify/NotifyServiceCompanion$preloadAllCatalogs$PreloadEnqueueThread", "Lcom/interlocsolutions/maximo/notify/util/InformerThread;", "logger", "Lpsdi/util/logging/MXLogger;", "(Lpsdi/util/logging/MXLogger;)V", "runInformerTask", "", "isinformer"})
            public final class PreloadEnqueueThread
            extends InformerThread {
                public PreloadEnqueueThread(@NotNull MXLogger logger2) {
                    Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
                    super("Informer Preload Enqueue", logger2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                protected void runInformerTask() {
                    void $this$use$iv$iv;
                    void whereClause$iv;
                    void mboName$iv;
                    MboInterface mbos = MboInterface.Companion.obtain$default(MboInterface.Companion, null, 1, null);
                    EvalContext evalContext = new EvalContext(mbos.getUserInfo(), null, null, 6, null);
                    String string = "ISCATALOG";
                    String string2 = "preload = :yes AND initialized = :yes AND notifyid IN (SELECT notifyid FROM isnotify WHERE active = :yes)";
                    boolean discardable$iv = false;
                    boolean $i$f$useNewMboSet = false;
                    MboSetRemote mboSetRemote = mbos.getNewMboSet((String)mboName$iv, (String)whereClause$iv, discardable$iv);
                    boolean $i$f$use = false;
                    Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv);
                    Throwable throwable = null;
                    try {
                        MboSetRemoteClosableWrapper it$iv$iv = (MboSetRemoteClosableWrapper)closeable;
                        boolean bl = false;
                        void catalogSet = $this$use$iv$iv;
                        boolean bl2 = false;
                        void $this$forEach$iv = catalogSet;
                        boolean $i$f$forEach = false;
                        Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence((MboSetRemote)$this$forEach$iv);
                        boolean $i$f$forEach2 = false;
                        for (E element$iv$iv : $this$forEach$iv$iv) {
                            MboRemote it = (MboRemote)element$iv$iv;
                            boolean bl3 = false;
                            JobConfig.getJobDispatcher().doPreload(evalContext, new JobPreload.JobSpecPreload(it.getLong("CATALOGID"), it.getLong("REVISION")));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            new PreloadEnqueueThread(mXLogger).start();
        }
    }

    public final void purgeUnsupportedLanguage() {
        this.logger.info((Object)"Purging Unsupported Languages");
        String unsupportedLangcodePredicate = DataUtils.formSafeNotInClause("langcode", "LANGUAGE", "MAXLANGCODE", (List<String>)new ArrayList<String>(NotifyUtil.getLangCodes()));
        DbConnectionAccessor maximoDb = DbConnectionManager.getInstance().getMaximoConnection();
        Intrinsics.checkNotNullExpressionValue((Object)maximoDb, (String)"maximoDb");
        DbConnectionAccessorKt.deleteIteratively(maximoDb, "iscatpreload", "catpreloadid", unsupportedLangcodePredicate, new Object[0], arg_0 -> NotifyServiceCompanion.purgeUnsupportedLanguage$lambda$24(maximoDb, arg_0));
        DbConnectionAccessorKt.deleteIteratively$default(maximoDb, "iscatalogdata", "catalogdataid", unsupportedLangcodePredicate, new Object[0], null, 16, null);
        DbConnectionAccessor.DefaultImpls.executeUpdate$default(maximoDb, "DELETE FROM isnotifyresource WHERE " + unsupportedLangcodePredicate, null, 2, null);
        DbConnectionAccessor.DefaultImpls.executeUpdate$default(maximoDb, "DELETE FROM issession WHERE " + unsupportedLangcodePredicate, null, 2, null);
        DbConnectionAccessor.DefaultImpls.executeUpdate$default(maximoDb, "DELETE FROM istracking WHERE " + unsupportedLangcodePredicate, null, 2, null);
        DbConnectionAccessor queueDb = DbConnectionManager.getInstance().getQueueConnection();
        Intrinsics.checkNotNullExpressionValue((Object)queueDb, (String)"queueDb");
        DbConnectionAccessor.DefaultImpls.executeUpdate$default(queueDb, "DELETE FROM iscatalogjobqueue WHERE " + unsupportedLangcodePredicate, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void activateNow(@NotNull MboRemote profile) throws MXException {
        void $this$use$iv;
        EvalContext evalContext;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        EvalContext $this$activateNow_u24lambda_u2425 = evalContext = new EvalContext(null, null, null, 7, null);
        boolean bl = false;
        $this$activateNow_u24lambda_u2425.setFlag(EvalFlags.USER_WAITING);
        $this$activateNow_u24lambda_u2425.setFlag(EvalFlags.PROFILE_ACTIVATION);
        EvalContext evalContext2 = evalContext;
        UserInfo systemUserInfo = MXServer.getMXServer().getSystemUserInfo();
        String string = new SqlFormat(profile, "notifyid = :notifyid").format();
        Intrinsics.checkNotNullExpressionValue((Object)systemUserInfo, (String)"systemUserInfo");
        $this$activateNow_u24lambda_u2425 = MboExtensionsKt.getNewMboSet("ISCATALOG", string, systemUserInfo, false);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv);
        Throwable throwable = null;
        try {
            void $this$activateNow_u24lambda_u2428_u24lambda_u2426;
            SqlFormat sqlFormat;
            MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl2 = false;
            void catalogSet = $this$use$iv;
            boolean bl3 = false;
            SqlFormat sqlFormat2 = sqlFormat = new SqlFormat("INITIALIZED = :1");
            void var14_19 = catalogSet;
            boolean bl4 = false;
            $this$activateNow_u24lambda_u2428_u24lambda_u2426.setBoolean(1, false);
            var14_19.setUserWhere(sqlFormat.format());
            void $this$forEach$iv = catalogSet;
            boolean $i$f$forEach = false;
            Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence((MboSetRemote)$this$forEach$iv);
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                MboRemote it = (MboRemote)element$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.Catalog");
                long newRevision = ((Catalog)it).incrementRevisionNumber();
                JobConfig.getJobDispatcher().cancelBefore(evalContext2.duplicate(), ((Catalog)it).getUniqueIDValue(), newRevision);
                it.setValue("INITIALIZED", true);
            }
            catalogSet.save();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        MboSetRemote $this$forEach$iv = MboExtensionsKt.getNewMboSet("ISCATALOG", new SqlFormat(profile, "notifyid = :notifyid and INITIALIZED = :no").format(), systemUserInfo, true);
        boolean $i$f$forEach = false;
        Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence($this$forEach$iv);
        boolean $i$f$forEach3 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            MboRemote catalog = (MboRemote)element$iv$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)catalog, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.CatalogRemote");
            ((CatalogRemote)catalog).reload(evalContext2.duplicate());
        }
        profile.setValue("ACTIVE", true, 2L);
        profile.getThisMboSet().save();
    }

    public final void initializeAndActivate(@NotNull MboRemote profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        BuildersKt.launch$default((CoroutineScope)this.informerScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, profile, null){
            int label;
            final /* synthetic */ NotifyServiceCompanion this$0;
            final /* synthetic */ MboRemote $profile;
            {
                this.this$0 = $receiver;
                this.$profile = $profile;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        UserInfo systemUserInfo = MXServer.getMXServer().getSystemUserInfo();
                        Intrinsics.checkNotNullExpressionValue((Object)systemUserInfo, (String)"systemUserInfo");
                        MboRemote mboRemote = MboExtensionsKt.getNewMboSet$default("ISNOTIFY", null, systemUserInfo, false, 10, null).getMboForUniqueId(this.$profile.getUniqueIDValue());
                        Intrinsics.checkNotNullExpressionValue((Object)mboRemote, (String)"getNewMboSet(\"ISNOTIFY\",\u2026Id(profile.uniqueIDValue)");
                        NotifyServiceCompanion.access$initializeCatalogs(this.this$0, mboRemote);
                        MboRemote mboRemote2 = MboExtensionsKt.getNewMboSet$default("ISNOTIFY", null, systemUserInfo, false, 10, null).getMboForUniqueId(this.$profile.getUniqueIDValue());
                        Intrinsics.checkNotNullExpressionValue((Object)mboRemote2, (String)"getNewMboSet(\"ISNOTIFY\",\u2026Id(profile.uniqueIDValue)");
                        NotifyServiceCompanion.access$activateProfile(this.this$0, mboRemote2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void initializeCatalogs(MboRemote profile) {
        EvalContext evalContext = new EvalContext(null, null, null, 7, null).setFlag(EvalFlags.USER_WAITING);
        MboSetRemote catalogs = profile.getMboSet("CATALOG");
        for (CatalogRemote catalog : new MboSetIterator(catalogs)) {
            if (catalog.getBoolean("INITIALIZED")) continue;
            if (StringsKt.equals((String)"ISPROPERTIES", (String)catalog.getString("CATALOG"), (boolean)true)) {
                catalog.initCatalog(evalContext.duplicate());
                continue;
            }
            catalog.initCatalog(evalContext);
        }
        profile.getThisMboSet().save();
    }

    private final void activateProfile(MboRemote profile) {
        while (!this.allCatalogsInitialized(profile)) {
            Thread.sleep(1000L);
        }
        profile.setValue("ACTIVE", true, 2L);
        profile.getThisMboSet().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean allCatalogsInitialized(@NotNull MboRemote profile) {
        boolean bl;
        void $this$use$iv$iv$iv;
        void whereClause$iv;
        void mboName$iv;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        SqlFormat sqlf = new SqlFormat(profile, "notifyid = :notifyid and initialized = :no");
        String string = "ISCATALOG";
        String string2 = sqlf.format();
        UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
        Intrinsics.checkNotNullExpressionValue((Object)userInfo, (String)"getMXServer().systemUserInfo");
        UserInfo userInfo$iv = userInfo;
        boolean discardable$iv = false;
        boolean $i$f$useNewMboSet = false;
        MboInterface mboInterface = MboInterface.Companion.obtain(userInfo$iv);
        boolean $i$f$useNewMboSet2 = false;
        MboSetRemote mboSetRemote = this_$iv$iv.getNewMboSet((String)mboName$iv, (String)whereClause$iv, discardable$iv);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper((MboSetRemote)$this$use$iv$iv$iv);
        Throwable throwable = null;
        try {
            MboSetRemoteClosableWrapper it$iv$iv$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl2 = false;
            void it = $this$use$iv$iv$iv;
            boolean bl3 = false;
            bl = it.isEmpty();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        boolean rc2 = bl;
        return rc2;
    }

    private static final void purgeUnsupportedLanguage$lambda$24(DbConnectionAccessor $maximoDb, Long catPreloadId) {
        Intrinsics.checkNotNullExpressionValue((Object)$maximoDb, (String)"maximoDb");
        Object[] objectArray = new Long[]{catPreloadId};
        ImmutableLongSet unsuccessfulDeletedIds = DbConnectionAccessorKt.deleteIteratively($maximoDb, "iscatprepage", "catprepageid", "preloaduid = (SELECT preloaduid FROM iscatpreload WHERE catpreloadid = ?)", objectArray, null).component2();
        if (unsuccessfulDeletedIds.size() > 0L) {
            throw new InformerException("ISCATPREPAGE was not delete entirely for catpreloadid: " + catPreloadId);
        }
    }

    public static final /* synthetic */ void access$initializeCatalogs(NotifyServiceCompanion $this, MboRemote profile) {
        $this.initializeCatalogs(profile);
    }

    public static final /* synthetic */ void access$activateProfile(NotifyServiceCompanion $this, MboRemote profile) {
        $this.activateProfile(profile);
    }

    public static final /* synthetic */ MXLogger access$getLogger$p(NotifyServiceCompanion $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/interlocsolutions/maximo/notify/NotifyServiceCompanion$Companion;", "", "()V", "SHUTDOWN_TIMEOUT", "", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

