/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeviceRemote;
import com.interlocsolutions.maximo.notify.FileFragmentRemote;
import com.interlocsolutions.maximo.notify.InstrumentCollector;
import com.interlocsolutions.maximo.notify.InstrumentCollectorImpl;
import com.interlocsolutions.maximo.notify.LoginRequest;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifyEvent;
import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.NotifyResourceRemote;
import com.interlocsolutions.maximo.notify.NotifyServiceCompanion;
import com.interlocsolutions.maximo.notify.NotifyServiceRemote;
import com.interlocsolutions.maximo.notify.PushDevice;
import com.interlocsolutions.maximo.notify.StartupMonitor;
import com.interlocsolutions.maximo.notify.UserNotificationRemote;
import com.interlocsolutions.maximo.notify.commands.CommandUtilities;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.requests.CatalogDeltaRequest;
import com.interlocsolutions.maximo.notify.requests.CatalogPreloadRequest;
import com.interlocsolutions.maximo.notify.requests.GetCatalogRequest;
import com.interlocsolutions.maximo.notify.requests.GetUserProfileRequest;
import com.interlocsolutions.maximo.notify.requests.PushRegisterRequest;
import com.interlocsolutions.maximo.notify.requests.ResetDeviceCatalogRequest;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.SessionManager;
import com.interlocsolutions.maximo.notify.security.datavalidator.GetAttachedDocumentValidationManager;
import com.interlocsolutions.maximo.notify.security.datavalidator.SendFileValidationManager;
import com.interlocsolutions.maximo.notify.util.AttachedDocumentProvider;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.MaximoOverrideKeyAccessor;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.OverrideKeyAccessor;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import com.interlocsolutions.maximo.notify.xml.AppVersion;
import com.interlocsolutions.maximo.notify.xml.AttachedDocumentFragment;
import com.interlocsolutions.maximo.notify.xml.CommandError;
import com.interlocsolutions.maximo.notify.xml.CommandErrors;
import com.interlocsolutions.maximo.notify.xml.ConfirmPushReceipt;
import com.interlocsolutions.maximo.notify.xml.ConfirmPushReceipts;
import com.interlocsolutions.maximo.notify.xml.DeviceAttribute;
import com.interlocsolutions.maximo.notify.xml.DeviceAttributes;
import com.interlocsolutions.maximo.notify.xml.InstrumentData;
import com.interlocsolutions.maximo.notify.xml.NotificationEvent;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import com.interlocsolutions.maximo.notify.xml.ProfileResource;
import com.interlocsolutions.maximo.notify.xml.ProfileResourceList;
import com.interlocsolutions.maximo.notify.xml.ServerRequest;
import com.interlocsolutions.maximo.notify.xml.ServerRequests;
import com.interlocsolutions.maximo.notify.xml.UserProfile;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.jws.WebMethod;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.AppService;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotifyService
extends AppService
implements NotifyServiceRemote {
    public static final String SERVICE_NAME = "NOTIFY";
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private static final long serialVersionUID = 9152091926695968270L;
    private final NotifyServiceCompanion notifyServiceCompanion;
    private final NotificationJobManager notificationJobManager;

    public NotifyService(MXServer mxServer) throws RemoteException {
        super(mxServer);
        this.notifyServiceCompanion = new NotifyServiceCompanion(this.mxServer);
        this.notificationJobManager = NotificationJobManager.INSTANCE;
    }

    @NotNull
    public static String getLangCodeForSession(SessionInfo sessionInfo) throws RemoteException, MXException, NotifyFault {
        String langCode = sessionInfo.getLangCode();
        if (langCode == null || langCode.trim().length() <= 0) {
            langCode = MXServer.getMXServer().getBaseLang();
        }
        if (langCode == null || langCode.trim().length() <= 0) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "undeterminedLangCode"));
        }
        return langCode;
    }

    public CoroutineScope getInformerContext() {
        return this.notifyServiceCompanion.getInformerScope();
    }

    public StartupMonitor getStartupMonitor() {
        return this.notifyServiceCompanion.getStartupMonitor();
    }

    public void init() {
        super.init();
        this.notifyServiceCompanion.init();
        License.setOverrideKeyAccessor((OverrideKeyAccessor)new MaximoOverrideKeyAccessor());
    }

    public void destroy() {
        this.notifyServiceCompanion.destroy();
        super.destroy();
    }

    public void wakeQueue() throws RemoteException {
        this.notificationJobManager.wakeQueue();
    }

    public void wakeCatalogQueue() throws MXException, RemoteException {
        JobConfig.getJobDispatcher().onContentChanged();
    }

    @WebMethod(action="resetDeviceCatalogs", operationName="resetDeviceCatalogs")
    public void resetDeviceCatalogs(String sessionId, String notificationName, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(notificationName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        try {
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            new ResetDeviceCatalogRequest(session, notificationName, null, null, null).invoke();
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
    }

    @WebMethod(action="resetDeviceCatalogsPartial", operationName="resetDeviceCatalogsPartial")
    public void resetDeviceCatalogsPartial(String sessionId, String profileName, List<String> catalog, List<String> langCode, List<String> partition, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(profileName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        try {
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, profileName, userInfo);
            new ResetDeviceCatalogRequest(session, profileName, catalog, langCode, partition).invoke();
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
    }

    @Override
    @WebMethod(action="login", operationName="login")
    public String login(String userName, String password, String deviceName, String deviceSerialNumber, String deviceOS, boolean compressionSupported, String extras, UserInfo userInfo) throws NotifyFault {
        try {
            NotificationSession retVal = new LoginRequest(userName, password, deviceName, deviceSerialNumber, deviceOS, compressionSupported, extras, userInfo).invoke();
            retVal.setServerTime(MXServer.getMXServer().getDate());
            return NotifyXMLUtils.getSession(retVal);
        }
        catch (NotifyFault e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"An error occurred during 'login' call", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"An error occurred during 'login' call", (Throwable)e);
            throw new NotifyFault("An error occurred during 'login' call");
        }
    }

    @Override
    @WebMethod(action="logout", operationName="logout")
    public void logout(String sessionId) throws RemoteException {
        try {
            SessionManager.removeSession(sessionId);
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }

    @Deprecated
    @WebMethod(action="getCommandSchema", operationName="getCommandSchema")
    public String getCommandSchema(String command) throws NotifyFault {
        throw new NotifyFault("This operation is not supported");
    }

    @Override
    @WebMethod(action="executeCommand", operationName="executeCommand")
    public String executeCommand(long notificationId, String sessionId, String notificationName, String command, String xml, boolean isCompressed, UserInfo userInfo) throws MXException, RemoteException {
        return this.internalExecuteCommand(notificationId, sessionId, notificationName, command, xml, isCompressed, true, userInfo);
    }

    /*
     * Exception decompiling
     */
    public String internalExecuteCommand(long notificationId, String sessionId, String notificationName, String command, String xml, boolean isCompressed, boolean inactivateCommandLog, UserInfo userInfo) throws MXException, RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 2[TRYBLOCK]], but top level block is 25[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod(action="getDomainValues", operationName="getDomainValues")
    public String getDomainValues(String objectName, long recordId, String attributeName, String whereClause, int start, int count, String sessionId, UserInfo userInfo) throws RemoteException, MXException {
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote set = null;
        try {
            MboSetRemote listValues;
            set = MXServerFactory.getMboSet(objectName);
            MboRemote obj = set.getMboForUniqueId(recordId);
            if (obj != null && !(listValues = obj.getList(attributeName)).isEmpty()) {
                String retVal = NotifyXMLUtils.getDomainValues(obj, listValues, attributeName, whereClause, start, count);
                String string = this.compressMessage(retVal, session);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            NotifyUtil.closeAndCleanup(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WebMethod(action="getNotification", operationName="getNotification")
    public String getNotification(long notificationId, String sessionId, UserInfo userInfo) throws NotifyFault, RemoteException {
        String string;
        MboSetRemote set;
        block21: {
            String notificationXml;
            SessionInfo session;
            block23: {
                MboSetRemote deviceSet;
                session = SessionManager.getValidNotifySession(sessionId, userInfo);
                String userId = session.getUserId();
                set = null;
                set = MXServer.getMXServer().getMboSet("ISUSERNOTIFICATION", MXServer.getMXServer().getSystemUserInfo());
                SqlFormat sqlf = new SqlFormat("userid = :1 and usernotificationid = :2 and active = :3");
                sqlf.setObject(1, "ISUSERNOTIFICATION", "USERID", userId);
                sqlf.setLong(2, notificationId);
                sqlf.setBoolean(3, true);
                set.setWhere(sqlf.format());
                if (set.isEmpty()) break block21;
                MboRemote notification = set.getMbo(0);
                String notificationName = notification.getString("NOTIFY.NOTIFYNUM");
                if (!session.isValidForProfile(notificationName)) {
                    throw new NotifyFault("[informer:unauthorizedSession]");
                }
                if (NotifyUtil.isTrackingRetrieval()) {
                    MboSetRemote retrievalSet = null;
                    deviceSet = null;
                    try {
                        retrievalSet = MXServer.getMXServer().getMboSet("ISRETRIEVALTRACKING", MXServer.getMXServer().getSystemUserInfo());
                        deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", MXServer.getMXServer().getSystemUserInfo());
                        MboRemote retrieval = retrievalSet.add();
                        retrieval.setValue("USERNOTIFICATIONID", notification.getUniqueIDValue());
                        retrieval.setValue("SEQUENCE", notification.getString("SEQUENCE"));
                        retrieval.setValue("NOTIFYID", notification.getLong("NOTIFYID"));
                        retrieval.setValue("RETRIEVALDATE", MXServer.getMXServer().getDate());
                        MboRemote device = session.getDevice(deviceSet);
                        if (device != null) {
                            retrieval.setValue("DEVICEID", device.getUniqueIDValue());
                        }
                        retrievalSet.save();
                    }
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(retrievalSet);
                        NotifyUtil.closeAndCleanup(deviceSet);
                        throw throwable;
                    }
                    NotifyUtil.closeAndCleanup(retrievalSet);
                    NotifyUtil.closeAndCleanup(deviceSet);
                }
                notificationXml = NotifyXMLUtils.getNotificationXml(notification);
                try {
                    deviceSet = notification.getMboSet("PUSHDEVICE");
                    if (deviceSet == null) break block23;
                    MboRemote device = deviceSet.moveFirst();
                    while (device != null) {
                        MboSetRemote udpateDeviceSet = MXServer.getMXServer().getMboSet("ISPUSHDEVICE", MXServer.getMXServer().getSystemUserInfo());
                        try {
                            long id = device.getUniqueIDValue();
                            MboRemote updateDev = udpateDeviceSet.getMboForUniqueId(id);
                            if (updateDev != null) {
                                updateDev.setValue("LASTSEQUENCE", notification.getLong("SEQUENCE"));
                                udpateDeviceSet.save();
                            }
                        }
                        catch (Throwable t) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("Error updating push device sequence:" + t.getMessage()), t);
                        }
                        finally {
                            NotifyUtil.closeAndCleanup(udpateDeviceSet);
                        }
                        device = deviceSet.moveNext();
                    }
                    deviceSet.save();
                }
                catch (Throwable t) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Error updating push device sequence:" + t.getMessage()), t);
                }
            }
            String string2 = this.compressMessage(notificationXml, session);
            NotifyUtil.closeAndCleanup(set);
            return string2;
        }
        try {
            string = null;
        }
        catch (NotifyFault e) {
            try {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
                throw e;
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault(e2);
                }
                catch (MXException e3) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e3);
                    throw new NotifyFault(e3);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(set);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(set);
        return string;
    }

    /*
     * Exception decompiling
     */
    @Override
    @WebMethod(action="registerListener", operationName="registerListener")
    public String registerListener(String sessionId, long sequence, List<String> notificationNames, long timeout, boolean notificationOnly, UserInfo userInfo) throws NotifyFault {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @WebMethod(action="getApplicationVersion", operationName="getApplicationVersion")
    public String getApplicationVersion(String sessionId, String notificationName, String type, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(notificationName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
        try {
            SqlFormat sqlf = new SqlFormat("type = :1 AND active = :yes AND notifyid = (SELECT notifyid FROM isnotify WHERE notifynum = :2)");
            sqlf.setObject(1, "ISAPPDEPLOY", "TYPE", type);
            sqlf.setObject(2, "ISNOTIFY", "NOTIFYNUM", notificationName);
            final String appLinkUrl = NotifyUtil.getAppDownloadUrl(notificationName);
            AppVersion av = DataUtils.queryByMbo(MXServer.getMXServer().getSystemUserInfo(), "ISAPPDEPLOY", new String[]{"VERSION", "VERSIONNAME"}, sqlf.format(), "VERSION DESC", new DataUtils.ResultSetHandler<AppVersion>(){

                @Override
                public AppVersion useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
                    if (!rs.next()) {
                        return null;
                    }
                    int version = rs.getInt("VERSION");
                    String versionName = rs.getString("VERSIONNAME");
                    return new AppVersion(version, versionName, appLinkUrl);
                }
            });
            if (av == null) {
                return null;
            }
            return InformerObjectSerializer.getInstance().serialize(av, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (NotifyFault e) {
            throw e;
        }
        catch (SQLException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (JAXBException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault((Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="confirmPushReceipt", operationName="confirmPushReceipt")
    public void confirmPushReceipt(String sessionId, String xml, UserInfo userInfo) throws NotifyFault {
        if (!NotifyUtil.isTrackingPush()) {
            return;
        }
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote deviceSet = null;
        try {
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", MXServer.getMXServer().getSystemUserInfo());
            MboRemote device = session.getDevice(deviceSet);
            ConfirmPushReceipts receipts = (ConfirmPushReceipts)InformerObjectSerializer.getInstance().deserialize(new StringReader(xml));
            if (receipts.getReceipts() != null && !receipts.getReceipts().isEmpty()) {
                receipts.getReceipts();
                for (ConfirmPushReceipt cpr : receipts.getReceipts()) {
                    InformerTracking.pushConfirm(cpr.getTrackingId(), cpr.getReceiptDate(), sessionId, device != null ? device.getUniqueIDValue() : 0L);
                }
            }
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (JAXBException e3) {
                    throw new NotifyFault((Exception)((Object)e3));
                }
                catch (XMLStreamException e4) {
                    throw new NotifyFault(e4);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(deviceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="setDeviceAttributes", operationName="setDeviceAttributes")
    public void setDeviceAttributes(String sessionId, String xml, UserInfo userInfo) throws NotifyFault {
        MboSetRemote deviceSet;
        MboSetRemote deviceAttributeSet;
        block13: {
            MboRemote device;
            SessionInfo session;
            block12: {
                session = SessionManager.getValidNotifySession(sessionId, userInfo);
                deviceAttributeSet = null;
                deviceSet = null;
                deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", MXServer.getMXServer().getSystemUserInfo());
                device = session.getDevice(deviceSet);
                if (device != null) break block12;
                NotifyConstants.INFORMER_LOGGER.warn((Object)("Unable to record device attributes because device for serial number " + session.getDeviceSerialNumber() + " and user " + session.getUserId() + " cannot be found."));
                NotifyUtil.closeAndCleanup(deviceSet);
                NotifyUtil.closeAndCleanup(deviceAttributeSet);
                return;
            }
            try {
                StringReader sr = new StringReader(xml);
                DeviceAttributes attributes = (DeviceAttributes)InformerObjectSerializer.getInstance().deserialize(sr);
                String notificationName = attributes.getProfile();
                if (this.isNullOrEmpty(notificationName)) {
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
                }
                if (!session.isValidForProfile(notificationName)) {
                    throw new NotifyFault("[informer:unauthorizedSession]");
                }
                if (attributes.getProfile() == null || attributes.getAttributes() == null || attributes.getAttributes().isEmpty()) break block13;
                SqlFormat sqlf = new SqlFormat("deviceid = :1 and notifynum = :2");
                sqlf.setLong(1, device.getUniqueIDValue());
                sqlf.setObject(2, "ISNOTIFY", "NOTIFYNUM", attributes.getProfile());
                deviceAttributeSet = MXServer.getMXServer().getMboSet("ISDEVICEATTRIBUTE", MXServer.getMXServer().getSystemUserInfo());
                deviceAttributeSet.setWhere(sqlf.format());
                deviceAttributeSet.reset();
                deviceAttributeSet.deleteAll();
                ArrayList<DeviceAttribute> attrs = attributes.getAttributes();
                for (DeviceAttribute attr : attrs) {
                    MboRemote deviceAttribute = deviceAttributeSet.add();
                    deviceAttribute.setValue("ATTRIBUTE", attr.getAttribute());
                    deviceAttribute.setValue("VALUE", attr.getValue());
                    deviceAttribute.setValue("NOTIFYNUM", attributes.getProfile());
                    deviceAttribute.setValue("DEVICEID", device.getUniqueIDValue());
                    deviceAttributeSet.save();
                }
            }
            catch (NotifyFault e) {
                try {
                    throw e;
                    catch (RemoteException e2) {
                        throw new NotifyFault(e2);
                    }
                    catch (MXException e3) {
                        throw new NotifyFault(e3);
                    }
                    catch (JAXBException e4) {
                        throw new NotifyFault((Exception)((Object)e4));
                    }
                    catch (XMLStreamException e5) {
                        throw new NotifyFault(e5);
                    }
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(deviceSet);
                    NotifyUtil.closeAndCleanup(deviceAttributeSet);
                    throw throwable;
                }
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
        NotifyUtil.closeAndCleanup(deviceAttributeSet);
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getAvailableResources", operationName="getAvailableResources")
    public String getAvailableResources(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        String string;
        if (this.isNullOrEmpty(profile)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, profile, userInfo);
        MboSetRemote resourcesSet = null;
        try {
            resourcesSet = MXServer.getMXServer().getMboSet("ISNOTIFYRESOURCE", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("notifyid in (select notifyid from isnotify where notifynum = :1)  AND NOT EXISTS (SELECT * FROM isnotifyresource r WHERE r.NOTIFYID = isnotifyresource.notifyid AND r.name = isnotifyresource.name AND r.langcode = isnotifyresource.langcode AND r.version > isnotifyresource.version)");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
            resourcesSet.setWhere(sqlf.format());
            resourcesSet.reset();
            MboRemote resource = null;
            ProfileResourceList prl = new ProfileResourceList();
            while ((resource = resourcesSet.getMbo(0)) != null) {
                prl.addResource(resource);
                resourcesSet.remove(0);
            }
            String xml = InformerObjectSerializer.getInstance().serialize(prl, InformerObjectSerializer.MARSHAL_PPRINT);
            string = this.compressMessage(xml, session);
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (JAXBException e3) {
                    throw new NotifyFault((Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(resourcesSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(resourcesSet);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getResource", operationName="getResource")
    public String getResource(String sessionId, String profile, String resource, String langCode, int version, int offset, int length, UserInfo userInfo) throws NotifyFault {
        String string;
        if (this.isNullOrEmpty(profile)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, profile, userInfo);
        MboSetRemote resourceSet = null;
        try {
            byte[] fragmentBytes;
            int bytesRead;
            byte[] resourceBytes;
            NotifyResourceRemote r;
            block14: {
                block13: {
                    resourceSet = MXServer.getMXServer().getMboSet("ISNOTIFYRESOURCE", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("notifyid = (select notifyid from isnotify where notifynum = :1) and name = :2 and version = :3 and langCode = :4");
                    sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
                    sqlf.setObject(2, "ISNOTIFYRESOURCE", "NAME", resource);
                    sqlf.setInt(3, version);
                    sqlf.setObject(4, "LANGUAGE", "MAXLANGCODE", langCode);
                    resourceSet.setWhere(sqlf.format());
                    if (resourceSet.isEmpty()) {
                        Object[] args = new String[]{profile, resource, String.valueOf(version)};
                        throw new NotifyFault((MXException)new MXApplicationException("informer", "invalidProfileResource", args));
                    }
                    r = (NotifyResourceRemote)resourceSet.getMbo(0);
                    r.addToSession(sessionId);
                    String data = r.getString("DATA");
                    resourceBytes = Base64.decodeBase64(data);
                    bytesRead = -1;
                    if (offset >= resourceBytes.length) break block13;
                    ByteArrayInputStream bais = new ByteArrayInputStream(resourceBytes);
                    bais.skip(offset);
                    fragmentBytes = new byte[length];
                    bytesRead = bais.read(fragmentBytes);
                    if (bytesRead == -1) {
                        fragmentBytes = new byte[]{};
                        break block14;
                    } else if (bytesRead < length) {
                        byte[] tmp = new byte[bytesRead];
                        System.arraycopy(fragmentBytes, 0, tmp, 0, bytesRead);
                        fragmentBytes = tmp;
                    }
                    break block14;
                }
                fragmentBytes = new byte[]{};
            }
            ProfileResource pr = new ProfileResource((long)resourceBytes.length, (long)offset, (long)fragmentBytes.length, fragmentBytes);
            if (bytesRead == -1 || offset + bytesRead == resourceBytes.length) {
                r.removeFromSession(sessionId);
            }
            String xml = InformerObjectSerializer.getInstance().serialize(pr, InformerObjectSerializer.MARSHAL_PPRINT);
            string = this.compressMessage(xml, session);
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (IOException e3) {
                    throw new NotifyFault(e3);
                }
                catch (JAXBException e4) {
                    throw new NotifyFault((Exception)((Object)e4));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(resourceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(resourceSet);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotifyEvent[] getPendingCatalogUpdates(SessionInfo session, List<String> notificationNames) throws RemoteException, MXException {
        if (session.getDeviceSerialNumber() != null) {
            MboSetRemote deviceSet;
            block11: {
                NotifyEvent[] notifyEventArray;
                MboRemote device;
                block9: {
                    deviceSet = null;
                    deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
                    device = session.getDevice(deviceSet);
                    if (device != null) break block9;
                    NotifyConstants.INFORMER_LOGGER.error((Object)("Failed to identify ISDEVICE for this ISSESSION (" + session.getSessionKey() + ")"));
                    NotifyEvent[] notifyEventArray2 = null;
                    NotifyUtil.closeAndCleanup(deviceSet);
                    return notifyEventArray2;
                }
                try {
                    SqlFormat sqlf = new SqlFormat(device, "devicekey = :deviceid and catalogid in (select catalogid from iscatalog where notifyid IN (" + DataUtils.formNotifyIdQuery(notificationNames) + "))");
                    MboSetRemote catalogDeviceSet = device.getMboSet("$catalogdevice", "ISCATALOGDEVICE", sqlf.format());
                    catalogDeviceSet.reset();
                    ArrayList<NotifyEvent> result = new ArrayList<NotifyEvent>();
                    MboRemote catalogDevice = catalogDeviceSet.moveFirst();
                    while (catalogDevice != null) {
                        block10: {
                            CachedCatalog catInfo;
                            try {
                                catInfo = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(catalogDevice.getLong("CATALOGID"), catalogDevice.getLong("REVISION"));
                            }
                            catch (NoSuchCatalogException e) {
                                break block10;
                            }
                            SqlFormat catDataSqlf = catalogDevice.isNull("PARTITIONNAME") ? new SqlFormat(catalogDevice, "catalogid = :catalogid AND revision = :revision AND mainrecord = :yes AND langcode = :1  AND sequence > :sequence") : new SqlFormat(catalogDevice, "catalogid = :catalogid AND revision = :revision AND partitionname = :partitionname AND langcode = :1  AND sequence > :sequence");
                            catDataSqlf.setObject(1, "ISCATALOGDATA", "LANGCODE", session.getLangCode());
                            MboSetRemote catalogDataSet = catalogDevice.getMboSet("$catalogdata", "ISCATALOGDATA", catDataSqlf.format());
                            catalogDataSet.reset();
                            if (!catalogDataSet.isEmpty()) {
                                MboRemote catalogData = catalogDataSet.getMbo(0);
                                NotifyEvent ne = new NotifyEvent(catInfo.catalogId, catInfo.catalogName, catalogDevice.isNull("PARTITIONNAME") ? null : catalogDevice.getString("PARTITIONNAME"), catalogData.getLong("RECORDID"), catalogData.getDate("CHANGEDATE"), NotificationEvent.EVENT_TYPE.CATALOG);
                                ne.setSequence(catalogData.getLong("SEQUENCE"));
                                ne.setNotificationName(catInfo.notifyNum);
                                result.add(ne);
                            }
                        }
                        catalogDevice = catalogDeviceSet.moveNext();
                    }
                    if (result.size() <= 0) break block11;
                    NotifyEvent[] eventResults = new NotifyEvent[result.size()];
                    for (int i = 0; i < result.size(); ++i) {
                        eventResults[i] = (NotifyEvent)result.get(i);
                    }
                    notifyEventArray = eventResults;
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(deviceSet);
                    throw throwable;
                }
                NotifyUtil.closeAndCleanup(deviceSet);
                return notifyEventArray;
            }
            NotifyUtil.closeAndCleanup(deviceSet);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotifyEvent[] getPendingNotifications(SessionInfo session, List<String> notificationNames, long sequence) throws RemoteException {
        if (sequence < 0L) {
            return null;
        }
        String userId = session.getUserId();
        ArrayList<NotifyEvent> events = new ArrayList<NotifyEvent>();
        try {
            MXServer mxServer = MXServer.getMXServer();
            UserInfo sysUserInfo = mxServer.getSystemUserInfo();
            MboSetRemote userNotificationsSet = mxServer.getMboSet("ISUSERNOTIFICATION", sysUserInfo);
            try {
                for (String notificationName : notificationNames) {
                    SqlFormat sqlf = new SqlFormat(" userid = :1  AND notifyid = (SELECT notifyid FROM isnotify WHERE notifynum = :2)  AND sequence > :3 ");
                    sqlf.setObject(1, "ISUSERNOTIFICATION", "USERID", userId);
                    sqlf.setObject(2, "ISNOTIFY", "NOTIFYNUM", notificationName);
                    sqlf.setLong(3, sequence);
                    userNotificationsSet.setWhere(sqlf.format());
                    userNotificationsSet.setFlag(39L, true);
                    MboRemote userNotification = userNotificationsSet.moveFirst();
                    while (userNotification != null) {
                        events.add(new NotifyEvent(userNotification.getUniqueIDValue(), userNotification.getLong("RECORDID"), userNotification.getString("OBJECTNAME"), userNotification.getString("NOTIFY.NOTIFYNUM"), userNotification.getDate("LASTUPDATE"), userNotification.getBoolean("ACTIVE"), NotificationEvent.EVENT_TYPE.NOTIFICATION, userNotification.getLong("SEQUENCE")));
                        userNotification = userNotificationsSet.moveNext();
                    }
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(userNotificationsSet);
            }
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        return events.isEmpty() ? null : events.toArray(new NotifyEvent[events.size()]);
    }

    private NotifyEvent[] getPendingServerRequests(SessionInfo session) throws RemoteException {
        MboSetRemote deviceSet;
        block12: {
            NotifyEvent[] notifyEventArray;
            block13: {
                deviceSet = null;
                deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
                MboRemote device = session.getDevice(deviceSet);
                if (device == null) break block12;
                NotifyEvent instrumentEvent = null;
                if (device.getBoolean("INSTRUMENTREQPENDING")) {
                    instrumentEvent = new NotifyEvent();
                    instrumentEvent.setType(NotificationEvent.EVENT_TYPE.INSTRUMENTATION);
                    device.setValue("INSTRUMENTREQPENDING", false);
                    deviceSet.save();
                }
                String[] profiles2 = session.getProfiles().split("\\|");
                ArrayList<String> profileNames = new ArrayList<String>();
                for (String profile : profiles2) {
                    if (profile.trim().length() <= 0) continue;
                    profileNames.add(profile);
                }
                SqlFormat sqlf = new SqlFormat("deviceid = :1 and status = 'PENDING' and (sessionid != :2 or sessionid is null) and " + DataUtils.formSafeInClause("profiles", "ISDEVICELOG", "PROFILES", profileNames));
                sqlf.setLong(1, device.getLong("DEVICEID"));
                sqlf.setObject(2, "ISDEVICELOG", "SESSIONID", session.getSessionKey());
                MboSetRemote deviceLogSet = device.getMboSet("$isdevicelog", "ISDEVICELOG", sqlf.format());
                deviceLogSet.reset();
                ArrayList<NotifyEvent> events = new ArrayList<NotifyEvent>();
                MboRemote deviceLog = deviceLogSet.moveFirst();
                while (deviceLog != null) {
                    NotifyEvent ne;
                    if ("LOG".equals(deviceLog.getString("TYPE"))) {
                        ne = new NotifyEvent();
                        ne.setType(NotificationEvent.EVENT_TYPE.LOG);
                        ne.setRecordId(deviceLog.getUniqueIDValue());
                        events.add(ne);
                    } else if ("SCREENSHOT".equals(deviceLog.getString("TYPE"))) {
                        ne = new NotifyEvent();
                        ne.setType(NotificationEvent.EVENT_TYPE.SCREENSHOT);
                        ne.setRecordId(deviceLog.getUniqueIDValue());
                        events.add(ne);
                    }
                    deviceLog.setValue("CONFIRMED", true);
                    deviceLog.setValue("SESSIONID", session.getSessionKey());
                    deviceLog = deviceLogSet.moveNext();
                }
                if (events.size() <= 0) break block13;
                if (instrumentEvent != null) {
                    events.add(instrumentEvent);
                }
                deviceSet.save();
                notifyEventArray = events.toArray(new NotifyEvent[events.size()]);
                NotifyUtil.closeAndCleanup(deviceSet);
                return notifyEventArray;
            }
            try {
                notifyEventArray = null;
            }
            catch (MXException e) {
                try {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e);
                    throw new NotifyFault(e);
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(deviceSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(deviceSet);
            return notifyEventArray;
        }
        NotifyUtil.closeAndCleanup(deviceSet);
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="refresh", operationName="refresh")
    public String refreshNotifications(String notificationName, String sessionId, UserInfo userInfo) throws NotifyFault {
        String string;
        MboSetRemote set;
        block8: {
            if (this.isNullOrEmpty(notificationName)) {
                throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
            }
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            String userId = session.getUserId();
            set = null;
            set = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("notifynum = :1 and active = :2");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notificationName);
            sqlf.setBoolean(2, true);
            set.setWhere(sqlf.format());
            if (set.isEmpty()) break block8;
            ((NotifyRemote)set.getMbo(0)).refreshNotifications(userId);
            String string2 = this.compressMessage(this.getNotificationIds(notificationName, sessionId, userInfo), session);
            NotifyUtil.closeAndCleanup(set);
            return string2;
        }
        try {
            string = null;
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e2));
                }
                catch (MXException e3) {
                    throw new NotifyFault(e3);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(set);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(set);
        return string;
    }

    @Override
    @WebMethod(action="getCatalog", operationName="getCatalog")
    public String getCatalog(String sessionId, String notificationName, String catalogName, long deviceId, int count, long sequence, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(notificationName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        if (this.isNullOrEmpty(catalogName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "catalogRequired"));
        }
        SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
        try {
            String langCode = NotifyService.getLangCodeForSession(session);
            return this.getCatalogForLanguage(sessionId, notificationName, catalogName, deviceId, count, sequence, langCode, userInfo);
        }
        catch (NotifyFault e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e));
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
    }

    @WebMethod(action="getCatalogForLanguage", operationName="getCatalogForLanguage")
    public String getCatalogForLanguage(String sessionId, String notificationName, String catalogName, long deviceId, int count, long sequence, String langCode, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(notificationName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        if (this.isNullOrEmpty(catalogName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "catalogRequired"));
        }
        try {
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            String responsePayload = new GetCatalogRequest(notificationName, catalogName, deviceId, count, sequence, langCode, session).invoke();
            if (responsePayload != null) {
                responsePayload = this.compressMessage(responsePayload, session);
            }
            return responsePayload;
        }
        catch (NotifyFault e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e));
        }
        catch (SQLException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
    }

    @WebMethod(action="getCatalogBaseline", operationName="getCatalogBaseline")
    public String getCatalogBaseline(String sessionId, String notificationName, String catalogName, long sequence, String langCode, String partitionName, UserInfo userInfo) throws NotifyFault {
        return this.getCatalogBaselineInternal(sessionId, notificationName, catalogName, sequence, langCode, partitionName, userInfo);
    }

    @WebMethod(action="getCatalogBaselineForLanguage", operationName="getCatalogBaselineForLanguage")
    public String getCatalogBaselineForLanguage(String sessionId, String notificationName, String catalogName, long sequence, String langCode, String partitionName, UserInfo userInfo) throws NotifyFault {
        return this.getCatalogBaselineInternal(sessionId, notificationName, catalogName, sequence, langCode, partitionName, userInfo);
    }

    private String getCatalogBaselineInternal(String sessionId, String notificationName, String catalogName, long sequence, String langCode, String partitionName, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(notificationName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        if (this.isNullOrEmpty(catalogName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "catalogRequired"));
        }
        if (partitionName != null && (partitionName.isEmpty() || partitionName.trim().isEmpty())) {
            partitionName = null;
        }
        try {
            String responsePayload;
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            if (this.isNullOrEmpty(langCode)) {
                langCode = NotifyService.getLangCodeForSession(session);
            }
            if ((responsePayload = new CatalogPreloadRequest(notificationName, catalogName, sequence, partitionName, langCode, session).invoke()) != null) {
                responsePayload = this.compressMessage(responsePayload, session);
            }
            return responsePayload;
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e));
        }
        catch (SQLException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (RuntimeException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
    }

    @WebMethod(action="getCatalogDeltas", operationName="getCatalogDeltas")
    public String getCatalogDeltas(String sessionId, String notificationName, String catalogName, long deviceId, int count, long sequence, String langCode, String partitionName, UserInfo userInfo) throws NotifyFault {
        return this.getCatalogDeltasInternal(sessionId, notificationName, catalogName, deviceId, count, sequence, langCode, partitionName, userInfo);
    }

    @WebMethod(action="getCatalogDeltasForLanguage", operationName="getCatalogDeltasForLanguage")
    public String getCatalogDeltasForLanguage(String sessionId, String notificationName, String catalogName, long deviceId, int count, long sequence, String langCode, String partitionName, UserInfo userInfo) throws NotifyFault {
        return this.getCatalogDeltasInternal(sessionId, notificationName, catalogName, deviceId, count, sequence, langCode, partitionName, userInfo);
    }

    private String getCatalogDeltasInternal(String sessionId, String notificationName, String catalogName, long deviceId, int count, long sequence, String langCode, String partitionName, UserInfo userInfo) throws NotifyFault {
        if (this.isNullOrEmpty(notificationName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        if (this.isNullOrEmpty(catalogName)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "catalogRequired"));
        }
        if (partitionName != null && (partitionName.isEmpty() || partitionName.trim().isEmpty())) {
            partitionName = null;
        }
        try {
            String responsePayload;
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            if (this.isNullOrEmpty(langCode)) {
                langCode = NotifyService.getLangCodeForSession(session);
            }
            if ((responsePayload = new CatalogDeltaRequest(notificationName, catalogName, partitionName, deviceId, count, sequence, langCode, session).invoke()) != null) {
                responsePayload = this.compressMessage(responsePayload, session);
            }
            return responsePayload;
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e));
        }
        catch (SQLException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (RuntimeException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getNotificationIds", operationName="getNotificationIds")
    public String getNotificationIds(String notificationName, String sessionId, UserInfo userInfo) throws NotifyFault {
        String string;
        MboSetRemote set;
        block8: {
            if (this.isNullOrEmpty(notificationName)) {
                throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
            }
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            String userId = session.getUserId();
            set = null;
            set = MXServer.getMXServer().getMboSet("ISNOTIFY", NotifyUtil.getLocalUserInfo(userId));
            SqlFormat sqlf = new SqlFormat("notifynum = :1 and active = :2");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notificationName);
            sqlf.setBoolean(2, true);
            set.setWhere(sqlf.format());
            if (set.isEmpty()) break block8;
            MboSetRemote nuSet = set.getMbo(0).getMboSet("NOTIFYUSER");
            sqlf = new SqlFormat("userid = :1");
            sqlf.setObject(1, "ISNOTIFYUSER", "USERID", userId);
            nuSet.setWhere(sqlf.format());
            if (nuSet.isEmpty()) break block8;
            MboSetRemote nSet = nuSet.getMbo(0).getMboSet("USERNOTIFICATION");
            sqlf = new SqlFormat("active = :1");
            sqlf.setBoolean(1, true);
            nSet.setWhere(sqlf.format());
            nSet.reset();
            String string2 = this.compressMessage(NotifyXMLUtils.getNotificationIds(nSet), session);
            NotifyUtil.closeAndCleanup(set);
            return string2;
        }
        try {
            string = null;
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e2));
                }
                catch (MXException e3) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e3);
                    throw new NotifyFault(e3);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(set);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(set);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getNotificationDefinitions", operationName="getNotificationDefinitions")
    public String getNotificationDefinitions(String sessionId, UserInfo userInfo) throws NotifyFault {
        String string;
        MboSetRemote set;
        block9: {
            List<String> sessionProfiles;
            String userId;
            SessionInfo session;
            block8: {
                session = SessionManager.getValidNotifySession(sessionId, userInfo);
                userId = session.getUserId();
                set = null;
                set = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
                sessionProfiles = session.getProfilesAsList();
                if (!sessionProfiles.isEmpty()) break block8;
                String string2 = null;
                NotifyUtil.closeAndCleanup(set);
                return string2;
            }
            SqlFormat sqlf = new SqlFormat("userid = :1 and notifyid in (" + DataUtils.formNotifyIdQuery(sessionProfiles) + ")");
            sqlf.setObject(1, "ISNOTIFYUSER", "USERID", userId);
            set.setWhere(sqlf.format());
            if (set.isEmpty()) break block9;
            string = this.compressMessage(NotifyXMLUtils.getNotificationDefinitions(set), session);
            NotifyUtil.closeAndCleanup(set);
            return string;
        }
        try {
            string = null;
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e2));
                }
                catch (MXException e3) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e3);
                    throw new NotifyFault(e3);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(set);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(set);
        return string;
    }

    @WebMethod(action="getRelease", operationName="getRelease")
    public String getRelease() {
        return NotifyUtil.getRelease();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getNotificationMetaData", operationName="getNotificationMetaData")
    public String getNotificationMetaData(String sessionId, String notificationName, UserInfo userInfo) throws NotifyFault {
        String string;
        MboSetRemote set;
        block8: {
            if (this.isNullOrEmpty(notificationName)) {
                throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
            }
            SessionInfo session = SessionManager.getValidNotifySessionForProfile(sessionId, notificationName, userInfo);
            set = null;
            set = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("notifynum = :1");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notificationName);
            set.setWhere(sqlf.format());
            if (set.isEmpty()) break block8;
            String string2 = this.compressMessage(((NotifyRemote)set.getMbo(0)).getMetaData(), session);
            NotifyUtil.closeAndCleanup(set);
            return string2;
        }
        try {
            string = null;
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "remoteError", (Throwable)e2));
                }
                catch (MXException e3) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e3);
                    throw new NotifyFault(e3);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(set);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(set);
        return string;
    }

    @WebMethod(action="setPushOptions", operationName="setPushOptions")
    public void setPushOptions(String sessionId, String deviceId, String appName, boolean playSound, boolean displayMessage, boolean displayBadge) throws NotifyFault {
        LOGGER.warn((Object)"Method 'setPushOptions' is deprecated");
    }

    @WebMethod(action="registerDeviceForPush", operationName="registerDeviceForPush")
    public void registerDeviceForPush(String sessionId, String deviceId, String appName, String token, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        if (deviceId == null || deviceId.trim().length() == 0) {
            deviceId = session.getDeviceSerialNumber();
        }
        Object regSet = null;
        try {
            new PushRegisterRequest(session, deviceId, appName, token).invoke();
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw NotifyFault.from(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="unregisterDevice", operationName="unregisterDevice")
    public void unregisterDeviceForPush(String sessionId, String token, String appName, UserInfo userInfo) throws NotifyFault {
        SqlFormat sqlf;
        MboSetRemote regSet;
        SessionInfo session;
        block14: {
            session = SessionManager.getValidNotifySession(sessionId, userInfo);
            regSet = null;
            regSet = MXServer.getMXServer().getMboSet("ISPUSHREG", MXServer.getMXServer().getSystemUserInfo());
            sqlf = new SqlFormat("appname = :1");
            sqlf.setObject(1, "ISPUSHREG", "APPNAME", appName);
            regSet.setWhere(sqlf.format());
            regSet.reset();
            if (!regSet.isEmpty()) break block14;
            NotifyUtil.closeAndCleanup(regSet);
            return;
        }
        try {
            MboRemote reg = regSet.moveFirst();
            while (reg != null) {
                block17: {
                    String notificationName;
                    block16: {
                        MboSetRemote deviceSet;
                        block15: {
                            notificationName = reg.getString("NOTIFY.NOTIFYNUM");
                            if (!session.isValidForProfile(notificationName)) break block16;
                            deviceSet = null;
                            try {
                                deviceSet = MXServer.getMXServer().getMboSet("ISPUSHDEVICE", MXServer.getMXServer().getSystemUserInfo());
                                sqlf = new SqlFormat("pushregid = :1");
                                sqlf.setLong(1, reg.getUniqueIDValue());
                                deviceSet.setWhere(sqlf.format());
                                deviceSet.reset();
                                if (deviceSet.isEmpty()) break block15;
                                ArrayList<Long> ids = new ArrayList<Long>();
                                MboRemote device = null;
                                while ((device = deviceSet.getMbo(0)) != null) {
                                    if (!device.isNull("TOKEN") && device.getString("TOKEN").equals(token)) {
                                        ids.add(device.getUniqueIDValue());
                                    }
                                    deviceSet.remove(0);
                                }
                                for (Long id : ids) {
                                    deviceSet.setWhere("");
                                    deviceSet.reset();
                                    MboRemote deleteMbo = deviceSet.getMboForUniqueId(id.longValue());
                                    if (deleteMbo == null) continue;
                                    deleteMbo.delete();
                                    deviceSet.save();
                                }
                            }
                            catch (Throwable throwable) {
                                NotifyUtil.closeAndCleanup(deviceSet);
                                throw throwable;
                            }
                        }
                        NotifyUtil.closeAndCleanup(deviceSet);
                        break block17;
                    }
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Skipping push deregistration for appName + " + appName + ", profile " + notificationName + ". Session " + sessionId + " is not authorized for this profile"));
                    }
                }
                reg = regSet.moveNext();
            }
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    throw new NotifyFault(e2);
                }
                catch (MXException e3) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e3);
                    throw new NotifyFault(e3);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(regSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(regSet);
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WebMethod(action="sendFile", operationName="sendFile")
    public String sendFile(String sessionId, long userNotificationId, String fragment, String fileId, String docType, String fileName, String description, boolean complete, boolean isCompressed, UserInfo maxUserInfo) throws NotifyFault {
        String string;
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, maxUserInfo);
        MboSetRemote userNotificationSet = null;
        MboSetRemote fileFragmentSet = null;
        FileFragmentRemote fileFragment = null;
        fileName = this.sanitizeFileName(fileName);
        try {
            UserInfo userInfo = NotifyUtil.getLocalUserInfo(session.getUserId());
            fileFragmentSet = MXServer.getMXServer().getMboSet("ISFILEFRAGMENT", userInfo);
            UserNotificationRemote userNotification = null;
            if (userNotificationId > 0L) {
                userNotificationSet = MXServer.getMXServer().getMboSet("ISUSERNOTIFICATION", userInfo);
                userNotification = (UserNotificationRemote)userNotificationSet.getMboForUniqueId(userNotificationId);
                if (userNotification == null) {
                    Object[] args = new String[]{String.valueOf(userNotificationId)};
                    throw new MXApplicationException("informer", "missingNotification", args);
                }
                String notificationName = userNotification.getMboSet(SERVICE_NAME).getMbo(0).getString("NOTIFYNUM");
                if (!session.isValidForProfile(notificationName)) {
                    throw new NotifyFault("[informer:unauthorizedSession]");
                }
            }
            if (fileId == null || fileId.trim().length() <= 0) {
                SendFileValidationManager.validateFileToReceive(session, docType, fileName);
                fileId = UUID.randomUUID().toString();
                fileFragment = (FileFragmentRemote)fileFragmentSet.add();
                fileFragment.setValue("FILEID", fileId);
                fileFragment.setValue("DOCTYPE", docType);
                fileFragment.setValue("DESCRIPTION", description);
                fileFragment.setValue("FILENAME", fileName);
                if (userNotification != null) {
                    fileFragment.setValue("OWNER", userNotification.getMainObject().getName());
                }
                fileFragment.setValue("USERNOTIFICATIONID", userNotificationId);
            } else {
                SqlFormat sqlf = new SqlFormat("fileid = :1");
                sqlf.setObject(1, "ISFILEFRAGMENT", "FILEID", fileId);
                fileFragmentSet.setWhere(sqlf.format());
                fileFragmentSet.reset();
                if (fileFragmentSet.isEmpty()) {
                    Object[] args = new String[]{fileId};
                    throw new MXApplicationException("informer", "fileIdNotFound", args);
                }
                fileFragment = (FileFragmentRemote)fileFragmentSet.getMbo(0);
            }
            byte[] data = Base64.decodeBase64(fragment);
            if (isCompressed) {
                data = NotifyXMLUtils.decompressMessage(data);
            }
            if (fileFragment.isNull("DATA")) {
                fileFragment.setValue("DATA", data);
            } else {
                byte[] existingData = fileFragment.getBytes("DATA");
                byte[] buffer = new byte[existingData.length + data.length];
                System.arraycopy(existingData, 0, buffer, 0, existingData.length);
                System.arraycopy(data, 0, buffer, existingData.length, data.length);
                fileFragment.setValue("DATA", buffer);
            }
            fileFragmentSet.save();
            if (complete) {
                long docInfoId = SendFileValidationManager.validateAndFinalizeReceivedFile(session, docType, fileName, fileFragment);
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setGroupingUsed(false);
                fileId = nf.format(docInfoId);
                long fileFragmentId = fileFragment.getUniqueIDValue();
                MboUtil.deleteSingleMbo(userInfo, "ISFILEFRAGMENT", fileFragmentId);
            }
            string = fileId;
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    throw new NotifyFault(e2);
                }
                catch (MXException e3) {
                    throw new NotifyFault(e3);
                }
                catch (IOException e4) {
                    throw new NotifyFault(e4);
                }
                catch (RuntimeException e5) {
                    throw new NotifyFault(e5);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(fileFragmentSet);
                NotifyUtil.closeAndCleanup(userNotificationSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(fileFragmentSet);
        NotifyUtil.closeAndCleanup(userNotificationSet);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WebMethod(action="recordInstrumentData", operationName="recordInstrumentData")
    public String recordInstrumentData(String sessionId, String xml, boolean isCompressed, UserInfo userInfo) throws NotifyFault, RemoteException {
        String string;
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote deviceSet = null;
        try {
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
            DeviceRemote device = (DeviceRemote)session.getDevice(deviceSet);
            if (device == null) {
                throw new NotifyFault((MXException)new MXApplicationException("informer", "missingDevice"));
            }
            if (isCompressed) {
                xml = NotifyXMLUtils.decompressMessage(xml);
            }
            StringReader sr = new StringReader(xml);
            InstrumentData data = (InstrumentData)InformerObjectSerializer.getInstance().deserialize(sr);
            String className = MXServer.getMXServer().getProperty("informer.instrumentcollector", "com.interlocsolutions.maximo.notify.InstrumentCollectorImpl");
            if (className == null || className.trim().length() == 0) {
                className = "com.interlocsolutions.maximo.notify.InstrumentCollectorImpl";
            }
            InstrumentCollector collector = null;
            try {
                collector = (InstrumentCollector)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException e) {
                NotifyConstants.INFORMER_LOGGER.warn((Object)e);
            }
            catch (InstantiationException e) {
                NotifyConstants.INFORMER_LOGGER.warn((Object)e);
            }
            catch (IllegalAccessException e) {
                NotifyConstants.INFORMER_LOGGER.warn((Object)e);
            }
            if (collector == null) {
                collector = new InstrumentCollectorImpl();
            }
            String retVal = collector.recordInstrumentData(device, data);
            device.setValue("INSTRUMENTREQPENDING", false);
            device.setValue("INSTRUMENTATIONFETCHED", false);
            deviceSet.save();
            string = retVal;
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (JAXBException e3) {
                    Object[] args = new String[]{"InstrumentData", e3.getMessage()};
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "jaxberror", args));
                }
                catch (XMLStreamException e4) {
                    Object[] args = new String[]{"InstrumentData", e4.getMessage()};
                    throw new NotifyFault((MXException)new MXApplicationException("informer", "jaxberror", args));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(deviceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
        return string;
    }

    @Override
    @WebMethod(action="getUserProfile", operationName="getUserProfile")
    public String getUserProfile(String sessionId, UserInfo userInfo) throws NotifyFault, RemoteException {
        try {
            SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
            UserProfile userProfile = new GetUserProfileRequest(session).invoke();
            return InformerObjectSerializer.getInstance().serialize(userProfile, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"UserProfile", e.getMessage()};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "jaxberror", args));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getLogLevel", operationName="getLogLevel")
    public String getLogLevel(String sessionId, UserInfo userInfo) throws NotifyFault {
        String string;
        MboSetRemote deviceSet;
        block6: {
            String loglevel;
            SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
            deviceSet = null;
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
            MboRemote device = session.getDevice(deviceSet);
            if (device == null) break block6;
            String string2 = loglevel = device.getString("LOGLEVEL");
            NotifyUtil.closeAndCleanup(deviceSet);
            return string2;
        }
        try {
            string = "INFO";
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(deviceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="confirmLogLevel", operationName="confirmLogLevel")
    public void confirmLogLevel(String sessionId, String logLevel, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote deviceSet = null;
        try {
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
            MboRemote device = session.getDevice(deviceSet);
            if (device.isNull("CURRENTLOGLEVEL") || !device.getString("CURRENTLOGLEVEL").equals(logLevel)) {
                device.setValue("CURRENTLOGLEVEL", logLevel);
                device.setValue("CURRENTLOGLEVELDATE", MXServer.getMXServer().getDate());
                device.setValue("LOGFETCHEDBYPOLL", false);
                deviceSet.save();
            }
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(deviceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getServerRequests", operationName="getServerRequests")
    public String getServerRequests(String sessionId, UserInfo userInfo) throws NotifyFault {
        String string;
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote deviceSet = null;
        try {
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
            MboRemote device = session.getDevice(deviceSet);
            ServerRequests requests = new ServerRequests();
            if (device != null) {
                MboSetRemote deviceLogSet = device.getMboSet("$isdevicelog", "ISDEVICELOG", "deviceid = :deviceid and status = 'PENDING'");
                deviceLogSet.reset();
                MboRemote deviceLog = deviceLogSet.moveFirst();
                while (deviceLog != null) {
                    requests.addRequest(new ServerRequest(deviceLog.getString("TYPE"), deviceLog.getDate("REQUESTLOGDATE")));
                    deviceLog = deviceLogSet.moveNext();
                }
                if (device.getBoolean("INSTRUMENTREQPENDING")) {
                    requests.addRequest(new ServerRequest("INSTRUMENTATION", MXServer.getMXServer().getDate()));
                }
            }
            string = InformerObjectSerializer.getInstance().serialize(requests, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (JAXBException e3) {
                    throw new NotifyFault((Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(deviceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="sendDiagnostics", operationName="sendDiagnostics")
    public void sendDiagnostics(String sessionId, String data, String type, boolean isCompressed, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote deviceSet = null;
        try {
            deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", NotifyUtil.getLocalUserInfo(session.getUserId()));
            MboRemote device = session.getDevice(deviceSet);
            if (device == null) {
                Object[] args = new String[]{session.getDeviceSerialNumber()};
                throw new MXApplicationException("informer", "missingDevice", args);
            }
            MboRemote deviceLog = null;
            SqlFormat sqlf = new SqlFormat("type = :1 and deviceid = :2 and status = 'PENDING'");
            sqlf.setObject(1, "ISDEVICELOG", "TYPE", type);
            sqlf.setLong(2, device.getUniqueIDValue());
            MboSetRemote deviceLogSet = device.getMboSet("$isdevicelog", "ISDEVICELOG", sqlf.format());
            deviceLogSet.setWhere(sqlf.format());
            if (deviceLogSet.isEmpty()) {
                deviceLog = device.getMboSet("DEVICELOG").add();
                deviceLog.setValue("TYPE", type);
            } else {
                deviceLog = deviceLogSet.getMbo(0);
            }
            if (isCompressed) {
                data = NotifyXMLUtils.decompressMessage(data);
            }
            if (data.trim().length() == 0) {
                deviceLog.setValue("STATUS", "NA");
            } else if ("LOG".equals(type)) {
                deviceLog.setValue("LOG", data);
            } else if ("SCREENSHOT".equals(type)) {
                deviceLog.setValue("LOG", data);
                MboSetRemote imglibSet = deviceLog.getMboSet("IMGLIB");
                MboRemote imglib = null;
                imglib = imglibSet.isEmpty() ? imglibSet.add() : imglibSet.getMbo(0);
                imglib.setValue("IMAGENAME", "SCREENSHOT");
                imglib.setValue("MIMETYPE", "image/jpeg");
                imglib.setValue("IMAGE", Base64.decodeBase64(data));
            }
            String[] profiles2 = session.getProfilesAsArray();
            String res = "";
            for (String profile : profiles2) {
                res = res + (res.length() > 0 ? ", " : "") + profile;
            }
            deviceLog.setValue("PROFILES", res);
            deviceLog.setValue("SESSIONID", sessionId);
            deviceLog.setValue("STATUS", "COMP");
            deviceLog.setValue("LOGDATE", MXServer.getMXServer().getDate());
            deviceSet.save();
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(deviceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
    }

    @WebMethod(action="getResubmittedErrors", operationName="getResubmittedErrors")
    public String getResubmittedErrors(String sessionId, String xml, UserInfo userInfo) throws NotifyFault {
        if (xml == null) {
            return null;
        }
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        MboSetRemote notifyHistorySet = null;
        try {
            StringReader sr = new StringReader(xml);
            CommandErrors errors = (CommandErrors)InformerObjectSerializer.getInstance().deserialize(sr);
            List<String> sessionProfiles = session.getProfilesAsList();
            if (sessionProfiles.isEmpty()) {
                String string = null;
                return string;
            }
            SqlFormat sqlf = new SqlFormat("guid = :1 and inexecution = :2 and notifyid in (" + DataUtils.formNotifyIdQuery(sessionProfiles) + ")");
            for (int i = 0; i < sessionProfiles.size(); ++i) {
                sqlf.setObject(i + 2, "ISNOTIFY", "NOTIFYNUM", sessionProfiles.get(i));
            }
            notifyHistorySet = MXServer.getMXServer().getMboSet("ISCOMMANDHISTORY", MXServer.getMXServer().getSystemUserInfo());
            CommandErrors returnErrors = new CommandErrors();
            List<CommandError> commandErrors = errors.getErrors();
            if (commandErrors != null) {
                for (CommandError ce : commandErrors) {
                    if (ce.getGUID() == null) continue;
                    sqlf.setObject(1, "ISCOMMANDHISTORY", "GUID", ce.getGUID());
                    sqlf.setInt(2, CommandUtilities.ExecutionStatus.SUCCEEDED.getValue());
                    notifyHistorySet.setWhere(sqlf.format());
                    notifyHistorySet.reset();
                    if (notifyHistorySet.isEmpty()) continue;
                    returnErrors.addError(ce);
                }
            }
            String returnMessage = InformerObjectSerializer.getInstance().serialize(returnErrors, InformerObjectSerializer.MARSHAL_PPRINT);
            String string = this.compressMessage(returnMessage, session);
            NotifyUtil.closeAndCleanup(notifyHistorySet);
            return string;
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (JAXBException e) {
            throw new NotifyFault((Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            throw new NotifyFault(e);
        }
        finally {
            NotifyUtil.closeAndCleanup(notifyHistorySet);
        }
    }

    @WebMethod(action="getAttachedDocument", operationName="getAttachedDocument")
    public String getAttachedDocument(String sessionId, long docInfoId, long offset, int length, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getValidNotifySession(sessionId, userInfo);
        try {
            AttachedDocumentProvider adp;
            AttachedDocumentFragment ad;
            GetAttachedDocumentValidationManager.validateGetAttachedDocument(session, docInfoId);
            String provider = MXServer.getMXServer().getProperty("informer.attacheddocument.provider");
            if (provider == null || provider.trim().length() == 0) {
                provider = "com.interlocsolutions.maximo.notify.util.DefaultAttachedDocumentProvider";
            }
            if ((ad = (adp = (AttachedDocumentProvider)Class.forName(provider).newInstance()).getAttachedDocumentFragment(docInfoId, offset, length)) == null) {
                NotifyFault nf = new NotifyFault(AttachedDocumentProvider.ERROR_CODE.DOCINFO_NOT_FOUND.toString());
                nf.setFaultCodeAsString(AttachedDocumentProvider.ERROR_CODE.DOCINFO_NOT_FOUND.toString());
                throw nf;
            }
            return this.compressMessage(InformerObjectSerializer.getInstance().serialize(ad), session);
        }
        catch (NotifyFault f) {
            throw f;
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"Unexpected error getting attached document:", (Throwable)e);
            throw new NotifyFault(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="sendTestPushMessage", operationName="sendTestPushMessage")
    public void sendTestPushMessage(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        block11: {
            if (this.isNullOrEmpty(profile)) {
                throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
            }
            session = SessionManager.getValidNotifySessionForProfile(sessionId, profile, userInfo);
            deviceSet = null;
            notifySet = null;
            try {
                deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", MXServer.getMXServer().getSystemUserInfo());
                device = session.getDevice(deviceSet);
                if (device == null) ** GOTO lbl39
                pushDeviceSet = device.getMboSet("PUSHDEVICE");
                if (!pushDeviceSet.isEmpty()) {
                    while ((pushDevice = (PushDevice)pushDeviceSet.moveNext()) != null) {
                        if (!pushDevice.getString("PUSHREG.NOTIFY.NOTIFYNUM").equalsIgnoreCase(profile)) continue;
                        pushDevice.pushTestMessage(null);
                        break block11;
                    }
                }
                ** GOTO lbl-1000
            }
            catch (RemoteException e) {
                throw new NotifyFault(e);
            }
            catch (MXException e) {
                throw new NotifyFault(e);
            }
            catch (Throwable var11_17) {
                NotifyUtil.closeAndCleanup(deviceSet);
                NotifyUtil.closeAndCleanup(notifySet);
                throw var11_17;
            }
        }
        NotifyUtil.closeAndCleanup(deviceSet);
        NotifyUtil.closeAndCleanup(notifySet);
        return;
lbl-1000:
        // 1 sources

        {
            notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            sqlf = new SqlFormat("notifynum = :1 and active = 1");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
            notifySet.setWhere(sqlf.format());
            if (notifySet.isEmpty()) {
                args = new String[]{profile};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "invalidTestPushProfile", args));
            }
            args = new String[]{profile};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "errorTestMessageNoDevice", args));
lbl39:
            // 1 sources

            notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            sqlf = new SqlFormat("notifynum = :1 and active = 1");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
            notifySet.setWhere(sqlf.format());
            if (notifySet.isEmpty()) {
                args = new String[]{profile};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "invalidTestPushProfile", args));
            }
            args = new String[]{profile};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "errorTestMessageNoDevice", args));
        }
    }

    @Override
    public void purgeUnsupportedLanguage() throws RemoteException {
        this.notifyServiceCompanion.purgeUnsupportedLanguage();
    }

    @Override
    public void activateNow(MboRemote profile) throws MXException, RemoteException {
        this.notifyServiceCompanion.activateNow(profile);
    }

    @Override
    public void initializeAndActivate(MboRemote profile) throws MXException, RemoteException {
        this.notifyServiceCompanion.initializeAndActivate(profile);
    }

    @Override
    public boolean allCatalogsInitialized(MboRemote profile) throws MXException, RemoteException {
        return this.notifyServiceCompanion.allCatalogsInitialized(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyMaximoGroups(MboRemote profile, MboSetRemote groupUsers, MboSetRemote groupSet) throws MXException, RemoteException {
        int foundUserCount = 0;
        Vector groups = groupSet.getSelection();
        MboSetRemote checkSet = null;
        try {
            checkSet = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("notifyid = :1 and userid = :2");
            sqlf.setLong(1, profile.getUniqueIDValue());
            for (MboRemote group : groups) {
                MboSetRemote userSet = group.getMboSet("GROUPUSER");
                MboRemote user = userSet.moveFirst();
                while (user != null) {
                    MboRemote groupUser;
                    String userId = user.getString("MAXUSER.USERID");
                    boolean foundUser = false;
                    if (groupUsers != null) {
                        groupUser = groupUsers.moveFirst();
                        while (groupUser != null) {
                            if (userId.equalsIgnoreCase(groupUser.getString("NOTIFYUSER.USERID"))) {
                                if (groupUser.toBeDeleted()) {
                                    groupUser.undelete();
                                    ++foundUserCount;
                                    break;
                                }
                                foundUser = true;
                            }
                            groupUser = groupUsers.moveNext();
                        }
                    }
                    if (!foundUser) {
                        sqlf.setObject(2, "ISNOTIFYUSER", "USERID", userId);
                        checkSet.setWhere(sqlf.format());
                        checkSet.reset();
                        if (!checkSet.isEmpty()) {
                            groupUser = groupUsers.add();
                            groupUser.setValue("RELATEDUSERID", user.getString("MAXUSER.USERID"));
                            ++foundUserCount;
                        }
                    }
                    user = userSet.moveNext();
                }
            }
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(checkSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(checkSet);
        return foundUserCount;
    }

    private String compressMessage(String message2, SessionInfo session) throws RemoteException, MXException {
        if (session.supportsCompressions() && (long)message2.getBytes().length > this.getCompressionThreshold()) {
            message2 = "<compressed>\n" + NotifyXMLUtils.compressMessage(message2) + "\n</compressed>";
        }
        return message2;
    }

    private long getCompressionThreshold() throws RemoteException, MXException {
        String val = MXServerFactory.getMXServer().getProperty("informer.compression.threshold", "4096");
        try {
            return Long.valueOf(val);
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            return 4096L;
        }
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userHasAccess(String notifyNum, String userId) throws RemoteException, MXException {
        MboSetRemote set = null;
        try {
            set = MXServerFactory.getMboSet("ISNOTIFY");
            SqlFormat sqlf = new SqlFormat("notifynum = :1 and active = :yes");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notifyNum);
            set.setWhere(sqlf.format());
            if (set.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.userHasAccess((NotifyRemote)set.getMbo(0), userId);
            return bl;
        }
        finally {
            NotifyUtil.closeAndCleanup(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userHasAccess(NotifyRemote notify, String userId) throws RemoteException, MXException {
        MboSetRemote userSet = null;
        try {
            userSet = notify.getMboSet("NOTIFYUSER");
            SqlFormat sqlf = new SqlFormat("userid = :1");
            sqlf.setObject(1, "ISNOTIFYUSER", "USERID", userId);
            userSet.setWhere(sqlf.format());
            userSet.reset();
            boolean bl = !userSet.isEmpty();
            return bl;
        }
        finally {
            NotifyUtil.closeAndCleanup(userSet);
        }
    }

    private String sanitizeFileName(String fileName) {
        File file = new File(fileName);
        return file.getName();
    }

    public static enum PlatformType {
        APPLE,
        ANDROID,
        WINDOWS,
        WINMO;

    }
}

