/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.NotifyObjectRemote;
import com.interlocsolutions.maximo.notify.NotifyRemote;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.util.BitFlag;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class NotifyObject
extends Mbo
implements NotifyObjectRemote {
    private static final long serialVersionUID = -1463379550344766901L;

    public NotifyObject(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void add() throws RemoteException, MXException {
        MboRemote owner = this.getOwner();
        if (owner != null && !owner.getName().equals("ISNOTIFY")) {
            throw new MXApplicationException("mxnotify", "onlyAddedFromNotify");
        }
        super.add();
        this.setValue("NOTIFYID", owner.getString("NOTIFYID"));
        this.setValue("OBJORDER", 0);
        if (this.getThisMboSet().count() == 0) {
            this.setValue("ISMAIN", true, 2L);
            this.setFlag(7L, true);
        } else {
            this.setValue("OBJORDER", this.getThisMboSet().count());
        }
    }

    public void delete(long flag) throws RemoteException, MXException {
        BitFlag bf = new BitFlag(flag);
        if (!this.isFlagSet(1L) && this.isFlagSet(7L) && !bf.isFlagSet(2L)) {
            throw new MXApplicationException("informer", "cannotDeleteBaseObj");
        }
        super.delete(flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYATTRIBUTE"), flag);
        this.modify();
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        this.getMboSet("NOTIFYATTRIBUTE").undeleteAll();
    }

    public void init() throws MXException {
        super.init();
        try {
            if (!this.toBeAdded() && this.getBoolean("ISMAIN")) {
                String[] fields = new String[]{"OBJECTNAME", "PARENT", "RELATIONSHIP", "OBJORDER", "RECURSIVE"};
                this.setFieldFlag(fields, 7L, true);
            } else if (!this.toBeAdded()) {
                String[] fields = new String[]{"OBJECTNAME", "PARENT", "RELATIONSHIP", "RECURSIVE"};
                this.setFieldFlag(fields, 7L, true);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void modify() throws MXException, RemoteException {
        super.modify();
        MboRemote owner = this.getOwner();
        if (owner != null && owner instanceof NotifyRemote && owner.isBasedOn("ISNOTIFY") && owner.getLong("NOTIFYID") == this.getLong("NOTIFYID")) {
            ((NotifyRemote)owner).modify();
        }
    }
}

