/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import com.interlocsolutions.maximo.notify.xml.ServerInfo;
import com.interlocsolutions.maximo.notify.xml.SupportedLanguage;
import com.interlocsolutions.maximo.notify.xml.SupportedLanguages;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jws.WebMethod;
import javax.xml.bind.JAXBException;
import psdi.security.AdminModeManager;
import psdi.server.AppService;
import psdi.server.MXServer;
import psdi.server.MaxVarServiceRemote;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class NotifyInfoService
extends AppService {
    private static final long serialVersionUID = -8670010282633429773L;
    private static AdminModeManager ad = null;

    public NotifyInfoService() throws RemoteException {
    }

    public NotifyInfoService(MXServer mxServer) throws RemoteException {
        super(mxServer);
    }

    @WebMethod(action="getSystemLanguages", operationName="getSystemLanguages")
    public String getSystemLanguages() throws NotifyFault {
        try {
            String baseLang = MXServer.getMXServer().getBaseLang();
            String[][] langList = MXServer.getMXServer().getLanguageList();
            Collection<String> informerLangs = NotifyUtil.getLangCodes();
            ArrayList<SupportedLanguage> languages = new ArrayList<SupportedLanguage>();
            for (String[] langInfo : langList) {
                String langCode = langInfo[0].toUpperCase();
                if (!informerLangs.contains(langCode)) continue;
                String langName = langInfo[1];
                Boolean isBaseLang = baseLang.equals(langCode) ? Boolean.valueOf(true) : null;
                languages.add(new SupportedLanguage(langCode, langName, isBaseLang));
            }
            SupportedLanguages sl = new SupportedLanguages();
            sl.setLanguages(languages);
            return NotifyXMLUtils.getLanguages(sl);
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"An error occurred while getting languages.");
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"An error occurred while while getting languages.");
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
    }

    @WebMethod(action="getVersion", operationName="getVersion")
    public String getVersion() throws NotifyFault {
        try {
            if (ad == null) {
                ad = (AdminModeManager)MXServer.getMXServer().getFromMaximoCache("ADMINMODE");
            }
            if (ad != null && (ad.isAdminModePendingThisInstance() || ad.isAdminModeOnThisInstance())) {
                NotifyFault nf = new NotifyFault("Admin mode is either pending or active.");
                nf.setFaultCodeAsString("ADMIN_MODE");
                throw nf;
            }
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        return "6.4.1-rc.2";
    }

    @WebMethod(action="getServerInfo", operationName="getServerInfo")
    public String getServerInfo() throws NotifyFault {
        try {
            if (ad == null) {
                ad = (AdminModeManager)MXServer.getMXServer().getFromMaximoCache("ADMINMODE");
            }
            MaxVarServiceRemote mvs = (MaxVarServiceRemote)MXServer.getMXServer().lookup("MAXVARS");
            String instanceID = mvs.getString("INFORMERINSTID", null);
            ServerInfo si = new ServerInfo("6.4.1-rc.2", instanceID);
            try {
                String maximoVersion = MaximoVersion.Companion.getSystemVersion().majorVersion + "." + MaximoVersion.Companion.getSystemVersion().minorVersion + "." + MaximoVersion.Companion.getSystemVersion().modLevel + "." + MaximoVersion.Companion.getSystemVersion().patch;
                si.setMaximoVersion(maximoVersion);
            }
            catch (Exception e) {
                si.setMaximoVersion("UNKNOWN");
            }
            if (ad != null && (ad.isAdminModePendingThisInstance() || ad.isAdminModeOnThisInstance())) {
                si.setStatus("ADMIN_MODE");
            } else {
                si.setStatus("ACTIVE");
            }
            return InformerObjectSerializer.getInstance().serialize(si, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Session", e.getMessage()};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "jaxberror", args));
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
    }
}

