/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.Notify;
import com.interlocsolutions.maximo.notify.push.PushQueueRepo;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobRepo;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobRepo;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.SqlFormat;
import psdi.txn.MXTransaction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lcom/interlocsolutions/maximo/notify/NotifyDeleteTransactable;", "Lcom/interlocsolutions/maximo/notify/DeleteTransactable;", "Lcom/interlocsolutions/maximo/notify/Notify;", "mbo", "(Lcom/interlocsolutions/maximo/notify/Notify;)V", "fireEventsAfterDBCommit", "", "p0", "Lpsdi/txn/MXTransaction;", "initializeDeleteRelatedMbos", "isinformer"})
public final class NotifyDeleteTransactable
extends DeleteTransactable<Notify> {
    public NotifyDeleteTransactable(@NotNull Notify mbo) {
        Intrinsics.checkNotNullParameter((Object)mbo, (String)"mbo");
        super((Mbo)mbo);
    }

    @Override
    protected void initializeDeleteRelatedMbos() {
        super.initializeDeleteRelatedMbos();
        this.addDeleteRelatedMbos("TRACKINGSUMMARY", 2L);
        this.addDeleteRelatedMbos("NOTIFYCOMMANDLOG", 2L);
        this.addDeleteRelatedMbos("ISCOMMANDHISTORY", "notifyid = :notifyid", 2L);
        this.addDeleteRelatedMbos("ISDEVICEATTRIBUTE", "notifynum = :notifynum", 2L);
        this.addDeleteRelatedMbos("ISTRACKING", "notifyid = :notifyid and catalogid is null and deviceid is null", 2L);
        this.addDeleteRelatedMbos("ISNOTIFYLISTENERREG", "notifyid = :notifyid", 2L);
    }

    @Override
    public void fireEventsAfterDBCommit(@Nullable MXTransaction p0) {
        super.fireEventsAfterDBCommit(p0);
        NotificationJobRepo.INSTANCE.discardJobsForProfile(((Notify)this.getParentMbo()).getLong("NOTIFYID"));
        ImmutableLongSet allCatalogIds = MboUtil.collectUniqueIds(((Notify)this.getParentMbo()).getUserInfo(), "ISCATALOG", new SqlFormat((MboRemote)this.getParentMbo(), "notifyid = :notifyid").format());
        for (Long catalogId : allCatalogIds) {
            Intrinsics.checkNotNullExpressionValue((Object)catalogId, (String)"catalogId");
            CatalogJobRepo.INSTANCE.discardJobsForCatalog(catalogId);
        }
        PushQueueRepo.INSTANCE.discardJobsFor((MboRemote)this.getParentMbo());
    }
}

