/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class NotifyCommandLog
extends Mbo {
    private static final long serialVersionUID = 2180949490149213718L;
    private static SimpleDateFormat df = new SimpleDateFormat();

    public NotifyCommandLog(MboSet ms) throws RemoteException {
        super(ms);
    }

    public MboRemote getMainObject() throws RemoteException, MXException {
        MboSetRemote objectSet = this.getMboSet("OBJECT", this.getString("OBJECTNAME"));
        return objectSet.getMboForUniqueId(this.getLong("RECORDID"));
    }

    public void save() throws RemoteException, MXException {
        if (this.toBeDeleted()) {
            this.undelete();
            this.setValue("ACTIVE", false, 2L);
        }
        super.save();
    }

    public void init() throws MXException {
        super.init();
        try {
            if (!this.isNull("ERRORDATE") && this.isNull("ERRORTIMESTAMP")) {
                this.setValue("ERRORTIMESTAMP", df.format(this.getDate("ERRORDATE")), 2L);
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }

    public void add() throws MXException, RemoteException {
        super.add();
        try {
            this.setValue("HOSTNAME", MXServer.getMXServer().getRegistryHostName());
            this.setValue("NODE", MXServer.getMXServer().getName());
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error while setting the command log host and server name.", t);
        }
    }

    static {
        df.applyPattern("yyyy-MM-dd HH:mm:ss");
    }
}

