/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.DeleteTransactableOwner;
import com.interlocsolutions.maximo.notify.NotifyCommandDeleteTransactable;
import com.interlocsolutions.maximo.notify.NotifyCommandRemote;
import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.commands.CommandRegistrar;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import com.interlocsolutions.maximo.notify.util.InformerCommandSerializer;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboSet;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotifyCommand
extends Mbo
implements NotifyCommandRemote,
DeleteTransactableOwner<NotifyCommandDeleteTransactable> {
    private NotifyCommandDeleteTransactable deleteTransactable;
    private static final long serialVersionUID = -8257865439410884039L;
    private static final MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    public NotifyCommand(MboSet ms) throws RemoteException {
        super(ms);
    }

    @Override
    public Command getCommand() throws RemoteException, MXException {
        if (!this.isNull("CLASSNAME")) {
            try {
                return (Command)InformerClassUtils.loadClass(this.getString("CLASSNAME")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return null;
            }
        }
        logger.error((Object)"The command does not have a class name specified and therefore cannot provide a command object");
        return null;
    }

    protected void save() throws MXException, RemoteException {
        if (!this.toBeDeleted()) {
            String sample;
            this.setValue("UPDATED", MXServer.getMXServer().getDate());
            try {
                Command o = this.getCommand();
                CommandRegistrar.populateObject(o);
                sample = InformerCommandSerializer.getInstance().serialize(this, o, InformerObjectSerializer.MARSHAL_PPRINT);
            }
            catch (Exception e) {
                logger.error((Object)e);
                sample = "";
            }
            this.setValue("SAMPLE", sample);
        }
        super.save();
    }

    public void delete(long accessModifier) throws MXException, RemoteException {
        super.delete(accessModifier);
        DeleteTransactable.onDelete(this);
        DeleteTransactable.resetDeleteAll(this.getMboSet("COMMANDLINK"), accessModifier);
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        DeleteTransactable.onUndelete(this);
        this.getMboSet("COMMANDLINK").undeleteAll();
    }

    @Override
    public void setDeleteTransactable(@Nullable NotifyCommandDeleteTransactable transactable) {
        this.deleteTransactable = transactable;
    }

    @Override
    @Nullable
    public NotifyCommandDeleteTransactable getDeleteTransactable() {
        return this.deleteTransactable;
    }

    @Override
    @NotNull
    public NotifyCommandDeleteTransactable newDeleteTransactable() {
        return new NotifyCommandDeleteTransactable(this);
    }
}

