/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.DeleteTransactableOwner;
import com.interlocsolutions.maximo.notify.NotifyDeleteTransactable;
import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobSqliteGeneration;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.MboMutator;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.ProfileAttribute;
import com.interlocsolutions.maximo.notify.xml.ProfileMetaData;
import com.interlocsolutions.maximo.notify.xml.ProfileObject;
import com.interlocsolutions.maximo.notify.xml.export.NotifyAssociatedApplicationExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyAttributeExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCatalogAttributeExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCatalogExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCatalogListenerExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCustomPropExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyGroupExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyObjectExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyOptionExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyProperty;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValueInfo;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class Notify
extends Mbo
implements NotifyRemote,
DeleteTransactableOwner<NotifyDeleteTransactable> {
    protected static final long serialVersionUID = 5652705219773485215L;
    private static MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    private NotifyDeleteTransactable deleteTransactable;

    public Notify(MboSet ms) throws RemoteException {
        super(ms);
    }

    private static void setValueIfDifferent(MboRemote mbo, String attrName, String value) throws RemoteException, MXException {
        Notify.setValueIfDifferent(mbo, attrName, value, 0L);
    }

    private static void setValueIfDifferent(MboRemote mbo, String attrName, String value, long flags) throws RemoteException, MXException {
        if (!mbo.getString(attrName).equals(value)) {
            mbo.setValue(attrName, value, flags);
        }
    }

    private static void setValueIfDifferent(MboRemote mbo, String attrName, boolean value) throws RemoteException, MXException {
        Notify.setValueIfDifferent(mbo, attrName, value, 0L);
    }

    private static void setValueIfDifferent(MboRemote mbo, String attrName, boolean value, long flags) throws RemoteException, MXException {
        if (mbo.getBoolean(attrName) != value) {
            mbo.setValue(attrName, value, flags);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void configureCatalog(MboRemote catalog, NotifyCatalogExport catalogDef, NotifyCatalogExport catalogDefParent) throws MXException, RemoteException {
        ((Catalog)catalog).childUpdating(false);
        MboMutator catalogMutator = new MboMutator(catalog, 2L);
        boolean isChildCatalog = catalogDef.isIschild();
        catalogMutator.setIfDifferent("ISCHILD", isChildCatalog);
        catalogMutator.setIfDifferent("CATALOG", catalogDef.getCatalog());
        catalogMutator.setIfDifferent("OBJECTNAME", catalogDef.getObjectName());
        catalogMutator.setIfDifferent("DESCRIPTION", catalogDef.getDescription());
        catalogMutator.setIfDifferent("WHERECLAUSE", catalogDef.getWhereClause());
        catalogMutator.setIfDifferent("CONDITIONNAME", catalogDef.getConditionName());
        catalogMutator.setIfDifferent("CONDITIONCLASS", catalogDef.getConditionClass());
        catalogMutator.setIfDifferent("CONDITIONEXPR", catalogDef.getConditionExpr());
        String partitionerClass = catalogDef.getPartitionerClass();
        String partitionByAttr = catalogDef.getPartitionByAttr();
        String partitionType = catalogDef.getPartitionType();
        if (partitionType != null && partitionType.trim().length() > 0) {
            if (!partitionType.equals(Catalog.PartitionType.UNPARTITIONED.toString()) && !partitionType.equals(Catalog.PartitionType.PARTITIONED.toString()) && !partitionType.equals(Catalog.PartitionType.BOTH.toString())) throw new MXApplicationException("informer", "partitionTypeNotSpecify");
            catalogMutator.setIfDifferent("PARTITIONTYPE", partitionType);
        } else if (partitionByAttr != null && partitionByAttr.trim().length() > 0 || partitionerClass != null && partitionerClass.trim().length() > 0) {
            catalogMutator.setIfDifferent("PARTITIONTYPE", Catalog.PartitionType.BOTH.toString());
        } else {
            catalogMutator.setIfDifferent("PARTITIONTYPE", Catalog.PartitionType.UNPARTITIONED.toString());
        }
        catalogMutator.setIfDifferent("PARTITIONERCLASS", partitionerClass);
        catalogMutator.setIfDifferent("PARTITIONBYATTR", partitionByAttr);
        String strategy = catalogDef.getStrategy();
        if (strategy == null || strategy.isEmpty() || strategy.equals(Catalog.Strategy.EVENT.toString())) {
            catalogMutator.setIfDifferent("STRATEGY", Catalog.Strategy.EVENT.toString());
            catalogMutator.setIfDifferent("dispatch", true);
        } else {
            if (!strategy.equals(Catalog.Strategy.MONITORING.toString())) throw new MXApplicationException("informer", "strategyNotSpecified");
            catalogMutator.setIfDifferent("STRATEGY", strategy);
            catalogMutator.setIfDifferent("dispatch", catalogDef.isDispatch());
        }
        if (isChildCatalog) {
            catalogMutator.setIfDifferent("PARENT", catalogDef.getParent());
            catalogMutator.setIfDifferent("PREFIX", catalogDef.getPrefix());
            catalogMutator.setIfDifferent("PRELOAD", catalogDefParent.isPreload());
            if (catalogDefParent.isPreload()) {
                catalogMutator.setIfDifferent("PRELOADTHRESHOLD", catalogDefParent.getThreshold());
                catalogMutator.setIfDifferent("PAGESIZE", catalogDefParent.getPagesize());
                return;
            } else {
                catalogMutator.setNullIfNotNull("PRELOADTHRESHOLD");
                catalogMutator.setNullIfNotNull("PAGESIZE");
            }
            return;
        } else {
            catalogMutator.setNullIfNotNull("PARENT");
            catalogMutator.setNullIfNotNull("PREFIX");
            catalogMutator.setIfDifferent("PRELOAD", catalogDef.isPreload());
            if (catalogDef.isPreload()) {
                catalogMutator.setIfDifferent("PRELOADTHRESHOLD", catalogDef.getThreshold());
                catalogMutator.setIfDifferent("PAGESIZE", catalogDef.getPagesize());
            } else {
                catalogMutator.setNullIfNotNull("PRELOADTHRESHOLD");
                catalogMutator.setNullIfNotNull("PAGESIZE");
            }
            ArrayList<Object> attrsToImport = new ArrayList<Object>(catalogDef.getAttributes());
            MboSetRemote attributeSet = catalog.getMboSet("CATALOGATTRIBUTES");
            Object attribute = attributeSet.moveFirst();
            while (attribute != null) {
                String string = attribute.getString("ATTRIBUTENAME");
                NotifyCatalogAttributeExport catalogAttribute = null;
                for (Object e : attrsToImport) {
                    if (!((NotifyCatalogAttributeExport)e).getAttributeName().contentEquals(string)) continue;
                    catalogAttribute = (NotifyCatalogAttributeExport)e;
                    break;
                }
                if (catalogAttribute == null) {
                    attribute.delete();
                } else {
                    attrsToImport.remove(catalogAttribute);
                }
                attribute = attributeSet.moveNext();
            }
            for (Object e : attrsToImport) {
                NotifyCatalogAttributeExport attribute2 = (NotifyCatalogAttributeExport)e;
                MboRemote attributeMbo = attributeSet.add();
                attributeMbo.setValue("ATTRIBUTENAME", attribute2.getAttributeName());
                attributeMbo.setValue("INCATALOG", attribute2.isInCatalog(), 2L);
                attributeMbo.setValue("INFILTER", attribute2.isInFilter(), 2L);
                attributeMbo.setValue("CANEDIT", attribute2.isCanEdit(), 2L);
            }
            ArrayList<NotifyCatalogListenerExport> listenersToImport = new ArrayList<NotifyCatalogListenerExport>(catalogDef.getListeners());
            MboSetRemote listenerSet = catalog.getMboSet("CATALOGLISTENER");
            MboRemote listener = listenerSet.moveFirst();
            while (listener != null) {
                void var12_18;
                Object var12_16 = null;
                for (NotifyCatalogListenerExport exportListener : listenersToImport) {
                    if (!listener.getString("OBJECTNAME").equals(exportListener.getObjectName())) continue;
                    NotifyCatalogListenerExport notifyCatalogListenerExport = exportListener;
                    break;
                }
                if (var12_18 != null) {
                    Notify.configureCatalogListener(listener, (NotifyCatalogListenerExport)var12_18);
                    listenersToImport.remove(var12_18);
                } else {
                    listener.delete();
                }
                listener = listenerSet.moveNext();
            }
            for (NotifyCatalogListenerExport notifyCatalogListenerExport : listenersToImport) {
                MboRemote listener2 = listenerSet.add();
                Notify.configureCatalogListener(listener2, notifyCatalogListenerExport);
            }
        }
    }

    private static void configureCatalogListener(MboRemote listener, NotifyCatalogListenerExport exportListener) throws MXException, RemoteException {
        new MboMutator(listener, 2L).setIfDifferent("OBJECTNAME", exportListener.getObjectName()).setIfDifferent("RELATIONSHIP", exportListener.getRelationship()).setIfDifferent("WHERECLAUSE", exportListener.getWhereClause());
    }

    public void add() throws RemoteException, MXException {
        super.add();
        this.setValue("ALLOWSTATUSCHANGE", true);
    }

    public void init() throws MXException {
        super.init();
        this.setFieldFlag("ACTIVE", 7L, true);
        if (!this.toBeAdded()) {
            this.setFieldFlag("NOTIFYNUM", 7L, true);
            this.setFieldFlag("APP", 7L, true);
        }
        try {
            if (!this.toBeAdded()) {
                if (this.getBoolean("ACTIVE")) {
                    this.setFieldFlag("ALTTRIGROOT", 7L, true);
                } else {
                    this.setFieldFlag("ALTTRIGROOT", 7L, false);
                }
            }
        }
        catch (RemoteException ex) {
            this.setFieldFlag("ALTTRIGROOT", 7L, true);
        }
        try {
            if (this.isNull("PROCESSNAME")) {
                this.setFieldFlag("ALLOWSTATUSCHANGE", 7L, false);
            } else {
                this.setFieldFlag("ALLOWSTATUSCHANGE", 7L, true);
            }
            if (!this.toBeAdded()) {
                this.setFieldFlag("ANONYMOUSUSER", 7L, !this.getBoolean("ANONYMOUSACCESS"));
                this.setFieldFlag("ANONYMOUSUSER", 128L, this.getBoolean("ANONYMOUSACCESS"));
            } else {
                this.setFieldFlag("ANONYMOUSUSER", 7L, true);
                this.setFieldFlag("ANONYMOUSUSER", 128L, false);
            }
        }
        catch (RemoteException e) {
            logger.warn((Object)e);
        }
    }

    public void delete(long flag) throws RemoteException, MXException {
        if (this.getBoolean("ACTIVE")) {
            throw new MXApplicationException("informer", "cannotDeleteActive");
        }
        super.delete(flag);
        DeleteTransactable.onDelete(this);
        DeleteTransactable.resetDeleteAll(this.getMboSet("PARENTCATALOG"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYOBJECT"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYOPTION"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYGROUP"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYCUSTOMPROP"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYCOMMANDLINK"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("APPDEPLOY"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("ALLNOTIFYUSER"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("PUSHREG"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("NOTIFYRESOURCE"), flag);
        DeleteTransactable.resetDeleteAll(this.getMboSet("ASSOCAPP"), flag);
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        DeleteTransactable.onUndelete(this);
        this.getMboSet("PARENTCATALOG").undeleteAll();
        this.getMboSet("NOTIFYOBJECT").undeleteAll();
        this.getMboSet("NOTIFYOPTION").undeleteAll();
        this.getMboSet("NOTIFYGROUP").undeleteAll();
        this.getMboSet("NOTIFYCUSTOMPROP").undeleteAll();
        this.getMboSet("NOTIFYCOMMANDLINK").undeleteAll();
        this.getMboSet("APPDEPLOY").undeleteAll();
        this.getMboSet("ALLNOTIFYUSER").undeleteAll();
        this.getMboSet("PUSHREG").undeleteAll();
        this.getMboSet("NOTIFYRESOURCE").undeleteAll();
        this.getMboSet("ASSOCAPP").undeleteAll();
    }

    @Override
    public void refreshNotifications() throws RemoteException, MXException {
        this.refreshNotifications(null);
    }

    @Override
    public void refreshNotifications(String userId) throws RemoteException, MXException {
        MboSetRemote notificationUserSet = this.getMboSet("NOTIFYUSER");
        if (userId != null) {
            SqlFormat sqlf = new SqlFormat("userid =:1");
            sqlf.setObject(1, "ISNOTIFYUSER", "USERID", userId);
            notificationUserSet.setWhere(sqlf.format());
            notificationUserSet.reset();
            MboRemote notifyUser = notificationUserSet.getMbo(0);
            if (notifyUser != null) {
                ((NotifyUserRemote)notifyUser).markForRefresh();
            }
        }
        MboUtil.visitMbos(MXServer.getMXServer().getSystemUserInfo(), notificationUserSet.getName(), notificationUserSet.getCompleteWhere(), new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote mbo) throws RemoteException, MXException {
                ((NotifyUserRemote)mbo).markForRefresh();
            }
        });
    }

    public void copyUsersToNotifyUsers(MboSetRemote userSet) throws MXException, RemoteException {
        MboSetRemote notifyUserSet = this.getMboSet("ALLNOTIFYUSER");
        String[] srcAttributes = new String[]{"userid"};
        String[] destAttributes = new String[]{"userid"};
        notifyUserSet.copy(userSet, srcAttributes, destAttributes);
    }

    public void copyCommandsToNotification(MboSetRemote commandSet) throws MXException, RemoteException {
        MboSetRemote notifyCommandLinkSet = this.getMboSet("NOTIFYCOMMANDLINK");
        String[] srcAttributes = new String[]{"notifycommandid"};
        String[] destAttributes = new String[]{"notifycommandid"};
        notifyCommandLinkSet.copy(commandSet, srcAttributes, destAttributes);
    }

    public void save() throws RemoteException, MXException {
        MboSetRemote objectSet;
        MboSetRemote resourceSet;
        MboSetRemote commandLinkSet;
        if (this.isNull("CLAUSENAME") && this.isNull("PROCESSNAME")) {
            throw new MXApplicationException("informer", "processOrWhereRequired");
        }
        if (this.toBeAdded()) {
            MboSetRemote catalogSet = this.getMboSet("Catalog");
            MboSetIterator catalogItr = new MboSetIterator(catalogSet);
            boolean needToGenerateISPROPERTIES = true;
            MboRemote catalog = catalogItr.moveFirst();
            while (catalog != null) {
                if (catalog.getString("CATALOG").equalsIgnoreCase("ISPROPERTIES")) {
                    needToGenerateISPROPERTIES = false;
                }
                catalog = catalogItr.moveNext();
            }
            if (needToGenerateISPROPERTIES) {
                catalog = catalogSet.add();
                catalog.setValue("CATALOG", "ISPROPERTIES");
                catalog.setValue("DESCRIPTION", "Informer System Properties");
                catalog.setValue("OBJECTNAME", "MAXPROPVALUE");
                catalog.setValue("WHERECLAUSE", "propname like 'informer.system.%' or propname like 'informer." + this.getString("NOTIFYNUM").toLowerCase() + ".%'");
                catalog.setValue("PARTITIONTYPE", Catalog.PartitionType.UNPARTITIONED.toString());
                MboSetRemote catalogAttributeSet = catalog.getMboSet("CATALOGATTRIBUTES");
                MboRemote catalogAttribute = catalogAttributeSet.add();
                catalogAttribute.setValue("ATTRIBUTENAME", "PROPNAME");
                catalogAttribute = catalogAttributeSet.add();
                catalogAttribute.setValue("ATTRIBUTENAME", "PROPVALUE");
            }
        }
        if (!(commandLinkSet = this.getMboSet("NOTIFYCOMMANDLINK")).isEmpty()) {
            int i = 0;
            if (!this.getBoolean("ANONYMOUSACCESS")) {
                MboRemote commandLink = commandLinkSet.getMbo(i++);
                while (commandLink != null) {
                    commandLink.setValue("ISANONYMOUS", false, 2L);
                    commandLink = commandLinkSet.getMbo(i++);
                }
            }
        }
        if (!(resourceSet = this.getMboSet("NOTIFYRESOURCE")).isEmpty()) {
            int i = 0;
            if (!this.getBoolean("ANONYMOUSACCESS")) {
                int count = resourceSet.count();
                MboRemote resource = resourceSet.getMbo(i++);
                while (resource != null) {
                    resource.setValue("ISANONYMOUS", false, 2L);
                    resource = resourceSet.getMbo(i++);
                }
            }
        }
        if (!(objectSet = this.getMboSet("NOTIFYOBJECT")).isEmpty()) {
            long maxOrder = 0L;
            MboRemote object = objectSet.moveFirst();
            while (object != null) {
                if (object.getLong("OBJORDER") > maxOrder) {
                    maxOrder = object.getLong("OBJORDER");
                }
                object = objectSet.moveNext();
            }
            object = objectSet.moveFirst();
            while (object != null) {
                if (object.getMboValueData("OBJORDER").isNull()) {
                    object.setValue("OBJORDER", ++maxOrder);
                }
                object = objectSet.moveNext();
            }
        }
        super.save();
    }

    @Override
    public void queueSqlDatabaseGeneration() throws RemoteException, MXException {
        if (this.getBoolean("GENERATESQLITE")) {
            NotifyConstants.INFORMER_CRQP_LOGGER.debug((Object)"queueSqlDatabaseGeneration");
            for (String langCode : NotifyUtil.getLangCodes()) {
                NotifyConstants.INFORMER_CRQP_LOGGER.debug((Object)("queueSqlDatabaseGeneration: langCode=" + langCode));
                JobConfig.getJobDispatcher().doSqliteGeneration(new EvalContext().setFlag(EvalFlags.INITIALIZATION), new JobSqliteGeneration.JobSpecSqliteGeneration(this.getLong("NOTIFYID"), langCode, false));
            }
        }
    }

    public MboRemote duplicate() throws RemoteException, MXException {
        throw new MXApplicationException("informer", "duplicateNotSupported");
    }

    /*
     * Loose catch block
     */
    @Override
    public String export() throws RemoteException, MXException {
        MboRemote attribute;
        MboSetRemote attributes;
        MboSetRemote querySet;
        NotifyExport export = new NotifyExport();
        export.setApp(this.getString("APP"));
        export.setClauseName(this.getString("CLAUSENAME"));
        export.setDescription(this.getString("DESCRIPTION"));
        export.setNotifynum(this.getString("NOTIFYNUM"));
        export.setProcessName(this.getString("PROCESSNAME"));
        export.setAltTrigRoot(this.getString("ALTTRIGROOT"));
        export.setVersion(this.getString("VERSION"));
        export.setGensqlite(this.getBoolean("GENERATESQLITE"));
        export.setAnonaccess(this.getBoolean("ANONYMOUSACCESS"));
        export.setAnonuser(this.getString("ANONYMOUSUSER"));
        MboSetRemote objects = null;
        MboSetRemote catalogs = null;
        MboSetRemote commands = null;
        MboSetRemote properties = null;
        MboSetRemote options = null;
        MboSetRemote customProps = null;
        MboSetRemote groups = null;
        MboSetRemote applications = null;
        if (!this.isNull("CLAUSENAME") && !(querySet = this.getMboSet("$query", "QUERY", "app=:app and clausename=:clausename")).isEmpty()) {
            export.setClauseValue(querySet.getMbo(0).getString("CLAUSE"));
            export.setClauseDescription(querySet.getMbo(0).getString("DESCRIPTION"));
        }
        objects = this.getMboSet("NOTIFYOBJECT");
        objects.setOrderBy("OBJORDER");
        objects.reset();
        MboRemote object = objects.moveFirst();
        while (object != null) {
            NotifyObjectExport exportObject = new NotifyObjectExport();
            exportObject.setObjectName(object.getString("OBJECTNAME"));
            exportObject.setParent(object.getString("PARENT"));
            exportObject.setMain(object.getBoolean("ISMAIN"));
            exportObject.setRelationship(object.getString("RELATIONSHIP"));
            exportObject.setObjOrder(object.getInt("OBJORDER"));
            attributes = object.getMboSet("NOTIFYATTRIBUTE");
            attributes.setOrderBy("ATTRIBUTENAME");
            attributes.reset();
            attribute = attributes.moveFirst();
            while (attribute != null) {
                exportObject.addAttribute(new NotifyAttributeExport(attribute.getString("ATTRIBUTENAME"), attribute.getBoolean("CANEDIT")));
                attribute = attributes.moveNext();
            }
            export.addObject(exportObject);
            object = objects.moveNext();
        }
        commands = this.getMboSet("NOTIFYCOMMANDLINK");
        MboRemote command = commands.moveFirst();
        while (command != null) {
            export.addCommand(command.getString("NOTIFYCOMMAND.NAME"));
            if (command.getBoolean("ISANONYMOUS")) {
                export.addAnonCommand(command.getString("NOTIFYCOMMAND.NAME"));
            }
            command = commands.moveNext();
        }
        options = this.getMboSet("NOTIFYOPTION");
        options.setOrderBy("OPTIONNAME");
        options.reset();
        MboRemote option = options.moveFirst();
        while (option != null) {
            export.addOption(new NotifyOptionExport(option.getString("OPTIONNAME"), option.getString("DESCRIPTION")));
            option = options.moveNext();
        }
        groups = this.getMboSet("NOTIFYGROUP");
        groups.setOrderBy("GROUPNAME");
        groups.reset();
        MboRemote group = groups.moveFirst();
        while (group != null) {
            NotifyGroupExport notifyGroupExport = new NotifyGroupExport();
            notifyGroupExport.setGroupName(group.getString("GROUPNAME"));
            notifyGroupExport.setDescription(group.getString("DESCRIPTION"));
            MboSetRemote groupOptions = group.getMboSet("NOTIFYGROUPOPTION");
            if (groupOptions.isEmpty()) {
                export.addGroup(notifyGroupExport);
            } else {
                MboRemote groupOption = groupOptions.moveFirst();
                while (groupOption != null) {
                    notifyGroupExport.addGroupOption(groupOption.getMboSet("NOTIFYOPTION").getMbo(0).getString("OPTIONNAME"));
                    groupOption = groupOptions.moveNext();
                }
                export.addGroup(notifyGroupExport);
            }
            group = groups.moveNext();
        }
        customProps = this.getMboSet("NOTIFYCUSTOMPROP");
        customProps.setOrderBy("NAME");
        customProps.reset();
        MboRemote customProp = customProps.moveFirst();
        while (customProp != null) {
            NotifyCustomPropExport customPropExport = new NotifyCustomPropExport();
            customPropExport.setName(customProp.getString("NAME"));
            export.addCustomProp(customPropExport);
            customProp = customProps.moveNext();
        }
        catalogs = this.getMboSet("CATALOG");
        catalogs.setOrderBy("CATALOG");
        catalogs.reset();
        MboRemote catalog = catalogs.moveFirst();
        while (catalog != null) {
            if (!"ISPROPERTIES".equals(catalog.getString("CATALOG"))) {
                NotifyCatalogExport exportCatalog = new NotifyCatalogExport();
                exportCatalog.setCatalog(catalog.getString("CATALOG"));
                exportCatalog.setDescription(catalog.getString("DESCRIPTION"));
                exportCatalog.setObjectName(catalog.getString("OBJECTNAME"));
                exportCatalog.setWhereClause(catalog.getString("WHERECLAUSE"));
                exportCatalog.setConditionName(catalog.getString("CONDITIONNAME"));
                exportCatalog.setConditionClass(catalog.getString("CONDITIONCLASS"));
                exportCatalog.setConditionExpr(catalog.getString("CONDITIONEXPR"));
                exportCatalog.setPartitionType(catalog.getString("PARTITIONTYPE"));
                exportCatalog.setPartitionerClass(catalog.getString("PARTITIONERCLASS"));
                exportCatalog.setPartitionByAttr(catalog.getString("PARTITIONBYATTR"));
                exportCatalog.setPreload(catalog.getBoolean("PRELOAD"));
                exportCatalog.setPagesize(catalog.getInt("PAGESIZE"));
                exportCatalog.setThreshold(catalog.getInt("PRELOADTHRESHOLD"));
                exportCatalog.setIschild(catalog.getBoolean("ISCHILD"));
                exportCatalog.setParent(catalog.getString("PARENT"));
                exportCatalog.setPrefix(catalog.getString("PREFIX"));
                exportCatalog.setStrategy(catalog.getString("STRATEGY"));
                exportCatalog.setDispatch(catalog.getBoolean("DISPATCH"));
                attributes = catalog.getMboSet("CATALOGATTRIBUTES");
                attributes.setOrderBy("ATTRIBUTENAME");
                attributes.reset();
                attribute = attributes.moveFirst();
                while (attribute != null) {
                    exportCatalog.addAtrribute(attribute.getString("ATTRIBUTENAME"), attribute.getBoolean("INCATALOG"), attribute.getBoolean("INFILTER"), attribute.getBoolean("CANEDIT"));
                    attribute = attributes.moveNext();
                }
                MboSetRemote listeners = catalog.getMboSet("CATALOGLISTENER");
                listeners.setOrderBy("OBJECTNAME");
                listeners.reset();
                MboRemote mbo = listeners.moveFirst();
                while (mbo != null) {
                    exportCatalog.addListener(new NotifyCatalogListenerExport(mbo));
                    mbo = listeners.moveNext();
                }
                export.addCatalog(exportCatalog);
            }
            catalog = catalogs.moveNext();
        }
        properties = this.getMboSet("$maxprop", "MAXPROP", "propname like 'informer." + this.getString("NOTIFYNUM").toLowerCase() + ".%'");
        properties.setOrderBy("PROPNAME");
        properties.reset();
        Object property = properties.moveFirst();
        while (property != null) {
            export.addProperty(new NotifyProperty(property.getString("PROPNAME"), property.getString("DESCRIPTION"), property.getString("MAXPROPVALUE.PROPVALUE")));
            property = properties.moveNext();
        }
        applications = this.getMboSet("ASSOCAPP");
        applications.reset();
        for (MboRemote application : new com.interlocsolutions.maximo.util.MboSetIterator(applications)) {
            export.addApplication(new NotifyAssociatedApplicationExport(application.getString("APP")));
        }
        property = InformerObjectSerializer.getInstance().serialize(export, InformerObjectSerializer.MARSHAL_PPRINT);
        NotifyUtil.closeAndCleanup(objects);
        NotifyUtil.closeAndCleanup(catalogs);
        NotifyUtil.closeAndCleanup(commands);
        NotifyUtil.closeAndCleanup(properties);
        NotifyUtil.closeAndCleanup(options);
        NotifyUtil.closeAndCleanup(groups);
        NotifyUtil.closeAndCleanup(applications);
        return property;
        {
            catch (JAXBException e) {
                try {
                    Object[] args = new String[]{"Export", e.getMessage()};
                    throw new MXApplicationException("informer", "jaxberror", args);
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(objects);
                    NotifyUtil.closeAndCleanup(catalogs);
                    NotifyUtil.closeAndCleanup(commands);
                    NotifyUtil.closeAndCleanup(properties);
                    NotifyUtil.closeAndCleanup(options);
                    NotifyUtil.closeAndCleanup(groups);
                    NotifyUtil.closeAndCleanup(applications);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void importConfiguration(NotifyExport export) throws MXException, RemoteException {
        void var9_39;
        block49: {
            block48: {
                MboSetRemote querySet;
                block47: {
                    if (this.getBoolean("ACTIVE")) {
                        throw new MXApplicationException("informer", "cannotImportActive");
                    }
                    if (export.getClauseName() == null || export.getClauseName().length() <= 0) break block48;
                    querySet = null;
                    try {
                        querySet = MXServerFactory.getMXServer().getMboSet("QUERY", this.getUserInfo());
                        String clauseName = export.getNotifynum();
                        SqlFormat sqlf = new SqlFormat("app = :1 and clausename = :2 ");
                        sqlf.setObject(1, "QUERY", "APP", export.getApp());
                        sqlf.setObject(2, "QUERY", "CLAUSENAME", clauseName);
                        querySet.setWhere(sqlf.format());
                        querySet.reset();
                        if (querySet.isEmpty()) {
                            MboRemote mboRemote = querySet.add();
                            mboRemote.setValue("APP", export.getApp());
                            mboRemote.setValue("CLAUSENAME", clauseName);
                            mboRemote.setValue("DESCRIPTION", export.getClauseDescription());
                            mboRemote.setValue("CLAUSE", export.getClauseValue());
                            mboRemote.setValue("ISPUBLIC", true);
                            querySet.save();
                            break block47;
                        }
                        MboRemote mboRemote = querySet.getMbo(0);
                        mboRemote.setValue("DESCRIPTION", export.getClauseDescription(), 2L);
                        mboRemote.setValue("CLAUSE", export.getClauseValue(), 3L);
                        querySet.save();
                    }
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(querySet);
                        throw throwable;
                    }
                }
                NotifyUtil.closeAndCleanup(querySet);
                break block49;
            }
            MboSetRemote processSet = this.getMboSet("$query", "WFPROCESS", "processname = '" + export.getProcessName() + "'");
            if (processSet.isEmpty()) {
                Object[] args = new String[]{export.getProcessName()};
                throw new MXApplicationException("informer", "missingProcess", args);
            }
        }
        this.setValue("NOTIFYNUM", export.getNotifynum(), 2L);
        this.setValue("APP", export.getApp(), 2L);
        this.setValue("DESCRIPTION", export.getDescription());
        this.setValue("ALTTRIGROOT", export.getAltTrigRoot(), 2L);
        this.setValue("VERSION", export.getVersion(), 2L);
        this.setValue("GENERATESQLITE", export.isGensqlite());
        this.setValue("ANONYMOUSACCESS", export.isAnonaccess());
        if (export.isAnonaccess()) {
            this.setValue("ANONYMOUSUSER", export.getAnonuser());
        }
        if (export.getProcessName() != null && export.getProcessName().length() > 0) {
            this.setValue("PROCESSNAME", export.getProcessName(), 2L);
        }
        if (export.getClauseName() != null && export.getClauseName().length() > 0) {
            this.setValue("CLAUSENAME", export.getNotifynum(), 3L);
        }
        this.setValue("ALLOWSTATUSCHANGE", false, 2L);
        MboSetRemote objSet = this.getMboSet("NOTIFYOBJECT");
        if (export.getObjects().isEmpty()) {
            objSet.deleteAll();
        } else {
            Object mainObj = null;
            Object obj = objSet.moveFirst();
            while (obj != null) {
                if (!obj.getBoolean("ISMAIN")) {
                    obj.delete();
                } else {
                    mainObj = obj;
                }
                obj = objSet.moveNext();
            }
            for (NotifyObjectExport notifyObjectExport : export.getObjects()) {
                if (!notifyObjectExport.isMain()) continue;
                if (mainObj == null) {
                    mainObj = objSet.add();
                    mainObj.setValue("ISMAIN", true);
                }
                mainObj.setValue("OBJECTNAME", notifyObjectExport.getObjectName(), 2L);
                mainObj.setValue("RELATIONSHIP", notifyObjectExport.getRelationship(), 2L);
                MboSetRemote attrs = mainObj.getMboSet("NOTIFYATTRIBUTE");
                attrs.deleteAll();
                if (notifyObjectExport.getAttributes() == null) continue;
                for (NotifyAttributeExport notifyAttributeExport : notifyObjectExport.getAttributes()) {
                    MboRemote mboRemote = attrs.add();
                    mboRemote.setValue("ATTRIBUTENAME", notifyAttributeExport.getAttributeName(), 2L);
                    mboRemote.setValue("CANEDIT", notifyAttributeExport.isCanEdit(), 2L);
                }
            }
            for (NotifyObjectExport notifyObjectExport : export.getObjects()) {
                if (notifyObjectExport.isMain()) continue;
                MboRemote notObj = objSet.add();
                notObj.setValue("OBJECTNAME", notifyObjectExport.getObjectName(), 2L);
                notObj.setValue("PARENT", notifyObjectExport.getParent(), 2L);
                notObj.setValue("RELATIONSHIP", notifyObjectExport.getRelationship(), 2L);
                notObj.setValue("OBJORDER", notifyObjectExport.getObjOrder(), 2L);
                MboSetRemote attrs = notObj.getMboSet("NOTIFYATTRIBUTE");
                if (notifyObjectExport.getAttributes() == null) continue;
                for (NotifyAttributeExport notifyAttributeExport : notifyObjectExport.getAttributes()) {
                    MboRemote notAttr = attrs.add();
                    notAttr.setValue("ATTRIBUTENAME", notifyAttributeExport.getAttributeName());
                    notAttr.setValue("CANEDIT", notifyAttributeExport.isCanEdit());
                }
            }
        }
        this.getMboSet("NOTIFYCOMMANDLINK").deleteAll();
        List<String> commands = export.getCommands();
        List<String> anonCommands = export.getAnonCommands();
        if (commands != null) {
            for (String command : commands) {
                MboSetRemote notCommands = this.getMboSet("$notifcommands", "ISNOTIFYCOMMAND", "name = '" + command + "'");
                if (notCommands.isEmpty()) continue;
                MboRemote mboRemote = this.getMboSet("NOTIFYCOMMANDLINK").add();
                mboRemote.setValue("NOTIFYCOMMANDID", notCommands.getMbo(0).getUniqueIDValue());
                if (!anonCommands.contains(command)) continue;
                mboRemote.setValue("ISANONYMOUS", true, 2L);
            }
        }
        this.importCatalogs(export);
        MboSetRemote mboSetRemote = this.getMboSet("NOTIFYOPTION");
        ArrayList<NotifyOptionExport> optionsToImport = new ArrayList<NotifyOptionExport>(export.getOptions());
        Object option = mboSetRemote.moveFirst();
        while (option != null) {
            void var8_27;
            Object var8_25 = null;
            for (NotifyOptionExport exportOption : optionsToImport) {
                if (!option.getString("OPTIONNAME").equals(exportOption.getOptionname())) continue;
                NotifyOptionExport notifyOptionExport = exportOption;
                break;
            }
            if (var8_27 == null) {
                option.delete();
            } else {
                option.setValue("DESCRIPTION", var8_27.getDescription());
                optionsToImport.remove(var8_27);
            }
            option = mboSetRemote.moveNext();
        }
        for (NotifyOptionExport notifyOptionExport : optionsToImport) {
            MboRemote mboRemote = mboSetRemote.add();
            mboRemote.setValue("OPTIONNAME", notifyOptionExport.getOptionname());
            mboRemote.setValue("DESCRIPTION", notifyOptionExport.getDescription());
        }
        MboSetRemote customPropSet = this.getMboSet("NOTIFYCUSTOMPROP");
        ArrayList<NotifyCustomPropExport> arrayList = new ArrayList<NotifyCustomPropExport>(export.getCustomProps());
        MboRemote mboRemote = customPropSet.moveFirst();
        while (var9_39 != null) {
            NotifyCustomPropExport customPropDef = null;
            for (NotifyCustomPropExport exportCustomProp : arrayList) {
                if (!var9_39.getString("NAME").equals(exportCustomProp.getName())) continue;
                customPropDef = exportCustomProp;
                break;
            }
            if (customPropDef == null) {
                var9_39.delete();
            } else {
                arrayList.remove(customPropDef);
            }
            MboRemote mboRemote2 = customPropSet.moveNext();
        }
        for (NotifyCustomPropExport customPropExport : arrayList) {
            if (customPropExport.getName() == null) continue;
            MboValueInfo valueInfo = MboUtilKt.getNaryMboValueInfo("MAXUSER", customPropExport.getName());
            if (valueInfo != null) {
                MboRemote customProp2 = customPropSet.add();
                customProp2.setValue("NAME", customPropExport.getName());
                customProp2.setValue("TITLE", valueInfo.getTitle());
                continue;
            }
            Object[] args = new String[]{customPropExport.getName(), "MAXUSER"};
            throw new MXApplicationException("informer", "invalidObjectAttribute", args);
        }
        MboSetRemote mboSetRemote2 = this.getMboSet("NOTIFYGROUP");
        ArrayList<NotifyGroupExport> groupsToImport = new ArrayList<NotifyGroupExport>(export.getGroups());
        Object group = mboSetRemote2.moveFirst();
        while (group != null) {
            NotifyGroupExport groupDef = null;
            for (NotifyGroupExport exportGroup : groupsToImport) {
                if (!group.getString("GROUPNAME").equals(exportGroup.getGroupName())) continue;
                groupDef = exportGroup;
                break;
            }
            if (groupDef == null) {
                group.delete();
            } else {
                group.setValue("DESCRIPTION", groupDef.getDescription());
                this.configureGroupOption((MboRemote)group, groupDef, mboSetRemote);
                groupsToImport.remove(groupDef);
            }
            group = mboSetRemote2.moveNext();
        }
        for (NotifyGroupExport groupExport : groupsToImport) {
            MboRemote group2 = mboSetRemote2.add();
            group2.setValue("GROUPNAME", groupExport.getGroupName());
            group2.setValue("DESCRIPTION", groupExport.getDescription());
            this.configureGroupOption(group2, groupExport, mboSetRemote);
        }
        MboSetRemote applicationSet = this.getMboSet("ASSOCAPP");
        ArrayList<NotifyAssociatedApplicationExport> appsToImport = new ArrayList<NotifyAssociatedApplicationExport>(export.getApplications());
        Object application = applicationSet.moveFirst();
        while (application != null) {
            NotifyAssociatedApplicationExport applicationDef = null;
            for (NotifyAssociatedApplicationExport exportApp : appsToImport) {
                if (!application.getString("APP").contentEquals(exportApp.getApp())) continue;
                applicationDef = exportApp;
                break;
            }
            if (applicationDef == null) {
                application.delete();
            } else {
                appsToImport.remove(applicationDef);
            }
            application = applicationSet.moveNext();
        }
        for (NotifyAssociatedApplicationExport applicationExport : appsToImport) {
            MboRemote application2 = applicationSet.add();
            application2.setValue("APP", applicationExport.getApp());
        }
        MboSetRemote propSet = null;
        try {
            propSet = MXServer.getMXServer().getMboSet("MAXPROP", MXServer.getMXServer().getSystemUserInfo());
            List<NotifyProperty> properties = export.getProperties();
            SqlFormat sqlf = new SqlFormat("propname = :1");
            if (properties != null) {
                for (NotifyProperty property : properties) {
                    MboRemote prop;
                    sqlf.setObject(1, "MAXPROP", "PROPNAME", property.getName());
                    propSet.setWhere(sqlf.format());
                    propSet.reset();
                    if (propSet.isEmpty()) {
                        prop = propSet.add();
                        prop.setValue("PROPNAME", property.getName());
                    } else {
                        prop = propSet.getMbo(0);
                    }
                    prop.setValue("DESCRIPTION", property.getDescription());
                    prop.setValue("DISPPROPVALUE", property.getValue());
                    propSet.save();
                    MXServer.getMXServer().reloadMaximoCache("MAXPROP", property.getName(), true);
                }
            }
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(propSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(propSet);
    }

    private void configureGroupOption(MboRemote group, NotifyGroupExport groupDef, MboSetRemote optionSet) throws MXException, RemoteException {
        ArrayList<String> groupOptionsToImport = new ArrayList<String>(groupDef.getGroupOptions());
        MboSetRemote groupOptionSet = group.getMboSet("NOTIFYGROUPOPTION");
        MboRemote groupOption = groupOptionSet.moveFirst();
        while (groupOption != null) {
            String optionName = groupOption.getString("NOTIFYOPTION.OPTIONNAME");
            if (groupDef.getGroupOptions().contains(optionName)) {
                groupOptionsToImport.remove(optionName);
            } else {
                groupOption.delete();
            }
            groupOption = groupOptionSet.moveNext();
        }
        for (String exportGroupOptionName : groupOptionsToImport) {
            MboRemote option = optionSet.moveFirst();
            while (option != null) {
                if (option.getString("OPTIONNAME").equals(exportGroupOptionName)) {
                    groupOptionSet.add().setValue("NOTIFYOPTIONID", option.getLong("NOTIFYOPTIONID"));
                }
                option = optionSet.moveNext();
            }
        }
    }

    private void importCatalogs(NotifyExport export) throws MXException, RemoteException {
        NotifyCatalogExport catalogDefParent;
        MboSetRemote catalogSet = this.getMboSet("IMPORTCATALOG");
        ArrayList<NotifyCatalogExport> originalCatalogToImport = new ArrayList<NotifyCatalogExport>(export.getCatalogs());
        ArrayList<NotifyCatalogExport> catalogsToImport = new ArrayList<NotifyCatalogExport>(export.getCatalogs());
        MboRemote catalog = catalogSet.moveFirst();
        while (catalog != null) {
            String catalogName = catalog.getString("CATALOG");
            NotifyCatalogExport catalogDef = null;
            for (NotifyCatalogExport exportCatalog : catalogsToImport) {
                if (!catalogName.equals(exportCatalog.getCatalog())) continue;
                catalogDef = exportCatalog;
                break;
            }
            if (catalogDef == null) {
                catalog.delete();
            } else {
                if (!"ISPROPERTIES".equals(catalogName)) {
                    catalogDefParent = this.getParentCatalogToImport(catalogDef, originalCatalogToImport);
                    Notify.configureCatalog(catalog, catalogDef, catalogDefParent);
                }
                catalogsToImport.remove(catalogDef);
            }
            catalog = catalogSet.moveNext();
        }
        for (NotifyCatalogExport catalogDef : catalogsToImport) {
            MboRemote catalog2 = catalogSet.add();
            catalogDefParent = this.getParentCatalogToImport(catalogDef, originalCatalogToImport);
            Notify.configureCatalog(catalog2, catalogDef, catalogDefParent);
        }
    }

    private NotifyCatalogExport getParentCatalogToImport(NotifyCatalogExport childCatalog, List<NotifyCatalogExport> catalogList) {
        NotifyCatalogExport catalogDefParent = null;
        if (childCatalog.isIschild()) {
            for (NotifyCatalogExport exportCatalog : catalogList) {
                if (!childCatalog.getParent().equals(exportCatalog.getCatalog())) continue;
                catalogDefParent = exportCatalog;
                break;
            }
        }
        return catalogDefParent;
    }

    @Override
    public String getMainObjectName() throws MXException, RemoteException {
        return this.getMboSet("$mainobject", "ISNOTIFYOBJECT", "notifyid = :notifyid and ismain = :yes").getMbo(0).getString("OBJECTNAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean userHasAccess(String userId) throws MXException, RemoteException {
        MboSetRemote userSet = null;
        try {
            userSet = this.getMboSet("NOTIFYUSER");
            userSet.setQbe("USERID", userId);
            userSet.setQbe("ACTIVE", "1");
            boolean bl = !userSet.isEmpty();
            return bl;
        }
        finally {
            NotifyUtil.closeAndCleanup(userSet);
        }
    }

    @Override
    public String getMetaData() throws RemoteException, MXException {
        MboRemote catalog;
        MboRemote notifyObject;
        ProfileMetaData pmd = new ProfileMetaData();
        MboSetRemote notifyObjectSet = this.getMboSet("NOTIFYOBJECT");
        int i = 0;
        while ((notifyObject = notifyObjectSet.getMbo(i)) != null) {
            MboRemote notifyAttribute;
            ProfileObject po = new ProfileObject(notifyObject.getString("OBJECTNAME"));
            MboSetRemote notifyAttributeSet = notifyObject.getMboSet("NOTIFYATTRIBUTE");
            int j = 0;
            while ((notifyAttribute = notifyAttributeSet.getMbo(j)) != null) {
                po.addAttribute(this.getProfileAttribute(po.getName(), notifyAttribute.getString("ATTRIBUTENAME"), null, notifyAttribute.getBoolean("CANEDIT")));
                ++j;
            }
            pmd.addProfileObject(po);
            ++i;
        }
        MboSetRemote catalogSet = this.getMboSet("$metacatalog", "ISCATALOG", "notifyid = :notifyid");
        int i2 = 0;
        while ((catalog = catalogSet.getMbo(i2)) != null) {
            MboRemote catalogAttribute;
            ProfileObject po = new ProfileObject(catalog.getString("OBJECTNAME"));
            MboSetRemote catalogAttributeSet = catalog.getMboSet("CATALOGATTRIBUTES");
            int j = 0;
            while ((catalogAttribute = catalogAttributeSet.getMbo(j)) != null) {
                if (catalogAttribute.getBoolean("INCATALOG")) {
                    po.addAttribute(this.getProfileAttribute(po.getName(), catalogAttribute.getString("ATTRIBUTENAME"), null, catalogAttribute.getBoolean("CANEDIT")));
                }
                ++j;
            }
            pmd.addProfileObject(po);
            ++i2;
        }
        try {
            return InformerObjectSerializer.getInstance().serialize(pmd, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileAttribute getProfileAttribute(String objectName, String attributeName, Boolean override, boolean canEdit) throws MXException, RemoteException {
        MboSetRemote set;
        block9: {
            block7: {
                String origAttributeName;
                block8: {
                    ProfileAttribute profileAttribute;
                    set = null;
                    if (objectName == null || attributeName == null) {
                        return null;
                    }
                    try {
                        if (attributeName.indexOf(".") <= 0) break block7;
                        origAttributeName = attributeName;
                        String relName = attributeName.substring(0, attributeName.indexOf("."));
                        attributeName = attributeName.substring(attributeName.indexOf(".") + 1);
                        set = MXServer.getMXServer().getMboSet("MAXRELATIONSHIP", MXServer.getMXServer().getSystemUserInfo());
                        SqlFormat sqlf = new SqlFormat("parent = :1 and name = :2");
                        sqlf.setObject(1, "MAXRELATIONSHIP", "PARENT", objectName);
                        sqlf.setObject(2, "MAXRELATIONSHIP", "NAME", relName);
                        set.setWhere(sqlf.format());
                        if (!set.isEmpty()) break block8;
                        profileAttribute = null;
                    }
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(set);
                        throw throwable;
                    }
                    NotifyUtil.closeAndCleanup(set);
                    return profileAttribute;
                }
                ProfileAttribute pa = this.getProfileAttribute(set.getMbo(0).getString("CHILD"), attributeName, false, canEdit);
                if (pa != null) {
                    pa.setName(origAttributeName);
                }
                ProfileAttribute profileAttribute = pa;
                NotifyUtil.closeAndCleanup(set);
                return profileAttribute;
            }
            set = MXServer.getMXServer().getMboSet("MAXATTRIBUTE", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("objectname = :1 and attributename = :2");
            sqlf.setObject(1, "MAXATTRIBUTE", "OBJECTNAME", objectName);
            sqlf.setObject(2, "MAXATTRIBUTE", "ATTRIBUTENAME", attributeName);
            set.setWhere(sqlf.format());
            if (!set.isEmpty()) break block9;
            ProfileAttribute relName = null;
            NotifyUtil.closeAndCleanup(set);
            return relName;
        }
        MboRemote attribute = set.getMbo(0);
        ProfileAttribute profileAttribute = new ProfileAttribute(attributeName, attribute.getInt("LENGTH"), attribute.getString("MAXTYPE"), attribute.getInt("SCALE"), attribute.getString("REMARKS"), override == null ? attribute.getBoolean("REQUIRED") : override.booleanValue(), canEdit);
        NotifyUtil.closeAndCleanup(set);
        return profileAttribute;
    }

    @Override
    public void modify() throws MXException, RemoteException {
        super.modify();
        Object oldRev = this.getDatabaseValue("REVISION");
        long lastSavedRevision = oldRev == null ? 0L : Long.valueOf(oldRev.toString());
        this.setValue("REVISION", lastSavedRevision + 1L, 2L);
    }

    @Override
    public void setDeleteTransactable(@Nullable NotifyDeleteTransactable transactable) {
        this.deleteTransactable = transactable;
    }

    @Override
    @Nullable
    public NotifyDeleteTransactable getDeleteTransactable() {
        return this.deleteTransactable;
    }

    @Override
    @NotNull
    public NotifyDeleteTransactable newDeleteTransactable() {
        return new NotifyDeleteTransactable(this);
    }
}

